package software.amazon.awscdk.customresources;

/**
 * Initialization properties for the <code>Provider</code> construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create custom resource handler entrypoint
 * Function handler = Function.Builder.create(this, "my-handler")
 *         .runtime(Runtime.NODEJS_20_X)
 *         .handler("index.handler")
 *         .code(Code.fromInline("\n  exports.handler = async (event, context) =&gt; {\n    return {\n      PhysicalResourceId: '1234',\n      NoEcho: true,\n      Data: {\n        mySecret: 'secret-value',\n        hello: 'world',\n        ghToken: 'gho_xxxxxxx',\n      },\n    };\n  };"))
 *         .build();
 * // Provision a custom resource provider framework
 * Provider provider = Provider.Builder.create(this, "my-provider")
 *         .onEventHandler(handler)
 *         .build();
 * CustomResource.Builder.create(this, "my-cr")
 *         .serviceToken(provider.getServiceToken())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:17.309Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.custom_resources.ProviderProps")
@software.amazon.jsii.Jsii.Proxy(ProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS Lambda function to invoke for all resource lifecycle operations (CREATE/UPDATE/DELETE).
     * <p>
     * This function is responsible to begin the requested resource operation
     * (CREATE/UPDATE/DELETE) and return any additional properties to add to the
     * event, which will later be passed to <code>isComplete</code>. The <code>PhysicalResourceId</code>
     * property must be included in the response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getOnEventHandler();

    /**
     * Whether logging for the waiter state machine is disabled.
     * <p>
     * Default: - true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDisableWaiterStateMachineLogging() {
        return null;
    }

    /**
     * Lambda execution role for provider framework's isComplete/onTimeout Lambda function.
     * <p>
     * Note that this role
     * must be assumed by the 'lambda.amazonaws.com' service principal. To prevent circular dependency problem
     * in the provider framework, please ensure you specify a different IAM Role for 'frameworkCompleteAndTimeoutRole'
     * from 'frameworkOnEventRole'.
     * <p>
     * This property cannot be used with 'role' property
     * <p>
     * Default: - A default role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getFrameworkCompleteAndTimeoutRole() {
        return null;
    }

    /**
     * Log level of the provider framework lambda.
     * <p>
     * Default: true - Logging is disabled by default
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ApplicationLogLevel getFrameworkLambdaLoggingLevel() {
        return null;
    }

    /**
     * Lambda execution role for provider framework's onEvent Lambda function.
     * <p>
     * Note that this role must be assumed
     * by the 'lambda.amazonaws.com' service principal.
     * <p>
     * This property cannot be used with 'role' property
     * <p>
     * Default: - A default role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getFrameworkOnEventRole() {
        return null;
    }

    /**
     * The AWS Lambda function to invoke in order to determine if the operation is complete.
     * <p>
     * This function will be called immediately after <code>onEvent</code> and then
     * periodically based on the configured query interval as long as it returns
     * <code>false</code>. If the function still returns <code>false</code> and the alloted timeout has
     * passed, the operation will fail.
     * <p>
     * Default: - provider is synchronous. This means that the `onEvent` handler
     * is expected to finish all lifecycle operations within the initial invocation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IFunction getIsCompleteHandler() {
        return null;
    }

    /**
     * The Log Group used for logging of events emitted by the custom resource's lambda function.
     * <p>
     * Providing a user-controlled log group was rolled out to commercial regions on 2023-11-16.
     * If you are deploying to another type of region, please check regional availability first.
     * <p>
     * Default: - a default log group created by AWS Lambda
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return null;
    }

    /**
     * The number of days framework log events are kept in CloudWatch Logs.
     * <p>
     * When
     * updating this property, unsetting it doesn't remove the log retention policy.
     * To remove the retention policy, set the value to <code>INFINITE</code>.
     * <p>
     * This is a legacy API and we strongly recommend you migrate to <code>logGroup</code> if you can.
     * <code>logGroup</code> allows you to create a fully customizable log group and instruct the Lambda function to send logs to it.
     * <p>
     * Default: logs.RetentionDays.INFINITE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
        return null;
    }

    /**
     * AWS KMS key used to encrypt provider lambda's environment variables.
     * <p>
     * Default: -  AWS Lambda creates and uses an AWS managed customer master key (CMK)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKeyRef getProviderFunctionEnvEncryption() {
        return null;
    }

    /**
     * Provider Lambda name.
     * <p>
     * The provider lambda function name.
     * <p>
     * Default: -  CloudFormation default name from unique physical ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProviderFunctionName() {
        return null;
    }

    /**
     * Time between calls to the <code>isComplete</code> handler which determines if the resource has been stabilized.
     * <p>
     * The first <code>isComplete</code> will be called immediately after <code>handler</code> and then
     * every <code>queryInterval</code> seconds, and until <code>timeout</code> has been reached or until
     * <code>isComplete</code> returns <code>true</code>.
     * <p>
     * Default: Duration.seconds(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getQueryInterval() {
        return null;
    }

    /**
     * (deprecated) AWS Lambda execution role.
     * <p>
     * The role is shared by provider framework's onEvent, isComplete lambda, and onTimeout Lambda functions.
     * This role will be assumed by the AWS Lambda, so it must be assumable by the 'lambda.amazonaws.com'
     * service principal.
     * <p>
     * Default: - A default role will be created.
     * <p>
     * @deprecated <ul>
     * <li>Use frameworkOnEventRole, frameworkCompleteAndTimeoutRole</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * Security groups to attach to the provider functions.
     * <p>
     * Only used if 'vpc' is supplied
     * <p>
     * Default: - If `vpc` is not supplied, no security groups are attached. Otherwise, a dedicated security
     * group is created for each function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * Total timeout for the entire operation.
     * <p>
     * The maximum timeout is 1 hour (yes, it can exceed the AWS Lambda 15 minutes)
     * <p>
     * Default: Duration.minutes(30)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTotalTimeout() {
        return null;
    }

    /**
     * The vpc to provision the lambda functions in.
     * <p>
     * Default: - functions are not provisioned inside a vpc.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * Which subnets from the VPC to place the lambda functions in.
     * <p>
     * Only used if 'vpc' is supplied. Note: internet access for Lambdas
     * requires a NAT gateway, so picking Public subnets is not allowed.
     * <p>
     * Default: - the Vpc default strategy if not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * Defines what execution history events of the waiter state machine are logged and where they are logged.
     * <p>
     * Default: - A default log group will be created if logging for the waiter state machine is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.customresources.LogOptions getWaiterStateMachineLogOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProviderProps> {
        software.amazon.awscdk.services.lambda.IFunction onEventHandler;
        java.lang.Boolean disableWaiterStateMachineLogging;
        software.amazon.awscdk.services.iam.IRole frameworkCompleteAndTimeoutRole;
        software.amazon.awscdk.services.lambda.ApplicationLogLevel frameworkLambdaLoggingLevel;
        software.amazon.awscdk.services.iam.IRole frameworkOnEventRole;
        software.amazon.awscdk.services.lambda.IFunction isCompleteHandler;
        software.amazon.awscdk.services.logs.ILogGroup logGroup;
        software.amazon.awscdk.services.logs.RetentionDays logRetention;
        software.amazon.awscdk.services.kms.IKeyRef providerFunctionEnvEncryption;
        java.lang.String providerFunctionName;
        software.amazon.awscdk.Duration queryInterval;
        software.amazon.awscdk.services.iam.IRole role;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.Duration totalTimeout;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        software.amazon.awscdk.customresources.LogOptions waiterStateMachineLogOptions;

        /**
         * Sets the value of {@link ProviderProps#getOnEventHandler}
         * @param onEventHandler The AWS Lambda function to invoke for all resource lifecycle operations (CREATE/UPDATE/DELETE). This parameter is required.
         *                       This function is responsible to begin the requested resource operation
         *                       (CREATE/UPDATE/DELETE) and return any additional properties to add to the
         *                       event, which will later be passed to <code>isComplete</code>. The <code>PhysicalResourceId</code>
         *                       property must be included in the response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onEventHandler(software.amazon.awscdk.services.lambda.IFunction onEventHandler) {
            this.onEventHandler = onEventHandler;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getDisableWaiterStateMachineLogging}
         * @param disableWaiterStateMachineLogging Whether logging for the waiter state machine is disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableWaiterStateMachineLogging(java.lang.Boolean disableWaiterStateMachineLogging) {
            this.disableWaiterStateMachineLogging = disableWaiterStateMachineLogging;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getFrameworkCompleteAndTimeoutRole}
         * @param frameworkCompleteAndTimeoutRole Lambda execution role for provider framework's isComplete/onTimeout Lambda function.
         *                                        Note that this role
         *                                        must be assumed by the 'lambda.amazonaws.com' service principal. To prevent circular dependency problem
         *                                        in the provider framework, please ensure you specify a different IAM Role for 'frameworkCompleteAndTimeoutRole'
         *                                        from 'frameworkOnEventRole'.
         *                                        <p>
         *                                        This property cannot be used with 'role' property
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frameworkCompleteAndTimeoutRole(software.amazon.awscdk.services.iam.IRole frameworkCompleteAndTimeoutRole) {
            this.frameworkCompleteAndTimeoutRole = frameworkCompleteAndTimeoutRole;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getFrameworkLambdaLoggingLevel}
         * @param frameworkLambdaLoggingLevel Log level of the provider framework lambda.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frameworkLambdaLoggingLevel(software.amazon.awscdk.services.lambda.ApplicationLogLevel frameworkLambdaLoggingLevel) {
            this.frameworkLambdaLoggingLevel = frameworkLambdaLoggingLevel;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getFrameworkOnEventRole}
         * @param frameworkOnEventRole Lambda execution role for provider framework's onEvent Lambda function.
         *                             Note that this role must be assumed
         *                             by the 'lambda.amazonaws.com' service principal.
         *                             <p>
         *                             This property cannot be used with 'role' property
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frameworkOnEventRole(software.amazon.awscdk.services.iam.IRole frameworkOnEventRole) {
            this.frameworkOnEventRole = frameworkOnEventRole;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getIsCompleteHandler}
         * @param isCompleteHandler The AWS Lambda function to invoke in order to determine if the operation is complete.
         *                          This function will be called immediately after <code>onEvent</code> and then
         *                          periodically based on the configured query interval as long as it returns
         *                          <code>false</code>. If the function still returns <code>false</code> and the alloted timeout has
         *                          passed, the operation will fail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isCompleteHandler(software.amazon.awscdk.services.lambda.IFunction isCompleteHandler) {
            this.isCompleteHandler = isCompleteHandler;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getLogGroup}
         * @param logGroup The Log Group used for logging of events emitted by the custom resource's lambda function.
         *                 Providing a user-controlled log group was rolled out to commercial regions on 2023-11-16.
         *                 If you are deploying to another type of region, please check regional availability first.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroup(software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getLogRetention}
         * @param logRetention The number of days framework log events are kept in CloudWatch Logs.
         *                     When
         *                     updating this property, unsetting it doesn't remove the log retention policy.
         *                     To remove the retention policy, set the value to <code>INFINITE</code>.
         *                     <p>
         *                     This is a legacy API and we strongly recommend you migrate to <code>logGroup</code> if you can.
         *                     <code>logGroup</code> allows you to create a fully customizable log group and instruct the Lambda function to send logs to it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getProviderFunctionEnvEncryption}
         * @param providerFunctionEnvEncryption AWS KMS key used to encrypt provider lambda's environment variables.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerFunctionEnvEncryption(software.amazon.awscdk.services.kms.IKeyRef providerFunctionEnvEncryption) {
            this.providerFunctionEnvEncryption = providerFunctionEnvEncryption;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getProviderFunctionName}
         * @param providerFunctionName Provider Lambda name.
         *                             The provider lambda function name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerFunctionName(java.lang.String providerFunctionName) {
            this.providerFunctionName = providerFunctionName;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getQueryInterval}
         * @param queryInterval Time between calls to the <code>isComplete</code> handler which determines if the resource has been stabilized.
         *                      The first <code>isComplete</code> will be called immediately after <code>handler</code> and then
         *                      every <code>queryInterval</code> seconds, and until <code>timeout</code> has been reached or until
         *                      <code>isComplete</code> returns <code>true</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryInterval(software.amazon.awscdk.Duration queryInterval) {
            this.queryInterval = queryInterval;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getRole}
         * @param role AWS Lambda execution role.
         *             The role is shared by provider framework's onEvent, isComplete lambda, and onTimeout Lambda functions.
         *             This role will be assumed by the AWS Lambda, so it must be assumable by the 'lambda.amazonaws.com'
         *             service principal.
         * @return {@code this}
         * @deprecated - Use frameworkOnEventRole, frameworkCompleteAndTimeoutRole
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getSecurityGroups}
         * @param securityGroups Security groups to attach to the provider functions.
         *                       Only used if 'vpc' is supplied
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getTotalTimeout}
         * @param totalTimeout Total timeout for the entire operation.
         *                     The maximum timeout is 1 hour (yes, it can exceed the AWS Lambda 15 minutes)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalTimeout(software.amazon.awscdk.Duration totalTimeout) {
            this.totalTimeout = totalTimeout;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getVpc}
         * @param vpc The vpc to provision the lambda functions in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getVpcSubnets}
         * @param vpcSubnets Which subnets from the VPC to place the lambda functions in.
         *                   Only used if 'vpc' is supplied. Note: internet access for Lambdas
         *                   requires a NAT gateway, so picking Public subnets is not allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getWaiterStateMachineLogOptions}
         * @param waiterStateMachineLogOptions Defines what execution history events of the waiter state machine are logged and where they are logged.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder waiterStateMachineLogOptions(software.amazon.awscdk.customresources.LogOptions waiterStateMachineLogOptions) {
            this.waiterStateMachineLogOptions = waiterStateMachineLogOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProviderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProviderProps {
        private final software.amazon.awscdk.services.lambda.IFunction onEventHandler;
        private final java.lang.Boolean disableWaiterStateMachineLogging;
        private final software.amazon.awscdk.services.iam.IRole frameworkCompleteAndTimeoutRole;
        private final software.amazon.awscdk.services.lambda.ApplicationLogLevel frameworkLambdaLoggingLevel;
        private final software.amazon.awscdk.services.iam.IRole frameworkOnEventRole;
        private final software.amazon.awscdk.services.lambda.IFunction isCompleteHandler;
        private final software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private final software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private final software.amazon.awscdk.services.kms.IKeyRef providerFunctionEnvEncryption;
        private final java.lang.String providerFunctionName;
        private final software.amazon.awscdk.Duration queryInterval;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.Duration totalTimeout;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        private final software.amazon.awscdk.customresources.LogOptions waiterStateMachineLogOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.onEventHandler = software.amazon.jsii.Kernel.get(this, "onEventHandler", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.disableWaiterStateMachineLogging = software.amazon.jsii.Kernel.get(this, "disableWaiterStateMachineLogging", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.frameworkCompleteAndTimeoutRole = software.amazon.jsii.Kernel.get(this, "frameworkCompleteAndTimeoutRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.frameworkLambdaLoggingLevel = software.amazon.jsii.Kernel.get(this, "frameworkLambdaLoggingLevel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ApplicationLogLevel.class));
            this.frameworkOnEventRole = software.amazon.jsii.Kernel.get(this, "frameworkOnEventRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.isCompleteHandler = software.amazon.jsii.Kernel.get(this, "isCompleteHandler", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.logRetention = software.amazon.jsii.Kernel.get(this, "logRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
            this.providerFunctionEnvEncryption = software.amazon.jsii.Kernel.get(this, "providerFunctionEnvEncryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKeyRef.class));
            this.providerFunctionName = software.amazon.jsii.Kernel.get(this, "providerFunctionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryInterval = software.amazon.jsii.Kernel.get(this, "queryInterval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.totalTimeout = software.amazon.jsii.Kernel.get(this, "totalTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.waiterStateMachineLogOptions = software.amazon.jsii.Kernel.get(this, "waiterStateMachineLogOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.LogOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.onEventHandler = java.util.Objects.requireNonNull(builder.onEventHandler, "onEventHandler is required");
            this.disableWaiterStateMachineLogging = builder.disableWaiterStateMachineLogging;
            this.frameworkCompleteAndTimeoutRole = builder.frameworkCompleteAndTimeoutRole;
            this.frameworkLambdaLoggingLevel = builder.frameworkLambdaLoggingLevel;
            this.frameworkOnEventRole = builder.frameworkOnEventRole;
            this.isCompleteHandler = builder.isCompleteHandler;
            this.logGroup = builder.logGroup;
            this.logRetention = builder.logRetention;
            this.providerFunctionEnvEncryption = builder.providerFunctionEnvEncryption;
            this.providerFunctionName = builder.providerFunctionName;
            this.queryInterval = builder.queryInterval;
            this.role = builder.role;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.totalTimeout = builder.totalTimeout;
            this.vpc = builder.vpc;
            this.vpcSubnets = builder.vpcSubnets;
            this.waiterStateMachineLogOptions = builder.waiterStateMachineLogOptions;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getOnEventHandler() {
            return this.onEventHandler;
        }

        @Override
        public final java.lang.Boolean getDisableWaiterStateMachineLogging() {
            return this.disableWaiterStateMachineLogging;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getFrameworkCompleteAndTimeoutRole() {
            return this.frameworkCompleteAndTimeoutRole;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.ApplicationLogLevel getFrameworkLambdaLoggingLevel() {
            return this.frameworkLambdaLoggingLevel;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getFrameworkOnEventRole() {
            return this.frameworkOnEventRole;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getIsCompleteHandler() {
            return this.isCompleteHandler;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
            return this.logRetention;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKeyRef getProviderFunctionEnvEncryption() {
            return this.providerFunctionEnvEncryption;
        }

        @Override
        public final java.lang.String getProviderFunctionName() {
            return this.providerFunctionName;
        }

        @Override
        public final software.amazon.awscdk.Duration getQueryInterval() {
            return this.queryInterval;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.Duration getTotalTimeout() {
            return this.totalTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.customresources.LogOptions getWaiterStateMachineLogOptions() {
            return this.waiterStateMachineLogOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("onEventHandler", om.valueToTree(this.getOnEventHandler()));
            if (this.getDisableWaiterStateMachineLogging() != null) {
                data.set("disableWaiterStateMachineLogging", om.valueToTree(this.getDisableWaiterStateMachineLogging()));
            }
            if (this.getFrameworkCompleteAndTimeoutRole() != null) {
                data.set("frameworkCompleteAndTimeoutRole", om.valueToTree(this.getFrameworkCompleteAndTimeoutRole()));
            }
            if (this.getFrameworkLambdaLoggingLevel() != null) {
                data.set("frameworkLambdaLoggingLevel", om.valueToTree(this.getFrameworkLambdaLoggingLevel()));
            }
            if (this.getFrameworkOnEventRole() != null) {
                data.set("frameworkOnEventRole", om.valueToTree(this.getFrameworkOnEventRole()));
            }
            if (this.getIsCompleteHandler() != null) {
                data.set("isCompleteHandler", om.valueToTree(this.getIsCompleteHandler()));
            }
            if (this.getLogGroup() != null) {
                data.set("logGroup", om.valueToTree(this.getLogGroup()));
            }
            if (this.getLogRetention() != null) {
                data.set("logRetention", om.valueToTree(this.getLogRetention()));
            }
            if (this.getProviderFunctionEnvEncryption() != null) {
                data.set("providerFunctionEnvEncryption", om.valueToTree(this.getProviderFunctionEnvEncryption()));
            }
            if (this.getProviderFunctionName() != null) {
                data.set("providerFunctionName", om.valueToTree(this.getProviderFunctionName()));
            }
            if (this.getQueryInterval() != null) {
                data.set("queryInterval", om.valueToTree(this.getQueryInterval()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getTotalTimeout() != null) {
                data.set("totalTimeout", om.valueToTree(this.getTotalTimeout()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }
            if (this.getWaiterStateMachineLogOptions() != null) {
                data.set("waiterStateMachineLogOptions", om.valueToTree(this.getWaiterStateMachineLogOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.custom_resources.ProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProviderProps.Jsii$Proxy that = (ProviderProps.Jsii$Proxy) o;

            if (!onEventHandler.equals(that.onEventHandler)) return false;
            if (this.disableWaiterStateMachineLogging != null ? !this.disableWaiterStateMachineLogging.equals(that.disableWaiterStateMachineLogging) : that.disableWaiterStateMachineLogging != null) return false;
            if (this.frameworkCompleteAndTimeoutRole != null ? !this.frameworkCompleteAndTimeoutRole.equals(that.frameworkCompleteAndTimeoutRole) : that.frameworkCompleteAndTimeoutRole != null) return false;
            if (this.frameworkLambdaLoggingLevel != null ? !this.frameworkLambdaLoggingLevel.equals(that.frameworkLambdaLoggingLevel) : that.frameworkLambdaLoggingLevel != null) return false;
            if (this.frameworkOnEventRole != null ? !this.frameworkOnEventRole.equals(that.frameworkOnEventRole) : that.frameworkOnEventRole != null) return false;
            if (this.isCompleteHandler != null ? !this.isCompleteHandler.equals(that.isCompleteHandler) : that.isCompleteHandler != null) return false;
            if (this.logGroup != null ? !this.logGroup.equals(that.logGroup) : that.logGroup != null) return false;
            if (this.logRetention != null ? !this.logRetention.equals(that.logRetention) : that.logRetention != null) return false;
            if (this.providerFunctionEnvEncryption != null ? !this.providerFunctionEnvEncryption.equals(that.providerFunctionEnvEncryption) : that.providerFunctionEnvEncryption != null) return false;
            if (this.providerFunctionName != null ? !this.providerFunctionName.equals(that.providerFunctionName) : that.providerFunctionName != null) return false;
            if (this.queryInterval != null ? !this.queryInterval.equals(that.queryInterval) : that.queryInterval != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.totalTimeout != null ? !this.totalTimeout.equals(that.totalTimeout) : that.totalTimeout != null) return false;
            if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) return false;
            if (this.vpcSubnets != null ? !this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets != null) return false;
            return this.waiterStateMachineLogOptions != null ? this.waiterStateMachineLogOptions.equals(that.waiterStateMachineLogOptions) : that.waiterStateMachineLogOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.onEventHandler.hashCode();
            result = 31 * result + (this.disableWaiterStateMachineLogging != null ? this.disableWaiterStateMachineLogging.hashCode() : 0);
            result = 31 * result + (this.frameworkCompleteAndTimeoutRole != null ? this.frameworkCompleteAndTimeoutRole.hashCode() : 0);
            result = 31 * result + (this.frameworkLambdaLoggingLevel != null ? this.frameworkLambdaLoggingLevel.hashCode() : 0);
            result = 31 * result + (this.frameworkOnEventRole != null ? this.frameworkOnEventRole.hashCode() : 0);
            result = 31 * result + (this.isCompleteHandler != null ? this.isCompleteHandler.hashCode() : 0);
            result = 31 * result + (this.logGroup != null ? this.logGroup.hashCode() : 0);
            result = 31 * result + (this.logRetention != null ? this.logRetention.hashCode() : 0);
            result = 31 * result + (this.providerFunctionEnvEncryption != null ? this.providerFunctionEnvEncryption.hashCode() : 0);
            result = 31 * result + (this.providerFunctionName != null ? this.providerFunctionName.hashCode() : 0);
            result = 31 * result + (this.queryInterval != null ? this.queryInterval.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.totalTimeout != null ? this.totalTimeout.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            result = 31 * result + (this.waiterStateMachineLogOptions != null ? this.waiterStateMachineLogOptions.hashCode() : 0);
            return result;
        }
    }
}
