package software.amazon.awscdk.pipelines;

/**
 * Pause the pipeline if a deployment would add IAM permissions or Security Group rules.
 * <p>
 * This step is only supported in CodePipeline pipelines.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodePipeline pipeline;
 * MyApplicationStage stage = new MyApplicationStage(this, "MyApplication");
 * pipeline.addStage(stage, AddStageOpts.builder()
 *         .pre(List.of(ConfirmPermissionsBroadening.Builder.create("Check").stage(stage).build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:17.388Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.ConfirmPermissionsBroadening")
public class ConfirmPermissionsBroadening extends software.amazon.awscdk.pipelines.Step implements software.amazon.awscdk.pipelines.ICodePipelineActionFactory {

    protected ConfirmPermissionsBroadening(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ConfirmPermissionsBroadening(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id Identifier for this step. This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ConfirmPermissionsBroadening(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.PermissionsBroadeningCheckProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Create the desired Action and add it to the pipeline.
     * <p>
     * @param stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipelineActionFactoryResult produceAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.ProduceActionOptions options) {
        return software.amazon.jsii.Kernel.call(this, "produceAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodePipelineActionFactoryResult.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.pipelines.ConfirmPermissionsBroadening}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.pipelines.ConfirmPermissionsBroadening> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id Identifier for this step. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String id) {
            return new Builder(id);
        }

        private final java.lang.String id;
        private final software.amazon.awscdk.pipelines.PermissionsBroadeningCheckProps.Builder props;

        private Builder(final java.lang.String id) {
            this.id = id;
            this.props = new software.amazon.awscdk.pipelines.PermissionsBroadeningCheckProps.Builder();
        }

        /**
         * The CDK Stage object to check the stacks of.
         * <p>
         * This should be the same Stage object you are passing to <code>addStage()</code>.
         * <p>
         * @return {@code this}
         * @param stage The CDK Stage object to check the stacks of. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stage(final software.amazon.awscdk.Stage stage) {
            this.props.stage(stage);
            return this;
        }

        /**
         * Topic to send notifications when a human needs to give manual confirmation.
         * <p>
         * Default: - no notification
         * <p>
         * @return {@code this}
         * @param notificationTopic Topic to send notifications when a human needs to give manual confirmation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTopic(final software.amazon.awscdk.services.sns.ITopic notificationTopic) {
            this.props.notificationTopic(notificationTopic);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.pipelines.ConfirmPermissionsBroadening}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.pipelines.ConfirmPermissionsBroadening build() {
            return new software.amazon.awscdk.pipelines.ConfirmPermissionsBroadening(
                this.id,
                this.props.build()
            );
        }
    }
}
