package software.amazon.awscdk.pipelines;

/**
 * Location of a FileSet consumed or produced by a ShellStep.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.pipelines.*;
 * FileSet fileSet;
 * FileSetLocation fileSetLocation = FileSetLocation.builder()
 *         .directory("directory")
 *         .fileSet(fileSet)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:17.392Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.FileSetLocation")
@software.amazon.jsii.Jsii.Proxy(FileSetLocation.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FileSetLocation extends software.amazon.jsii.JsiiSerializable {

    /**
     * The (relative) directory where the FileSet is found.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDirectory();

    /**
     * The FileSet object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.FileSet getFileSet();

    /**
     * @return a {@link Builder} of {@link FileSetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileSetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FileSetLocation> {
        java.lang.String directory;
        software.amazon.awscdk.pipelines.FileSet fileSet;

        /**
         * Sets the value of {@link FileSetLocation#getDirectory}
         * @param directory The (relative) directory where the FileSet is found. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directory(java.lang.String directory) {
            this.directory = directory;
            return this;
        }

        /**
         * Sets the value of {@link FileSetLocation#getFileSet}
         * @param fileSet The FileSet object. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSet(software.amazon.awscdk.pipelines.FileSet fileSet) {
            this.fileSet = fileSet;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileSetLocation}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FileSetLocation build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FileSetLocation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileSetLocation {
        private final java.lang.String directory;
        private final software.amazon.awscdk.pipelines.FileSet fileSet;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.directory = software.amazon.jsii.Kernel.get(this, "directory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileSet = software.amazon.jsii.Kernel.get(this, "fileSet", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.FileSet.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.directory = java.util.Objects.requireNonNull(builder.directory, "directory is required");
            this.fileSet = java.util.Objects.requireNonNull(builder.fileSet, "fileSet is required");
        }

        @Override
        public final java.lang.String getDirectory() {
            return this.directory;
        }

        @Override
        public final software.amazon.awscdk.pipelines.FileSet getFileSet() {
            return this.fileSet;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("directory", om.valueToTree(this.getDirectory()));
            data.set("fileSet", om.valueToTree(this.getFileSet()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.FileSetLocation"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileSetLocation.Jsii$Proxy that = (FileSetLocation.Jsii$Proxy) o;

            if (!directory.equals(that.directory)) return false;
            return this.fileSet.equals(that.fileSet);
        }

        @Override
        public final int hashCode() {
            int result = this.directory.hashCode();
            result = 31 * result + (this.fileSet.hashCode());
            return result;
        }
    }
}
