package software.amazon.awscdk.pipelines;

/**
 * A Reference to a Stack Output.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * public class MyLambdaStep extends Step implements ICodePipelineActionFactory {
 *     private StackOutputReference stackOutputReference;
 *     public MyLambdaStep(Function fn, CfnOutput stackOutput) {
 *         super("MyLambdaStep");
 *         this.stackOutputReference = StackOutputReference.fromCfnOutput(stackOutput);
 *     }
 *     public CodePipelineActionFactoryResult produceAction(IStage stage, ProduceActionOptions options) {
 *         stage.addAction(
 *         LambdaInvokeAction.Builder.create()
 *                 .actionName(options.getActionName())
 *                 .runOrder(options.getRunOrder())
 *                 // Map the reference to the variable name the CDK has generated for you.
 *                 .userParameters(Map.of(
 *                         "stackOutput", options.stackOutputsMap.toCodePipeline(this.stackOutputReference)))
 *                 .lambda(this.fn)
 *                 .build());
 *         return CodePipelineActionFactoryResult.builder().runOrdersConsumed(1).build();
 *     }public get consumedStackOutputs(): pipelines.StackOutputReference[] {
 *         return [this.stackOutputReference];
 *       }
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:17.414Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.StackOutputReference")
public class StackOutputReference extends software.amazon.jsii.JsiiObject {

    protected StackOutputReference(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StackOutputReference(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Create a StackOutputReference that references the given CfnOutput.
     * <p>
     * @param output This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.StackOutputReference fromCfnOutput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnOutput output) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.StackOutputReference.class, "fromCfnOutput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StackOutputReference.class), new Object[] { java.util.Objects.requireNonNull(output, "output is required") });
    }

    /**
     * Whether or not this stack output is being produced by the given Stack deployment.
     * <p>
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean isProducedBy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.StackDeployment stack) {
        return software.amazon.jsii.Kernel.call(this, "isProducedBy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * Output name of the producing stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOutputName() {
        return software.amazon.jsii.Kernel.get(this, "outputName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A human-readable description of the producing stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStackDescription() {
        return software.amazon.jsii.Kernel.get(this, "stackDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
