package software.amazon.awscdk.services.accessanalyzer;

/**
 * A reference to a Analyzer resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.accessanalyzer.*;
 * AnalyzerReference analyzerReference = AnalyzerReference.builder()
 *         .analyzerArn("analyzerArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:56.976Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_accessanalyzer.AnalyzerReference")
@software.amazon.jsii.Jsii.Proxy(AnalyzerReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AnalyzerReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the Analyzer resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAnalyzerArn();

    /**
     * @return a {@link Builder} of {@link AnalyzerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AnalyzerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AnalyzerReference> {
        java.lang.String analyzerArn;

        /**
         * Sets the value of {@link AnalyzerReference#getAnalyzerArn}
         * @param analyzerArn The Arn of the Analyzer resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyzerArn(java.lang.String analyzerArn) {
            this.analyzerArn = analyzerArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AnalyzerReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AnalyzerReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AnalyzerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalyzerReference {
        private final java.lang.String analyzerArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.analyzerArn = software.amazon.jsii.Kernel.get(this, "analyzerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.analyzerArn = java.util.Objects.requireNonNull(builder.analyzerArn, "analyzerArn is required");
        }

        @Override
        public final java.lang.String getAnalyzerArn() {
            return this.analyzerArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("analyzerArn", om.valueToTree(this.getAnalyzerArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_accessanalyzer.AnalyzerReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AnalyzerReference.Jsii$Proxy that = (AnalyzerReference.Jsii$Proxy) o;

            return this.analyzerArn.equals(that.analyzerArn);
        }

        @Override
        public final int hashCode() {
            int result = this.analyzerArn.hashCode();
            return result;
        }
    }
}
