package software.amazon.awscdk.services.amazonmq;

/**
 * A reference to a Broker resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.amazonmq.*;
 * BrokerReference brokerReference = BrokerReference.builder()
 *         .brokerArn("brokerArn")
 *         .brokerId("brokerId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:57.049Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amazonmq.BrokerReference")
@software.amazon.jsii.Jsii.Proxy(BrokerReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BrokerReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Broker resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBrokerArn();

    /**
     * The Id of the Broker resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBrokerId();

    /**
     * @return a {@link Builder} of {@link BrokerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BrokerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BrokerReference> {
        java.lang.String brokerArn;
        java.lang.String brokerId;

        /**
         * Sets the value of {@link BrokerReference#getBrokerArn}
         * @param brokerArn The ARN of the Broker resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder brokerArn(java.lang.String brokerArn) {
            this.brokerArn = brokerArn;
            return this;
        }

        /**
         * Sets the value of {@link BrokerReference#getBrokerId}
         * @param brokerId The Id of the Broker resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder brokerId(java.lang.String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BrokerReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BrokerReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BrokerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BrokerReference {
        private final java.lang.String brokerArn;
        private final java.lang.String brokerId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.brokerArn = software.amazon.jsii.Kernel.get(this, "brokerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.brokerId = software.amazon.jsii.Kernel.get(this, "brokerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.brokerArn = java.util.Objects.requireNonNull(builder.brokerArn, "brokerArn is required");
            this.brokerId = java.util.Objects.requireNonNull(builder.brokerId, "brokerId is required");
        }

        @Override
        public final java.lang.String getBrokerArn() {
            return this.brokerArn;
        }

        @Override
        public final java.lang.String getBrokerId() {
            return this.brokerId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("brokerArn", om.valueToTree(this.getBrokerArn()));
            data.set("brokerId", om.valueToTree(this.getBrokerId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amazonmq.BrokerReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BrokerReference.Jsii$Proxy that = (BrokerReference.Jsii$Proxy) o;

            if (!brokerArn.equals(that.brokerArn)) return false;
            return this.brokerId.equals(that.brokerId);
        }

        @Override
        public final int hashCode() {
            int result = this.brokerArn.hashCode();
            result = 31 * result + (this.brokerId.hashCode());
            return result;
        }
    }
}
