package software.amazon.awscdk.services.apigateway;

/**
 * A reference to a DocumentationPart resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * DocumentationPartReference documentationPartReference = DocumentationPartReference.builder()
 *         .documentationPartId("documentationPartId")
 *         .restApiId("restApiId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:57.309Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.DocumentationPartReference")
@software.amazon.jsii.Jsii.Proxy(DocumentationPartReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DocumentationPartReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The DocumentationPartId of the DocumentationPart resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDocumentationPartId();

    /**
     * The RestApiId of the DocumentationPart resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRestApiId();

    /**
     * @return a {@link Builder} of {@link DocumentationPartReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DocumentationPartReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DocumentationPartReference> {
        java.lang.String documentationPartId;
        java.lang.String restApiId;

        /**
         * Sets the value of {@link DocumentationPartReference#getDocumentationPartId}
         * @param documentationPartId The DocumentationPartId of the DocumentationPart resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentationPartId(java.lang.String documentationPartId) {
            this.documentationPartId = documentationPartId;
            return this;
        }

        /**
         * Sets the value of {@link DocumentationPartReference#getRestApiId}
         * @param restApiId The RestApiId of the DocumentationPart resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(java.lang.String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DocumentationPartReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DocumentationPartReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DocumentationPartReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentationPartReference {
        private final java.lang.String documentationPartId;
        private final java.lang.String restApiId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.documentationPartId = software.amazon.jsii.Kernel.get(this, "documentationPartId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restApiId = software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.documentationPartId = java.util.Objects.requireNonNull(builder.documentationPartId, "documentationPartId is required");
            this.restApiId = java.util.Objects.requireNonNull(builder.restApiId, "restApiId is required");
        }

        @Override
        public final java.lang.String getDocumentationPartId() {
            return this.documentationPartId;
        }

        @Override
        public final java.lang.String getRestApiId() {
            return this.restApiId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("documentationPartId", om.valueToTree(this.getDocumentationPartId()));
            data.set("restApiId", om.valueToTree(this.getRestApiId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.DocumentationPartReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DocumentationPartReference.Jsii$Proxy that = (DocumentationPartReference.Jsii$Proxy) o;

            if (!documentationPartId.equals(that.documentationPartId)) return false;
            return this.restApiId.equals(that.restApiId);
        }

        @Override
        public final int hashCode() {
            int result = this.documentationPartId.hashCode();
            result = 31 * result + (this.restApiId.hashCode());
            return result;
        }
    }
}
