package software.amazon.awscdk.services.apigateway;

/**
 * The endpoint configuration of a REST API, including VPCs and endpoint types.
 * <p>
 * EndpointConfiguration is a property of the AWS::ApiGateway::RestApi resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpcEndpoint someEndpoint;
 * RestApi api = RestApi.Builder.create(this, "api")
 *         .endpointConfiguration(EndpointConfiguration.builder()
 *                 .types(List.of(EndpointType.PRIVATE))
 *                 .vpcEndpoints(List.of(someEndpoint))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:57.314Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.EndpointConfiguration")
@software.amazon.jsii.Jsii.Proxy(EndpointConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EndpointConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of endpoint types of an API or its custom domain name.
     * <p>
     * Default: EndpointType.EDGE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> getTypes();

    /**
     * The IP address types that can invoke the API.
     * <p>
     * Default: undefined - AWS default is DUAL_STACK for private API, IPV4 for all other APIs.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-ip-address-type.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-ip-address-type.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.IpAddressType getIpAddressType() {
        return null;
    }

    /**
     * A list of VPC Endpoints against which to create Route53 ALIASes.
     * <p>
     * Default: - no ALIASes are created for the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpoint> getVpcEndpoints() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EndpointConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EndpointConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EndpointConfiguration> {
        java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> types;
        software.amazon.awscdk.services.apigateway.IpAddressType ipAddressType;
        java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpoint> vpcEndpoints;

        /**
         * Sets the value of {@link EndpointConfiguration#getTypes}
         * @param types A list of endpoint types of an API or its custom domain name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder types(java.util.List<? extends software.amazon.awscdk.services.apigateway.EndpointType> types) {
            this.types = (java.util.List<software.amazon.awscdk.services.apigateway.EndpointType>)types;
            return this;
        }

        /**
         * Sets the value of {@link EndpointConfiguration#getIpAddressType}
         * @param ipAddressType The IP address types that can invoke the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(software.amazon.awscdk.services.apigateway.IpAddressType ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Sets the value of {@link EndpointConfiguration#getVpcEndpoints}
         * @param vpcEndpoints A list of VPC Endpoints against which to create Route53 ALIASes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder vpcEndpoints(java.util.List<? extends software.amazon.awscdk.services.ec2.IVpcEndpoint> vpcEndpoints) {
            this.vpcEndpoints = (java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpoint>)vpcEndpoints;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EndpointConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EndpointConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EndpointConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointConfiguration {
        private final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> types;
        private final software.amazon.awscdk.services.apigateway.IpAddressType ipAddressType;
        private final java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpoint> vpcEndpoints;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.types = software.amazon.jsii.Kernel.get(this, "types", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.EndpointType.class)));
            this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IpAddressType.class));
            this.vpcEndpoints = software.amazon.jsii.Kernel.get(this, "vpcEndpoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpcEndpoint.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.types = (java.util.List<software.amazon.awscdk.services.apigateway.EndpointType>)java.util.Objects.requireNonNull(builder.types, "types is required");
            this.ipAddressType = builder.ipAddressType;
            this.vpcEndpoints = (java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpoint>)builder.vpcEndpoints;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> getTypes() {
            return this.types;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IpAddressType getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpoint> getVpcEndpoints() {
            return this.vpcEndpoints;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("types", om.valueToTree(this.getTypes()));
            if (this.getIpAddressType() != null) {
                data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
            }
            if (this.getVpcEndpoints() != null) {
                data.set("vpcEndpoints", om.valueToTree(this.getVpcEndpoints()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.EndpointConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EndpointConfiguration.Jsii$Proxy that = (EndpointConfiguration.Jsii$Proxy) o;

            if (!types.equals(that.types)) return false;
            if (this.ipAddressType != null ? !this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType != null) return false;
            return this.vpcEndpoints != null ? this.vpcEndpoints.equals(that.vpcEndpoints) : that.vpcEndpoints == null;
        }

        @Override
        public final int hashCode() {
            int result = this.types.hashCode();
            result = 31 * result + (this.ipAddressType != null ? this.ipAddressType.hashCode() : 0);
            result = 31 * result + (this.vpcEndpoints != null ? this.vpcEndpoints.hashCode() : 0);
            return result;
        }
    }
}
