package software.amazon.awscdk.services.apigatewayv2;

/**
 * A reference to a ApiMapping resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * ApiMappingReference apiMappingReference = ApiMappingReference.builder()
 *         .apiMappingId("apiMappingId")
 *         .domainName("domainName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:57.472Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.ApiMappingReference")
@software.amazon.jsii.Jsii.Proxy(ApiMappingReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApiMappingReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ApiMappingId of the ApiMapping resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiMappingId();

    /**
     * The DomainName of the ApiMapping resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * @return a {@link Builder} of {@link ApiMappingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApiMappingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApiMappingReference> {
        java.lang.String apiMappingId;
        java.lang.String domainName;

        /**
         * Sets the value of {@link ApiMappingReference#getApiMappingId}
         * @param apiMappingId The ApiMappingId of the ApiMapping resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiMappingId(java.lang.String apiMappingId) {
            this.apiMappingId = apiMappingId;
            return this;
        }

        /**
         * Sets the value of {@link ApiMappingReference#getDomainName}
         * @param domainName The DomainName of the ApiMapping resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApiMappingReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApiMappingReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApiMappingReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiMappingReference {
        private final java.lang.String apiMappingId;
        private final java.lang.String domainName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiMappingId = software.amazon.jsii.Kernel.get(this, "apiMappingId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiMappingId = java.util.Objects.requireNonNull(builder.apiMappingId, "apiMappingId is required");
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
        }

        @Override
        public final java.lang.String getApiMappingId() {
            return this.apiMappingId;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiMappingId", om.valueToTree(this.getApiMappingId()));
            data.set("domainName", om.valueToTree(this.getDomainName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.ApiMappingReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApiMappingReference.Jsii$Proxy that = (ApiMappingReference.Jsii$Proxy) o;

            if (!apiMappingId.equals(that.apiMappingId)) return false;
            return this.domainName.equals(that.domainName);
        }

        @Override
        public final int hashCode() {
            int result = this.apiMappingId.hashCode();
            result = 31 * result + (this.domainName.hashCode());
            return result;
        }
    }
}
