package software.amazon.awscdk.services.apigatewayv2;

/**
 * properties used for creating the DomainName.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.certificatemanager.*;
 * Bucket bucket;
 * String certArn = "arn:aws:acm:us-east-1:111111111111:certificate";
 * String domainName = "example.com";
 * DomainName.Builder.create(this, "DomainName")
 *         .domainName(domainName)
 *         .certificate(Certificate.fromCertificateArn(this, "cert", certArn))
 *         .mtls(MTLSConfig.builder()
 *                 .bucket(bucket)
 *                 .key("someca.pem")
 *                 .version("version")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:57.548Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.DomainNameProps")
@software.amazon.jsii.Jsii.Proxy(DomainNameProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DomainNameProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigatewayv2.EndpointOptions {

    /**
     * The custom domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * The mutual TLS authentication configuration for a custom domain name.
     * <p>
     * Default: - mTLS is not configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.MTLSConfig getMtls() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DomainNameProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DomainNameProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DomainNameProps> {
        java.lang.String domainName;
        software.amazon.awscdk.services.apigatewayv2.MTLSConfig mtls;
        software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        java.lang.String certificateName;
        software.amazon.awscdk.services.apigatewayv2.EndpointType endpointType;
        software.amazon.awscdk.services.apigatewayv2.IpAddressType ipAddressType;
        software.amazon.awscdk.services.certificatemanager.ICertificate ownershipCertificate;
        software.amazon.awscdk.services.apigatewayv2.SecurityPolicy securityPolicy;

        /**
         * Sets the value of {@link DomainNameProps#getDomainName}
         * @param domainName The custom domain name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameProps#getMtls}
         * @param mtls The mutual TLS authentication configuration for a custom domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mtls(software.amazon.awscdk.services.apigatewayv2.MTLSConfig mtls) {
            this.mtls = mtls;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameProps#getCertificate}
         * @param certificate The ACM certificate for this domain name. This parameter is required.
         *                    Certificate can be both ACM issued or imported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameProps#getCertificateName}
         * @param certificateName The user-friendly name of the certificate that will be used by the endpoint for this domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateName(java.lang.String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameProps#getEndpointType}
         * @param endpointType The type of endpoint for this DomainName.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointType(software.amazon.awscdk.services.apigatewayv2.EndpointType endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameProps#getIpAddressType}
         * @param ipAddressType The IP address types that can invoke the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(software.amazon.awscdk.services.apigatewayv2.IpAddressType ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameProps#getOwnershipCertificate}
         * @param ownershipCertificate A public certificate issued by ACM to validate that you own a custom domain.
         *                             This parameter is required
         *                             only when you configure mutual TLS authentication and you specify an ACM imported or private CA certificate
         *                             for <code>certificate</code>. The ownership certificate validates that you have permissions to use the domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownershipCertificate(software.amazon.awscdk.services.certificatemanager.ICertificate ownershipCertificate) {
            this.ownershipCertificate = ownershipCertificate;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameProps#getSecurityPolicy}
         * @param securityPolicy The Transport Layer Security (TLS) version + cipher suite for this domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityPolicy(software.amazon.awscdk.services.apigatewayv2.SecurityPolicy securityPolicy) {
            this.securityPolicy = securityPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DomainNameProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DomainNameProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DomainNameProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainNameProps {
        private final java.lang.String domainName;
        private final software.amazon.awscdk.services.apigatewayv2.MTLSConfig mtls;
        private final software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private final java.lang.String certificateName;
        private final software.amazon.awscdk.services.apigatewayv2.EndpointType endpointType;
        private final software.amazon.awscdk.services.apigatewayv2.IpAddressType ipAddressType;
        private final software.amazon.awscdk.services.certificatemanager.ICertificate ownershipCertificate;
        private final software.amazon.awscdk.services.apigatewayv2.SecurityPolicy securityPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mtls = software.amazon.jsii.Kernel.get(this, "mtls", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.MTLSConfig.class));
            this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.ICertificate.class));
            this.certificateName = software.amazon.jsii.Kernel.get(this, "certificateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpointType = software.amazon.jsii.Kernel.get(this, "endpointType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.EndpointType.class));
            this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IpAddressType.class));
            this.ownershipCertificate = software.amazon.jsii.Kernel.get(this, "ownershipCertificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.ICertificate.class));
            this.securityPolicy = software.amazon.jsii.Kernel.get(this, "securityPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.SecurityPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.mtls = builder.mtls;
            this.certificate = java.util.Objects.requireNonNull(builder.certificate, "certificate is required");
            this.certificateName = builder.certificateName;
            this.endpointType = builder.endpointType;
            this.ipAddressType = builder.ipAddressType;
            this.ownershipCertificate = builder.ownershipCertificate;
            this.securityPolicy = builder.securityPolicy;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.MTLSConfig getMtls() {
            return this.mtls;
        }

        @Override
        public final software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
            return this.certificate;
        }

        @Override
        public final java.lang.String getCertificateName() {
            return this.certificateName;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.EndpointType getEndpointType() {
            return this.endpointType;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IpAddressType getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final software.amazon.awscdk.services.certificatemanager.ICertificate getOwnershipCertificate() {
            return this.ownershipCertificate;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.SecurityPolicy getSecurityPolicy() {
            return this.securityPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getMtls() != null) {
                data.set("mtls", om.valueToTree(this.getMtls()));
            }
            data.set("certificate", om.valueToTree(this.getCertificate()));
            if (this.getCertificateName() != null) {
                data.set("certificateName", om.valueToTree(this.getCertificateName()));
            }
            if (this.getEndpointType() != null) {
                data.set("endpointType", om.valueToTree(this.getEndpointType()));
            }
            if (this.getIpAddressType() != null) {
                data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
            }
            if (this.getOwnershipCertificate() != null) {
                data.set("ownershipCertificate", om.valueToTree(this.getOwnershipCertificate()));
            }
            if (this.getSecurityPolicy() != null) {
                data.set("securityPolicy", om.valueToTree(this.getSecurityPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.DomainNameProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DomainNameProps.Jsii$Proxy that = (DomainNameProps.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (this.mtls != null ? !this.mtls.equals(that.mtls) : that.mtls != null) return false;
            if (!certificate.equals(that.certificate)) return false;
            if (this.certificateName != null ? !this.certificateName.equals(that.certificateName) : that.certificateName != null) return false;
            if (this.endpointType != null ? !this.endpointType.equals(that.endpointType) : that.endpointType != null) return false;
            if (this.ipAddressType != null ? !this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType != null) return false;
            if (this.ownershipCertificate != null ? !this.ownershipCertificate.equals(that.ownershipCertificate) : that.ownershipCertificate != null) return false;
            return this.securityPolicy != null ? this.securityPolicy.equals(that.securityPolicy) : that.securityPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.mtls != null ? this.mtls.hashCode() : 0);
            result = 31 * result + (this.certificate.hashCode());
            result = 31 * result + (this.certificateName != null ? this.certificateName.hashCode() : 0);
            result = 31 * result + (this.endpointType != null ? this.endpointType.hashCode() : 0);
            result = 31 * result + (this.ipAddressType != null ? this.ipAddressType.hashCode() : 0);
            result = 31 * result + (this.ownershipCertificate != null ? this.ownershipCertificate.hashCode() : 0);
            result = 31 * result + (this.securityPolicy != null ? this.securityPolicy.hashCode() : 0);
            return result;
        }
    }
}
