package software.amazon.awscdk.services.applicationsignals;

/**
 * Creates or updates a service level objective (SLO), which can help you ensure that your critical business operations are meeting customer expectations.
 * <p>
 * Use SLOs to set and track specific target levels for the reliability and availability of your applications and services. SLOs use service level indicators (SLIs) to calculate whether the application is performing at the level that you want.
 * <p>
 * Create an SLO to set a target for a service operation, or service dependency's availability or latency. CloudWatch measures this target frequently you can find whether it has been breached.
 * <p>
 * The target performance quality that is defined for an SLO is the <em>attainment goal</em> . An attainment goal is the percentage of time or requests that the SLI is expected to meet the threshold over each time interval. For example, an attainment goal of 99.9% means that within your interval, you are targeting 99.9% of the periods to be in healthy state.
 * <p>
 * When you create an SLO, you specify whether it is a <em>period-based SLO</em> or a <em>request-based SLO</em> . Each type of SLO has a different way of evaluating your application's performance against its attainment goal.
 * <p>
 * <ul>
 * <li>A <em>period-based SLO</em> uses defined <em>periods</em> of time within a specified total time interval. For each period of time, Application Signals determines whether the application met its goal. The attainment rate is calculated as the <code>number of good periods/number of total periods</code> .</li>
 * </ul>
 * <p>
 * For example, for a period-based SLO, meeting an attainment goal of 99.9% means that within your interval, your application must meet its performance goal during at least 99.9% of the time periods.
 * <p>
 * <ul>
 * <li>A <em>request-based SLO</em> doesn't use pre-defined periods of time. Instead, the SLO measures <code>number of good requests/number of total requests</code> during the interval. At any time, you can find the ratio of good requests to total requests for the interval up to the time stamp that you specify, and measure that ratio against the goal set in your SLO.</li>
 * </ul>
 * <p>
 * After you have created an SLO, you can retrieve error budget reports for it. An <em>error budget</em> is the amount of time or amount of requests that your application can be non-compliant with the SLO's goal, and still have your application meet the goal.
 * <p>
 * <ul>
 * <li>For a period-based SLO, the error budget starts at a number defined by the highest number of periods that can fail to meet the threshold, while still meeting the overall goal. The <em>remaining error budget</em> decreases with every failed period that is recorded. The error budget within one interval can never increase.</li>
 * </ul>
 * <p>
 * For example, an SLO with a threshold that 99.95% of requests must be completed under 2000ms every month translates to an error budget of 21.9 minutes of downtime per month.
 * <p>
 * <ul>
 * <li>For a request-based SLO, the remaining error budget is dynamic and can increase or decrease, depending on the ratio of good requests to total requests.</li>
 * </ul>
 * <p>
 * When you call this operation, Application Signals creates the <em>AWSServiceRoleForCloudWatchApplicationSignals</em> service-linked role, if it doesn't already exist in your account. This service- linked role has the following permissions:
 * <p>
 * <ul>
 * <li><code>xray:GetServiceGraph</code></li>
 * <li><code>logs:StartQuery</code></li>
 * <li><code>logs:GetQueryResults</code></li>
 * <li><code>cloudwatch:GetMetricData</code></li>
 * <li><code>cloudwatch:ListMetrics</code></li>
 * <li><code>tag:GetResources</code></li>
 * <li><code>autoscaling:DescribeAutoScalingGroups</code></li>
 * </ul>
 * <p>
 * You can easily set SLO targets for your applications, and their dependencies, that are discovered by Application Signals, using critical metrics such as latency and availability. You can also set SLOs against any CloudWatch metric or math expression that produces a time series.
 * <p>
 * <blockquote>
 * <p>
 * You can't create an SLO for a service operation that was discovered by Application Signals until after that operation has reported standard metrics to Application Signals.
 * <p>
 * </blockquote>
 * <p>
 * You cannot change from a period-based SLO to a request-based SLO, or change from a request-based SLO to a period-based SLO.
 * <p>
 * For more information about SLOs, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-ServiceLevelObjectives.html">Service level objectives (SLOs)</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.applicationsignals.*;
 * CfnServiceLevelObjective cfnServiceLevelObjective = CfnServiceLevelObjective.Builder.create(this, "MyCfnServiceLevelObjective")
 *         .name("name")
 *         // the properties below are optional
 *         .burnRateConfigurations(List.of(BurnRateConfigurationProperty.builder()
 *                 .lookBackWindowMinutes(123)
 *                 .build()))
 *         .description("description")
 *         .exclusionWindows(List.of(ExclusionWindowProperty.builder()
 *                 .window(WindowProperty.builder()
 *                         .duration(123)
 *                         .durationUnit("durationUnit")
 *                         .build())
 *                 // the properties below are optional
 *                 .reason("reason")
 *                 .recurrenceRule(RecurrenceRuleProperty.builder()
 *                         .expression("expression")
 *                         .build())
 *                 .startTime("startTime")
 *                 .build()))
 *         .goal(GoalProperty.builder()
 *                 .attainmentGoal(123)
 *                 .interval(IntervalProperty.builder()
 *                         .calendarInterval(CalendarIntervalProperty.builder()
 *                                 .duration(123)
 *                                 .durationUnit("durationUnit")
 *                                 .startTime(123)
 *                                 .build())
 *                         .rollingInterval(RollingIntervalProperty.builder()
 *                                 .duration(123)
 *                                 .durationUnit("durationUnit")
 *                                 .build())
 *                         .build())
 *                 .warningThreshold(123)
 *                 .build())
 *         .requestBasedSli(RequestBasedSliProperty.builder()
 *                 .requestBasedSliMetric(RequestBasedSliMetricProperty.builder()
 *                         .dependencyConfig(DependencyConfigProperty.builder()
 *                                 .dependencyKeyAttributes(Map.of(
 *                                         "dependencyKeyAttributesKey", "dependencyKeyAttributes"))
 *                                 .dependencyOperationName("dependencyOperationName")
 *                                 .build())
 *                         .keyAttributes(Map.of(
 *                                 "keyAttributesKey", "keyAttributes"))
 *                         .metricType("metricType")
 *                         .monitoredRequestCountMetric(MonitoredRequestCountMetricProperty.builder()
 *                                 .badCountMetric(List.of(MetricDataQueryProperty.builder()
 *                                         .id("id")
 *                                         // the properties below are optional
 *                                         .accountId("accountId")
 *                                         .expression("expression")
 *                                         .metricStat(MetricStatProperty.builder()
 *                                                 .metric(MetricProperty.builder()
 *                                                         .dimensions(List.of(DimensionProperty.builder()
 *                                                                 .name("name")
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .metricName("metricName")
 *                                                         .namespace("namespace")
 *                                                         .build())
 *                                                 .period(123)
 *                                                 .stat("stat")
 *                                                 // the properties below are optional
 *                                                 .unit("unit")
 *                                                 .build())
 *                                         .returnData(false)
 *                                         .build()))
 *                                 .goodCountMetric(List.of(MetricDataQueryProperty.builder()
 *                                         .id("id")
 *                                         // the properties below are optional
 *                                         .accountId("accountId")
 *                                         .expression("expression")
 *                                         .metricStat(MetricStatProperty.builder()
 *                                                 .metric(MetricProperty.builder()
 *                                                         .dimensions(List.of(DimensionProperty.builder()
 *                                                                 .name("name")
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .metricName("metricName")
 *                                                         .namespace("namespace")
 *                                                         .build())
 *                                                 .period(123)
 *                                                 .stat("stat")
 *                                                 // the properties below are optional
 *                                                 .unit("unit")
 *                                                 .build())
 *                                         .returnData(false)
 *                                         .build()))
 *                                 .build())
 *                         .operationName("operationName")
 *                         .totalRequestCountMetric(List.of(MetricDataQueryProperty.builder()
 *                                 .id("id")
 *                                 // the properties below are optional
 *                                 .accountId("accountId")
 *                                 .expression("expression")
 *                                 .metricStat(MetricStatProperty.builder()
 *                                         .metric(MetricProperty.builder()
 *                                                 .dimensions(List.of(DimensionProperty.builder()
 *                                                         .name("name")
 *                                                         .value("value")
 *                                                         .build()))
 *                                                 .metricName("metricName")
 *                                                 .namespace("namespace")
 *                                                 .build())
 *                                         .period(123)
 *                                         .stat("stat")
 *                                         // the properties below are optional
 *                                         .unit("unit")
 *                                         .build())
 *                                 .returnData(false)
 *                                 .build()))
 *                         .build())
 *                 // the properties below are optional
 *                 .comparisonOperator("comparisonOperator")
 *                 .metricThreshold(123)
 *                 .build())
 *         .sli(SliProperty.builder()
 *                 .comparisonOperator("comparisonOperator")
 *                 .metricThreshold(123)
 *                 .sliMetric(SliMetricProperty.builder()
 *                         .dependencyConfig(DependencyConfigProperty.builder()
 *                                 .dependencyKeyAttributes(Map.of(
 *                                         "dependencyKeyAttributesKey", "dependencyKeyAttributes"))
 *                                 .dependencyOperationName("dependencyOperationName")
 *                                 .build())
 *                         .keyAttributes(Map.of(
 *                                 "keyAttributesKey", "keyAttributes"))
 *                         .metricDataQueries(List.of(MetricDataQueryProperty.builder()
 *                                 .id("id")
 *                                 // the properties below are optional
 *                                 .accountId("accountId")
 *                                 .expression("expression")
 *                                 .metricStat(MetricStatProperty.builder()
 *                                         .metric(MetricProperty.builder()
 *                                                 .dimensions(List.of(DimensionProperty.builder()
 *                                                         .name("name")
 *                                                         .value("value")
 *                                                         .build()))
 *                                                 .metricName("metricName")
 *                                                 .namespace("namespace")
 *                                                 .build())
 *                                         .period(123)
 *                                         .stat("stat")
 *                                         // the properties below are optional
 *                                         .unit("unit")
 *                                         .build())
 *                                 .returnData(false)
 *                                 .build()))
 *                         .metricType("metricType")
 *                         .operationName("operationName")
 *                         .periodSeconds(123)
 *                         .statistic("statistic")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:58.003Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective")
public class CfnServiceLevelObjective extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.applicationsignals.IServiceLevelObjectiveRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnServiceLevelObjective(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnServiceLevelObjective(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnServiceLevelObjective(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjectiveProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of this SLO.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time that this SLO was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrCreatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Displays whether this is a period-based SLO or a request-based SLO.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEvaluationType() {
        return software.amazon.jsii.Kernel.get(this, "attrEvaluationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time that this SLO was most recently updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrLastUpdatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdatedTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a ServiceLevelObjective resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationsignals.ServiceLevelObjectiveReference getServiceLevelObjectiveRef() {
        return software.amazon.jsii.Kernel.get(this, "serviceLevelObjectiveRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationsignals.ServiceLevelObjectiveReference.class));
    }

    /**
     * A name for this SLO.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for this SLO.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Each object in this array defines the length of the look-back window used to calculate one burn rate metric for this SLO.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.BurnRateConfigurationProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBurnRateConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "burnRateConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Each object in this array defines the length of the look-back window used to calculate one burn rate metric for this SLO.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBurnRateConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "burnRateConfigurations", value);
    }

    /**
     * Each object in this array defines the length of the look-back window used to calculate one burn rate metric for this SLO.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBurnRateConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.BurnRateConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.BurnRateConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "burnRateConfigurations", value);
    }

    /**
     * An optional description for this SLO.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An optional description for this SLO.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The time window to be excluded from the SLO performance metrics.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.ExclusionWindowProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExclusionWindows() {
        return software.amazon.jsii.Kernel.get(this, "exclusionWindows", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The time window to be excluded from the SLO performance metrics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExclusionWindows(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "exclusionWindows", value);
    }

    /**
     * The time window to be excluded from the SLO performance metrics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExclusionWindows(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.ExclusionWindowProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.ExclusionWindowProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "exclusionWindows", value);
    }

    /**
     * This structure contains the attributes that determine the goal of an SLO.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.GoalProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGoal() {
        return software.amazon.jsii.Kernel.get(this, "goal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * This structure contains the attributes that determine the goal of an SLO.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGoal(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "goal", value);
    }

    /**
     * This structure contains the attributes that determine the goal of an SLO.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGoal(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.GoalProperty value) {
        software.amazon.jsii.Kernel.set(this, "goal", value);
    }

    /**
     * A structure containing information about the performance metric that this SLO monitors, if this is a request-based SLO.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.RequestBasedSliProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRequestBasedSli() {
        return software.amazon.jsii.Kernel.get(this, "requestBasedSli", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure containing information about the performance metric that this SLO monitors, if this is a request-based SLO.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequestBasedSli(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "requestBasedSli", value);
    }

    /**
     * A structure containing information about the performance metric that this SLO monitors, if this is a request-based SLO.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequestBasedSli(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.RequestBasedSliProperty value) {
        software.amazon.jsii.Kernel.set(this, "requestBasedSli", value);
    }

    /**
     * A structure containing information about the performance metric that this SLO monitors, if this is a period-based SLO.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.SliProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSli() {
        return software.amazon.jsii.Kernel.get(this, "sli", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure containing information about the performance metric that this SLO monitors, if this is a period-based SLO.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSli(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sli", value);
    }

    /**
     * A structure containing information about the performance metric that this SLO monitors, if this is a period-based SLO.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSli(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.SliProperty value) {
        software.amazon.jsii.Kernel.set(this, "sli", value);
    }

    /**
     * A list of key-value pairs to associate with the SLO.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of key-value pairs to associate with the SLO.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * This object defines the length of the look-back window used to calculate one burn rate metric for this SLO.
     * <p>
     * The burn rate measures how fast the service is consuming the error budget, relative to the attainment goal of the SLO. A burn rate of exactly 1 indicates that the SLO goal will be met exactly.
     * <p>
     * For example, if you specify 60 as the number of minutes in the look-back window, the burn rate is calculated as the following:
     * <p>
     * <em>burn rate = error rate over the look-back window / (100% - attainment goal percentage)</em>
     * <p>
     * For more information about burn rates, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-ServiceLevelObjectives.html#CloudWatch-ServiceLevelObjectives-burn">Calculate burn rates</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * BurnRateConfigurationProperty burnRateConfigurationProperty = BurnRateConfigurationProperty.builder()
     *         .lookBackWindowMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-burnrateconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-burnrateconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.BurnRateConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(BurnRateConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BurnRateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of minutes to use as the look-back window.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-burnrateconfiguration.html#cfn-applicationsignals-servicelevelobjective-burnrateconfiguration-lookbackwindowminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-burnrateconfiguration.html#cfn-applicationsignals-servicelevelobjective-burnrateconfiguration-lookbackwindowminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getLookBackWindowMinutes();

        /**
         * @return a {@link Builder} of {@link BurnRateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BurnRateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BurnRateConfigurationProperty> {
            java.lang.Number lookBackWindowMinutes;

            /**
             * Sets the value of {@link BurnRateConfigurationProperty#getLookBackWindowMinutes}
             * @param lookBackWindowMinutes The number of minutes to use as the look-back window. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lookBackWindowMinutes(java.lang.Number lookBackWindowMinutes) {
                this.lookBackWindowMinutes = lookBackWindowMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BurnRateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BurnRateConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BurnRateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BurnRateConfigurationProperty {
            private final java.lang.Number lookBackWindowMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lookBackWindowMinutes = software.amazon.jsii.Kernel.get(this, "lookBackWindowMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lookBackWindowMinutes = java.util.Objects.requireNonNull(builder.lookBackWindowMinutes, "lookBackWindowMinutes is required");
            }

            @Override
            public final java.lang.Number getLookBackWindowMinutes() {
                return this.lookBackWindowMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("lookBackWindowMinutes", om.valueToTree(this.getLookBackWindowMinutes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.BurnRateConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BurnRateConfigurationProperty.Jsii$Proxy that = (BurnRateConfigurationProperty.Jsii$Proxy) o;

                return this.lookBackWindowMinutes.equals(that.lookBackWindowMinutes);
            }

            @Override
            public final int hashCode() {
                int result = this.lookBackWindowMinutes.hashCode();
                return result;
            }
        }
    }
    /**
     * If the interval for this service level objective is a calendar interval, this structure contains the interval specifications.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * CalendarIntervalProperty calendarIntervalProperty = CalendarIntervalProperty.builder()
     *         .duration(123)
     *         .durationUnit("durationUnit")
     *         .startTime(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-calendarinterval.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-calendarinterval.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.CalendarIntervalProperty")
    @software.amazon.jsii.Jsii.Proxy(CalendarIntervalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CalendarIntervalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the duration of each calendar interval.
         * <p>
         * For example, if <code>Duration</code> is <code>1</code> and <code>DurationUnit</code> is <code>MONTH</code> , each interval is one month, aligned with the calendar.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-calendarinterval.html#cfn-applicationsignals-servicelevelobjective-calendarinterval-duration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-calendarinterval.html#cfn-applicationsignals-servicelevelobjective-calendarinterval-duration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDuration();

        /**
         * Specifies the calendar interval unit.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-calendarinterval.html#cfn-applicationsignals-servicelevelobjective-calendarinterval-durationunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-calendarinterval.html#cfn-applicationsignals-servicelevelobjective-calendarinterval-durationunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDurationUnit();

        /**
         * The date and time when you want the first interval to start.
         * <p>
         * Be sure to choose a time that configures the intervals the way that you want. For example, if you want weekly intervals starting on Mondays at 6 a.m., be sure to specify a start time that is a Monday at 6 a.m.
         * <p>
         * When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code>
         * <p>
         * As soon as one calendar interval ends, another automatically begins.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-calendarinterval.html#cfn-applicationsignals-servicelevelobjective-calendarinterval-starttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-calendarinterval.html#cfn-applicationsignals-servicelevelobjective-calendarinterval-starttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getStartTime();

        /**
         * @return a {@link Builder} of {@link CalendarIntervalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CalendarIntervalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CalendarIntervalProperty> {
            java.lang.Number duration;
            java.lang.String durationUnit;
            java.lang.Number startTime;

            /**
             * Sets the value of {@link CalendarIntervalProperty#getDuration}
             * @param duration Specifies the duration of each calendar interval. This parameter is required.
             *                 For example, if <code>Duration</code> is <code>1</code> and <code>DurationUnit</code> is <code>MONTH</code> , each interval is one month, aligned with the calendar.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder duration(java.lang.Number duration) {
                this.duration = duration;
                return this;
            }

            /**
             * Sets the value of {@link CalendarIntervalProperty#getDurationUnit}
             * @param durationUnit Specifies the calendar interval unit. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationUnit(java.lang.String durationUnit) {
                this.durationUnit = durationUnit;
                return this;
            }

            /**
             * Sets the value of {@link CalendarIntervalProperty#getStartTime}
             * @param startTime The date and time when you want the first interval to start. This parameter is required.
             *                  Be sure to choose a time that configures the intervals the way that you want. For example, if you want weekly intervals starting on Mondays at 6 a.m., be sure to specify a start time that is a Monday at 6 a.m.
             *                  <p>
             *                  When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code>
             *                  <p>
             *                  As soon as one calendar interval ends, another automatically begins.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(java.lang.Number startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CalendarIntervalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CalendarIntervalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CalendarIntervalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CalendarIntervalProperty {
            private final java.lang.Number duration;
            private final java.lang.String durationUnit;
            private final java.lang.Number startTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.duration = software.amazon.jsii.Kernel.get(this, "duration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.durationUnit = software.amazon.jsii.Kernel.get(this, "durationUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.duration = java.util.Objects.requireNonNull(builder.duration, "duration is required");
                this.durationUnit = java.util.Objects.requireNonNull(builder.durationUnit, "durationUnit is required");
                this.startTime = java.util.Objects.requireNonNull(builder.startTime, "startTime is required");
            }

            @Override
            public final java.lang.Number getDuration() {
                return this.duration;
            }

            @Override
            public final java.lang.String getDurationUnit() {
                return this.durationUnit;
            }

            @Override
            public final java.lang.Number getStartTime() {
                return this.startTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("duration", om.valueToTree(this.getDuration()));
                data.set("durationUnit", om.valueToTree(this.getDurationUnit()));
                data.set("startTime", om.valueToTree(this.getStartTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.CalendarIntervalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CalendarIntervalProperty.Jsii$Proxy that = (CalendarIntervalProperty.Jsii$Proxy) o;

                if (!duration.equals(that.duration)) return false;
                if (!durationUnit.equals(that.durationUnit)) return false;
                return this.startTime.equals(that.startTime);
            }

            @Override
            public final int hashCode() {
                int result = this.duration.hashCode();
                result = 31 * result + (this.durationUnit.hashCode());
                result = 31 * result + (this.startTime.hashCode());
                return result;
            }
        }
    }
    /**
     * Identifies the dependency using the <code>DependencyKeyAttributes</code> and <code>DependencyOperationName</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * DependencyConfigProperty dependencyConfigProperty = DependencyConfigProperty.builder()
     *         .dependencyKeyAttributes(Map.of(
     *                 "dependencyKeyAttributesKey", "dependencyKeyAttributes"))
     *         .dependencyOperationName("dependencyOperationName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-dependencyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-dependencyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.DependencyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DependencyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DependencyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If this SLO is related to a metric collected by Application Signals, you must use this field to specify which dependency the SLO metric is related to.
         * <p>
         * <ul>
         * <li><code>Type</code> designates the type of object this is.</li>
         * <li><code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
         * <li><code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code> , <code>RemoteService</code> , or <code>AWS::Service</code> .</li>
         * <li><code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
         * <li><code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</li>
         * </ul>
         * <p>
         * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-dependencyconfig.html#cfn-applicationsignals-servicelevelobjective-dependencyconfig-dependencykeyattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-dependencyconfig.html#cfn-applicationsignals-servicelevelobjective-dependencyconfig-dependencykeyattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDependencyKeyAttributes();

        /**
         * When the SLO monitors a specific operation of the dependency, this field specifies the name of that operation in the dependency.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-dependencyconfig.html#cfn-applicationsignals-servicelevelobjective-dependencyconfig-dependencyoperationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-dependencyconfig.html#cfn-applicationsignals-servicelevelobjective-dependencyconfig-dependencyoperationname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDependencyOperationName();

        /**
         * @return a {@link Builder} of {@link DependencyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DependencyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DependencyConfigProperty> {
            java.lang.Object dependencyKeyAttributes;
            java.lang.String dependencyOperationName;

            /**
             * Sets the value of {@link DependencyConfigProperty#getDependencyKeyAttributes}
             * @param dependencyKeyAttributes If this SLO is related to a metric collected by Application Signals, you must use this field to specify which dependency the SLO metric is related to. This parameter is required.
             *                                <ul>
             *                                <li><code>Type</code> designates the type of object this is.</li>
             *                                <li><code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
             *                                <li><code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code> , <code>RemoteService</code> , or <code>AWS::Service</code> .</li>
             *                                <li><code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
             *                                <li><code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</li>
             *                                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependencyKeyAttributes(java.util.Map<java.lang.String, java.lang.String> dependencyKeyAttributes) {
                this.dependencyKeyAttributes = dependencyKeyAttributes;
                return this;
            }

            /**
             * Sets the value of {@link DependencyConfigProperty#getDependencyKeyAttributes}
             * @param dependencyKeyAttributes If this SLO is related to a metric collected by Application Signals, you must use this field to specify which dependency the SLO metric is related to. This parameter is required.
             *                                <ul>
             *                                <li><code>Type</code> designates the type of object this is.</li>
             *                                <li><code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
             *                                <li><code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code> , <code>RemoteService</code> , or <code>AWS::Service</code> .</li>
             *                                <li><code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
             *                                <li><code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</li>
             *                                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependencyKeyAttributes(software.amazon.awscdk.IResolvable dependencyKeyAttributes) {
                this.dependencyKeyAttributes = dependencyKeyAttributes;
                return this;
            }

            /**
             * Sets the value of {@link DependencyConfigProperty#getDependencyOperationName}
             * @param dependencyOperationName When the SLO monitors a specific operation of the dependency, this field specifies the name of that operation in the dependency. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependencyOperationName(java.lang.String dependencyOperationName) {
                this.dependencyOperationName = dependencyOperationName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DependencyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DependencyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DependencyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DependencyConfigProperty {
            private final java.lang.Object dependencyKeyAttributes;
            private final java.lang.String dependencyOperationName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dependencyKeyAttributes = software.amazon.jsii.Kernel.get(this, "dependencyKeyAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dependencyOperationName = software.amazon.jsii.Kernel.get(this, "dependencyOperationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dependencyKeyAttributes = java.util.Objects.requireNonNull(builder.dependencyKeyAttributes, "dependencyKeyAttributes is required");
                this.dependencyOperationName = java.util.Objects.requireNonNull(builder.dependencyOperationName, "dependencyOperationName is required");
            }

            @Override
            public final java.lang.Object getDependencyKeyAttributes() {
                return this.dependencyKeyAttributes;
            }

            @Override
            public final java.lang.String getDependencyOperationName() {
                return this.dependencyOperationName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dependencyKeyAttributes", om.valueToTree(this.getDependencyKeyAttributes()));
                data.set("dependencyOperationName", om.valueToTree(this.getDependencyOperationName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.DependencyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DependencyConfigProperty.Jsii$Proxy that = (DependencyConfigProperty.Jsii$Proxy) o;

                if (!dependencyKeyAttributes.equals(that.dependencyKeyAttributes)) return false;
                return this.dependencyOperationName.equals(that.dependencyOperationName);
            }

            @Override
            public final int hashCode() {
                int result = this.dependencyKeyAttributes.hashCode();
                result = 31 * result + (this.dependencyOperationName.hashCode());
                return result;
            }
        }
    }
    /**
     * A dimension is a name/value pair that is part of the identity of a metric.
     * <p>
     * Because dimensions are part of the unique identifier for a metric, whenever you add a unique name/value pair to one of your metrics, you are creating a new variation of that metric. For example, many Amazon EC2 metrics publish <code>InstanceId</code> as a dimension name, and the actual instance ID as the value for that dimension.
     * <p>
     * You can assign up to 30 dimensions to a metric.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * DimensionProperty dimensionProperty = DimensionProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-dimension.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-dimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.DimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(DimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the dimension.
         * <p>
         * Dimension names must contain only ASCII characters, must include at least one non-whitespace character, and cannot start with a colon ( <code>:</code> ). ASCII control characters are not supported as part of dimension names.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-dimension.html#cfn-applicationsignals-servicelevelobjective-dimension-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-dimension.html#cfn-applicationsignals-servicelevelobjective-dimension-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value of the dimension.
         * <p>
         * Dimension values must contain only ASCII characters and must include at least one non-whitespace character. ASCII control characters are not supported as part of dimension values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-dimension.html#cfn-applicationsignals-servicelevelobjective-dimension-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-dimension.html#cfn-applicationsignals-servicelevelobjective-dimension-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DimensionProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link DimensionProperty#getName}
             * @param name The name of the dimension. This parameter is required.
             *             Dimension names must contain only ASCII characters, must include at least one non-whitespace character, and cannot start with a colon ( <code>:</code> ). ASCII control characters are not supported as part of dimension names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DimensionProperty#getValue}
             * @param value The value of the dimension. This parameter is required.
             *              Dimension values must contain only ASCII characters and must include at least one non-whitespace character. ASCII control characters are not supported as part of dimension values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DimensionProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.DimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DimensionProperty.Jsii$Proxy that = (DimensionProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The time window to be excluded from the SLO performance metrics.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * ExclusionWindowProperty exclusionWindowProperty = ExclusionWindowProperty.builder()
     *         .window(WindowProperty.builder()
     *                 .duration(123)
     *                 .durationUnit("durationUnit")
     *                 .build())
     *         // the properties below are optional
     *         .reason("reason")
     *         .recurrenceRule(RecurrenceRuleProperty.builder()
     *                 .expression("expression")
     *                 .build())
     *         .startTime("startTime")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-exclusionwindow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-exclusionwindow.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.ExclusionWindowProperty")
    @software.amazon.jsii.Jsii.Proxy(ExclusionWindowProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExclusionWindowProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The time exclusion window.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.WindowProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-exclusionwindow.html#cfn-applicationsignals-servicelevelobjective-exclusionwindow-window">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-exclusionwindow.html#cfn-applicationsignals-servicelevelobjective-exclusionwindow-window</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getWindow();

        /**
         * The reason for the time exclusion windows.
         * <p>
         * For example, maintenance.
         * <p>
         * Default: - "No reason"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-exclusionwindow.html#cfn-applicationsignals-servicelevelobjective-exclusionwindow-reason">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-exclusionwindow.html#cfn-applicationsignals-servicelevelobjective-exclusionwindow-reason</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReason() {
            return null;
        }

        /**
         * The recurrence rule for the time exclusion window.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.RecurrenceRuleProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-exclusionwindow.html#cfn-applicationsignals-servicelevelobjective-exclusionwindow-recurrencerule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-exclusionwindow.html#cfn-applicationsignals-servicelevelobjective-exclusionwindow-recurrencerule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRecurrenceRule() {
            return null;
        }

        /**
         * The start time of the time exclusion window.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-exclusionwindow.html#cfn-applicationsignals-servicelevelobjective-exclusionwindow-starttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-exclusionwindow.html#cfn-applicationsignals-servicelevelobjective-exclusionwindow-starttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExclusionWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExclusionWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExclusionWindowProperty> {
            java.lang.Object window;
            java.lang.String reason;
            java.lang.Object recurrenceRule;
            java.lang.String startTime;

            /**
             * Sets the value of {@link ExclusionWindowProperty#getWindow}
             * @param window The time exclusion window. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder window(software.amazon.awscdk.IResolvable window) {
                this.window = window;
                return this;
            }

            /**
             * Sets the value of {@link ExclusionWindowProperty#getWindow}
             * @param window The time exclusion window. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder window(software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.WindowProperty window) {
                this.window = window;
                return this;
            }

            /**
             * Sets the value of {@link ExclusionWindowProperty#getReason}
             * @param reason The reason for the time exclusion windows.
             *               For example, maintenance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reason(java.lang.String reason) {
                this.reason = reason;
                return this;
            }

            /**
             * Sets the value of {@link ExclusionWindowProperty#getRecurrenceRule}
             * @param recurrenceRule The recurrence rule for the time exclusion window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recurrenceRule(software.amazon.awscdk.IResolvable recurrenceRule) {
                this.recurrenceRule = recurrenceRule;
                return this;
            }

            /**
             * Sets the value of {@link ExclusionWindowProperty#getRecurrenceRule}
             * @param recurrenceRule The recurrence rule for the time exclusion window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recurrenceRule(software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.RecurrenceRuleProperty recurrenceRule) {
                this.recurrenceRule = recurrenceRule;
                return this;
            }

            /**
             * Sets the value of {@link ExclusionWindowProperty#getStartTime}
             * @param startTime The start time of the time exclusion window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(java.lang.String startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExclusionWindowProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExclusionWindowProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExclusionWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExclusionWindowProperty {
            private final java.lang.Object window;
            private final java.lang.String reason;
            private final java.lang.Object recurrenceRule;
            private final java.lang.String startTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.window = software.amazon.jsii.Kernel.get(this, "window", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.reason = software.amazon.jsii.Kernel.get(this, "reason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recurrenceRule = software.amazon.jsii.Kernel.get(this, "recurrenceRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.window = java.util.Objects.requireNonNull(builder.window, "window is required");
                this.reason = builder.reason;
                this.recurrenceRule = builder.recurrenceRule;
                this.startTime = builder.startTime;
            }

            @Override
            public final java.lang.Object getWindow() {
                return this.window;
            }

            @Override
            public final java.lang.String getReason() {
                return this.reason;
            }

            @Override
            public final java.lang.Object getRecurrenceRule() {
                return this.recurrenceRule;
            }

            @Override
            public final java.lang.String getStartTime() {
                return this.startTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("window", om.valueToTree(this.getWindow()));
                if (this.getReason() != null) {
                    data.set("reason", om.valueToTree(this.getReason()));
                }
                if (this.getRecurrenceRule() != null) {
                    data.set("recurrenceRule", om.valueToTree(this.getRecurrenceRule()));
                }
                if (this.getStartTime() != null) {
                    data.set("startTime", om.valueToTree(this.getStartTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.ExclusionWindowProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExclusionWindowProperty.Jsii$Proxy that = (ExclusionWindowProperty.Jsii$Proxy) o;

                if (!window.equals(that.window)) return false;
                if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) return false;
                if (this.recurrenceRule != null ? !this.recurrenceRule.equals(that.recurrenceRule) : that.recurrenceRule != null) return false;
                return this.startTime != null ? this.startTime.equals(that.startTime) : that.startTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.window.hashCode();
                result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
                result = 31 * result + (this.recurrenceRule != null ? this.recurrenceRule.hashCode() : 0);
                result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure contains the attributes that determine the goal of an SLO.
     * <p>
     * This includes the time period for evaluation and the attainment threshold.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * GoalProperty goalProperty = GoalProperty.builder()
     *         .attainmentGoal(123)
     *         .interval(IntervalProperty.builder()
     *                 .calendarInterval(CalendarIntervalProperty.builder()
     *                         .duration(123)
     *                         .durationUnit("durationUnit")
     *                         .startTime(123)
     *                         .build())
     *                 .rollingInterval(RollingIntervalProperty.builder()
     *                         .duration(123)
     *                         .durationUnit("durationUnit")
     *                         .build())
     *                 .build())
     *         .warningThreshold(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-goal.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-goal.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.GoalProperty")
    @software.amazon.jsii.Jsii.Proxy(GoalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GoalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The threshold that determines if the goal is being met.
         * <p>
         * If this is a period-based SLO, the attainment goal is the percentage of good periods that meet the threshold requirements to the total periods within the interval. For example, an attainment goal of 99.9% means that within your interval, you are targeting 99.9% of the periods to be in healthy state.
         * <p>
         * If this is a request-based SLO, the attainment goal is the percentage of requests that must be successful to meet the attainment goal.
         * <p>
         * If you omit this parameter, 99 is used to represent 99% as the attainment goal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-goal.html#cfn-applicationsignals-servicelevelobjective-goal-attainmentgoal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-goal.html#cfn-applicationsignals-servicelevelobjective-goal-attainmentgoal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAttainmentGoal() {
            return null;
        }

        /**
         * The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.
         * <p>
         * If you omit this parameter, a rolling interval of 7 days is used.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.IntervalProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-goal.html#cfn-applicationsignals-servicelevelobjective-goal-interval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-goal.html#cfn-applicationsignals-servicelevelobjective-goal-interval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInterval() {
            return null;
        }

        /**
         * The percentage of remaining budget over total budget that you want to get warnings for.
         * <p>
         * If you omit this parameter, the default of 50.0 is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-goal.html#cfn-applicationsignals-servicelevelobjective-goal-warningthreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-goal.html#cfn-applicationsignals-servicelevelobjective-goal-warningthreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWarningThreshold() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GoalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GoalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GoalProperty> {
            java.lang.Number attainmentGoal;
            java.lang.Object interval;
            java.lang.Number warningThreshold;

            /**
             * Sets the value of {@link GoalProperty#getAttainmentGoal}
             * @param attainmentGoal The threshold that determines if the goal is being met.
             *                       If this is a period-based SLO, the attainment goal is the percentage of good periods that meet the threshold requirements to the total periods within the interval. For example, an attainment goal of 99.9% means that within your interval, you are targeting 99.9% of the periods to be in healthy state.
             *                       <p>
             *                       If this is a request-based SLO, the attainment goal is the percentage of requests that must be successful to meet the attainment goal.
             *                       <p>
             *                       If you omit this parameter, 99 is used to represent 99% as the attainment goal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attainmentGoal(java.lang.Number attainmentGoal) {
                this.attainmentGoal = attainmentGoal;
                return this;
            }

            /**
             * Sets the value of {@link GoalProperty#getInterval}
             * @param interval The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.
             *                 If you omit this parameter, a rolling interval of 7 days is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(software.amazon.awscdk.IResolvable interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link GoalProperty#getInterval}
             * @param interval The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.
             *                 If you omit this parameter, a rolling interval of 7 days is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.IntervalProperty interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link GoalProperty#getWarningThreshold}
             * @param warningThreshold The percentage of remaining budget over total budget that you want to get warnings for.
             *                         If you omit this parameter, the default of 50.0 is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warningThreshold(java.lang.Number warningThreshold) {
                this.warningThreshold = warningThreshold;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GoalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GoalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GoalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GoalProperty {
            private final java.lang.Number attainmentGoal;
            private final java.lang.Object interval;
            private final java.lang.Number warningThreshold;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attainmentGoal = software.amazon.jsii.Kernel.get(this, "attainmentGoal", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.warningThreshold = software.amazon.jsii.Kernel.get(this, "warningThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attainmentGoal = builder.attainmentGoal;
                this.interval = builder.interval;
                this.warningThreshold = builder.warningThreshold;
            }

            @Override
            public final java.lang.Number getAttainmentGoal() {
                return this.attainmentGoal;
            }

            @Override
            public final java.lang.Object getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.Number getWarningThreshold() {
                return this.warningThreshold;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttainmentGoal() != null) {
                    data.set("attainmentGoal", om.valueToTree(this.getAttainmentGoal()));
                }
                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getWarningThreshold() != null) {
                    data.set("warningThreshold", om.valueToTree(this.getWarningThreshold()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.GoalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GoalProperty.Jsii$Proxy that = (GoalProperty.Jsii$Proxy) o;

                if (this.attainmentGoal != null ? !this.attainmentGoal.equals(that.attainmentGoal) : that.attainmentGoal != null) return false;
                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                return this.warningThreshold != null ? this.warningThreshold.equals(that.warningThreshold) : that.warningThreshold == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attainmentGoal != null ? this.attainmentGoal.hashCode() : 0;
                result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
                result = 31 * result + (this.warningThreshold != null ? this.warningThreshold.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The time period used to evaluate the SLO.
     * <p>
     * It can be either a calendar interval or rolling interval.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * IntervalProperty intervalProperty = IntervalProperty.builder()
     *         .calendarInterval(CalendarIntervalProperty.builder()
     *                 .duration(123)
     *                 .durationUnit("durationUnit")
     *                 .startTime(123)
     *                 .build())
     *         .rollingInterval(RollingIntervalProperty.builder()
     *                 .duration(123)
     *                 .durationUnit("durationUnit")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-interval.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-interval.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.IntervalProperty")
    @software.amazon.jsii.Jsii.Proxy(IntervalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntervalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If the interval is a calendar interval, this structure contains the interval specifications.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.CalendarIntervalProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-interval.html#cfn-applicationsignals-servicelevelobjective-interval-calendarinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-interval.html#cfn-applicationsignals-servicelevelobjective-interval-calendarinterval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCalendarInterval() {
            return null;
        }

        /**
         * If the interval is a rolling interval, this structure contains the interval specifications.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.RollingIntervalProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-interval.html#cfn-applicationsignals-servicelevelobjective-interval-rollinginterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-interval.html#cfn-applicationsignals-servicelevelobjective-interval-rollinginterval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRollingInterval() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntervalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntervalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntervalProperty> {
            java.lang.Object calendarInterval;
            java.lang.Object rollingInterval;

            /**
             * Sets the value of {@link IntervalProperty#getCalendarInterval}
             * @param calendarInterval If the interval is a calendar interval, this structure contains the interval specifications.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder calendarInterval(software.amazon.awscdk.IResolvable calendarInterval) {
                this.calendarInterval = calendarInterval;
                return this;
            }

            /**
             * Sets the value of {@link IntervalProperty#getCalendarInterval}
             * @param calendarInterval If the interval is a calendar interval, this structure contains the interval specifications.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder calendarInterval(software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.CalendarIntervalProperty calendarInterval) {
                this.calendarInterval = calendarInterval;
                return this;
            }

            /**
             * Sets the value of {@link IntervalProperty#getRollingInterval}
             * @param rollingInterval If the interval is a rolling interval, this structure contains the interval specifications.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollingInterval(software.amazon.awscdk.IResolvable rollingInterval) {
                this.rollingInterval = rollingInterval;
                return this;
            }

            /**
             * Sets the value of {@link IntervalProperty#getRollingInterval}
             * @param rollingInterval If the interval is a rolling interval, this structure contains the interval specifications.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollingInterval(software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.RollingIntervalProperty rollingInterval) {
                this.rollingInterval = rollingInterval;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntervalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntervalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntervalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntervalProperty {
            private final java.lang.Object calendarInterval;
            private final java.lang.Object rollingInterval;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.calendarInterval = software.amazon.jsii.Kernel.get(this, "calendarInterval", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rollingInterval = software.amazon.jsii.Kernel.get(this, "rollingInterval", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.calendarInterval = builder.calendarInterval;
                this.rollingInterval = builder.rollingInterval;
            }

            @Override
            public final java.lang.Object getCalendarInterval() {
                return this.calendarInterval;
            }

            @Override
            public final java.lang.Object getRollingInterval() {
                return this.rollingInterval;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCalendarInterval() != null) {
                    data.set("calendarInterval", om.valueToTree(this.getCalendarInterval()));
                }
                if (this.getRollingInterval() != null) {
                    data.set("rollingInterval", om.valueToTree(this.getRollingInterval()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.IntervalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntervalProperty.Jsii$Proxy that = (IntervalProperty.Jsii$Proxy) o;

                if (this.calendarInterval != null ? !this.calendarInterval.equals(that.calendarInterval) : that.calendarInterval != null) return false;
                return this.rollingInterval != null ? this.rollingInterval.equals(that.rollingInterval) : that.rollingInterval == null;
            }

            @Override
            public final int hashCode() {
                int result = this.calendarInterval != null ? this.calendarInterval.hashCode() : 0;
                result = 31 * result + (this.rollingInterval != null ? this.rollingInterval.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use this structure to define a metric or metric math expression that you want to use as for a service level objective.
     * <p>
     * Each <code>MetricDataQuery</code> in the <code>MetricDataQueries</code> array specifies either a metric to retrieve, or a metric math expression to be performed on retrieved metrics. A single <code>MetricDataQueries</code> array can include as many as 20 <code>MetricDataQuery</code> structures in the array. The 20 structures can include as many as 10 structures that contain a <code>MetricStat</code> parameter to retrieve a metric, and as many as 10 structures that contain the <code>Expression</code> parameter to perform a math expression. Of those <code>Expression</code> structures, exactly one must have true as the value for <code>ReturnData</code> . The result of this expression used for the SLO.
     * <p>
     * For more information about metric math expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html">Use metric math</a> .
     * <p>
     * Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> but not both.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * MetricDataQueryProperty metricDataQueryProperty = MetricDataQueryProperty.builder()
     *         .id("id")
     *         // the properties below are optional
     *         .accountId("accountId")
     *         .expression("expression")
     *         .metricStat(MetricStatProperty.builder()
     *                 .metric(MetricProperty.builder()
     *                         .dimensions(List.of(DimensionProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .metricName("metricName")
     *                         .namespace("namespace")
     *                         .build())
     *                 .period(123)
     *                 .stat("stat")
     *                 // the properties below are optional
     *                 .unit("unit")
     *                 .build())
     *         .returnData(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricdataquery.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricdataquery.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.MetricDataQueryProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricDataQueryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricDataQueryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A short name used to tie this object to the results in the response.
         * <p>
         * This <code>Id</code> must be unique within a <code>MetricDataQueries</code> array. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the metric math expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricdataquery.html#cfn-applicationsignals-servicelevelobjective-metricdataquery-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricdataquery.html#cfn-applicationsignals-servicelevelobjective-metricdataquery-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The ID of the account where this metric is located.
         * <p>
         * If you are performing this operation in a monitoring account, use this to specify which source account to retrieve this metric from.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricdataquery.html#cfn-applicationsignals-servicelevelobjective-metricdataquery-accountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricdataquery.html#cfn-applicationsignals-servicelevelobjective-metricdataquery-accountid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccountId() {
            return null;
        }

        /**
         * This field can contain a metric math expression to be performed on the other metrics that you are retrieving within this <code>MetricDataQueries</code> structure.
         * <p>
         * A math expression can use the <code>Id</code> of the other metrics or queries to refer to those metrics, and can also use the <code>Id</code> of other expressions to use the result of those expressions. For more information about metric math expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax">Metric Math Syntax and Functions</a> in the <em>Amazon CloudWatch User Guide</em> .
         * <p>
         * Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> but not both.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricdataquery.html#cfn-applicationsignals-servicelevelobjective-metricdataquery-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricdataquery.html#cfn-applicationsignals-servicelevelobjective-metricdataquery-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpression() {
            return null;
        }

        /**
         * A metric to be used directly for the SLO, or to be used in the math expression that will be used for the SLO.
         * <p>
         * Within one <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> but not both.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.MetricStatProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricdataquery.html#cfn-applicationsignals-servicelevelobjective-metricdataquery-metricstat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricdataquery.html#cfn-applicationsignals-servicelevelobjective-metricdataquery-metricstat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricStat() {
            return null;
        }

        /**
         * Use this only if you are using a metric math expression for the SLO.
         * <p>
         * Specify <code>true</code> for <code>ReturnData</code> for only the one expression result to use as the alarm. For all other metrics and expressions in the same <code>CreateServiceLevelObjective</code> operation, specify <code>ReturnData</code> as <code>false</code> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricdataquery.html#cfn-applicationsignals-servicelevelobjective-metricdataquery-returndata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricdataquery.html#cfn-applicationsignals-servicelevelobjective-metricdataquery-returndata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReturnData() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricDataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricDataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricDataQueryProperty> {
            java.lang.String id;
            java.lang.String accountId;
            java.lang.String expression;
            java.lang.Object metricStat;
            java.lang.Object returnData;

            /**
             * Sets the value of {@link MetricDataQueryProperty#getId}
             * @param id A short name used to tie this object to the results in the response. This parameter is required.
             *           This <code>Id</code> must be unique within a <code>MetricDataQueries</code> array. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the metric math expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getAccountId}
             * @param accountId The ID of the account where this metric is located.
             *                  If you are performing this operation in a monitoring account, use this to specify which source account to retrieve this metric from.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountId(java.lang.String accountId) {
                this.accountId = accountId;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getExpression}
             * @param expression This field can contain a metric math expression to be performed on the other metrics that you are retrieving within this <code>MetricDataQueries</code> structure.
             *                   A math expression can use the <code>Id</code> of the other metrics or queries to refer to those metrics, and can also use the <code>Id</code> of other expressions to use the result of those expressions. For more information about metric math expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax">Metric Math Syntax and Functions</a> in the <em>Amazon CloudWatch User Guide</em> .
             *                   <p>
             *                   Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getMetricStat}
             * @param metricStat A metric to be used directly for the SLO, or to be used in the math expression that will be used for the SLO.
             *                   Within one <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricStat(software.amazon.awscdk.IResolvable metricStat) {
                this.metricStat = metricStat;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getMetricStat}
             * @param metricStat A metric to be used directly for the SLO, or to be used in the math expression that will be used for the SLO.
             *                   Within one <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricStat(software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.MetricStatProperty metricStat) {
                this.metricStat = metricStat;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getReturnData}
             * @param returnData Use this only if you are using a metric math expression for the SLO.
             *                   Specify <code>true</code> for <code>ReturnData</code> for only the one expression result to use as the alarm. For all other metrics and expressions in the same <code>CreateServiceLevelObjective</code> operation, specify <code>ReturnData</code> as <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder returnData(java.lang.Boolean returnData) {
                this.returnData = returnData;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getReturnData}
             * @param returnData Use this only if you are using a metric math expression for the SLO.
             *                   Specify <code>true</code> for <code>ReturnData</code> for only the one expression result to use as the alarm. For all other metrics and expressions in the same <code>CreateServiceLevelObjective</code> operation, specify <code>ReturnData</code> as <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder returnData(software.amazon.awscdk.IResolvable returnData) {
                this.returnData = returnData;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricDataQueryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricDataQueryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricDataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricDataQueryProperty {
            private final java.lang.String id;
            private final java.lang.String accountId;
            private final java.lang.String expression;
            private final java.lang.Object metricStat;
            private final java.lang.Object returnData;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accountId = software.amazon.jsii.Kernel.get(this, "accountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricStat = software.amazon.jsii.Kernel.get(this, "metricStat", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.returnData = software.amazon.jsii.Kernel.get(this, "returnData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.accountId = builder.accountId;
                this.expression = builder.expression;
                this.metricStat = builder.metricStat;
                this.returnData = builder.returnData;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getAccountId() {
                return this.accountId;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.Object getMetricStat() {
                return this.metricStat;
            }

            @Override
            public final java.lang.Object getReturnData() {
                return this.returnData;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                if (this.getAccountId() != null) {
                    data.set("accountId", om.valueToTree(this.getAccountId()));
                }
                if (this.getExpression() != null) {
                    data.set("expression", om.valueToTree(this.getExpression()));
                }
                if (this.getMetricStat() != null) {
                    data.set("metricStat", om.valueToTree(this.getMetricStat()));
                }
                if (this.getReturnData() != null) {
                    data.set("returnData", om.valueToTree(this.getReturnData()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.MetricDataQueryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricDataQueryProperty.Jsii$Proxy that = (MetricDataQueryProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) return false;
                if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) return false;
                if (this.metricStat != null ? !this.metricStat.equals(that.metricStat) : that.metricStat != null) return false;
                return this.returnData != null ? this.returnData.equals(that.returnData) : that.returnData == null;
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
                result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
                result = 31 * result + (this.metricStat != null ? this.metricStat.hashCode() : 0);
                result = 31 * result + (this.returnData != null ? this.returnData.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure defines the metric used for a service level indicator, including the metric name, namespace, and dimensions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * MetricProperty metricProperty = MetricProperty.builder()
     *         .dimensions(List.of(DimensionProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .metricName("metricName")
     *         .namespace("namespace")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metric.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metric.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.MetricProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of one or more dimensions to use to define the metric that you want to use.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension">Dimensions</a> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.DimensionProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metric.html#cfn-applicationsignals-servicelevelobjective-metric-dimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metric.html#cfn-applicationsignals-servicelevelobjective-metric-dimensions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
            return null;
        }

        /**
         * The name of the metric to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metric.html#cfn-applicationsignals-servicelevelobjective-metric-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metric.html#cfn-applicationsignals-servicelevelobjective-metric-metricname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricName() {
            return null;
        }

        /**
         * The namespace of the metric.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace">Namespaces</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metric.html#cfn-applicationsignals-servicelevelobjective-metric-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metric.html#cfn-applicationsignals-servicelevelobjective-metric-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricProperty> {
            java.lang.Object dimensions;
            java.lang.String metricName;
            java.lang.String namespace;

            /**
             * Sets the value of {@link MetricProperty#getDimensions}
             * @param dimensions An array of one or more dimensions to use to define the metric that you want to use.
             *                   For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension">Dimensions</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link MetricProperty#getDimensions}
             * @param dimensions An array of one or more dimensions to use to define the metric that you want to use.
             *                   For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension">Dimensions</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link MetricProperty#getMetricName}
             * @param metricName The name of the metric to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link MetricProperty#getNamespace}
             * @param namespace The namespace of the metric.
             *                  For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace">Namespaces</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricProperty {
            private final java.lang.Object dimensions;
            private final java.lang.String metricName;
            private final java.lang.String namespace;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensions = builder.dimensions;
                this.metricName = builder.metricName;
                this.namespace = builder.namespace;
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getMetricName() != null) {
                    data.set("metricName", om.valueToTree(this.getMetricName()));
                }
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.MetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricProperty.Jsii$Proxy that = (MetricProperty.Jsii$Proxy) o;

                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) return false;
                return this.namespace != null ? this.namespace.equals(that.namespace) : that.namespace == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dimensions != null ? this.dimensions.hashCode() : 0;
                result = 31 * result + (this.metricName != null ? this.metricName.hashCode() : 0);
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure defines the metric to be used as the service level indicator, along with the statistics, period, and unit.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * MetricStatProperty metricStatProperty = MetricStatProperty.builder()
     *         .metric(MetricProperty.builder()
     *                 .dimensions(List.of(DimensionProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .metricName("metricName")
     *                 .namespace("namespace")
     *                 .build())
     *         .period(123)
     *         .stat("stat")
     *         // the properties below are optional
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricstat.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricstat.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.MetricStatProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricStatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricStatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The metric to use as the service level indicator, including the metric name, namespace, and dimensions.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.MetricProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricstat.html#cfn-applicationsignals-servicelevelobjective-metricstat-metric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricstat.html#cfn-applicationsignals-servicelevelobjective-metricstat-metric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMetric();

        /**
         * The granularity, in seconds, to be used for the metric.
         * <p>
         * For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a <code>PutMetricData</code> call that includes a <code>StorageResolution</code> of 1 second.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricstat.html#cfn-applicationsignals-servicelevelobjective-metricstat-period">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricstat.html#cfn-applicationsignals-servicelevelobjective-metricstat-period</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPeriod();

        /**
         * The statistic to use for comparison to the threshold.
         * <p>
         * It can be any CloudWatch statistic or extended statistic. For more information about statistics, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html">CloudWatch statistics definitions</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricstat.html#cfn-applicationsignals-servicelevelobjective-metricstat-stat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricstat.html#cfn-applicationsignals-servicelevelobjective-metricstat-stat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStat();

        /**
         * If you omit <code>Unit</code> then all data that was collected with any unit is returned, along with the corresponding units that were specified when the data was reported to CloudWatch.
         * <p>
         * If you specify a unit, the operation returns only data that was collected with that unit specified. If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricstat.html#cfn-applicationsignals-servicelevelobjective-metricstat-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-metricstat.html#cfn-applicationsignals-servicelevelobjective-metricstat-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricStatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricStatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricStatProperty> {
            java.lang.Object metric;
            java.lang.Number period;
            java.lang.String stat;
            java.lang.String unit;

            /**
             * Sets the value of {@link MetricStatProperty#getMetric}
             * @param metric The metric to use as the service level indicator, including the metric name, namespace, and dimensions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metric(software.amazon.awscdk.IResolvable metric) {
                this.metric = metric;
                return this;
            }

            /**
             * Sets the value of {@link MetricStatProperty#getMetric}
             * @param metric The metric to use as the service level indicator, including the metric name, namespace, and dimensions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metric(software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.MetricProperty metric) {
                this.metric = metric;
                return this;
            }

            /**
             * Sets the value of {@link MetricStatProperty#getPeriod}
             * @param period The granularity, in seconds, to be used for the metric. This parameter is required.
             *               For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a <code>PutMetricData</code> call that includes a <code>StorageResolution</code> of 1 second.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder period(java.lang.Number period) {
                this.period = period;
                return this;
            }

            /**
             * Sets the value of {@link MetricStatProperty#getStat}
             * @param stat The statistic to use for comparison to the threshold. This parameter is required.
             *             It can be any CloudWatch statistic or extended statistic. For more information about statistics, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html">CloudWatch statistics definitions</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stat(java.lang.String stat) {
                this.stat = stat;
                return this;
            }

            /**
             * Sets the value of {@link MetricStatProperty#getUnit}
             * @param unit If you omit <code>Unit</code> then all data that was collected with any unit is returned, along with the corresponding units that were specified when the data was reported to CloudWatch.
             *             If you specify a unit, the operation returns only data that was collected with that unit specified. If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricStatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricStatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricStatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricStatProperty {
            private final java.lang.Object metric;
            private final java.lang.Number period;
            private final java.lang.String stat;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metric = software.amazon.jsii.Kernel.get(this, "metric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stat = software.amazon.jsii.Kernel.get(this, "stat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metric = java.util.Objects.requireNonNull(builder.metric, "metric is required");
                this.period = java.util.Objects.requireNonNull(builder.period, "period is required");
                this.stat = java.util.Objects.requireNonNull(builder.stat, "stat is required");
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.Object getMetric() {
                return this.metric;
            }

            @Override
            public final java.lang.Number getPeriod() {
                return this.period;
            }

            @Override
            public final java.lang.String getStat() {
                return this.stat;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metric", om.valueToTree(this.getMetric()));
                data.set("period", om.valueToTree(this.getPeriod()));
                data.set("stat", om.valueToTree(this.getStat()));
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.MetricStatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricStatProperty.Jsii$Proxy that = (MetricStatProperty.Jsii$Proxy) o;

                if (!metric.equals(that.metric)) return false;
                if (!period.equals(that.period)) return false;
                if (!stat.equals(that.stat)) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metric.hashCode();
                result = 31 * result + (this.period.hashCode());
                result = 31 * result + (this.stat.hashCode());
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure defines the metric that is used as the "good request" or "bad request" value for a request-based SLO.
     * <p>
     * This value observed for the metric defined in <code>TotalRequestCountMetric</code> is divided by the number found for <code>MonitoredRequestCountMetric</code> to determine the percentage of successful requests that this SLO tracks.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * MonitoredRequestCountMetricProperty monitoredRequestCountMetricProperty = MonitoredRequestCountMetricProperty.builder()
     *         .badCountMetric(List.of(MetricDataQueryProperty.builder()
     *                 .id("id")
     *                 // the properties below are optional
     *                 .accountId("accountId")
     *                 .expression("expression")
     *                 .metricStat(MetricStatProperty.builder()
     *                         .metric(MetricProperty.builder()
     *                                 .dimensions(List.of(DimensionProperty.builder()
     *                                         .name("name")
     *                                         .value("value")
     *                                         .build()))
     *                                 .metricName("metricName")
     *                                 .namespace("namespace")
     *                                 .build())
     *                         .period(123)
     *                         .stat("stat")
     *                         // the properties below are optional
     *                         .unit("unit")
     *                         .build())
     *                 .returnData(false)
     *                 .build()))
     *         .goodCountMetric(List.of(MetricDataQueryProperty.builder()
     *                 .id("id")
     *                 // the properties below are optional
     *                 .accountId("accountId")
     *                 .expression("expression")
     *                 .metricStat(MetricStatProperty.builder()
     *                         .metric(MetricProperty.builder()
     *                                 .dimensions(List.of(DimensionProperty.builder()
     *                                         .name("name")
     *                                         .value("value")
     *                                         .build()))
     *                                 .metricName("metricName")
     *                                 .namespace("namespace")
     *                                 .build())
     *                         .period(123)
     *                         .stat("stat")
     *                         // the properties below are optional
     *                         .unit("unit")
     *                         .build())
     *                 .returnData(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-monitoredrequestcountmetric.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-monitoredrequestcountmetric.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.MonitoredRequestCountMetricProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoredRequestCountMetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoredRequestCountMetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If you want to count "bad requests" to determine the percentage of successful requests for this request-based SLO, specify the metric to use as "bad requests" in this structure.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.MetricDataQueryProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-monitoredrequestcountmetric.html#cfn-applicationsignals-servicelevelobjective-monitoredrequestcountmetric-badcountmetric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-monitoredrequestcountmetric.html#cfn-applicationsignals-servicelevelobjective-monitoredrequestcountmetric-badcountmetric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBadCountMetric() {
            return null;
        }

        /**
         * If you want to count "good requests" to determine the percentage of successful requests for this request-based SLO, specify the metric to use as "good requests" in this structure.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.MetricDataQueryProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-monitoredrequestcountmetric.html#cfn-applicationsignals-servicelevelobjective-monitoredrequestcountmetric-goodcountmetric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-monitoredrequestcountmetric.html#cfn-applicationsignals-servicelevelobjective-monitoredrequestcountmetric-goodcountmetric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGoodCountMetric() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoredRequestCountMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoredRequestCountMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoredRequestCountMetricProperty> {
            java.lang.Object badCountMetric;
            java.lang.Object goodCountMetric;

            /**
             * Sets the value of {@link MonitoredRequestCountMetricProperty#getBadCountMetric}
             * @param badCountMetric If you want to count "bad requests" to determine the percentage of successful requests for this request-based SLO, specify the metric to use as "bad requests" in this structure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder badCountMetric(software.amazon.awscdk.IResolvable badCountMetric) {
                this.badCountMetric = badCountMetric;
                return this;
            }

            /**
             * Sets the value of {@link MonitoredRequestCountMetricProperty#getBadCountMetric}
             * @param badCountMetric If you want to count "bad requests" to determine the percentage of successful requests for this request-based SLO, specify the metric to use as "bad requests" in this structure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder badCountMetric(java.util.List<? extends java.lang.Object> badCountMetric) {
                this.badCountMetric = badCountMetric;
                return this;
            }

            /**
             * Sets the value of {@link MonitoredRequestCountMetricProperty#getGoodCountMetric}
             * @param goodCountMetric If you want to count "good requests" to determine the percentage of successful requests for this request-based SLO, specify the metric to use as "good requests" in this structure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder goodCountMetric(software.amazon.awscdk.IResolvable goodCountMetric) {
                this.goodCountMetric = goodCountMetric;
                return this;
            }

            /**
             * Sets the value of {@link MonitoredRequestCountMetricProperty#getGoodCountMetric}
             * @param goodCountMetric If you want to count "good requests" to determine the percentage of successful requests for this request-based SLO, specify the metric to use as "good requests" in this structure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder goodCountMetric(java.util.List<? extends java.lang.Object> goodCountMetric) {
                this.goodCountMetric = goodCountMetric;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoredRequestCountMetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoredRequestCountMetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoredRequestCountMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoredRequestCountMetricProperty {
            private final java.lang.Object badCountMetric;
            private final java.lang.Object goodCountMetric;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.badCountMetric = software.amazon.jsii.Kernel.get(this, "badCountMetric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.goodCountMetric = software.amazon.jsii.Kernel.get(this, "goodCountMetric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.badCountMetric = builder.badCountMetric;
                this.goodCountMetric = builder.goodCountMetric;
            }

            @Override
            public final java.lang.Object getBadCountMetric() {
                return this.badCountMetric;
            }

            @Override
            public final java.lang.Object getGoodCountMetric() {
                return this.goodCountMetric;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBadCountMetric() != null) {
                    data.set("badCountMetric", om.valueToTree(this.getBadCountMetric()));
                }
                if (this.getGoodCountMetric() != null) {
                    data.set("goodCountMetric", om.valueToTree(this.getGoodCountMetric()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.MonitoredRequestCountMetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoredRequestCountMetricProperty.Jsii$Proxy that = (MonitoredRequestCountMetricProperty.Jsii$Proxy) o;

                if (this.badCountMetric != null ? !this.badCountMetric.equals(that.badCountMetric) : that.badCountMetric != null) return false;
                return this.goodCountMetric != null ? this.goodCountMetric.equals(that.goodCountMetric) : that.goodCountMetric == null;
            }

            @Override
            public final int hashCode() {
                int result = this.badCountMetric != null ? this.badCountMetric.hashCode() : 0;
                result = 31 * result + (this.goodCountMetric != null ? this.goodCountMetric.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The recurrence rule for the time exclusion window.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * RecurrenceRuleProperty recurrenceRuleProperty = RecurrenceRuleProperty.builder()
     *         .expression("expression")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-recurrencerule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-recurrencerule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.RecurrenceRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RecurrenceRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecurrenceRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The following two rules are supported:.
         * <p>
         * <ul>
         * <li>rate(value unit) - The value must be a positive integer and the unit can be hour|day|month.</li>
         * <li>cron - An expression which consists of six fields separated by white spaces: (minutes hours day_of_month month day_of_week year).</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-recurrencerule.html#cfn-applicationsignals-servicelevelobjective-recurrencerule-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-recurrencerule.html#cfn-applicationsignals-servicelevelobjective-recurrencerule-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpression();

        /**
         * @return a {@link Builder} of {@link RecurrenceRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecurrenceRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecurrenceRuleProperty> {
            java.lang.String expression;

            /**
             * Sets the value of {@link RecurrenceRuleProperty#getExpression}
             * @param expression The following two rules are supported:. This parameter is required.
             *                   <ul>
             *                   <li>rate(value unit) - The value must be a positive integer and the unit can be hour|day|month.</li>
             *                   <li>cron - An expression which consists of six fields separated by white spaces: (minutes hours day_of_month month day_of_week year).</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecurrenceRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecurrenceRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecurrenceRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecurrenceRuleProperty {
            private final java.lang.String expression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("expression", om.valueToTree(this.getExpression()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.RecurrenceRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecurrenceRuleProperty.Jsii$Proxy that = (RecurrenceRuleProperty.Jsii$Proxy) o;

                return this.expression.equals(that.expression);
            }

            @Override
            public final int hashCode() {
                int result = this.expression.hashCode();
                return result;
            }
        }
    }
    /**
     * This structure contains the information about the metric that is used for a request-based SLO.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * RequestBasedSliMetricProperty requestBasedSliMetricProperty = RequestBasedSliMetricProperty.builder()
     *         .dependencyConfig(DependencyConfigProperty.builder()
     *                 .dependencyKeyAttributes(Map.of(
     *                         "dependencyKeyAttributesKey", "dependencyKeyAttributes"))
     *                 .dependencyOperationName("dependencyOperationName")
     *                 .build())
     *         .keyAttributes(Map.of(
     *                 "keyAttributesKey", "keyAttributes"))
     *         .metricType("metricType")
     *         .monitoredRequestCountMetric(MonitoredRequestCountMetricProperty.builder()
     *                 .badCountMetric(List.of(MetricDataQueryProperty.builder()
     *                         .id("id")
     *                         // the properties below are optional
     *                         .accountId("accountId")
     *                         .expression("expression")
     *                         .metricStat(MetricStatProperty.builder()
     *                                 .metric(MetricProperty.builder()
     *                                         .dimensions(List.of(DimensionProperty.builder()
     *                                                 .name("name")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .metricName("metricName")
     *                                         .namespace("namespace")
     *                                         .build())
     *                                 .period(123)
     *                                 .stat("stat")
     *                                 // the properties below are optional
     *                                 .unit("unit")
     *                                 .build())
     *                         .returnData(false)
     *                         .build()))
     *                 .goodCountMetric(List.of(MetricDataQueryProperty.builder()
     *                         .id("id")
     *                         // the properties below are optional
     *                         .accountId("accountId")
     *                         .expression("expression")
     *                         .metricStat(MetricStatProperty.builder()
     *                                 .metric(MetricProperty.builder()
     *                                         .dimensions(List.of(DimensionProperty.builder()
     *                                                 .name("name")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .metricName("metricName")
     *                                         .namespace("namespace")
     *                                         .build())
     *                                 .period(123)
     *                                 .stat("stat")
     *                                 // the properties below are optional
     *                                 .unit("unit")
     *                                 .build())
     *                         .returnData(false)
     *                         .build()))
     *                 .build())
     *         .operationName("operationName")
     *         .totalRequestCountMetric(List.of(MetricDataQueryProperty.builder()
     *                 .id("id")
     *                 // the properties below are optional
     *                 .accountId("accountId")
     *                 .expression("expression")
     *                 .metricStat(MetricStatProperty.builder()
     *                         .metric(MetricProperty.builder()
     *                                 .dimensions(List.of(DimensionProperty.builder()
     *                                         .name("name")
     *                                         .value("value")
     *                                         .build()))
     *                                 .metricName("metricName")
     *                                 .namespace("namespace")
     *                                 .build())
     *                         .period(123)
     *                         .stat("stat")
     *                         // the properties below are optional
     *                         .unit("unit")
     *                         .build())
     *                 .returnData(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedslimetric.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedslimetric.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.RequestBasedSliMetricProperty")
    @software.amazon.jsii.Jsii.Proxy(RequestBasedSliMetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RequestBasedSliMetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Identifies the dependency using the <code>DependencyKeyAttributes</code> and <code>DependencyOperationName</code> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.DependencyConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedslimetric.html#cfn-applicationsignals-servicelevelobjective-requestbasedslimetric-dependencyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedslimetric.html#cfn-applicationsignals-servicelevelobjective-requestbasedslimetric-dependencyconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDependencyConfig() {
            return null;
        }

        /**
         * This is a string-to-string map that contains information about the type of object that this SLO is related to.
         * <p>
         * It can include the following fields.
         * <p>
         * <ul>
         * <li><code>Type</code> designates the type of object that this SLO is related to.</li>
         * <li><code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
         * <li><code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code> , <code>RemoteService</code> , or <code>AWS::Service</code> .</li>
         * <li><code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
         * <li><code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</li>
         * <li><code>AwsAccountId</code> allows you to create an SLO for an object that exists in another account.</li>
         * </ul>
         * <p>
         * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedslimetric.html#cfn-applicationsignals-servicelevelobjective-requestbasedslimetric-keyattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedslimetric.html#cfn-applicationsignals-servicelevelobjective-requestbasedslimetric-keyattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKeyAttributes() {
            return null;
        }

        /**
         * If the SLO monitors either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application Signals collects, this field displays which of those metrics is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedslimetric.html#cfn-applicationsignals-servicelevelobjective-requestbasedslimetric-metrictype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedslimetric.html#cfn-applicationsignals-servicelevelobjective-requestbasedslimetric-metrictype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricType() {
            return null;
        }

        /**
         * Use this structure to define the metric that you want to use as the "good request" or "bad request" value for a request-based SLO.
         * <p>
         * This value observed for the metric defined in <code>TotalRequestCountMetric</code> will be divided by the number found for <code>MonitoredRequestCountMetric</code> to determine the percentage of successful requests that this SLO tracks.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.MonitoredRequestCountMetricProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedslimetric.html#cfn-applicationsignals-servicelevelobjective-requestbasedslimetric-monitoredrequestcountmetric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedslimetric.html#cfn-applicationsignals-servicelevelobjective-requestbasedslimetric-monitoredrequestcountmetric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMonitoredRequestCountMetric() {
            return null;
        }

        /**
         * If the SLO monitors a specific operation of the service, this field displays that operation name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedslimetric.html#cfn-applicationsignals-servicelevelobjective-requestbasedslimetric-operationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedslimetric.html#cfn-applicationsignals-servicelevelobjective-requestbasedslimetric-operationname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOperationName() {
            return null;
        }

        /**
         * This structure defines the metric that is used as the "total requests" number for a request-based SLO.
         * <p>
         * The number observed for this metric is divided by the number of "good requests" or "bad requests" that is observed for the metric defined in <code>MonitoredRequestCountMetric</code> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.MetricDataQueryProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedslimetric.html#cfn-applicationsignals-servicelevelobjective-requestbasedslimetric-totalrequestcountmetric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedslimetric.html#cfn-applicationsignals-servicelevelobjective-requestbasedslimetric-totalrequestcountmetric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTotalRequestCountMetric() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RequestBasedSliMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RequestBasedSliMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RequestBasedSliMetricProperty> {
            java.lang.Object dependencyConfig;
            java.lang.Object keyAttributes;
            java.lang.String metricType;
            java.lang.Object monitoredRequestCountMetric;
            java.lang.String operationName;
            java.lang.Object totalRequestCountMetric;

            /**
             * Sets the value of {@link RequestBasedSliMetricProperty#getDependencyConfig}
             * @param dependencyConfig Identifies the dependency using the <code>DependencyKeyAttributes</code> and <code>DependencyOperationName</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependencyConfig(software.amazon.awscdk.IResolvable dependencyConfig) {
                this.dependencyConfig = dependencyConfig;
                return this;
            }

            /**
             * Sets the value of {@link RequestBasedSliMetricProperty#getDependencyConfig}
             * @param dependencyConfig Identifies the dependency using the <code>DependencyKeyAttributes</code> and <code>DependencyOperationName</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependencyConfig(software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.DependencyConfigProperty dependencyConfig) {
                this.dependencyConfig = dependencyConfig;
                return this;
            }

            /**
             * Sets the value of {@link RequestBasedSliMetricProperty#getKeyAttributes}
             * @param keyAttributes This is a string-to-string map that contains information about the type of object that this SLO is related to.
             *                      It can include the following fields.
             *                      <p>
             *                      <ul>
             *                      <li><code>Type</code> designates the type of object that this SLO is related to.</li>
             *                      <li><code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
             *                      <li><code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code> , <code>RemoteService</code> , or <code>AWS::Service</code> .</li>
             *                      <li><code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
             *                      <li><code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</li>
             *                      <li><code>AwsAccountId</code> allows you to create an SLO for an object that exists in another account.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyAttributes(java.util.Map<java.lang.String, java.lang.String> keyAttributes) {
                this.keyAttributes = keyAttributes;
                return this;
            }

            /**
             * Sets the value of {@link RequestBasedSliMetricProperty#getKeyAttributes}
             * @param keyAttributes This is a string-to-string map that contains information about the type of object that this SLO is related to.
             *                      It can include the following fields.
             *                      <p>
             *                      <ul>
             *                      <li><code>Type</code> designates the type of object that this SLO is related to.</li>
             *                      <li><code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
             *                      <li><code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code> , <code>RemoteService</code> , or <code>AWS::Service</code> .</li>
             *                      <li><code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
             *                      <li><code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</li>
             *                      <li><code>AwsAccountId</code> allows you to create an SLO for an object that exists in another account.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyAttributes(software.amazon.awscdk.IResolvable keyAttributes) {
                this.keyAttributes = keyAttributes;
                return this;
            }

            /**
             * Sets the value of {@link RequestBasedSliMetricProperty#getMetricType}
             * @param metricType If the SLO monitors either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application Signals collects, this field displays which of those metrics is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricType(java.lang.String metricType) {
                this.metricType = metricType;
                return this;
            }

            /**
             * Sets the value of {@link RequestBasedSliMetricProperty#getMonitoredRequestCountMetric}
             * @param monitoredRequestCountMetric Use this structure to define the metric that you want to use as the "good request" or "bad request" value for a request-based SLO.
             *                                    This value observed for the metric defined in <code>TotalRequestCountMetric</code> will be divided by the number found for <code>MonitoredRequestCountMetric</code> to determine the percentage of successful requests that this SLO tracks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoredRequestCountMetric(software.amazon.awscdk.IResolvable monitoredRequestCountMetric) {
                this.monitoredRequestCountMetric = monitoredRequestCountMetric;
                return this;
            }

            /**
             * Sets the value of {@link RequestBasedSliMetricProperty#getMonitoredRequestCountMetric}
             * @param monitoredRequestCountMetric Use this structure to define the metric that you want to use as the "good request" or "bad request" value for a request-based SLO.
             *                                    This value observed for the metric defined in <code>TotalRequestCountMetric</code> will be divided by the number found for <code>MonitoredRequestCountMetric</code> to determine the percentage of successful requests that this SLO tracks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoredRequestCountMetric(software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.MonitoredRequestCountMetricProperty monitoredRequestCountMetric) {
                this.monitoredRequestCountMetric = monitoredRequestCountMetric;
                return this;
            }

            /**
             * Sets the value of {@link RequestBasedSliMetricProperty#getOperationName}
             * @param operationName If the SLO monitors a specific operation of the service, this field displays that operation name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operationName(java.lang.String operationName) {
                this.operationName = operationName;
                return this;
            }

            /**
             * Sets the value of {@link RequestBasedSliMetricProperty#getTotalRequestCountMetric}
             * @param totalRequestCountMetric This structure defines the metric that is used as the "total requests" number for a request-based SLO.
             *                                The number observed for this metric is divided by the number of "good requests" or "bad requests" that is observed for the metric defined in <code>MonitoredRequestCountMetric</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalRequestCountMetric(software.amazon.awscdk.IResolvable totalRequestCountMetric) {
                this.totalRequestCountMetric = totalRequestCountMetric;
                return this;
            }

            /**
             * Sets the value of {@link RequestBasedSliMetricProperty#getTotalRequestCountMetric}
             * @param totalRequestCountMetric This structure defines the metric that is used as the "total requests" number for a request-based SLO.
             *                                The number observed for this metric is divided by the number of "good requests" or "bad requests" that is observed for the metric defined in <code>MonitoredRequestCountMetric</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalRequestCountMetric(java.util.List<? extends java.lang.Object> totalRequestCountMetric) {
                this.totalRequestCountMetric = totalRequestCountMetric;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RequestBasedSliMetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RequestBasedSliMetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RequestBasedSliMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RequestBasedSliMetricProperty {
            private final java.lang.Object dependencyConfig;
            private final java.lang.Object keyAttributes;
            private final java.lang.String metricType;
            private final java.lang.Object monitoredRequestCountMetric;
            private final java.lang.String operationName;
            private final java.lang.Object totalRequestCountMetric;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dependencyConfig = software.amazon.jsii.Kernel.get(this, "dependencyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.keyAttributes = software.amazon.jsii.Kernel.get(this, "keyAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metricType = software.amazon.jsii.Kernel.get(this, "metricType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.monitoredRequestCountMetric = software.amazon.jsii.Kernel.get(this, "monitoredRequestCountMetric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.operationName = software.amazon.jsii.Kernel.get(this, "operationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.totalRequestCountMetric = software.amazon.jsii.Kernel.get(this, "totalRequestCountMetric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dependencyConfig = builder.dependencyConfig;
                this.keyAttributes = builder.keyAttributes;
                this.metricType = builder.metricType;
                this.monitoredRequestCountMetric = builder.monitoredRequestCountMetric;
                this.operationName = builder.operationName;
                this.totalRequestCountMetric = builder.totalRequestCountMetric;
            }

            @Override
            public final java.lang.Object getDependencyConfig() {
                return this.dependencyConfig;
            }

            @Override
            public final java.lang.Object getKeyAttributes() {
                return this.keyAttributes;
            }

            @Override
            public final java.lang.String getMetricType() {
                return this.metricType;
            }

            @Override
            public final java.lang.Object getMonitoredRequestCountMetric() {
                return this.monitoredRequestCountMetric;
            }

            @Override
            public final java.lang.String getOperationName() {
                return this.operationName;
            }

            @Override
            public final java.lang.Object getTotalRequestCountMetric() {
                return this.totalRequestCountMetric;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDependencyConfig() != null) {
                    data.set("dependencyConfig", om.valueToTree(this.getDependencyConfig()));
                }
                if (this.getKeyAttributes() != null) {
                    data.set("keyAttributes", om.valueToTree(this.getKeyAttributes()));
                }
                if (this.getMetricType() != null) {
                    data.set("metricType", om.valueToTree(this.getMetricType()));
                }
                if (this.getMonitoredRequestCountMetric() != null) {
                    data.set("monitoredRequestCountMetric", om.valueToTree(this.getMonitoredRequestCountMetric()));
                }
                if (this.getOperationName() != null) {
                    data.set("operationName", om.valueToTree(this.getOperationName()));
                }
                if (this.getTotalRequestCountMetric() != null) {
                    data.set("totalRequestCountMetric", om.valueToTree(this.getTotalRequestCountMetric()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.RequestBasedSliMetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RequestBasedSliMetricProperty.Jsii$Proxy that = (RequestBasedSliMetricProperty.Jsii$Proxy) o;

                if (this.dependencyConfig != null ? !this.dependencyConfig.equals(that.dependencyConfig) : that.dependencyConfig != null) return false;
                if (this.keyAttributes != null ? !this.keyAttributes.equals(that.keyAttributes) : that.keyAttributes != null) return false;
                if (this.metricType != null ? !this.metricType.equals(that.metricType) : that.metricType != null) return false;
                if (this.monitoredRequestCountMetric != null ? !this.monitoredRequestCountMetric.equals(that.monitoredRequestCountMetric) : that.monitoredRequestCountMetric != null) return false;
                if (this.operationName != null ? !this.operationName.equals(that.operationName) : that.operationName != null) return false;
                return this.totalRequestCountMetric != null ? this.totalRequestCountMetric.equals(that.totalRequestCountMetric) : that.totalRequestCountMetric == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dependencyConfig != null ? this.dependencyConfig.hashCode() : 0;
                result = 31 * result + (this.keyAttributes != null ? this.keyAttributes.hashCode() : 0);
                result = 31 * result + (this.metricType != null ? this.metricType.hashCode() : 0);
                result = 31 * result + (this.monitoredRequestCountMetric != null ? this.monitoredRequestCountMetric.hashCode() : 0);
                result = 31 * result + (this.operationName != null ? this.operationName.hashCode() : 0);
                result = 31 * result + (this.totalRequestCountMetric != null ? this.totalRequestCountMetric.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure contains information about the performance metric that a request-based SLO monitors.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * RequestBasedSliProperty requestBasedSliProperty = RequestBasedSliProperty.builder()
     *         .requestBasedSliMetric(RequestBasedSliMetricProperty.builder()
     *                 .dependencyConfig(DependencyConfigProperty.builder()
     *                         .dependencyKeyAttributes(Map.of(
     *                                 "dependencyKeyAttributesKey", "dependencyKeyAttributes"))
     *                         .dependencyOperationName("dependencyOperationName")
     *                         .build())
     *                 .keyAttributes(Map.of(
     *                         "keyAttributesKey", "keyAttributes"))
     *                 .metricType("metricType")
     *                 .monitoredRequestCountMetric(MonitoredRequestCountMetricProperty.builder()
     *                         .badCountMetric(List.of(MetricDataQueryProperty.builder()
     *                                 .id("id")
     *                                 // the properties below are optional
     *                                 .accountId("accountId")
     *                                 .expression("expression")
     *                                 .metricStat(MetricStatProperty.builder()
     *                                         .metric(MetricProperty.builder()
     *                                                 .dimensions(List.of(DimensionProperty.builder()
     *                                                         .name("name")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .metricName("metricName")
     *                                                 .namespace("namespace")
     *                                                 .build())
     *                                         .period(123)
     *                                         .stat("stat")
     *                                         // the properties below are optional
     *                                         .unit("unit")
     *                                         .build())
     *                                 .returnData(false)
     *                                 .build()))
     *                         .goodCountMetric(List.of(MetricDataQueryProperty.builder()
     *                                 .id("id")
     *                                 // the properties below are optional
     *                                 .accountId("accountId")
     *                                 .expression("expression")
     *                                 .metricStat(MetricStatProperty.builder()
     *                                         .metric(MetricProperty.builder()
     *                                                 .dimensions(List.of(DimensionProperty.builder()
     *                                                         .name("name")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .metricName("metricName")
     *                                                 .namespace("namespace")
     *                                                 .build())
     *                                         .period(123)
     *                                         .stat("stat")
     *                                         // the properties below are optional
     *                                         .unit("unit")
     *                                         .build())
     *                                 .returnData(false)
     *                                 .build()))
     *                         .build())
     *                 .operationName("operationName")
     *                 .totalRequestCountMetric(List.of(MetricDataQueryProperty.builder()
     *                         .id("id")
     *                         // the properties below are optional
     *                         .accountId("accountId")
     *                         .expression("expression")
     *                         .metricStat(MetricStatProperty.builder()
     *                                 .metric(MetricProperty.builder()
     *                                         .dimensions(List.of(DimensionProperty.builder()
     *                                                 .name("name")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .metricName("metricName")
     *                                         .namespace("namespace")
     *                                         .build())
     *                                 .period(123)
     *                                 .stat("stat")
     *                                 // the properties below are optional
     *                                 .unit("unit")
     *                                 .build())
     *                         .returnData(false)
     *                         .build()))
     *                 .build())
     *         // the properties below are optional
     *         .comparisonOperator("comparisonOperator")
     *         .metricThreshold(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedsli.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedsli.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.RequestBasedSliProperty")
    @software.amazon.jsii.Jsii.Proxy(RequestBasedSliProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RequestBasedSliProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A structure that contains information about the metric that the SLO monitors.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.RequestBasedSliMetricProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedsli.html#cfn-applicationsignals-servicelevelobjective-requestbasedsli-requestbasedslimetric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedsli.html#cfn-applicationsignals-servicelevelobjective-requestbasedsli-requestbasedslimetric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRequestBasedSliMetric();

        /**
         * The arithmetic operation used when comparing the specified metric to the threshold.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedsli.html#cfn-applicationsignals-servicelevelobjective-requestbasedsli-comparisonoperator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedsli.html#cfn-applicationsignals-servicelevelobjective-requestbasedsli-comparisonoperator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComparisonOperator() {
            return null;
        }

        /**
         * This value is the threshold that the observed metric values of the SLI metric are compared to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedsli.html#cfn-applicationsignals-servicelevelobjective-requestbasedsli-metricthreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-requestbasedsli.html#cfn-applicationsignals-servicelevelobjective-requestbasedsli-metricthreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMetricThreshold() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RequestBasedSliProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RequestBasedSliProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RequestBasedSliProperty> {
            java.lang.Object requestBasedSliMetric;
            java.lang.String comparisonOperator;
            java.lang.Number metricThreshold;

            /**
             * Sets the value of {@link RequestBasedSliProperty#getRequestBasedSliMetric}
             * @param requestBasedSliMetric A structure that contains information about the metric that the SLO monitors. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestBasedSliMetric(software.amazon.awscdk.IResolvable requestBasedSliMetric) {
                this.requestBasedSliMetric = requestBasedSliMetric;
                return this;
            }

            /**
             * Sets the value of {@link RequestBasedSliProperty#getRequestBasedSliMetric}
             * @param requestBasedSliMetric A structure that contains information about the metric that the SLO monitors. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestBasedSliMetric(software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.RequestBasedSliMetricProperty requestBasedSliMetric) {
                this.requestBasedSliMetric = requestBasedSliMetric;
                return this;
            }

            /**
             * Sets the value of {@link RequestBasedSliProperty#getComparisonOperator}
             * @param comparisonOperator The arithmetic operation used when comparing the specified metric to the threshold.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonOperator(java.lang.String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            /**
             * Sets the value of {@link RequestBasedSliProperty#getMetricThreshold}
             * @param metricThreshold This value is the threshold that the observed metric values of the SLI metric are compared to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricThreshold(java.lang.Number metricThreshold) {
                this.metricThreshold = metricThreshold;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RequestBasedSliProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RequestBasedSliProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RequestBasedSliProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RequestBasedSliProperty {
            private final java.lang.Object requestBasedSliMetric;
            private final java.lang.String comparisonOperator;
            private final java.lang.Number metricThreshold;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.requestBasedSliMetric = software.amazon.jsii.Kernel.get(this, "requestBasedSliMetric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricThreshold = software.amazon.jsii.Kernel.get(this, "metricThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.requestBasedSliMetric = java.util.Objects.requireNonNull(builder.requestBasedSliMetric, "requestBasedSliMetric is required");
                this.comparisonOperator = builder.comparisonOperator;
                this.metricThreshold = builder.metricThreshold;
            }

            @Override
            public final java.lang.Object getRequestBasedSliMetric() {
                return this.requestBasedSliMetric;
            }

            @Override
            public final java.lang.String getComparisonOperator() {
                return this.comparisonOperator;
            }

            @Override
            public final java.lang.Number getMetricThreshold() {
                return this.metricThreshold;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("requestBasedSliMetric", om.valueToTree(this.getRequestBasedSliMetric()));
                if (this.getComparisonOperator() != null) {
                    data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
                }
                if (this.getMetricThreshold() != null) {
                    data.set("metricThreshold", om.valueToTree(this.getMetricThreshold()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.RequestBasedSliProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RequestBasedSliProperty.Jsii$Proxy that = (RequestBasedSliProperty.Jsii$Proxy) o;

                if (!requestBasedSliMetric.equals(that.requestBasedSliMetric)) return false;
                if (this.comparisonOperator != null ? !this.comparisonOperator.equals(that.comparisonOperator) : that.comparisonOperator != null) return false;
                return this.metricThreshold != null ? this.metricThreshold.equals(that.metricThreshold) : that.metricThreshold == null;
            }

            @Override
            public final int hashCode() {
                int result = this.requestBasedSliMetric.hashCode();
                result = 31 * result + (this.comparisonOperator != null ? this.comparisonOperator.hashCode() : 0);
                result = 31 * result + (this.metricThreshold != null ? this.metricThreshold.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * If the interval for this SLO is a rolling interval, this structure contains the interval specifications.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * RollingIntervalProperty rollingIntervalProperty = RollingIntervalProperty.builder()
     *         .duration(123)
     *         .durationUnit("durationUnit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-rollinginterval.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-rollinginterval.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.RollingIntervalProperty")
    @software.amazon.jsii.Jsii.Proxy(RollingIntervalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RollingIntervalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the duration of each rolling interval.
         * <p>
         * For example, if <code>Duration</code> is <code>7</code> and <code>DurationUnit</code> is <code>DAY</code> , each rolling interval is seven days.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-rollinginterval.html#cfn-applicationsignals-servicelevelobjective-rollinginterval-duration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-rollinginterval.html#cfn-applicationsignals-servicelevelobjective-rollinginterval-duration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDuration();

        /**
         * Specifies the rolling interval unit.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-rollinginterval.html#cfn-applicationsignals-servicelevelobjective-rollinginterval-durationunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-rollinginterval.html#cfn-applicationsignals-servicelevelobjective-rollinginterval-durationunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDurationUnit();

        /**
         * @return a {@link Builder} of {@link RollingIntervalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RollingIntervalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RollingIntervalProperty> {
            java.lang.Number duration;
            java.lang.String durationUnit;

            /**
             * Sets the value of {@link RollingIntervalProperty#getDuration}
             * @param duration Specifies the duration of each rolling interval. This parameter is required.
             *                 For example, if <code>Duration</code> is <code>7</code> and <code>DurationUnit</code> is <code>DAY</code> , each rolling interval is seven days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder duration(java.lang.Number duration) {
                this.duration = duration;
                return this;
            }

            /**
             * Sets the value of {@link RollingIntervalProperty#getDurationUnit}
             * @param durationUnit Specifies the rolling interval unit. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationUnit(java.lang.String durationUnit) {
                this.durationUnit = durationUnit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RollingIntervalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RollingIntervalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RollingIntervalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RollingIntervalProperty {
            private final java.lang.Number duration;
            private final java.lang.String durationUnit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.duration = software.amazon.jsii.Kernel.get(this, "duration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.durationUnit = software.amazon.jsii.Kernel.get(this, "durationUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.duration = java.util.Objects.requireNonNull(builder.duration, "duration is required");
                this.durationUnit = java.util.Objects.requireNonNull(builder.durationUnit, "durationUnit is required");
            }

            @Override
            public final java.lang.Number getDuration() {
                return this.duration;
            }

            @Override
            public final java.lang.String getDurationUnit() {
                return this.durationUnit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("duration", om.valueToTree(this.getDuration()));
                data.set("durationUnit", om.valueToTree(this.getDurationUnit()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.RollingIntervalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RollingIntervalProperty.Jsii$Proxy that = (RollingIntervalProperty.Jsii$Proxy) o;

                if (!duration.equals(that.duration)) return false;
                return this.durationUnit.equals(that.durationUnit);
            }

            @Override
            public final int hashCode() {
                int result = this.duration.hashCode();
                result = 31 * result + (this.durationUnit.hashCode());
                return result;
            }
        }
    }
    /**
     * Use this structure to specify the metric to be used for the SLO.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * SliMetricProperty sliMetricProperty = SliMetricProperty.builder()
     *         .dependencyConfig(DependencyConfigProperty.builder()
     *                 .dependencyKeyAttributes(Map.of(
     *                         "dependencyKeyAttributesKey", "dependencyKeyAttributes"))
     *                 .dependencyOperationName("dependencyOperationName")
     *                 .build())
     *         .keyAttributes(Map.of(
     *                 "keyAttributesKey", "keyAttributes"))
     *         .metricDataQueries(List.of(MetricDataQueryProperty.builder()
     *                 .id("id")
     *                 // the properties below are optional
     *                 .accountId("accountId")
     *                 .expression("expression")
     *                 .metricStat(MetricStatProperty.builder()
     *                         .metric(MetricProperty.builder()
     *                                 .dimensions(List.of(DimensionProperty.builder()
     *                                         .name("name")
     *                                         .value("value")
     *                                         .build()))
     *                                 .metricName("metricName")
     *                                 .namespace("namespace")
     *                                 .build())
     *                         .period(123)
     *                         .stat("stat")
     *                         // the properties below are optional
     *                         .unit("unit")
     *                         .build())
     *                 .returnData(false)
     *                 .build()))
     *         .metricType("metricType")
     *         .operationName("operationName")
     *         .periodSeconds(123)
     *         .statistic("statistic")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-slimetric.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-slimetric.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.SliMetricProperty")
    @software.amazon.jsii.Jsii.Proxy(SliMetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SliMetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Identifies the dependency using the <code>DependencyKeyAttributes</code> and <code>DependencyOperationName</code> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.DependencyConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-slimetric.html#cfn-applicationsignals-servicelevelobjective-slimetric-dependencyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-slimetric.html#cfn-applicationsignals-servicelevelobjective-slimetric-dependencyconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDependencyConfig() {
            return null;
        }

        /**
         * If this SLO is related to a metric collected by Application Signals, you must use this field to specify which service the SLO metric is related to.
         * <p>
         * To do so, you must specify at least the <code>Type</code> , <code>Name</code> , and <code>Environment</code> attributes.
         * <p>
         * This is a string-to-string map. It can include the following fields.
         * <p>
         * <ul>
         * <li><code>Type</code> designates the type of object this is.</li>
         * <li><code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
         * <li><code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code> , <code>RemoteService</code> , or <code>AWS::Service</code> .</li>
         * <li><code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
         * <li><code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</li>
         * </ul>
         * <p>
         * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-slimetric.html#cfn-applicationsignals-servicelevelobjective-slimetric-keyattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-slimetric.html#cfn-applicationsignals-servicelevelobjective-slimetric-keyattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKeyAttributes() {
            return null;
        }

        /**
         * If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, use this structure to specify that metric or expression.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.MetricDataQueryProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-slimetric.html#cfn-applicationsignals-servicelevelobjective-slimetric-metricdataqueries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-slimetric.html#cfn-applicationsignals-servicelevelobjective-slimetric-metricdataqueries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricDataQueries() {
            return null;
        }

        /**
         * If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application Signals collects, use this field to specify which of those metrics is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-slimetric.html#cfn-applicationsignals-servicelevelobjective-slimetric-metrictype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-slimetric.html#cfn-applicationsignals-servicelevelobjective-slimetric-metrictype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricType() {
            return null;
        }

        /**
         * If the SLO is to monitor a specific operation of the service, use this field to specify the name of that operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-slimetric.html#cfn-applicationsignals-servicelevelobjective-slimetric-operationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-slimetric.html#cfn-applicationsignals-servicelevelobjective-slimetric-operationname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOperationName() {
            return null;
        }

        /**
         * The number of seconds to use as the period for SLO evaluation.
         * <p>
         * Your application's performance is compared to the SLI during each period. For each period, the application is determined to have either achieved or not achieved the necessary performance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-slimetric.html#cfn-applicationsignals-servicelevelobjective-slimetric-periodseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-slimetric.html#cfn-applicationsignals-servicelevelobjective-slimetric-periodseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPeriodSeconds() {
            return null;
        }

        /**
         * The statistic to use for comparison to the threshold.
         * <p>
         * It can be any CloudWatch statistic or extended statistic. For more information about statistics, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html">CloudWatch statistics definitions</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-slimetric.html#cfn-applicationsignals-servicelevelobjective-slimetric-statistic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-slimetric.html#cfn-applicationsignals-servicelevelobjective-slimetric-statistic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatistic() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SliMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SliMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SliMetricProperty> {
            java.lang.Object dependencyConfig;
            java.lang.Object keyAttributes;
            java.lang.Object metricDataQueries;
            java.lang.String metricType;
            java.lang.String operationName;
            java.lang.Number periodSeconds;
            java.lang.String statistic;

            /**
             * Sets the value of {@link SliMetricProperty#getDependencyConfig}
             * @param dependencyConfig Identifies the dependency using the <code>DependencyKeyAttributes</code> and <code>DependencyOperationName</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependencyConfig(software.amazon.awscdk.IResolvable dependencyConfig) {
                this.dependencyConfig = dependencyConfig;
                return this;
            }

            /**
             * Sets the value of {@link SliMetricProperty#getDependencyConfig}
             * @param dependencyConfig Identifies the dependency using the <code>DependencyKeyAttributes</code> and <code>DependencyOperationName</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependencyConfig(software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.DependencyConfigProperty dependencyConfig) {
                this.dependencyConfig = dependencyConfig;
                return this;
            }

            /**
             * Sets the value of {@link SliMetricProperty#getKeyAttributes}
             * @param keyAttributes If this SLO is related to a metric collected by Application Signals, you must use this field to specify which service the SLO metric is related to.
             *                      To do so, you must specify at least the <code>Type</code> , <code>Name</code> , and <code>Environment</code> attributes.
             *                      <p>
             *                      This is a string-to-string map. It can include the following fields.
             *                      <p>
             *                      <ul>
             *                      <li><code>Type</code> designates the type of object this is.</li>
             *                      <li><code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
             *                      <li><code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code> , <code>RemoteService</code> , or <code>AWS::Service</code> .</li>
             *                      <li><code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
             *                      <li><code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyAttributes(java.util.Map<java.lang.String, java.lang.String> keyAttributes) {
                this.keyAttributes = keyAttributes;
                return this;
            }

            /**
             * Sets the value of {@link SliMetricProperty#getKeyAttributes}
             * @param keyAttributes If this SLO is related to a metric collected by Application Signals, you must use this field to specify which service the SLO metric is related to.
             *                      To do so, you must specify at least the <code>Type</code> , <code>Name</code> , and <code>Environment</code> attributes.
             *                      <p>
             *                      This is a string-to-string map. It can include the following fields.
             *                      <p>
             *                      <ul>
             *                      <li><code>Type</code> designates the type of object this is.</li>
             *                      <li><code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
             *                      <li><code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code> , <code>RemoteService</code> , or <code>AWS::Service</code> .</li>
             *                      <li><code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code> .</li>
             *                      <li><code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyAttributes(software.amazon.awscdk.IResolvable keyAttributes) {
                this.keyAttributes = keyAttributes;
                return this;
            }

            /**
             * Sets the value of {@link SliMetricProperty#getMetricDataQueries}
             * @param metricDataQueries If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, use this structure to specify that metric or expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDataQueries(software.amazon.awscdk.IResolvable metricDataQueries) {
                this.metricDataQueries = metricDataQueries;
                return this;
            }

            /**
             * Sets the value of {@link SliMetricProperty#getMetricDataQueries}
             * @param metricDataQueries If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, use this structure to specify that metric or expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricDataQueries(java.util.List<? extends java.lang.Object> metricDataQueries) {
                this.metricDataQueries = metricDataQueries;
                return this;
            }

            /**
             * Sets the value of {@link SliMetricProperty#getMetricType}
             * @param metricType If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application Signals collects, use this field to specify which of those metrics is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricType(java.lang.String metricType) {
                this.metricType = metricType;
                return this;
            }

            /**
             * Sets the value of {@link SliMetricProperty#getOperationName}
             * @param operationName If the SLO is to monitor a specific operation of the service, use this field to specify the name of that operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operationName(java.lang.String operationName) {
                this.operationName = operationName;
                return this;
            }

            /**
             * Sets the value of {@link SliMetricProperty#getPeriodSeconds}
             * @param periodSeconds The number of seconds to use as the period for SLO evaluation.
             *                      Your application's performance is compared to the SLI during each period. For each period, the application is determined to have either achieved or not achieved the necessary performance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder periodSeconds(java.lang.Number periodSeconds) {
                this.periodSeconds = periodSeconds;
                return this;
            }

            /**
             * Sets the value of {@link SliMetricProperty#getStatistic}
             * @param statistic The statistic to use for comparison to the threshold.
             *                  It can be any CloudWatch statistic or extended statistic. For more information about statistics, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html">CloudWatch statistics definitions</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistic(java.lang.String statistic) {
                this.statistic = statistic;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SliMetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SliMetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SliMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SliMetricProperty {
            private final java.lang.Object dependencyConfig;
            private final java.lang.Object keyAttributes;
            private final java.lang.Object metricDataQueries;
            private final java.lang.String metricType;
            private final java.lang.String operationName;
            private final java.lang.Number periodSeconds;
            private final java.lang.String statistic;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dependencyConfig = software.amazon.jsii.Kernel.get(this, "dependencyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.keyAttributes = software.amazon.jsii.Kernel.get(this, "keyAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metricDataQueries = software.amazon.jsii.Kernel.get(this, "metricDataQueries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metricType = software.amazon.jsii.Kernel.get(this, "metricType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.operationName = software.amazon.jsii.Kernel.get(this, "operationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.periodSeconds = software.amazon.jsii.Kernel.get(this, "periodSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dependencyConfig = builder.dependencyConfig;
                this.keyAttributes = builder.keyAttributes;
                this.metricDataQueries = builder.metricDataQueries;
                this.metricType = builder.metricType;
                this.operationName = builder.operationName;
                this.periodSeconds = builder.periodSeconds;
                this.statistic = builder.statistic;
            }

            @Override
            public final java.lang.Object getDependencyConfig() {
                return this.dependencyConfig;
            }

            @Override
            public final java.lang.Object getKeyAttributes() {
                return this.keyAttributes;
            }

            @Override
            public final java.lang.Object getMetricDataQueries() {
                return this.metricDataQueries;
            }

            @Override
            public final java.lang.String getMetricType() {
                return this.metricType;
            }

            @Override
            public final java.lang.String getOperationName() {
                return this.operationName;
            }

            @Override
            public final java.lang.Number getPeriodSeconds() {
                return this.periodSeconds;
            }

            @Override
            public final java.lang.String getStatistic() {
                return this.statistic;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDependencyConfig() != null) {
                    data.set("dependencyConfig", om.valueToTree(this.getDependencyConfig()));
                }
                if (this.getKeyAttributes() != null) {
                    data.set("keyAttributes", om.valueToTree(this.getKeyAttributes()));
                }
                if (this.getMetricDataQueries() != null) {
                    data.set("metricDataQueries", om.valueToTree(this.getMetricDataQueries()));
                }
                if (this.getMetricType() != null) {
                    data.set("metricType", om.valueToTree(this.getMetricType()));
                }
                if (this.getOperationName() != null) {
                    data.set("operationName", om.valueToTree(this.getOperationName()));
                }
                if (this.getPeriodSeconds() != null) {
                    data.set("periodSeconds", om.valueToTree(this.getPeriodSeconds()));
                }
                if (this.getStatistic() != null) {
                    data.set("statistic", om.valueToTree(this.getStatistic()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.SliMetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SliMetricProperty.Jsii$Proxy that = (SliMetricProperty.Jsii$Proxy) o;

                if (this.dependencyConfig != null ? !this.dependencyConfig.equals(that.dependencyConfig) : that.dependencyConfig != null) return false;
                if (this.keyAttributes != null ? !this.keyAttributes.equals(that.keyAttributes) : that.keyAttributes != null) return false;
                if (this.metricDataQueries != null ? !this.metricDataQueries.equals(that.metricDataQueries) : that.metricDataQueries != null) return false;
                if (this.metricType != null ? !this.metricType.equals(that.metricType) : that.metricType != null) return false;
                if (this.operationName != null ? !this.operationName.equals(that.operationName) : that.operationName != null) return false;
                if (this.periodSeconds != null ? !this.periodSeconds.equals(that.periodSeconds) : that.periodSeconds != null) return false;
                return this.statistic != null ? this.statistic.equals(that.statistic) : that.statistic == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dependencyConfig != null ? this.dependencyConfig.hashCode() : 0;
                result = 31 * result + (this.keyAttributes != null ? this.keyAttributes.hashCode() : 0);
                result = 31 * result + (this.metricDataQueries != null ? this.metricDataQueries.hashCode() : 0);
                result = 31 * result + (this.metricType != null ? this.metricType.hashCode() : 0);
                result = 31 * result + (this.operationName != null ? this.operationName.hashCode() : 0);
                result = 31 * result + (this.periodSeconds != null ? this.periodSeconds.hashCode() : 0);
                result = 31 * result + (this.statistic != null ? this.statistic.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure specifies the information about the service and the performance metric that an SLO is to monitor.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * SliProperty sliProperty = SliProperty.builder()
     *         .comparisonOperator("comparisonOperator")
     *         .metricThreshold(123)
     *         .sliMetric(SliMetricProperty.builder()
     *                 .dependencyConfig(DependencyConfigProperty.builder()
     *                         .dependencyKeyAttributes(Map.of(
     *                                 "dependencyKeyAttributesKey", "dependencyKeyAttributes"))
     *                         .dependencyOperationName("dependencyOperationName")
     *                         .build())
     *                 .keyAttributes(Map.of(
     *                         "keyAttributesKey", "keyAttributes"))
     *                 .metricDataQueries(List.of(MetricDataQueryProperty.builder()
     *                         .id("id")
     *                         // the properties below are optional
     *                         .accountId("accountId")
     *                         .expression("expression")
     *                         .metricStat(MetricStatProperty.builder()
     *                                 .metric(MetricProperty.builder()
     *                                         .dimensions(List.of(DimensionProperty.builder()
     *                                                 .name("name")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .metricName("metricName")
     *                                         .namespace("namespace")
     *                                         .build())
     *                                 .period(123)
     *                                 .stat("stat")
     *                                 // the properties below are optional
     *                                 .unit("unit")
     *                                 .build())
     *                         .returnData(false)
     *                         .build()))
     *                 .metricType("metricType")
     *                 .operationName("operationName")
     *                 .periodSeconds(123)
     *                 .statistic("statistic")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-sli.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-sli.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.SliProperty")
    @software.amazon.jsii.Jsii.Proxy(SliProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SliProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The arithmetic operation to use when comparing the specified metric to the threshold.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-sli.html#cfn-applicationsignals-servicelevelobjective-sli-comparisonoperator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-sli.html#cfn-applicationsignals-servicelevelobjective-sli-comparisonoperator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComparisonOperator();

        /**
         * The value that the SLI metric is compared to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-sli.html#cfn-applicationsignals-servicelevelobjective-sli-metricthreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-sli.html#cfn-applicationsignals-servicelevelobjective-sli-metricthreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMetricThreshold();

        /**
         * Use this structure to specify the metric to be used for the SLO.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.SliMetricProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-sli.html#cfn-applicationsignals-servicelevelobjective-sli-slimetric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-sli.html#cfn-applicationsignals-servicelevelobjective-sli-slimetric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSliMetric();

        /**
         * @return a {@link Builder} of {@link SliProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SliProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SliProperty> {
            java.lang.String comparisonOperator;
            java.lang.Number metricThreshold;
            java.lang.Object sliMetric;

            /**
             * Sets the value of {@link SliProperty#getComparisonOperator}
             * @param comparisonOperator The arithmetic operation to use when comparing the specified metric to the threshold. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonOperator(java.lang.String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            /**
             * Sets the value of {@link SliProperty#getMetricThreshold}
             * @param metricThreshold The value that the SLI metric is compared to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricThreshold(java.lang.Number metricThreshold) {
                this.metricThreshold = metricThreshold;
                return this;
            }

            /**
             * Sets the value of {@link SliProperty#getSliMetric}
             * @param sliMetric Use this structure to specify the metric to be used for the SLO. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sliMetric(software.amazon.awscdk.IResolvable sliMetric) {
                this.sliMetric = sliMetric;
                return this;
            }

            /**
             * Sets the value of {@link SliProperty#getSliMetric}
             * @param sliMetric Use this structure to specify the metric to be used for the SLO. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sliMetric(software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.SliMetricProperty sliMetric) {
                this.sliMetric = sliMetric;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SliProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SliProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SliProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SliProperty {
            private final java.lang.String comparisonOperator;
            private final java.lang.Number metricThreshold;
            private final java.lang.Object sliMetric;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricThreshold = software.amazon.jsii.Kernel.get(this, "metricThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sliMetric = software.amazon.jsii.Kernel.get(this, "sliMetric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparisonOperator = java.util.Objects.requireNonNull(builder.comparisonOperator, "comparisonOperator is required");
                this.metricThreshold = java.util.Objects.requireNonNull(builder.metricThreshold, "metricThreshold is required");
                this.sliMetric = java.util.Objects.requireNonNull(builder.sliMetric, "sliMetric is required");
            }

            @Override
            public final java.lang.String getComparisonOperator() {
                return this.comparisonOperator;
            }

            @Override
            public final java.lang.Number getMetricThreshold() {
                return this.metricThreshold;
            }

            @Override
            public final java.lang.Object getSliMetric() {
                return this.sliMetric;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
                data.set("metricThreshold", om.valueToTree(this.getMetricThreshold()));
                data.set("sliMetric", om.valueToTree(this.getSliMetric()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.SliProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SliProperty.Jsii$Proxy that = (SliProperty.Jsii$Proxy) o;

                if (!comparisonOperator.equals(that.comparisonOperator)) return false;
                if (!metricThreshold.equals(that.metricThreshold)) return false;
                return this.sliMetric.equals(that.sliMetric);
            }

            @Override
            public final int hashCode() {
                int result = this.comparisonOperator.hashCode();
                result = 31 * result + (this.metricThreshold.hashCode());
                result = 31 * result + (this.sliMetric.hashCode());
                return result;
            }
        }
    }
    /**
     * The start and end time of the time exclusion window.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationsignals.*;
     * WindowProperty windowProperty = WindowProperty.builder()
     *         .duration(123)
     *         .durationUnit("durationUnit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-window.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-window.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.WindowProperty")
    @software.amazon.jsii.Jsii.Proxy(WindowProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WindowProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The start and end time of the time exclusion window.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-window.html#cfn-applicationsignals-servicelevelobjective-window-duration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-window.html#cfn-applicationsignals-servicelevelobjective-window-duration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDuration();

        /**
         * The unit of measurement to use during the time window exclusion.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-window.html#cfn-applicationsignals-servicelevelobjective-window-durationunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationsignals-servicelevelobjective-window.html#cfn-applicationsignals-servicelevelobjective-window-durationunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDurationUnit();

        /**
         * @return a {@link Builder} of {@link WindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WindowProperty> {
            java.lang.Number duration;
            java.lang.String durationUnit;

            /**
             * Sets the value of {@link WindowProperty#getDuration}
             * @param duration The start and end time of the time exclusion window. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder duration(java.lang.Number duration) {
                this.duration = duration;
                return this;
            }

            /**
             * Sets the value of {@link WindowProperty#getDurationUnit}
             * @param durationUnit The unit of measurement to use during the time window exclusion. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationUnit(java.lang.String durationUnit) {
                this.durationUnit = durationUnit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WindowProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WindowProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WindowProperty {
            private final java.lang.Number duration;
            private final java.lang.String durationUnit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.duration = software.amazon.jsii.Kernel.get(this, "duration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.durationUnit = software.amazon.jsii.Kernel.get(this, "durationUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.duration = java.util.Objects.requireNonNull(builder.duration, "duration is required");
                this.durationUnit = java.util.Objects.requireNonNull(builder.durationUnit, "durationUnit is required");
            }

            @Override
            public final java.lang.Number getDuration() {
                return this.duration;
            }

            @Override
            public final java.lang.String getDurationUnit() {
                return this.durationUnit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("duration", om.valueToTree(this.getDuration()));
                data.set("durationUnit", om.valueToTree(this.getDurationUnit()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjective.WindowProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WindowProperty.Jsii$Proxy that = (WindowProperty.Jsii$Proxy) o;

                if (!duration.equals(that.duration)) return false;
                return this.durationUnit.equals(that.durationUnit);
            }

            @Override
            public final int hashCode() {
                int result = this.duration.hashCode();
                result = 31 * result + (this.durationUnit.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjectiveProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjectiveProps.Builder();
        }

        /**
         * A name for this SLO.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-name</a>
         * @param name A name for this SLO. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Each object in this array defines the length of the look-back window used to calculate one burn rate metric for this SLO.
         * <p>
         * The burn rate measures how fast the service is consuming the error budget, relative to the attainment goal of the SLO.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-burnrateconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-burnrateconfigurations</a>
         * @param burnRateConfigurations Each object in this array defines the length of the look-back window used to calculate one burn rate metric for this SLO. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder burnRateConfigurations(final software.amazon.awscdk.IResolvable burnRateConfigurations) {
            this.props.burnRateConfigurations(burnRateConfigurations);
            return this;
        }
        /**
         * Each object in this array defines the length of the look-back window used to calculate one burn rate metric for this SLO.
         * <p>
         * The burn rate measures how fast the service is consuming the error budget, relative to the attainment goal of the SLO.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-burnrateconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-burnrateconfigurations</a>
         * @param burnRateConfigurations Each object in this array defines the length of the look-back window used to calculate one burn rate metric for this SLO. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder burnRateConfigurations(final java.util.List<? extends java.lang.Object> burnRateConfigurations) {
            this.props.burnRateConfigurations(burnRateConfigurations);
            return this;
        }

        /**
         * An optional description for this SLO.
         * <p>
         * Default: - "No description"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-description</a>
         * @param description An optional description for this SLO. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The time window to be excluded from the SLO performance metrics.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-exclusionwindows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-exclusionwindows</a>
         * @param exclusionWindows The time window to be excluded from the SLO performance metrics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclusionWindows(final software.amazon.awscdk.IResolvable exclusionWindows) {
            this.props.exclusionWindows(exclusionWindows);
            return this;
        }
        /**
         * The time window to be excluded from the SLO performance metrics.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-exclusionwindows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-exclusionwindows</a>
         * @param exclusionWindows The time window to be excluded from the SLO performance metrics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclusionWindows(final java.util.List<? extends java.lang.Object> exclusionWindows) {
            this.props.exclusionWindows(exclusionWindows);
            return this;
        }

        /**
         * This structure contains the attributes that determine the goal of an SLO.
         * <p>
         * This includes the time period for evaluation and the attainment threshold.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-goal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-goal</a>
         * @param goal This structure contains the attributes that determine the goal of an SLO. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder goal(final software.amazon.awscdk.IResolvable goal) {
            this.props.goal(goal);
            return this;
        }
        /**
         * This structure contains the attributes that determine the goal of an SLO.
         * <p>
         * This includes the time period for evaluation and the attainment threshold.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-goal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-goal</a>
         * @param goal This structure contains the attributes that determine the goal of an SLO. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder goal(final software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.GoalProperty goal) {
            this.props.goal(goal);
            return this;
        }

        /**
         * A structure containing information about the performance metric that this SLO monitors, if this is a request-based SLO.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-requestbasedsli">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-requestbasedsli</a>
         * @param requestBasedSli A structure containing information about the performance metric that this SLO monitors, if this is a request-based SLO. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestBasedSli(final software.amazon.awscdk.IResolvable requestBasedSli) {
            this.props.requestBasedSli(requestBasedSli);
            return this;
        }
        /**
         * A structure containing information about the performance metric that this SLO monitors, if this is a request-based SLO.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-requestbasedsli">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-requestbasedsli</a>
         * @param requestBasedSli A structure containing information about the performance metric that this SLO monitors, if this is a request-based SLO. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestBasedSli(final software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.RequestBasedSliProperty requestBasedSli) {
            this.props.requestBasedSli(requestBasedSli);
            return this;
        }

        /**
         * A structure containing information about the performance metric that this SLO monitors, if this is a period-based SLO.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-sli">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-sli</a>
         * @param sli A structure containing information about the performance metric that this SLO monitors, if this is a period-based SLO. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sli(final software.amazon.awscdk.IResolvable sli) {
            this.props.sli(sli);
            return this;
        }
        /**
         * A structure containing information about the performance metric that this SLO monitors, if this is a period-based SLO.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-sli">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-sli</a>
         * @param sli A structure containing information about the performance metric that this SLO monitors, if this is a period-based SLO. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sli(final software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.SliProperty sli) {
            this.props.sli(sli);
            return this;
        }

        /**
         * A list of key-value pairs to associate with the SLO.
         * <p>
         * You can associate as many as 50 tags with an SLO. To be able to associate tags with the SLO when you create the SLO, you must have the cloudwatch:TagResource permission.
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-tags</a>
         * @param tags A list of key-value pairs to associate with the SLO. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective build() {
            return new software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
