package software.amazon.awscdk.services.appmesh;

/**
 * Enum of supported IP preferences.
 * <p>
 * Used to dictate the IP version for mesh wide and virtual node service discovery.
 * Also used to specify the IP version that a sidecar Envoy uses when sending traffic to a local application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh = Mesh.Builder.create(this, "AppMesh")
 *         .meshName("myAwsMesh")
 *         .serviceDiscovery(MeshServiceDiscovery.builder()
 *                 .ipPreference(IpPreference.IPV4_ONLY)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:58.229Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.IpPreference")
public enum IpPreference {
    /**
     * Use IPv4 when sending traffic to a local application.
     * <p>
     * Only use IPv4 for service discovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV4_ONLY,
    /**
     * Use IPv4 when sending traffic to a local application.
     * <p>
     * First attempt to use IPv4 and fall back to IPv6 for service discovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV4_PREFERRED,
    /**
     * Use IPv6 when sending traffic to a local application.
     * <p>
     * Only use IPv6 for service discovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV6_ONLY,
    /**
     * Use IPv6 when sending traffic to a local application.
     * <p>
     * First attempt to use IPv6 and fall back to IPv4 for service discovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV6_PREFERRED,
}
