package software.amazon.awscdk.services.appstream;

/**
 * A reference to a AppBlockBuilder resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appstream.*;
 * AppBlockBuilderReference appBlockBuilderReference = AppBlockBuilderReference.builder()
 *         .appBlockBuilderArn("appBlockBuilderArn")
 *         .appBlockBuilderName("appBlockBuilderName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:58.304Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appstream.AppBlockBuilderReference")
@software.amazon.jsii.Jsii.Proxy(AppBlockBuilderReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AppBlockBuilderReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the AppBlockBuilder resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAppBlockBuilderArn();

    /**
     * The Name of the AppBlockBuilder resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAppBlockBuilderName();

    /**
     * @return a {@link Builder} of {@link AppBlockBuilderReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AppBlockBuilderReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AppBlockBuilderReference> {
        java.lang.String appBlockBuilderArn;
        java.lang.String appBlockBuilderName;

        /**
         * Sets the value of {@link AppBlockBuilderReference#getAppBlockBuilderArn}
         * @param appBlockBuilderArn The ARN of the AppBlockBuilder resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appBlockBuilderArn(java.lang.String appBlockBuilderArn) {
            this.appBlockBuilderArn = appBlockBuilderArn;
            return this;
        }

        /**
         * Sets the value of {@link AppBlockBuilderReference#getAppBlockBuilderName}
         * @param appBlockBuilderName The Name of the AppBlockBuilder resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appBlockBuilderName(java.lang.String appBlockBuilderName) {
            this.appBlockBuilderName = appBlockBuilderName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AppBlockBuilderReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AppBlockBuilderReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AppBlockBuilderReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppBlockBuilderReference {
        private final java.lang.String appBlockBuilderArn;
        private final java.lang.String appBlockBuilderName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appBlockBuilderArn = software.amazon.jsii.Kernel.get(this, "appBlockBuilderArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.appBlockBuilderName = software.amazon.jsii.Kernel.get(this, "appBlockBuilderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appBlockBuilderArn = java.util.Objects.requireNonNull(builder.appBlockBuilderArn, "appBlockBuilderArn is required");
            this.appBlockBuilderName = java.util.Objects.requireNonNull(builder.appBlockBuilderName, "appBlockBuilderName is required");
        }

        @Override
        public final java.lang.String getAppBlockBuilderArn() {
            return this.appBlockBuilderArn;
        }

        @Override
        public final java.lang.String getAppBlockBuilderName() {
            return this.appBlockBuilderName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("appBlockBuilderArn", om.valueToTree(this.getAppBlockBuilderArn()));
            data.set("appBlockBuilderName", om.valueToTree(this.getAppBlockBuilderName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appstream.AppBlockBuilderReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AppBlockBuilderReference.Jsii$Proxy that = (AppBlockBuilderReference.Jsii$Proxy) o;

            if (!appBlockBuilderArn.equals(that.appBlockBuilderArn)) return false;
            return this.appBlockBuilderName.equals(that.appBlockBuilderName);
        }

        @Override
        public final int hashCode() {
            int result = this.appBlockBuilderArn.hashCode();
            result = 31 * result + (this.appBlockBuilderName.hashCode());
            return result;
        }
    }
}
