package software.amazon.awscdk.services.appstream;

/**
 * A reference to a Entitlement resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appstream.*;
 * EntitlementReference entitlementReference = EntitlementReference.builder()
 *         .entitlementName("entitlementName")
 *         .stackName("stackName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:58.366Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appstream.EntitlementReference")
@software.amazon.jsii.Jsii.Proxy(EntitlementReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EntitlementReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Name of the Entitlement resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEntitlementName();

    /**
     * The StackName of the Entitlement resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStackName();

    /**
     * @return a {@link Builder} of {@link EntitlementReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EntitlementReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EntitlementReference> {
        java.lang.String entitlementName;
        java.lang.String stackName;

        /**
         * Sets the value of {@link EntitlementReference#getEntitlementName}
         * @param entitlementName The Name of the Entitlement resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entitlementName(java.lang.String entitlementName) {
            this.entitlementName = entitlementName;
            return this;
        }

        /**
         * Sets the value of {@link EntitlementReference#getStackName}
         * @param stackName The StackName of the Entitlement resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackName(java.lang.String stackName) {
            this.stackName = stackName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EntitlementReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EntitlementReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EntitlementReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EntitlementReference {
        private final java.lang.String entitlementName;
        private final java.lang.String stackName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.entitlementName = software.amazon.jsii.Kernel.get(this, "entitlementName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stackName = software.amazon.jsii.Kernel.get(this, "stackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.entitlementName = java.util.Objects.requireNonNull(builder.entitlementName, "entitlementName is required");
            this.stackName = java.util.Objects.requireNonNull(builder.stackName, "stackName is required");
        }

        @Override
        public final java.lang.String getEntitlementName() {
            return this.entitlementName;
        }

        @Override
        public final java.lang.String getStackName() {
            return this.stackName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("entitlementName", om.valueToTree(this.getEntitlementName()));
            data.set("stackName", om.valueToTree(this.getStackName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appstream.EntitlementReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EntitlementReference.Jsii$Proxy that = (EntitlementReference.Jsii$Proxy) o;

            if (!entitlementName.equals(that.entitlementName)) return false;
            return this.stackName.equals(that.stackName);
        }

        @Override
        public final int hashCode() {
            int result = this.entitlementName.hashCode();
            result = 31 * result + (this.stackName.hashCode());
            return result;
        }
    }
}
