package software.amazon.awscdk.services.appsync;

/**
 * An AppSync datasource backed by a DynamoDB table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EventApi api = EventApi.Builder.create(this, "EventApiDynamoDB")
 *         .apiName("DynamoDBEventApi")
 *         .build();
 * Table table = Table.Builder.create(this, "table")
 *         .tableName("event-messages")
 *         .partitionKey(Attribute.builder()
 *                 .name("id")
 *                 .type(AttributeType.STRING)
 *                 .build())
 *         .build();
 * AppSyncDynamoDbDataSource dataSource = api.addDynamoDbDataSource("ddbsource", table);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:58.401Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AppSyncDynamoDbDataSource")
public class AppSyncDynamoDbDataSource extends software.amazon.awscdk.services.appsync.AppSyncBackedDataSource {

    protected AppSyncDynamoDbDataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AppSyncDynamoDbDataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AppSyncDynamoDbDataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppSyncDynamoDbDataSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.AppSyncDynamoDbDataSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.AppSyncDynamoDbDataSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.AppSyncDynamoDbDataSourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.AppSyncDynamoDbDataSourceProps.Builder();
        }

        /**
         * The API to attach this data source to.
         * <p>
         * @return {@code this}
         * @param api The API to attach this data source to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(final software.amazon.awscdk.services.appsync.IApi api) {
            this.props.api(api);
            return this;
        }

        /**
         * The description of the data source.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param description The description of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the data source.
         * <p>
         * The only allowed pattern is: {[_A-Za-z][_0-9A-Za-z]*}.
         * Any invalid characters will be automatically removed.
         * <p>
         * Default: - id of data source
         * <p>
         * @return {@code this}
         * @param name The name of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The IAM service role to be assumed by AppSync to interact with the data source.
         * <p>
         * Default: -  Create a new role
         * <p>
         * @return {@code this}
         * @param serviceRole The IAM service role to be assumed by AppSync to interact with the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(final software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        /**
         * The DynamoDB table backing this data source.
         * <p>
         * @return {@code this}
         * @param table The DynamoDB table backing this data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder table(final software.amazon.awscdk.services.dynamodb.ITable table) {
            this.props.table(table);
            return this;
        }

        /**
         * Specify whether this Data Source is read only or has read and write permissions to the DynamoDB table.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param readOnlyAccess Specify whether this Data Source is read only or has read and write permissions to the DynamoDB table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readOnlyAccess(final java.lang.Boolean readOnlyAccess) {
            this.props.readOnlyAccess(readOnlyAccess);
            return this;
        }

        /**
         * Use credentials of caller to access DynamoDB.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param useCallerCredentials Use credentials of caller to access DynamoDB. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useCallerCredentials(final java.lang.Boolean useCallerCredentials) {
            this.props.useCallerCredentials(useCallerCredentials);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appsync.AppSyncDynamoDbDataSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.AppSyncDynamoDbDataSource build() {
            return new software.amazon.awscdk.services.appsync.AppSyncDynamoDbDataSource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
