package software.amazon.awscdk.services.appsync;

/**
 * Properties for defining a <code>CfnApiCache</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnApiCacheProps cfnApiCacheProps = CfnApiCacheProps.builder()
 *         .apiCachingBehavior("apiCachingBehavior")
 *         .apiId("apiId")
 *         .ttl(123)
 *         .type("type")
 *         // the properties below are optional
 *         .atRestEncryptionEnabled(false)
 *         .healthMetricsConfig("healthMetricsConfig")
 *         .transitEncryptionEnabled(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:58.430Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnApiCacheProps")
@software.amazon.jsii.Jsii.Proxy(CfnApiCacheProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApiCacheProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Caching behavior.
     * <p>
     * <ul>
     * <li><em>FULL_REQUEST_CACHING</em> : All requests from the same user are cached. Individual resolvers are automatically cached. All API calls will try to return responses from the cache.</li>
     * <li><em>PER_RESOLVER_CACHING</em> : Individual resolvers that you specify are cached.</li>
     * <li><em>OPERATION_LEVEL_CACHING</em> : Full requests are cached together and returned without executing resolvers.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-apicachingbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-apicachingbehavior</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiCachingBehavior();

    /**
     * The GraphQL API ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-apiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-apiid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiId();

    /**
     * TTL in seconds for cache entries.
     * <p>
     * Valid values are 1–3,600 seconds.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-ttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-ttl</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getTtl();

    /**
     * The cache instance type. Valid values are.
     * <p>
     * <ul>
     * <li><code>SMALL</code></li>
     * <li><code>MEDIUM</code></li>
     * <li><code>LARGE</code></li>
     * <li><code>XLARGE</code></li>
     * <li><code>LARGE_2X</code></li>
     * <li><code>LARGE_4X</code></li>
     * <li><code>LARGE_8X</code> (not available in all regions)</li>
     * <li><code>LARGE_12X</code></li>
     * </ul>
     * <p>
     * Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.
     * <p>
     * The following legacy instance types are available, but their use is discouraged:
     * <p>
     * <ul>
     * <li><em>T2_SMALL</em> : A t2.small instance type.</li>
     * <li><em>T2_MEDIUM</em> : A t2.medium instance type.</li>
     * <li><em>R4_LARGE</em> : A r4.large instance type.</li>
     * <li><em>R4_XLARGE</em> : A r4.xlarge instance type.</li>
     * <li><em>R4_2XLARGE</em> : A r4.2xlarge instance type.</li>
     * <li><em>R4_4XLARGE</em> : A r4.4xlarge instance type.</li>
     * <li><em>R4_8XLARGE</em> : A r4.8xlarge instance type.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * <em>This parameter has been deprecated</em> .
     * <p>
     * At-rest encryption flag for cache. You cannot update this setting after creation.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-atrestencryptionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-atrestencryptionenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAtRestEncryptionEnabled() {
        return null;
    }

    /**
     * Controls how cache health metrics will be emitted to CloudWatch. Cache health metrics include:.
     * <p>
     * <ul>
     * <li><em>NetworkBandwidthOutAllowanceExceeded</em> : The network packets dropped because the throughput exceeded the aggregated bandwidth limit. This is useful for diagnosing bottlenecks in a cache configuration.</li>
     * <li><em>EngineCPUUtilization</em> : The CPU utilization (percentage) allocated to the Redis process. This is useful for diagnosing bottlenecks in a cache configuration.</li>
     * </ul>
     * <p>
     * Metrics will be recorded by API ID. You can set the value to <code>ENABLED</code> or <code>DISABLED</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-healthmetricsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-healthmetricsconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHealthMetricsConfig() {
        return null;
    }

    /**
     * <em>This parameter has been deprecated</em> .
     * <p>
     * Transit encryption flag when connecting to cache. You cannot update this setting after creation.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-transitencryptionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-apicache.html#cfn-appsync-apicache-transitencryptionenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTransitEncryptionEnabled() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApiCacheProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApiCacheProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApiCacheProps> {
        java.lang.String apiCachingBehavior;
        java.lang.String apiId;
        java.lang.Number ttl;
        java.lang.String type;
        java.lang.Object atRestEncryptionEnabled;
        java.lang.String healthMetricsConfig;
        java.lang.Object transitEncryptionEnabled;

        /**
         * Sets the value of {@link CfnApiCacheProps#getApiCachingBehavior}
         * @param apiCachingBehavior Caching behavior. This parameter is required.
         *                           <ul>
         *                           <li><em>FULL_REQUEST_CACHING</em> : All requests from the same user are cached. Individual resolvers are automatically cached. All API calls will try to return responses from the cache.</li>
         *                           <li><em>PER_RESOLVER_CACHING</em> : Individual resolvers that you specify are cached.</li>
         *                           <li><em>OPERATION_LEVEL_CACHING</em> : Full requests are cached together and returned without executing resolvers.</li>
         *                           </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiCachingBehavior(java.lang.String apiCachingBehavior) {
            this.apiCachingBehavior = apiCachingBehavior;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiCacheProps#getApiId}
         * @param apiId The GraphQL API ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(java.lang.String apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiCacheProps#getTtl}
         * @param ttl TTL in seconds for cache entries. This parameter is required.
         *            Valid values are 1–3,600 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttl(java.lang.Number ttl) {
            this.ttl = ttl;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiCacheProps#getType}
         * @param type The cache instance type. Valid values are. This parameter is required.
         *             <ul>
         *             <li><code>SMALL</code></li>
         *             <li><code>MEDIUM</code></li>
         *             <li><code>LARGE</code></li>
         *             <li><code>XLARGE</code></li>
         *             <li><code>LARGE_2X</code></li>
         *             <li><code>LARGE_4X</code></li>
         *             <li><code>LARGE_8X</code> (not available in all regions)</li>
         *             <li><code>LARGE_12X</code></li>
         *             </ul>
         *             <p>
         *             Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.
         *             <p>
         *             The following legacy instance types are available, but their use is discouraged:
         *             <p>
         *             <ul>
         *             <li><em>T2_SMALL</em> : A t2.small instance type.</li>
         *             <li><em>T2_MEDIUM</em> : A t2.medium instance type.</li>
         *             <li><em>R4_LARGE</em> : A r4.large instance type.</li>
         *             <li><em>R4_XLARGE</em> : A r4.xlarge instance type.</li>
         *             <li><em>R4_2XLARGE</em> : A r4.2xlarge instance type.</li>
         *             <li><em>R4_4XLARGE</em> : A r4.4xlarge instance type.</li>
         *             <li><em>R4_8XLARGE</em> : A r4.8xlarge instance type.</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiCacheProps#getAtRestEncryptionEnabled}
         * @param atRestEncryptionEnabled <em>This parameter has been deprecated</em> .
         *                                At-rest encryption flag for cache. You cannot update this setting after creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder atRestEncryptionEnabled(java.lang.Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiCacheProps#getAtRestEncryptionEnabled}
         * @param atRestEncryptionEnabled <em>This parameter has been deprecated</em> .
         *                                At-rest encryption flag for cache. You cannot update this setting after creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder atRestEncryptionEnabled(software.amazon.awscdk.IResolvable atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiCacheProps#getHealthMetricsConfig}
         * @param healthMetricsConfig Controls how cache health metrics will be emitted to CloudWatch. Cache health metrics include:.
         *                            <ul>
         *                            <li><em>NetworkBandwidthOutAllowanceExceeded</em> : The network packets dropped because the throughput exceeded the aggregated bandwidth limit. This is useful for diagnosing bottlenecks in a cache configuration.</li>
         *                            <li><em>EngineCPUUtilization</em> : The CPU utilization (percentage) allocated to the Redis process. This is useful for diagnosing bottlenecks in a cache configuration.</li>
         *                            </ul>
         *                            <p>
         *                            Metrics will be recorded by API ID. You can set the value to <code>ENABLED</code> or <code>DISABLED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthMetricsConfig(java.lang.String healthMetricsConfig) {
            this.healthMetricsConfig = healthMetricsConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiCacheProps#getTransitEncryptionEnabled}
         * @param transitEncryptionEnabled <em>This parameter has been deprecated</em> .
         *                                 Transit encryption flag when connecting to cache. You cannot update this setting after creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryptionEnabled(java.lang.Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiCacheProps#getTransitEncryptionEnabled}
         * @param transitEncryptionEnabled <em>This parameter has been deprecated</em> .
         *                                 Transit encryption flag when connecting to cache. You cannot update this setting after creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryptionEnabled(software.amazon.awscdk.IResolvable transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApiCacheProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApiCacheProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApiCacheProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApiCacheProps {
        private final java.lang.String apiCachingBehavior;
        private final java.lang.String apiId;
        private final java.lang.Number ttl;
        private final java.lang.String type;
        private final java.lang.Object atRestEncryptionEnabled;
        private final java.lang.String healthMetricsConfig;
        private final java.lang.Object transitEncryptionEnabled;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiCachingBehavior = software.amazon.jsii.Kernel.get(this, "apiCachingBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ttl = software.amazon.jsii.Kernel.get(this, "ttl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.atRestEncryptionEnabled = software.amazon.jsii.Kernel.get(this, "atRestEncryptionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.healthMetricsConfig = software.amazon.jsii.Kernel.get(this, "healthMetricsConfig", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transitEncryptionEnabled = software.amazon.jsii.Kernel.get(this, "transitEncryptionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiCachingBehavior = java.util.Objects.requireNonNull(builder.apiCachingBehavior, "apiCachingBehavior is required");
            this.apiId = java.util.Objects.requireNonNull(builder.apiId, "apiId is required");
            this.ttl = java.util.Objects.requireNonNull(builder.ttl, "ttl is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
            this.healthMetricsConfig = builder.healthMetricsConfig;
            this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        }

        @Override
        public final java.lang.String getApiCachingBehavior() {
            return this.apiCachingBehavior;
        }

        @Override
        public final java.lang.String getApiId() {
            return this.apiId;
        }

        @Override
        public final java.lang.Number getTtl() {
            return this.ttl;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getAtRestEncryptionEnabled() {
            return this.atRestEncryptionEnabled;
        }

        @Override
        public final java.lang.String getHealthMetricsConfig() {
            return this.healthMetricsConfig;
        }

        @Override
        public final java.lang.Object getTransitEncryptionEnabled() {
            return this.transitEncryptionEnabled;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiCachingBehavior", om.valueToTree(this.getApiCachingBehavior()));
            data.set("apiId", om.valueToTree(this.getApiId()));
            data.set("ttl", om.valueToTree(this.getTtl()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getAtRestEncryptionEnabled() != null) {
                data.set("atRestEncryptionEnabled", om.valueToTree(this.getAtRestEncryptionEnabled()));
            }
            if (this.getHealthMetricsConfig() != null) {
                data.set("healthMetricsConfig", om.valueToTree(this.getHealthMetricsConfig()));
            }
            if (this.getTransitEncryptionEnabled() != null) {
                data.set("transitEncryptionEnabled", om.valueToTree(this.getTransitEncryptionEnabled()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnApiCacheProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApiCacheProps.Jsii$Proxy that = (CfnApiCacheProps.Jsii$Proxy) o;

            if (!apiCachingBehavior.equals(that.apiCachingBehavior)) return false;
            if (!apiId.equals(that.apiId)) return false;
            if (!ttl.equals(that.ttl)) return false;
            if (!type.equals(that.type)) return false;
            if (this.atRestEncryptionEnabled != null ? !this.atRestEncryptionEnabled.equals(that.atRestEncryptionEnabled) : that.atRestEncryptionEnabled != null) return false;
            if (this.healthMetricsConfig != null ? !this.healthMetricsConfig.equals(that.healthMetricsConfig) : that.healthMetricsConfig != null) return false;
            return this.transitEncryptionEnabled != null ? this.transitEncryptionEnabled.equals(that.transitEncryptionEnabled) : that.transitEncryptionEnabled == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiCachingBehavior.hashCode();
            result = 31 * result + (this.apiId.hashCode());
            result = 31 * result + (this.ttl.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.atRestEncryptionEnabled != null ? this.atRestEncryptionEnabled.hashCode() : 0);
            result = 31 * result + (this.healthMetricsConfig != null ? this.healthMetricsConfig.hashCode() : 0);
            result = 31 * result + (this.transitEncryptionEnabled != null ? this.transitEncryptionEnabled.hashCode() : 0);
            return result;
        }
    }
}
