package software.amazon.awscdk.services.appsync;

/**
 * The <code>AWS::AppSync::DataSource</code> resource creates data sources for resolvers in AWS AppSync to connect to, such as Amazon DynamoDB , AWS Lambda , and Amazon OpenSearch Service .
 * <p>
 * Resolvers use these data sources to fetch data when clients make GraphQL calls.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnDataSource cfnDataSource = CfnDataSource.Builder.create(this, "MyCfnDataSource")
 *         .apiId("apiId")
 *         .name("name")
 *         .type("type")
 *         // the properties below are optional
 *         .description("description")
 *         .dynamoDbConfig(DynamoDBConfigProperty.builder()
 *                 .awsRegion("awsRegion")
 *                 .tableName("tableName")
 *                 // the properties below are optional
 *                 .deltaSyncConfig(DeltaSyncConfigProperty.builder()
 *                         .baseTableTtl("baseTableTtl")
 *                         .deltaSyncTableName("deltaSyncTableName")
 *                         .deltaSyncTableTtl("deltaSyncTableTtl")
 *                         .build())
 *                 .useCallerCredentials(false)
 *                 .versioned(false)
 *                 .build())
 *         .elasticsearchConfig(ElasticsearchConfigProperty.builder()
 *                 .awsRegion("awsRegion")
 *                 .endpoint("endpoint")
 *                 .build())
 *         .eventBridgeConfig(EventBridgeConfigProperty.builder()
 *                 .eventBusArn("eventBusArn")
 *                 .build())
 *         .httpConfig(HttpConfigProperty.builder()
 *                 .endpoint("endpoint")
 *                 // the properties below are optional
 *                 .authorizationConfig(AuthorizationConfigProperty.builder()
 *                         .authorizationType("authorizationType")
 *                         // the properties below are optional
 *                         .awsIamConfig(AwsIamConfigProperty.builder()
 *                                 .signingRegion("signingRegion")
 *                                 .signingServiceName("signingServiceName")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .lambdaConfig(LambdaConfigProperty.builder()
 *                 .lambdaFunctionArn("lambdaFunctionArn")
 *                 .build())
 *         .metricsConfig("metricsConfig")
 *         .openSearchServiceConfig(OpenSearchServiceConfigProperty.builder()
 *                 .awsRegion("awsRegion")
 *                 .endpoint("endpoint")
 *                 .build())
 *         .relationalDatabaseConfig(RelationalDatabaseConfigProperty.builder()
 *                 .relationalDatabaseSourceType("relationalDatabaseSourceType")
 *                 // the properties below are optional
 *                 .rdsHttpEndpointConfig(RdsHttpEndpointConfigProperty.builder()
 *                         .awsRegion("awsRegion")
 *                         .awsSecretStoreArn("awsSecretStoreArn")
 *                         .dbClusterIdentifier("dbClusterIdentifier")
 *                         // the properties below are optional
 *                         .databaseName("databaseName")
 *                         .schema("schema")
 *                         .build())
 *                 .build())
 *         .serviceRoleArn("serviceRoleArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:58.452Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnDataSource")
public class CfnDataSource extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.appsync.IDataSourceRef {

    protected CfnDataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appsync.CfnDataSource.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.CfnDataSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the API key, such as <code>arn:aws:appsync:us-east-1:123456789012:apis/graphqlapiid/datasources/datasourcename</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDataSourceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDataSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Friendly name for you to identify your AWS AppSync data source after creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a DataSource resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.DataSourceReference getDataSourceRef() {
        return software.amazon.jsii.Kernel.get(this, "dataSourceRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.DataSourceReference.class));
    }

    /**
     * Unique AWS AppSync GraphQL API identifier where this data source will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiId() {
        return software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Unique AWS AppSync GraphQL API identifier where this data source will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "apiId", java.util.Objects.requireNonNull(value, "apiId is required"));
    }

    /**
     * Friendly name for you to identify your AppSync data source after creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Friendly name for you to identify your AppSync data source after creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The type of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * The description of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * AWS Region and TableName for an Amazon DynamoDB table in your account.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.DynamoDBConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbConfig() {
        return software.amazon.jsii.Kernel.get(this, "dynamoDbConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * AWS Region and TableName for an Amazon DynamoDB table in your account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDynamoDbConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dynamoDbConfig", value);
    }

    /**
     * AWS Region and TableName for an Amazon DynamoDB table in your account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDynamoDbConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnDataSource.DynamoDBConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "dynamoDbConfig", value);
    }

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.ElasticsearchConfigProperty}
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearchConfig() {
        return software.amazon.jsii.Kernel.get(this, "elasticsearchConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setElasticsearchConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "elasticsearchConfig", value);
    }

    /**
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setElasticsearchConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnDataSource.ElasticsearchConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "elasticsearchConfig", value);
    }

    /**
     * An EventBridge configuration that contains a valid ARN of an event bus.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.EventBridgeConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEventBridgeConfig() {
        return software.amazon.jsii.Kernel.get(this, "eventBridgeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An EventBridge configuration that contains a valid ARN of an event bus.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventBridgeConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "eventBridgeConfig", value);
    }

    /**
     * An EventBridge configuration that contains a valid ARN of an event bus.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventBridgeConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnDataSource.EventBridgeConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "eventBridgeConfig", value);
    }

    /**
     * Endpoints for an HTTP data source.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.HttpConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHttpConfig() {
        return software.amazon.jsii.Kernel.get(this, "httpConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Endpoints for an HTTP data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHttpConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "httpConfig", value);
    }

    /**
     * Endpoints for an HTTP data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHttpConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnDataSource.HttpConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "httpConfig", value);
    }

    /**
     * An ARN of a Lambda function in valid ARN format.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.LambdaConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLambdaConfig() {
        return software.amazon.jsii.Kernel.get(this, "lambdaConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An ARN of a Lambda function in valid ARN format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLambdaConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lambdaConfig", value);
    }

    /**
     * An ARN of a Lambda function in valid ARN format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLambdaConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnDataSource.LambdaConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "lambdaConfig", value);
    }

    /**
     * Enables or disables enhanced data source metrics for specified data sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMetricsConfig() {
        return software.amazon.jsii.Kernel.get(this, "metricsConfig", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Enables or disables enhanced data source metrics for specified data sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricsConfig(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "metricsConfig", value);
    }

    /**
     * AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.OpenSearchServiceConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOpenSearchServiceConfig() {
        return software.amazon.jsii.Kernel.get(this, "openSearchServiceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenSearchServiceConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "openSearchServiceConfig", value);
    }

    /**
     * AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenSearchServiceConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnDataSource.OpenSearchServiceConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "openSearchServiceConfig", value);
    }

    /**
     * Relational Database configuration of the relational database data source.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.RelationalDatabaseConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRelationalDatabaseConfig() {
        return software.amazon.jsii.Kernel.get(this, "relationalDatabaseConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Relational Database configuration of the relational database data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRelationalDatabaseConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "relationalDatabaseConfig", value);
    }

    /**
     * Relational Database configuration of the relational database data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRelationalDatabaseConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnDataSource.RelationalDatabaseConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "relationalDatabaseConfig", value);
    }

    /**
     * The AWS Identity and Access Management service role ARN for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServiceRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "serviceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS Identity and Access Management service role ARN for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceRoleArn", value);
    }
    /**
     * The <code>AuthorizationConfig</code> property type specifies the authorization type and configuration for an AWS AppSync http data source.
     * <p>
     * <code>AuthorizationConfig</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-httpconfig.html">AWS AppSync DataSource HttpConfig</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * AuthorizationConfigProperty authorizationConfigProperty = AuthorizationConfigProperty.builder()
     *         .authorizationType("authorizationType")
     *         // the properties below are optional
     *         .awsIamConfig(AwsIamConfigProperty.builder()
     *                 .signingRegion("signingRegion")
     *                 .signingServiceName("signingServiceName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-authorizationconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-authorizationconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnDataSource.AuthorizationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthorizationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthorizationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authorization type that the HTTP endpoint requires.
         * <p>
         * <ul>
         * <li><em>AWS_IAM</em> : The authorization type is Signature Version 4 (SigV4).</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-authorizationconfig.html#cfn-appsync-datasource-authorizationconfig-authorizationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-authorizationconfig.html#cfn-appsync-datasource-authorizationconfig-authorizationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthorizationType();

        /**
         * The AWS Identity and Access Management settings.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.AwsIamConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-authorizationconfig.html#cfn-appsync-datasource-authorizationconfig-awsiamconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-authorizationconfig.html#cfn-appsync-datasource-authorizationconfig-awsiamconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsIamConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthorizationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthorizationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthorizationConfigProperty> {
            java.lang.String authorizationType;
            java.lang.Object awsIamConfig;

            /**
             * Sets the value of {@link AuthorizationConfigProperty#getAuthorizationType}
             * @param authorizationType The authorization type that the HTTP endpoint requires. This parameter is required.
             *                          <ul>
             *                          <li><em>AWS_IAM</em> : The authorization type is Signature Version 4 (SigV4).</li>
             *                          </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationType(java.lang.String authorizationType) {
                this.authorizationType = authorizationType;
                return this;
            }

            /**
             * Sets the value of {@link AuthorizationConfigProperty#getAwsIamConfig}
             * @param awsIamConfig The AWS Identity and Access Management settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsIamConfig(software.amazon.awscdk.IResolvable awsIamConfig) {
                this.awsIamConfig = awsIamConfig;
                return this;
            }

            /**
             * Sets the value of {@link AuthorizationConfigProperty#getAwsIamConfig}
             * @param awsIamConfig The AWS Identity and Access Management settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsIamConfig(software.amazon.awscdk.services.appsync.CfnDataSource.AwsIamConfigProperty awsIamConfig) {
                this.awsIamConfig = awsIamConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthorizationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthorizationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthorizationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthorizationConfigProperty {
            private final java.lang.String authorizationType;
            private final java.lang.Object awsIamConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizationType = software.amazon.jsii.Kernel.get(this, "authorizationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsIamConfig = software.amazon.jsii.Kernel.get(this, "awsIamConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizationType = java.util.Objects.requireNonNull(builder.authorizationType, "authorizationType is required");
                this.awsIamConfig = builder.awsIamConfig;
            }

            @Override
            public final java.lang.String getAuthorizationType() {
                return this.authorizationType;
            }

            @Override
            public final java.lang.Object getAwsIamConfig() {
                return this.awsIamConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authorizationType", om.valueToTree(this.getAuthorizationType()));
                if (this.getAwsIamConfig() != null) {
                    data.set("awsIamConfig", om.valueToTree(this.getAwsIamConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnDataSource.AuthorizationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthorizationConfigProperty.Jsii$Proxy that = (AuthorizationConfigProperty.Jsii$Proxy) o;

                if (!authorizationType.equals(that.authorizationType)) return false;
                return this.awsIamConfig != null ? this.awsIamConfig.equals(that.awsIamConfig) : that.awsIamConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authorizationType.hashCode();
                result = 31 * result + (this.awsIamConfig != null ? this.awsIamConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use the <code>AwsIamConfig</code> property type to specify <code>AwsIamConfig</code> for a AWS AppSync authorizaton.
     * <p>
     * <code>AwsIamConfig</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-httpconfig-authorizationconfig.html">AWS AppSync DataSource AuthorizationConfig</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * AwsIamConfigProperty awsIamConfigProperty = AwsIamConfigProperty.builder()
     *         .signingRegion("signingRegion")
     *         .signingServiceName("signingServiceName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-awsiamconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-awsiamconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnDataSource.AwsIamConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AwsIamConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AwsIamConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The signing Region for AWS Identity and Access Management authorization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-awsiamconfig.html#cfn-appsync-datasource-awsiamconfig-signingregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-awsiamconfig.html#cfn-appsync-datasource-awsiamconfig-signingregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSigningRegion() {
            return null;
        }

        /**
         * The signing service name for AWS Identity and Access Management authorization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-awsiamconfig.html#cfn-appsync-datasource-awsiamconfig-signingservicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-awsiamconfig.html#cfn-appsync-datasource-awsiamconfig-signingservicename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSigningServiceName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AwsIamConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AwsIamConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AwsIamConfigProperty> {
            java.lang.String signingRegion;
            java.lang.String signingServiceName;

            /**
             * Sets the value of {@link AwsIamConfigProperty#getSigningRegion}
             * @param signingRegion The signing Region for AWS Identity and Access Management authorization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder signingRegion(java.lang.String signingRegion) {
                this.signingRegion = signingRegion;
                return this;
            }

            /**
             * Sets the value of {@link AwsIamConfigProperty#getSigningServiceName}
             * @param signingServiceName The signing service name for AWS Identity and Access Management authorization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder signingServiceName(java.lang.String signingServiceName) {
                this.signingServiceName = signingServiceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AwsIamConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AwsIamConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AwsIamConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsIamConfigProperty {
            private final java.lang.String signingRegion;
            private final java.lang.String signingServiceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.signingRegion = software.amazon.jsii.Kernel.get(this, "signingRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.signingServiceName = software.amazon.jsii.Kernel.get(this, "signingServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.signingRegion = builder.signingRegion;
                this.signingServiceName = builder.signingServiceName;
            }

            @Override
            public final java.lang.String getSigningRegion() {
                return this.signingRegion;
            }

            @Override
            public final java.lang.String getSigningServiceName() {
                return this.signingServiceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSigningRegion() != null) {
                    data.set("signingRegion", om.valueToTree(this.getSigningRegion()));
                }
                if (this.getSigningServiceName() != null) {
                    data.set("signingServiceName", om.valueToTree(this.getSigningServiceName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnDataSource.AwsIamConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AwsIamConfigProperty.Jsii$Proxy that = (AwsIamConfigProperty.Jsii$Proxy) o;

                if (this.signingRegion != null ? !this.signingRegion.equals(that.signingRegion) : that.signingRegion != null) return false;
                return this.signingServiceName != null ? this.signingServiceName.equals(that.signingServiceName) : that.signingServiceName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.signingRegion != null ? this.signingRegion.hashCode() : 0;
                result = 31 * result + (this.signingServiceName != null ? this.signingServiceName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a Delta Sync configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * DeltaSyncConfigProperty deltaSyncConfigProperty = DeltaSyncConfigProperty.builder()
     *         .baseTableTtl("baseTableTtl")
     *         .deltaSyncTableName("deltaSyncTableName")
     *         .deltaSyncTableTtl("deltaSyncTableTtl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-deltasyncconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-deltasyncconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnDataSource.DeltaSyncConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DeltaSyncConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeltaSyncConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of minutes that an Item is stored in the data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-deltasyncconfig.html#cfn-appsync-datasource-deltasyncconfig-basetablettl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-deltasyncconfig.html#cfn-appsync-datasource-deltasyncconfig-basetablettl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBaseTableTtl();

        /**
         * The Delta Sync table name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-deltasyncconfig.html#cfn-appsync-datasource-deltasyncconfig-deltasynctablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-deltasyncconfig.html#cfn-appsync-datasource-deltasyncconfig-deltasynctablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeltaSyncTableName();

        /**
         * The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-deltasyncconfig.html#cfn-appsync-datasource-deltasyncconfig-deltasynctablettl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-deltasyncconfig.html#cfn-appsync-datasource-deltasyncconfig-deltasynctablettl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeltaSyncTableTtl();

        /**
         * @return a {@link Builder} of {@link DeltaSyncConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeltaSyncConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeltaSyncConfigProperty> {
            java.lang.String baseTableTtl;
            java.lang.String deltaSyncTableName;
            java.lang.String deltaSyncTableTtl;

            /**
             * Sets the value of {@link DeltaSyncConfigProperty#getBaseTableTtl}
             * @param baseTableTtl The number of minutes that an Item is stored in the data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseTableTtl(java.lang.String baseTableTtl) {
                this.baseTableTtl = baseTableTtl;
                return this;
            }

            /**
             * Sets the value of {@link DeltaSyncConfigProperty#getDeltaSyncTableName}
             * @param deltaSyncTableName The Delta Sync table name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deltaSyncTableName(java.lang.String deltaSyncTableName) {
                this.deltaSyncTableName = deltaSyncTableName;
                return this;
            }

            /**
             * Sets the value of {@link DeltaSyncConfigProperty#getDeltaSyncTableTtl}
             * @param deltaSyncTableTtl The number of minutes that a Delta Sync log entry is stored in the Delta Sync table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deltaSyncTableTtl(java.lang.String deltaSyncTableTtl) {
                this.deltaSyncTableTtl = deltaSyncTableTtl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeltaSyncConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeltaSyncConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeltaSyncConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeltaSyncConfigProperty {
            private final java.lang.String baseTableTtl;
            private final java.lang.String deltaSyncTableName;
            private final java.lang.String deltaSyncTableTtl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.baseTableTtl = software.amazon.jsii.Kernel.get(this, "baseTableTtl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deltaSyncTableName = software.amazon.jsii.Kernel.get(this, "deltaSyncTableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deltaSyncTableTtl = software.amazon.jsii.Kernel.get(this, "deltaSyncTableTtl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.baseTableTtl = java.util.Objects.requireNonNull(builder.baseTableTtl, "baseTableTtl is required");
                this.deltaSyncTableName = java.util.Objects.requireNonNull(builder.deltaSyncTableName, "deltaSyncTableName is required");
                this.deltaSyncTableTtl = java.util.Objects.requireNonNull(builder.deltaSyncTableTtl, "deltaSyncTableTtl is required");
            }

            @Override
            public final java.lang.String getBaseTableTtl() {
                return this.baseTableTtl;
            }

            @Override
            public final java.lang.String getDeltaSyncTableName() {
                return this.deltaSyncTableName;
            }

            @Override
            public final java.lang.String getDeltaSyncTableTtl() {
                return this.deltaSyncTableTtl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("baseTableTtl", om.valueToTree(this.getBaseTableTtl()));
                data.set("deltaSyncTableName", om.valueToTree(this.getDeltaSyncTableName()));
                data.set("deltaSyncTableTtl", om.valueToTree(this.getDeltaSyncTableTtl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnDataSource.DeltaSyncConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeltaSyncConfigProperty.Jsii$Proxy that = (DeltaSyncConfigProperty.Jsii$Proxy) o;

                if (!baseTableTtl.equals(that.baseTableTtl)) return false;
                if (!deltaSyncTableName.equals(that.deltaSyncTableName)) return false;
                return this.deltaSyncTableTtl.equals(that.deltaSyncTableTtl);
            }

            @Override
            public final int hashCode() {
                int result = this.baseTableTtl.hashCode();
                result = 31 * result + (this.deltaSyncTableName.hashCode());
                result = 31 * result + (this.deltaSyncTableTtl.hashCode());
                return result;
            }
        }
    }
    /**
     * The <code>DynamoDBConfig</code> property type specifies the <code>AwsRegion</code> and <code>TableName</code> for an Amazon DynamoDB table in your account for an AWS AppSync data source.
     * <p>
     * <code>DynamoDBConfig</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html">AWS::AppSync::DataSource</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * DynamoDBConfigProperty dynamoDBConfigProperty = DynamoDBConfigProperty.builder()
     *         .awsRegion("awsRegion")
     *         .tableName("tableName")
     *         // the properties below are optional
     *         .deltaSyncConfig(DeltaSyncConfigProperty.builder()
     *                 .baseTableTtl("baseTableTtl")
     *                 .deltaSyncTableName("deltaSyncTableName")
     *                 .deltaSyncTableTtl("deltaSyncTableTtl")
     *                 .build())
     *         .useCallerCredentials(false)
     *         .versioned(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnDataSource.DynamoDBConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DynamoDBConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamoDBConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Region.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html#cfn-appsync-datasource-dynamodbconfig-awsregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html#cfn-appsync-datasource-dynamodbconfig-awsregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAwsRegion();

        /**
         * The table name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html#cfn-appsync-datasource-dynamodbconfig-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html#cfn-appsync-datasource-dynamodbconfig-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * The <code>DeltaSyncConfig</code> for a versioned datasource.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.DeltaSyncConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html#cfn-appsync-datasource-dynamodbconfig-deltasyncconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html#cfn-appsync-datasource-dynamodbconfig-deltasyncconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeltaSyncConfig() {
            return null;
        }

        /**
         * Set to <code>TRUE</code> to use AWS Identity and Access Management with this data source.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html#cfn-appsync-datasource-dynamodbconfig-usecallercredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html#cfn-appsync-datasource-dynamodbconfig-usecallercredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseCallerCredentials() {
            return null;
        }

        /**
         * Set to TRUE to use Conflict Detection and Resolution with this data source.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html#cfn-appsync-datasource-dynamodbconfig-versioned">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-dynamodbconfig.html#cfn-appsync-datasource-dynamodbconfig-versioned</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVersioned() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DynamoDBConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamoDBConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamoDBConfigProperty> {
            java.lang.String awsRegion;
            java.lang.String tableName;
            java.lang.Object deltaSyncConfig;
            java.lang.Object useCallerCredentials;
            java.lang.Object versioned;

            /**
             * Sets the value of {@link DynamoDBConfigProperty#getAwsRegion}
             * @param awsRegion The AWS Region. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsRegion(java.lang.String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBConfigProperty#getTableName}
             * @param tableName The table name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBConfigProperty#getDeltaSyncConfig}
             * @param deltaSyncConfig The <code>DeltaSyncConfig</code> for a versioned datasource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deltaSyncConfig(software.amazon.awscdk.IResolvable deltaSyncConfig) {
                this.deltaSyncConfig = deltaSyncConfig;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBConfigProperty#getDeltaSyncConfig}
             * @param deltaSyncConfig The <code>DeltaSyncConfig</code> for a versioned datasource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deltaSyncConfig(software.amazon.awscdk.services.appsync.CfnDataSource.DeltaSyncConfigProperty deltaSyncConfig) {
                this.deltaSyncConfig = deltaSyncConfig;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBConfigProperty#getUseCallerCredentials}
             * @param useCallerCredentials Set to <code>TRUE</code> to use AWS Identity and Access Management with this data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useCallerCredentials(java.lang.Boolean useCallerCredentials) {
                this.useCallerCredentials = useCallerCredentials;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBConfigProperty#getUseCallerCredentials}
             * @param useCallerCredentials Set to <code>TRUE</code> to use AWS Identity and Access Management with this data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useCallerCredentials(software.amazon.awscdk.IResolvable useCallerCredentials) {
                this.useCallerCredentials = useCallerCredentials;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBConfigProperty#getVersioned}
             * @param versioned Set to TRUE to use Conflict Detection and Resolution with this data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder versioned(java.lang.Boolean versioned) {
                this.versioned = versioned;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBConfigProperty#getVersioned}
             * @param versioned Set to TRUE to use Conflict Detection and Resolution with this data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder versioned(software.amazon.awscdk.IResolvable versioned) {
                this.versioned = versioned;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamoDBConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamoDBConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamoDBConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoDBConfigProperty {
            private final java.lang.String awsRegion;
            private final java.lang.String tableName;
            private final java.lang.Object deltaSyncConfig;
            private final java.lang.Object useCallerCredentials;
            private final java.lang.Object versioned;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsRegion = software.amazon.jsii.Kernel.get(this, "awsRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deltaSyncConfig = software.amazon.jsii.Kernel.get(this, "deltaSyncConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useCallerCredentials = software.amazon.jsii.Kernel.get(this, "useCallerCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.versioned = software.amazon.jsii.Kernel.get(this, "versioned", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsRegion = java.util.Objects.requireNonNull(builder.awsRegion, "awsRegion is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
                this.deltaSyncConfig = builder.deltaSyncConfig;
                this.useCallerCredentials = builder.useCallerCredentials;
                this.versioned = builder.versioned;
            }

            @Override
            public final java.lang.String getAwsRegion() {
                return this.awsRegion;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.Object getDeltaSyncConfig() {
                return this.deltaSyncConfig;
            }

            @Override
            public final java.lang.Object getUseCallerCredentials() {
                return this.useCallerCredentials;
            }

            @Override
            public final java.lang.Object getVersioned() {
                return this.versioned;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("awsRegion", om.valueToTree(this.getAwsRegion()));
                data.set("tableName", om.valueToTree(this.getTableName()));
                if (this.getDeltaSyncConfig() != null) {
                    data.set("deltaSyncConfig", om.valueToTree(this.getDeltaSyncConfig()));
                }
                if (this.getUseCallerCredentials() != null) {
                    data.set("useCallerCredentials", om.valueToTree(this.getUseCallerCredentials()));
                }
                if (this.getVersioned() != null) {
                    data.set("versioned", om.valueToTree(this.getVersioned()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnDataSource.DynamoDBConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamoDBConfigProperty.Jsii$Proxy that = (DynamoDBConfigProperty.Jsii$Proxy) o;

                if (!awsRegion.equals(that.awsRegion)) return false;
                if (!tableName.equals(that.tableName)) return false;
                if (this.deltaSyncConfig != null ? !this.deltaSyncConfig.equals(that.deltaSyncConfig) : that.deltaSyncConfig != null) return false;
                if (this.useCallerCredentials != null ? !this.useCallerCredentials.equals(that.useCallerCredentials) : that.useCallerCredentials != null) return false;
                return this.versioned != null ? this.versioned.equals(that.versioned) : that.versioned == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsRegion.hashCode();
                result = 31 * result + (this.tableName.hashCode());
                result = 31 * result + (this.deltaSyncConfig != null ? this.deltaSyncConfig.hashCode() : 0);
                result = 31 * result + (this.useCallerCredentials != null ? this.useCallerCredentials.hashCode() : 0);
                result = 31 * result + (this.versioned != null ? this.versioned.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * ElasticsearchConfigProperty elasticsearchConfigProperty = ElasticsearchConfigProperty.builder()
     *         .awsRegion("awsRegion")
     *         .endpoint("endpoint")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-elasticsearchconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-elasticsearchconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnDataSource.ElasticsearchConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticsearchConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticsearchConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Region.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-elasticsearchconfig.html#cfn-appsync-datasource-elasticsearchconfig-awsregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-elasticsearchconfig.html#cfn-appsync-datasource-elasticsearchconfig-awsregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAwsRegion();

        /**
         * The endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-elasticsearchconfig.html#cfn-appsync-datasource-elasticsearchconfig-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-elasticsearchconfig.html#cfn-appsync-datasource-elasticsearchconfig-endpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndpoint();

        /**
         * @return a {@link Builder} of {@link ElasticsearchConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticsearchConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticsearchConfigProperty> {
            java.lang.String awsRegion;
            java.lang.String endpoint;

            /**
             * Sets the value of {@link ElasticsearchConfigProperty#getAwsRegion}
             * @param awsRegion The AWS Region. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsRegion(java.lang.String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchConfigProperty#getEndpoint}
             * @param endpoint The endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpoint(java.lang.String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticsearchConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticsearchConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticsearchConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticsearchConfigProperty {
            private final java.lang.String awsRegion;
            private final java.lang.String endpoint;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsRegion = software.amazon.jsii.Kernel.get(this, "awsRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsRegion = java.util.Objects.requireNonNull(builder.awsRegion, "awsRegion is required");
                this.endpoint = java.util.Objects.requireNonNull(builder.endpoint, "endpoint is required");
            }

            @Override
            public final java.lang.String getAwsRegion() {
                return this.awsRegion;
            }

            @Override
            public final java.lang.String getEndpoint() {
                return this.endpoint;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("awsRegion", om.valueToTree(this.getAwsRegion()));
                data.set("endpoint", om.valueToTree(this.getEndpoint()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnDataSource.ElasticsearchConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticsearchConfigProperty.Jsii$Proxy that = (ElasticsearchConfigProperty.Jsii$Proxy) o;

                if (!awsRegion.equals(that.awsRegion)) return false;
                return this.endpoint.equals(that.endpoint);
            }

            @Override
            public final int hashCode() {
                int result = this.awsRegion.hashCode();
                result = 31 * result + (this.endpoint.hashCode());
                return result;
            }
        }
    }
    /**
     * The data source.
     * <p>
     * This can be an API destination, resource, or AWS service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * EventBridgeConfigProperty eventBridgeConfigProperty = EventBridgeConfigProperty.builder()
     *         .eventBusArn("eventBusArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-eventbridgeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-eventbridgeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnDataSource.EventBridgeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EventBridgeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventBridgeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The event bus pipeline's ARN.
         * <p>
         * For more information about event buses, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus.html">EventBridge event buses</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-eventbridgeconfig.html#cfn-appsync-datasource-eventbridgeconfig-eventbusarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-eventbridgeconfig.html#cfn-appsync-datasource-eventbridgeconfig-eventbusarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEventBusArn();

        /**
         * @return a {@link Builder} of {@link EventBridgeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventBridgeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventBridgeConfigProperty> {
            java.lang.String eventBusArn;

            /**
             * Sets the value of {@link EventBridgeConfigProperty#getEventBusArn}
             * @param eventBusArn The event bus pipeline's ARN. This parameter is required.
             *                    For more information about event buses, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus.html">EventBridge event buses</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBusArn(java.lang.String eventBusArn) {
                this.eventBusArn = eventBusArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventBridgeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventBridgeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventBridgeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventBridgeConfigProperty {
            private final java.lang.String eventBusArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventBusArn = software.amazon.jsii.Kernel.get(this, "eventBusArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventBusArn = java.util.Objects.requireNonNull(builder.eventBusArn, "eventBusArn is required");
            }

            @Override
            public final java.lang.String getEventBusArn() {
                return this.eventBusArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eventBusArn", om.valueToTree(this.getEventBusArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnDataSource.EventBridgeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventBridgeConfigProperty.Jsii$Proxy that = (EventBridgeConfigProperty.Jsii$Proxy) o;

                return this.eventBusArn.equals(that.eventBusArn);
            }

            @Override
            public final int hashCode() {
                int result = this.eventBusArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Use the <code>HttpConfig</code> property type to specify <code>HttpConfig</code> for an AWS AppSync data source.
     * <p>
     * <code>HttpConfig</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html">AWS::AppSync::DataSource</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * HttpConfigProperty httpConfigProperty = HttpConfigProperty.builder()
     *         .endpoint("endpoint")
     *         // the properties below are optional
     *         .authorizationConfig(AuthorizationConfigProperty.builder()
     *                 .authorizationType("authorizationType")
     *                 // the properties below are optional
     *                 .awsIamConfig(AwsIamConfigProperty.builder()
     *                         .signingRegion("signingRegion")
     *                         .signingServiceName("signingServiceName")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-httpconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-httpconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnDataSource.HttpConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-httpconfig.html#cfn-appsync-datasource-httpconfig-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-httpconfig.html#cfn-appsync-datasource-httpconfig-endpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndpoint();

        /**
         * The authorization configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.AuthorizationConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-httpconfig.html#cfn-appsync-datasource-httpconfig-authorizationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-httpconfig.html#cfn-appsync-datasource-httpconfig-authorizationconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthorizationConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpConfigProperty> {
            java.lang.String endpoint;
            java.lang.Object authorizationConfig;

            /**
             * Sets the value of {@link HttpConfigProperty#getEndpoint}
             * @param endpoint The endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpoint(java.lang.String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            /**
             * Sets the value of {@link HttpConfigProperty#getAuthorizationConfig}
             * @param authorizationConfig The authorization configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationConfig(software.amazon.awscdk.IResolvable authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            /**
             * Sets the value of {@link HttpConfigProperty#getAuthorizationConfig}
             * @param authorizationConfig The authorization configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationConfig(software.amazon.awscdk.services.appsync.CfnDataSource.AuthorizationConfigProperty authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpConfigProperty {
            private final java.lang.String endpoint;
            private final java.lang.Object authorizationConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authorizationConfig = software.amazon.jsii.Kernel.get(this, "authorizationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpoint = java.util.Objects.requireNonNull(builder.endpoint, "endpoint is required");
                this.authorizationConfig = builder.authorizationConfig;
            }

            @Override
            public final java.lang.String getEndpoint() {
                return this.endpoint;
            }

            @Override
            public final java.lang.Object getAuthorizationConfig() {
                return this.authorizationConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endpoint", om.valueToTree(this.getEndpoint()));
                if (this.getAuthorizationConfig() != null) {
                    data.set("authorizationConfig", om.valueToTree(this.getAuthorizationConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnDataSource.HttpConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpConfigProperty.Jsii$Proxy that = (HttpConfigProperty.Jsii$Proxy) o;

                if (!endpoint.equals(that.endpoint)) return false;
                return this.authorizationConfig != null ? this.authorizationConfig.equals(that.authorizationConfig) : that.authorizationConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endpoint.hashCode();
                result = 31 * result + (this.authorizationConfig != null ? this.authorizationConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>LambdaConfig</code> property type specifies the Lambda function ARN for an AWS AppSync data source.
     * <p>
     * <code>LambdaConfig</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html">AWS::AppSync::DataSource</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * LambdaConfigProperty lambdaConfigProperty = LambdaConfigProperty.builder()
     *         .lambdaFunctionArn("lambdaFunctionArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-lambdaconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-lambdaconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnDataSource.LambdaConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN for the Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-lambdaconfig.html#cfn-appsync-datasource-lambdaconfig-lambdafunctionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-lambdaconfig.html#cfn-appsync-datasource-lambdaconfig-lambdafunctionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLambdaFunctionArn();

        /**
         * @return a {@link Builder} of {@link LambdaConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaConfigProperty> {
            java.lang.String lambdaFunctionArn;

            /**
             * Sets the value of {@link LambdaConfigProperty#getLambdaFunctionArn}
             * @param lambdaFunctionArn The ARN for the Lambda function. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionArn(java.lang.String lambdaFunctionArn) {
                this.lambdaFunctionArn = lambdaFunctionArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaConfigProperty {
            private final java.lang.String lambdaFunctionArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaFunctionArn = software.amazon.jsii.Kernel.get(this, "lambdaFunctionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaFunctionArn = java.util.Objects.requireNonNull(builder.lambdaFunctionArn, "lambdaFunctionArn is required");
            }

            @Override
            public final java.lang.String getLambdaFunctionArn() {
                return this.lambdaFunctionArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("lambdaFunctionArn", om.valueToTree(this.getLambdaFunctionArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnDataSource.LambdaConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaConfigProperty.Jsii$Proxy that = (LambdaConfigProperty.Jsii$Proxy) o;

                return this.lambdaFunctionArn.equals(that.lambdaFunctionArn);
            }

            @Override
            public final int hashCode() {
                int result = this.lambdaFunctionArn.hashCode();
                return result;
            }
        }
    }
    /**
     * The <code>OpenSearchServiceConfig</code> property type specifies the <code>AwsRegion</code> and <code>Endpoints</code> for an Amazon OpenSearch Service domain in your account for an AWS AppSync data source.
     * <p>
     * <code>OpenSearchServiceConfig</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html">AWS::AppSync::DataSource</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * OpenSearchServiceConfigProperty openSearchServiceConfigProperty = OpenSearchServiceConfigProperty.builder()
     *         .awsRegion("awsRegion")
     *         .endpoint("endpoint")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-opensearchserviceconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-opensearchserviceconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnDataSource.OpenSearchServiceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenSearchServiceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenSearchServiceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Region.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-opensearchserviceconfig.html#cfn-appsync-datasource-opensearchserviceconfig-awsregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-opensearchserviceconfig.html#cfn-appsync-datasource-opensearchserviceconfig-awsregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAwsRegion();

        /**
         * The endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-opensearchserviceconfig.html#cfn-appsync-datasource-opensearchserviceconfig-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-opensearchserviceconfig.html#cfn-appsync-datasource-opensearchserviceconfig-endpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndpoint();

        /**
         * @return a {@link Builder} of {@link OpenSearchServiceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenSearchServiceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenSearchServiceConfigProperty> {
            java.lang.String awsRegion;
            java.lang.String endpoint;

            /**
             * Sets the value of {@link OpenSearchServiceConfigProperty#getAwsRegion}
             * @param awsRegion The AWS Region. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsRegion(java.lang.String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchServiceConfigProperty#getEndpoint}
             * @param endpoint The endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpoint(java.lang.String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenSearchServiceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenSearchServiceConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenSearchServiceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenSearchServiceConfigProperty {
            private final java.lang.String awsRegion;
            private final java.lang.String endpoint;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsRegion = software.amazon.jsii.Kernel.get(this, "awsRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsRegion = java.util.Objects.requireNonNull(builder.awsRegion, "awsRegion is required");
                this.endpoint = java.util.Objects.requireNonNull(builder.endpoint, "endpoint is required");
            }

            @Override
            public final java.lang.String getAwsRegion() {
                return this.awsRegion;
            }

            @Override
            public final java.lang.String getEndpoint() {
                return this.endpoint;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("awsRegion", om.valueToTree(this.getAwsRegion()));
                data.set("endpoint", om.valueToTree(this.getEndpoint()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnDataSource.OpenSearchServiceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenSearchServiceConfigProperty.Jsii$Proxy that = (OpenSearchServiceConfigProperty.Jsii$Proxy) o;

                if (!awsRegion.equals(that.awsRegion)) return false;
                return this.endpoint.equals(that.endpoint);
            }

            @Override
            public final int hashCode() {
                int result = this.awsRegion.hashCode();
                result = 31 * result + (this.endpoint.hashCode());
                return result;
            }
        }
    }
    /**
     * Use the <code>RdsHttpEndpointConfig</code> property type to specify the <code>RdsHttpEndpoint</code> for an AWS AppSync relational database.
     * <p>
     * <code>RdsHttpEndpointConfig</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-relationaldatabaseconfig.html">AWS AppSync DataSource RelationalDatabaseConfig</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * RdsHttpEndpointConfigProperty rdsHttpEndpointConfigProperty = RdsHttpEndpointConfigProperty.builder()
     *         .awsRegion("awsRegion")
     *         .awsSecretStoreArn("awsSecretStoreArn")
     *         .dbClusterIdentifier("dbClusterIdentifier")
     *         // the properties below are optional
     *         .databaseName("databaseName")
     *         .schema("schema")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnDataSource.RdsHttpEndpointConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RdsHttpEndpointConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RdsHttpEndpointConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * AWS Region for RDS HTTP endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html#cfn-appsync-datasource-rdshttpendpointconfig-awsregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html#cfn-appsync-datasource-rdshttpendpointconfig-awsregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAwsRegion();

        /**
         * The ARN for database credentials stored in AWS Secrets Manager .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html#cfn-appsync-datasource-rdshttpendpointconfig-awssecretstorearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html#cfn-appsync-datasource-rdshttpendpointconfig-awssecretstorearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAwsSecretStoreArn();

        /**
         * Amazon RDS cluster Amazon Resource Name (ARN).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html#cfn-appsync-datasource-rdshttpendpointconfig-dbclusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html#cfn-appsync-datasource-rdshttpendpointconfig-dbclusteridentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDbClusterIdentifier();

        /**
         * Logical database name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html#cfn-appsync-datasource-rdshttpendpointconfig-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html#cfn-appsync-datasource-rdshttpendpointconfig-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * Logical schema name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html#cfn-appsync-datasource-rdshttpendpointconfig-schema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-rdshttpendpointconfig.html#cfn-appsync-datasource-rdshttpendpointconfig-schema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSchema() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RdsHttpEndpointConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RdsHttpEndpointConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RdsHttpEndpointConfigProperty> {
            java.lang.String awsRegion;
            java.lang.String awsSecretStoreArn;
            java.lang.String dbClusterIdentifier;
            java.lang.String databaseName;
            java.lang.String schema;

            /**
             * Sets the value of {@link RdsHttpEndpointConfigProperty#getAwsRegion}
             * @param awsRegion AWS Region for RDS HTTP endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsRegion(java.lang.String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            /**
             * Sets the value of {@link RdsHttpEndpointConfigProperty#getAwsSecretStoreArn}
             * @param awsSecretStoreArn The ARN for database credentials stored in AWS Secrets Manager . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsSecretStoreArn(java.lang.String awsSecretStoreArn) {
                this.awsSecretStoreArn = awsSecretStoreArn;
                return this;
            }

            /**
             * Sets the value of {@link RdsHttpEndpointConfigProperty#getDbClusterIdentifier}
             * @param dbClusterIdentifier Amazon RDS cluster Amazon Resource Name (ARN). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dbClusterIdentifier(java.lang.String dbClusterIdentifier) {
                this.dbClusterIdentifier = dbClusterIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link RdsHttpEndpointConfigProperty#getDatabaseName}
             * @param databaseName Logical database name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link RdsHttpEndpointConfigProperty#getSchema}
             * @param schema Logical schema name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schema(java.lang.String schema) {
                this.schema = schema;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RdsHttpEndpointConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RdsHttpEndpointConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RdsHttpEndpointConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RdsHttpEndpointConfigProperty {
            private final java.lang.String awsRegion;
            private final java.lang.String awsSecretStoreArn;
            private final java.lang.String dbClusterIdentifier;
            private final java.lang.String databaseName;
            private final java.lang.String schema;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsRegion = software.amazon.jsii.Kernel.get(this, "awsRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsSecretStoreArn = software.amazon.jsii.Kernel.get(this, "awsSecretStoreArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dbClusterIdentifier = software.amazon.jsii.Kernel.get(this, "dbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.schema = software.amazon.jsii.Kernel.get(this, "schema", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsRegion = java.util.Objects.requireNonNull(builder.awsRegion, "awsRegion is required");
                this.awsSecretStoreArn = java.util.Objects.requireNonNull(builder.awsSecretStoreArn, "awsSecretStoreArn is required");
                this.dbClusterIdentifier = java.util.Objects.requireNonNull(builder.dbClusterIdentifier, "dbClusterIdentifier is required");
                this.databaseName = builder.databaseName;
                this.schema = builder.schema;
            }

            @Override
            public final java.lang.String getAwsRegion() {
                return this.awsRegion;
            }

            @Override
            public final java.lang.String getAwsSecretStoreArn() {
                return this.awsSecretStoreArn;
            }

            @Override
            public final java.lang.String getDbClusterIdentifier() {
                return this.dbClusterIdentifier;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getSchema() {
                return this.schema;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("awsRegion", om.valueToTree(this.getAwsRegion()));
                data.set("awsSecretStoreArn", om.valueToTree(this.getAwsSecretStoreArn()));
                data.set("dbClusterIdentifier", om.valueToTree(this.getDbClusterIdentifier()));
                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getSchema() != null) {
                    data.set("schema", om.valueToTree(this.getSchema()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnDataSource.RdsHttpEndpointConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RdsHttpEndpointConfigProperty.Jsii$Proxy that = (RdsHttpEndpointConfigProperty.Jsii$Proxy) o;

                if (!awsRegion.equals(that.awsRegion)) return false;
                if (!awsSecretStoreArn.equals(that.awsSecretStoreArn)) return false;
                if (!dbClusterIdentifier.equals(that.dbClusterIdentifier)) return false;
                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                return this.schema != null ? this.schema.equals(that.schema) : that.schema == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsRegion.hashCode();
                result = 31 * result + (this.awsSecretStoreArn.hashCode());
                result = 31 * result + (this.dbClusterIdentifier.hashCode());
                result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
                result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use the <code>RelationalDatabaseConfig</code> property type to specify <code>RelationalDatabaseConfig</code> for an AWS AppSync data source.
     * <p>
     * <code>RelationalDatabaseConfig</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html">AWS::AppSync::DataSource</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * RelationalDatabaseConfigProperty relationalDatabaseConfigProperty = RelationalDatabaseConfigProperty.builder()
     *         .relationalDatabaseSourceType("relationalDatabaseSourceType")
     *         // the properties below are optional
     *         .rdsHttpEndpointConfig(RdsHttpEndpointConfigProperty.builder()
     *                 .awsRegion("awsRegion")
     *                 .awsSecretStoreArn("awsSecretStoreArn")
     *                 .dbClusterIdentifier("dbClusterIdentifier")
     *                 // the properties below are optional
     *                 .databaseName("databaseName")
     *                 .schema("schema")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-relationaldatabaseconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-relationaldatabaseconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnDataSource.RelationalDatabaseConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RelationalDatabaseConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RelationalDatabaseConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of relational data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-relationaldatabaseconfig.html#cfn-appsync-datasource-relationaldatabaseconfig-relationaldatabasesourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-relationaldatabaseconfig.html#cfn-appsync-datasource-relationaldatabaseconfig-relationaldatabasesourcetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRelationalDatabaseSourceType();

        /**
         * Information about the Amazon RDS resource.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.RdsHttpEndpointConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-relationaldatabaseconfig.html#cfn-appsync-datasource-relationaldatabaseconfig-rdshttpendpointconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-datasource-relationaldatabaseconfig.html#cfn-appsync-datasource-relationaldatabaseconfig-rdshttpendpointconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRdsHttpEndpointConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RelationalDatabaseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RelationalDatabaseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RelationalDatabaseConfigProperty> {
            java.lang.String relationalDatabaseSourceType;
            java.lang.Object rdsHttpEndpointConfig;

            /**
             * Sets the value of {@link RelationalDatabaseConfigProperty#getRelationalDatabaseSourceType}
             * @param relationalDatabaseSourceType The type of relational data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationalDatabaseSourceType(java.lang.String relationalDatabaseSourceType) {
                this.relationalDatabaseSourceType = relationalDatabaseSourceType;
                return this;
            }

            /**
             * Sets the value of {@link RelationalDatabaseConfigProperty#getRdsHttpEndpointConfig}
             * @param rdsHttpEndpointConfig Information about the Amazon RDS resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rdsHttpEndpointConfig(software.amazon.awscdk.IResolvable rdsHttpEndpointConfig) {
                this.rdsHttpEndpointConfig = rdsHttpEndpointConfig;
                return this;
            }

            /**
             * Sets the value of {@link RelationalDatabaseConfigProperty#getRdsHttpEndpointConfig}
             * @param rdsHttpEndpointConfig Information about the Amazon RDS resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rdsHttpEndpointConfig(software.amazon.awscdk.services.appsync.CfnDataSource.RdsHttpEndpointConfigProperty rdsHttpEndpointConfig) {
                this.rdsHttpEndpointConfig = rdsHttpEndpointConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RelationalDatabaseConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RelationalDatabaseConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RelationalDatabaseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RelationalDatabaseConfigProperty {
            private final java.lang.String relationalDatabaseSourceType;
            private final java.lang.Object rdsHttpEndpointConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.relationalDatabaseSourceType = software.amazon.jsii.Kernel.get(this, "relationalDatabaseSourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rdsHttpEndpointConfig = software.amazon.jsii.Kernel.get(this, "rdsHttpEndpointConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.relationalDatabaseSourceType = java.util.Objects.requireNonNull(builder.relationalDatabaseSourceType, "relationalDatabaseSourceType is required");
                this.rdsHttpEndpointConfig = builder.rdsHttpEndpointConfig;
            }

            @Override
            public final java.lang.String getRelationalDatabaseSourceType() {
                return this.relationalDatabaseSourceType;
            }

            @Override
            public final java.lang.Object getRdsHttpEndpointConfig() {
                return this.rdsHttpEndpointConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("relationalDatabaseSourceType", om.valueToTree(this.getRelationalDatabaseSourceType()));
                if (this.getRdsHttpEndpointConfig() != null) {
                    data.set("rdsHttpEndpointConfig", om.valueToTree(this.getRdsHttpEndpointConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnDataSource.RelationalDatabaseConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RelationalDatabaseConfigProperty.Jsii$Proxy that = (RelationalDatabaseConfigProperty.Jsii$Proxy) o;

                if (!relationalDatabaseSourceType.equals(that.relationalDatabaseSourceType)) return false;
                return this.rdsHttpEndpointConfig != null ? this.rdsHttpEndpointConfig.equals(that.rdsHttpEndpointConfig) : that.rdsHttpEndpointConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.relationalDatabaseSourceType.hashCode();
                result = 31 * result + (this.rdsHttpEndpointConfig != null ? this.rdsHttpEndpointConfig.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.CfnDataSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.CfnDataSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.CfnDataSourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.CfnDataSourceProps.Builder();
        }

        /**
         * Unique AWS AppSync GraphQL API identifier where this data source will be created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-apiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-apiid</a>
         * @param apiId Unique AWS AppSync GraphQL API identifier where this data source will be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(final java.lang.String apiId) {
            this.props.apiId(apiId);
            return this;
        }

        /**
         * Friendly name for you to identify your AppSync data source after creation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-name</a>
         * @param name Friendly name for you to identify your AppSync data source after creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The type of the data source.
         * <p>
         * <ul>
         * <li><em>AWS_LAMBDA</em> : The data source is an AWS Lambda function.</li>
         * <li><em>AMAZON_DYNAMODB</em> : The data source is an Amazon DynamoDB table.</li>
         * <li><em>AMAZON_ELASTICSEARCH</em> : The data source is an Amazon OpenSearch Service domain.</li>
         * <li><em>AMAZON_EVENTBRIDGE</em> : The data source is an Amazon EventBridge event bus.</li>
         * <li><em>AMAZON_OPENSEARCH_SERVICE</em> : The data source is an Amazon OpenSearch Service domain.</li>
         * <li><em>AMAZON_BEDROCK_RUNTIME</em> : The data source is the Amazon Bedrock runtime.</li>
         * <li><em>NONE</em> : There is no data source. This type is used when you wish to invoke a GraphQL operation without connecting to a data source, such as performing data transformation with resolvers or triggering a subscription to be invoked from a mutation.</li>
         * <li><em>HTTP</em> : The data source is an HTTP endpoint.</li>
         * <li><em>RELATIONAL_DATABASE</em> : The data source is a relational database.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-type</a>
         * @param type The type of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * The description of the data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-description</a>
         * @param description The description of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * AWS Region and TableName for an Amazon DynamoDB table in your account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-dynamodbconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-dynamodbconfig</a>
         * @param dynamoDbConfig AWS Region and TableName for an Amazon DynamoDB table in your account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dynamoDbConfig(final software.amazon.awscdk.IResolvable dynamoDbConfig) {
            this.props.dynamoDbConfig(dynamoDbConfig);
            return this;
        }
        /**
         * AWS Region and TableName for an Amazon DynamoDB table in your account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-dynamodbconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-dynamodbconfig</a>
         * @param dynamoDbConfig AWS Region and TableName for an Amazon DynamoDB table in your account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dynamoDbConfig(final software.amazon.awscdk.services.appsync.CfnDataSource.DynamoDBConfigProperty dynamoDbConfig) {
            this.props.dynamoDbConfig(dynamoDbConfig);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-elasticsearchconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-elasticsearchconfig</a>
         * @deprecated this property has been deprecated
         * @param elasticsearchConfig This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder elasticsearchConfig(final software.amazon.awscdk.IResolvable elasticsearchConfig) {
            this.props.elasticsearchConfig(elasticsearchConfig);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-elasticsearchconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-elasticsearchconfig</a>
         * @deprecated this property has been deprecated
         * @param elasticsearchConfig This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder elasticsearchConfig(final software.amazon.awscdk.services.appsync.CfnDataSource.ElasticsearchConfigProperty elasticsearchConfig) {
            this.props.elasticsearchConfig(elasticsearchConfig);
            return this;
        }

        /**
         * An EventBridge configuration that contains a valid ARN of an event bus.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-eventbridgeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-eventbridgeconfig</a>
         * @param eventBridgeConfig An EventBridge configuration that contains a valid ARN of an event bus. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBridgeConfig(final software.amazon.awscdk.IResolvable eventBridgeConfig) {
            this.props.eventBridgeConfig(eventBridgeConfig);
            return this;
        }
        /**
         * An EventBridge configuration that contains a valid ARN of an event bus.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-eventbridgeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-eventbridgeconfig</a>
         * @param eventBridgeConfig An EventBridge configuration that contains a valid ARN of an event bus. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBridgeConfig(final software.amazon.awscdk.services.appsync.CfnDataSource.EventBridgeConfigProperty eventBridgeConfig) {
            this.props.eventBridgeConfig(eventBridgeConfig);
            return this;
        }

        /**
         * Endpoints for an HTTP data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-httpconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-httpconfig</a>
         * @param httpConfig Endpoints for an HTTP data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpConfig(final software.amazon.awscdk.IResolvable httpConfig) {
            this.props.httpConfig(httpConfig);
            return this;
        }
        /**
         * Endpoints for an HTTP data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-httpconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-httpconfig</a>
         * @param httpConfig Endpoints for an HTTP data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpConfig(final software.amazon.awscdk.services.appsync.CfnDataSource.HttpConfigProperty httpConfig) {
            this.props.httpConfig(httpConfig);
            return this;
        }

        /**
         * An ARN of a Lambda function in valid ARN format.
         * <p>
         * This can be the ARN of a Lambda function that exists in the current account or in another account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-lambdaconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-lambdaconfig</a>
         * @param lambdaConfig An ARN of a Lambda function in valid ARN format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaConfig(final software.amazon.awscdk.IResolvable lambdaConfig) {
            this.props.lambdaConfig(lambdaConfig);
            return this;
        }
        /**
         * An ARN of a Lambda function in valid ARN format.
         * <p>
         * This can be the ARN of a Lambda function that exists in the current account or in another account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-lambdaconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-lambdaconfig</a>
         * @param lambdaConfig An ARN of a Lambda function in valid ARN format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaConfig(final software.amazon.awscdk.services.appsync.CfnDataSource.LambdaConfigProperty lambdaConfig) {
            this.props.lambdaConfig(lambdaConfig);
            return this;
        }

        /**
         * Enables or disables enhanced data source metrics for specified data sources.
         * <p>
         * Note that <code>MetricsConfig</code> won't be used unless the <code>dataSourceLevelMetricsBehavior</code> value is set to <code>PER_DATA_SOURCE_METRICS</code> . If the <code>dataSourceLevelMetricsBehavior</code> is set to <code>FULL_REQUEST_DATA_SOURCE_METRICS</code> instead, <code>MetricsConfig</code> will be ignored. However, you can still set its value.
         * <p>
         * <code>MetricsConfig</code> can be <code>ENABLED</code> or <code>DISABLED</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-metricsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-metricsconfig</a>
         * @param metricsConfig Enables or disables enhanced data source metrics for specified data sources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsConfig(final java.lang.String metricsConfig) {
            this.props.metricsConfig(metricsConfig);
            return this;
        }

        /**
         * AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-opensearchserviceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-opensearchserviceconfig</a>
         * @param openSearchServiceConfig AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openSearchServiceConfig(final software.amazon.awscdk.IResolvable openSearchServiceConfig) {
            this.props.openSearchServiceConfig(openSearchServiceConfig);
            return this;
        }
        /**
         * AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-opensearchserviceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-opensearchserviceconfig</a>
         * @param openSearchServiceConfig AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openSearchServiceConfig(final software.amazon.awscdk.services.appsync.CfnDataSource.OpenSearchServiceConfigProperty openSearchServiceConfig) {
            this.props.openSearchServiceConfig(openSearchServiceConfig);
            return this;
        }

        /**
         * Relational Database configuration of the relational database data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-relationaldatabaseconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-relationaldatabaseconfig</a>
         * @param relationalDatabaseConfig Relational Database configuration of the relational database data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relationalDatabaseConfig(final software.amazon.awscdk.IResolvable relationalDatabaseConfig) {
            this.props.relationalDatabaseConfig(relationalDatabaseConfig);
            return this;
        }
        /**
         * Relational Database configuration of the relational database data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-relationaldatabaseconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-relationaldatabaseconfig</a>
         * @param relationalDatabaseConfig Relational Database configuration of the relational database data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relationalDatabaseConfig(final software.amazon.awscdk.services.appsync.CfnDataSource.RelationalDatabaseConfigProperty relationalDatabaseConfig) {
            this.props.relationalDatabaseConfig(relationalDatabaseConfig);
            return this;
        }

        /**
         * The AWS Identity and Access Management service role ARN for the data source.
         * <p>
         * The system assumes this role when accessing the data source.
         * <p>
         * Required if <code>Type</code> is specified as <code>AWS_LAMBDA</code> , <code>AMAZON_DYNAMODB</code> , <code>AMAZON_ELASTICSEARCH</code> , <code>AMAZON_EVENTBRIDGE</code> , <code>AMAZON_OPENSEARCH_SERVICE</code> , <code>RELATIONAL_DATABASE</code> , or <code>AMAZON_BEDROCK_RUNTIME</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-servicerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-servicerolearn</a>
         * @param serviceRoleArn The AWS Identity and Access Management service role ARN for the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRoleArn(final java.lang.String serviceRoleArn) {
            this.props.serviceRoleArn(serviceRoleArn);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appsync.CfnDataSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.CfnDataSource build() {
            return new software.amazon.awscdk.services.appsync.CfnDataSource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
