package software.amazon.awscdk.services.appsync;

/**
 * props used by implementations of BaseDataSource to provide configuration.
 * <p>
 * Should not be used directly.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * ExtendedDataSourceProps extendedDataSourceProps = ExtendedDataSourceProps.builder()
 *         .type("type")
 *         // the properties below are optional
 *         .dynamoDbConfig(DynamoDBConfigProperty.builder()
 *                 .awsRegion("awsRegion")
 *                 .tableName("tableName")
 *                 // the properties below are optional
 *                 .deltaSyncConfig(DeltaSyncConfigProperty.builder()
 *                         .baseTableTtl("baseTableTtl")
 *                         .deltaSyncTableName("deltaSyncTableName")
 *                         .deltaSyncTableTtl("deltaSyncTableTtl")
 *                         .build())
 *                 .useCallerCredentials(false)
 *                 .versioned(false)
 *                 .build())
 *         .elasticsearchConfig(ElasticsearchConfigProperty.builder()
 *                 .awsRegion("awsRegion")
 *                 .endpoint("endpoint")
 *                 .build())
 *         .eventBridgeConfig(EventBridgeConfigProperty.builder()
 *                 .eventBusArn("eventBusArn")
 *                 .build())
 *         .httpConfig(HttpConfigProperty.builder()
 *                 .endpoint("endpoint")
 *                 // the properties below are optional
 *                 .authorizationConfig(AuthorizationConfigProperty.builder()
 *                         .authorizationType("authorizationType")
 *                         // the properties below are optional
 *                         .awsIamConfig(AwsIamConfigProperty.builder()
 *                                 .signingRegion("signingRegion")
 *                                 .signingServiceName("signingServiceName")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .lambdaConfig(LambdaConfigProperty.builder()
 *                 .lambdaFunctionArn("lambdaFunctionArn")
 *                 .build())
 *         .openSearchServiceConfig(OpenSearchServiceConfigProperty.builder()
 *                 .awsRegion("awsRegion")
 *                 .endpoint("endpoint")
 *                 .build())
 *         .relationalDatabaseConfig(RelationalDatabaseConfigProperty.builder()
 *                 .relationalDatabaseSourceType("relationalDatabaseSourceType")
 *                 // the properties below are optional
 *                 .rdsHttpEndpointConfig(RdsHttpEndpointConfigProperty.builder()
 *                         .awsRegion("awsRegion")
 *                         .awsSecretStoreArn("awsSecretStoreArn")
 *                         .dbClusterIdentifier("dbClusterIdentifier")
 *                         // the properties below are optional
 *                         .databaseName("databaseName")
 *                         .schema("schema")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:58.524Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.ExtendedDataSourceProps")
@software.amazon.jsii.Jsii.Proxy(ExtendedDataSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ExtendedDataSourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * the type of the AppSync datasource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * configuration for DynamoDB Datasource.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.DynamoDBConfigProperty}
     * <p>
     * Default: - No config
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbConfig() {
        return null;
    }

    /**
     * (deprecated) configuration for Elasticsearch data source.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.ElasticsearchConfigProperty}
     * <p>
     * Default: - No config
     * <p>
     * @deprecated <ul>
     * <li>use <code>openSearchConfig</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearchConfig() {
        return null;
    }

    /**
     * configuration for EventBridge Datasource.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.EventBridgeConfigProperty}
     * <p>
     * Default: - No config
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEventBridgeConfig() {
        return null;
    }

    /**
     * configuration for HTTP Datasource.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.HttpConfigProperty}
     * <p>
     * Default: - No config
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHttpConfig() {
        return null;
    }

    /**
     * configuration for Lambda Datasource.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.LambdaConfigProperty}
     * <p>
     * Default: - No config
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaConfig() {
        return null;
    }

    /**
     * configuration for OpenSearch data source.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.OpenSearchServiceConfigProperty}
     * <p>
     * Default: - No config
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOpenSearchServiceConfig() {
        return null;
    }

    /**
     * configuration for RDS Datasource.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.appsync.CfnDataSource.RelationalDatabaseConfigProperty}
     * <p>
     * Default: - No config
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRelationalDatabaseConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ExtendedDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ExtendedDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ExtendedDataSourceProps> {
        java.lang.String type;
        java.lang.Object dynamoDbConfig;
        java.lang.Object elasticsearchConfig;
        java.lang.Object eventBridgeConfig;
        java.lang.Object httpConfig;
        java.lang.Object lambdaConfig;
        java.lang.Object openSearchServiceConfig;
        java.lang.Object relationalDatabaseConfig;

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getType}
         * @param type the type of the AppSync datasource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getDynamoDbConfig}
         * @param dynamoDbConfig configuration for DynamoDB Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dynamoDbConfig(software.amazon.awscdk.IResolvable dynamoDbConfig) {
            this.dynamoDbConfig = dynamoDbConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getDynamoDbConfig}
         * @param dynamoDbConfig configuration for DynamoDB Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dynamoDbConfig(software.amazon.awscdk.services.appsync.CfnDataSource.DynamoDBConfigProperty dynamoDbConfig) {
            this.dynamoDbConfig = dynamoDbConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getElasticsearchConfig}
         * @param elasticsearchConfig configuration for Elasticsearch data source.
         * @return {@code this}
         * @deprecated - use `openSearchConfig`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder elasticsearchConfig(software.amazon.awscdk.IResolvable elasticsearchConfig) {
            this.elasticsearchConfig = elasticsearchConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getElasticsearchConfig}
         * @param elasticsearchConfig configuration for Elasticsearch data source.
         * @return {@code this}
         * @deprecated - use `openSearchConfig`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder elasticsearchConfig(software.amazon.awscdk.services.appsync.CfnDataSource.ElasticsearchConfigProperty elasticsearchConfig) {
            this.elasticsearchConfig = elasticsearchConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getEventBridgeConfig}
         * @param eventBridgeConfig configuration for EventBridge Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBridgeConfig(software.amazon.awscdk.IResolvable eventBridgeConfig) {
            this.eventBridgeConfig = eventBridgeConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getEventBridgeConfig}
         * @param eventBridgeConfig configuration for EventBridge Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBridgeConfig(software.amazon.awscdk.services.appsync.CfnDataSource.EventBridgeConfigProperty eventBridgeConfig) {
            this.eventBridgeConfig = eventBridgeConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getHttpConfig}
         * @param httpConfig configuration for HTTP Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpConfig(software.amazon.awscdk.IResolvable httpConfig) {
            this.httpConfig = httpConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getHttpConfig}
         * @param httpConfig configuration for HTTP Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpConfig(software.amazon.awscdk.services.appsync.CfnDataSource.HttpConfigProperty httpConfig) {
            this.httpConfig = httpConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getLambdaConfig}
         * @param lambdaConfig configuration for Lambda Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaConfig(software.amazon.awscdk.IResolvable lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getLambdaConfig}
         * @param lambdaConfig configuration for Lambda Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaConfig(software.amazon.awscdk.services.appsync.CfnDataSource.LambdaConfigProperty lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getOpenSearchServiceConfig}
         * @param openSearchServiceConfig configuration for OpenSearch data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openSearchServiceConfig(software.amazon.awscdk.IResolvable openSearchServiceConfig) {
            this.openSearchServiceConfig = openSearchServiceConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getOpenSearchServiceConfig}
         * @param openSearchServiceConfig configuration for OpenSearch data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openSearchServiceConfig(software.amazon.awscdk.services.appsync.CfnDataSource.OpenSearchServiceConfigProperty openSearchServiceConfig) {
            this.openSearchServiceConfig = openSearchServiceConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getRelationalDatabaseConfig}
         * @param relationalDatabaseConfig configuration for RDS Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relationalDatabaseConfig(software.amazon.awscdk.IResolvable relationalDatabaseConfig) {
            this.relationalDatabaseConfig = relationalDatabaseConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getRelationalDatabaseConfig}
         * @param relationalDatabaseConfig configuration for RDS Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relationalDatabaseConfig(software.amazon.awscdk.services.appsync.CfnDataSource.RelationalDatabaseConfigProperty relationalDatabaseConfig) {
            this.relationalDatabaseConfig = relationalDatabaseConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ExtendedDataSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ExtendedDataSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ExtendedDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExtendedDataSourceProps {
        private final java.lang.String type;
        private final java.lang.Object dynamoDbConfig;
        private final java.lang.Object elasticsearchConfig;
        private final java.lang.Object eventBridgeConfig;
        private final java.lang.Object httpConfig;
        private final java.lang.Object lambdaConfig;
        private final java.lang.Object openSearchServiceConfig;
        private final java.lang.Object relationalDatabaseConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dynamoDbConfig = software.amazon.jsii.Kernel.get(this, "dynamoDbConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.elasticsearchConfig = software.amazon.jsii.Kernel.get(this, "elasticsearchConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.eventBridgeConfig = software.amazon.jsii.Kernel.get(this, "eventBridgeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.httpConfig = software.amazon.jsii.Kernel.get(this, "httpConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.lambdaConfig = software.amazon.jsii.Kernel.get(this, "lambdaConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.openSearchServiceConfig = software.amazon.jsii.Kernel.get(this, "openSearchServiceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.relationalDatabaseConfig = software.amazon.jsii.Kernel.get(this, "relationalDatabaseConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.dynamoDbConfig = builder.dynamoDbConfig;
            this.elasticsearchConfig = builder.elasticsearchConfig;
            this.eventBridgeConfig = builder.eventBridgeConfig;
            this.httpConfig = builder.httpConfig;
            this.lambdaConfig = builder.lambdaConfig;
            this.openSearchServiceConfig = builder.openSearchServiceConfig;
            this.relationalDatabaseConfig = builder.relationalDatabaseConfig;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getDynamoDbConfig() {
            return this.dynamoDbConfig;
        }

        @Override
        public final java.lang.Object getElasticsearchConfig() {
            return this.elasticsearchConfig;
        }

        @Override
        public final java.lang.Object getEventBridgeConfig() {
            return this.eventBridgeConfig;
        }

        @Override
        public final java.lang.Object getHttpConfig() {
            return this.httpConfig;
        }

        @Override
        public final java.lang.Object getLambdaConfig() {
            return this.lambdaConfig;
        }

        @Override
        public final java.lang.Object getOpenSearchServiceConfig() {
            return this.openSearchServiceConfig;
        }

        @Override
        public final java.lang.Object getRelationalDatabaseConfig() {
            return this.relationalDatabaseConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getDynamoDbConfig() != null) {
                data.set("dynamoDbConfig", om.valueToTree(this.getDynamoDbConfig()));
            }
            if (this.getElasticsearchConfig() != null) {
                data.set("elasticsearchConfig", om.valueToTree(this.getElasticsearchConfig()));
            }
            if (this.getEventBridgeConfig() != null) {
                data.set("eventBridgeConfig", om.valueToTree(this.getEventBridgeConfig()));
            }
            if (this.getHttpConfig() != null) {
                data.set("httpConfig", om.valueToTree(this.getHttpConfig()));
            }
            if (this.getLambdaConfig() != null) {
                data.set("lambdaConfig", om.valueToTree(this.getLambdaConfig()));
            }
            if (this.getOpenSearchServiceConfig() != null) {
                data.set("openSearchServiceConfig", om.valueToTree(this.getOpenSearchServiceConfig()));
            }
            if (this.getRelationalDatabaseConfig() != null) {
                data.set("relationalDatabaseConfig", om.valueToTree(this.getRelationalDatabaseConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.ExtendedDataSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ExtendedDataSourceProps.Jsii$Proxy that = (ExtendedDataSourceProps.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.dynamoDbConfig != null ? !this.dynamoDbConfig.equals(that.dynamoDbConfig) : that.dynamoDbConfig != null) return false;
            if (this.elasticsearchConfig != null ? !this.elasticsearchConfig.equals(that.elasticsearchConfig) : that.elasticsearchConfig != null) return false;
            if (this.eventBridgeConfig != null ? !this.eventBridgeConfig.equals(that.eventBridgeConfig) : that.eventBridgeConfig != null) return false;
            if (this.httpConfig != null ? !this.httpConfig.equals(that.httpConfig) : that.httpConfig != null) return false;
            if (this.lambdaConfig != null ? !this.lambdaConfig.equals(that.lambdaConfig) : that.lambdaConfig != null) return false;
            if (this.openSearchServiceConfig != null ? !this.openSearchServiceConfig.equals(that.openSearchServiceConfig) : that.openSearchServiceConfig != null) return false;
            return this.relationalDatabaseConfig != null ? this.relationalDatabaseConfig.equals(that.relationalDatabaseConfig) : that.relationalDatabaseConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.dynamoDbConfig != null ? this.dynamoDbConfig.hashCode() : 0);
            result = 31 * result + (this.elasticsearchConfig != null ? this.elasticsearchConfig.hashCode() : 0);
            result = 31 * result + (this.eventBridgeConfig != null ? this.eventBridgeConfig.hashCode() : 0);
            result = 31 * result + (this.httpConfig != null ? this.httpConfig.hashCode() : 0);
            result = 31 * result + (this.lambdaConfig != null ? this.lambdaConfig.hashCode() : 0);
            result = 31 * result + (this.openSearchServiceConfig != null ? this.openSearchServiceConfig.hashCode() : 0);
            result = 31 * result + (this.relationalDatabaseConfig != null ? this.relationalDatabaseConfig.hashCode() : 0);
            return result;
        }
    }
}
