package software.amazon.awscdk.services.aps;

/**
 * An Amazon Managed Service for Prometheus workspace is a logical and isolated Prometheus server dedicated to ingesting, storing, and querying your Prometheus-compatible metrics.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.aps.*;
 * CfnWorkspace cfnWorkspace = CfnWorkspace.Builder.create(this, "MyCfnWorkspace")
 *         .alertManagerDefinition("alertManagerDefinition")
 *         .alias("alias")
 *         .kmsKeyArn("kmsKeyArn")
 *         .loggingConfiguration(LoggingConfigurationProperty.builder()
 *                 .logGroupArn("logGroupArn")
 *                 .build())
 *         .queryLoggingConfiguration(QueryLoggingConfigurationProperty.builder()
 *                 .destinations(List.of(LoggingDestinationProperty.builder()
 *                         .cloudWatchLogs(CloudWatchLogDestinationProperty.builder()
 *                                 .logGroupArn("logGroupArn")
 *                                 .build())
 *                         .filters(LoggingFilterProperty.builder()
 *                                 .qspThreshold(123)
 *                                 .build())
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .workspaceConfiguration(WorkspaceConfigurationProperty.builder()
 *                 .limitsPerLabelSets(List.of(LimitsPerLabelSetProperty.builder()
 *                         .labelSet(List.of(LabelProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .limits(LimitsPerLabelSetEntryProperty.builder()
 *                                 .maxSeries(123)
 *                                 .build())
 *                         .build()))
 *                 .retentionPeriodInDays(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:58.629Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_aps.CfnWorkspace")
public class CfnWorkspace extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.aps.IWorkspaceRef, software.amazon.awscdk.ITaggable {

    protected CfnWorkspace(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWorkspace(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.aps.CfnWorkspace.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWorkspace(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.aps.CfnWorkspaceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWorkspace(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the workspace.
     * <p>
     * For example, <code>arn:aws:aps:&lt;region&gt;:123456789012:workspace/ws-example1-1234-abcd-5678-ef90abcd1234</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Prometheus endpoint available for this workspace.
     * <p>
     * For example, <code>https://aps-workspaces.&lt;region&gt;.amazonaws.com/workspaces/ws-example1-1234-abcd-5678-ef90abcd1234/api/v1/</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPrometheusEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrPrometheusEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID for the workspace.
     * <p>
     * For example, <code>ws-example1-1234-abcd-5678-ef90abcd1234</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkspaceId() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkspaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A reference to a Workspace resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.aps.WorkspaceReference getWorkspaceRef() {
        return software.amazon.jsii.Kernel.get(this, "workspaceRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.aps.WorkspaceReference.class));
    }

    /**
     * The alert manager definition, a YAML configuration for the alert manager in your Amazon Managed Service for Prometheus workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAlertManagerDefinition() {
        return software.amazon.jsii.Kernel.get(this, "alertManagerDefinition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The alert manager definition, a YAML configuration for the alert manager in your Amazon Managed Service for Prometheus workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlertManagerDefinition(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "alertManagerDefinition", value);
    }

    /**
     * The alias that is assigned to this workspace to help identify it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAlias() {
        return software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The alias that is assigned to this workspace to help identify it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlias(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "alias", value);
    }

    /**
     * (optional) The ARN for a customer managed AWS KMS key to use for encrypting data within your workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (optional) The ARN for a customer managed AWS KMS key to use for encrypting data within your workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyArn", value);
    }

    /**
     * Contains information about the logging configuration for the workspace.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.aps.CfnWorkspace.LoggingConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoggingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "loggingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains information about the logging configuration for the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "loggingConfiguration", value);
    }

    /**
     * Contains information about the logging configuration for the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.aps.CfnWorkspace.LoggingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "loggingConfiguration", value);
    }

    /**
     * The definition of logging configuration in an Amazon Managed Service for Prometheus workspace.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.aps.CfnWorkspace.QueryLoggingConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getQueryLoggingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "queryLoggingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The definition of logging configuration in an Amazon Managed Service for Prometheus workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQueryLoggingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "queryLoggingConfiguration", value);
    }

    /**
     * The definition of logging configuration in an Amazon Managed Service for Prometheus workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQueryLoggingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.aps.CfnWorkspace.QueryLoggingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "queryLoggingConfiguration", value);
    }

    /**
     * The list of tag keys and values that are associated with the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of tag keys and values that are associated with the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Use this structure to define label sets and the ingestion limits for time series that match label sets, and to specify the retention period of the workspace.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.aps.CfnWorkspace.WorkspaceConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWorkspaceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "workspaceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Use this structure to define label sets and the ingestion limits for time series that match label sets, and to specify the retention period of the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkspaceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "workspaceConfiguration", value);
    }

    /**
     * Use this structure to define label sets and the ingestion limits for time series that match label sets, and to specify the retention period of the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkspaceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.aps.CfnWorkspace.WorkspaceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "workspaceConfiguration", value);
    }
    /**
     * Configuration details for logging to CloudWatch Logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.aps.*;
     * CloudWatchLogDestinationProperty cloudWatchLogDestinationProperty = CloudWatchLogDestinationProperty.builder()
     *         .logGroupArn("logGroupArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-cloudwatchlogdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-cloudwatchlogdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_aps.CfnWorkspace.CloudWatchLogDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLogDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLogDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the CloudWatch log group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-cloudwatchlogdestination.html#cfn-aps-workspace-cloudwatchlogdestination-loggrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-cloudwatchlogdestination.html#cfn-aps-workspace-cloudwatchlogdestination-loggrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogGroupArn();

        /**
         * @return a {@link Builder} of {@link CloudWatchLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogDestinationProperty> {
            java.lang.String logGroupArn;

            /**
             * Sets the value of {@link CloudWatchLogDestinationProperty#getLogGroupArn}
             * @param logGroupArn The ARN of the CloudWatch log group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupArn(java.lang.String logGroupArn) {
                this.logGroupArn = logGroupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLogDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogDestinationProperty {
            private final java.lang.String logGroupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logGroupArn = software.amazon.jsii.Kernel.get(this, "logGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logGroupArn = java.util.Objects.requireNonNull(builder.logGroupArn, "logGroupArn is required");
            }

            @Override
            public final java.lang.String getLogGroupArn() {
                return this.logGroupArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logGroupArn", om.valueToTree(this.getLogGroupArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_aps.CfnWorkspace.CloudWatchLogDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLogDestinationProperty.Jsii$Proxy that = (CloudWatchLogDestinationProperty.Jsii$Proxy) o;

                return this.logGroupArn.equals(that.logGroupArn);
            }

            @Override
            public final int hashCode() {
                int result = this.logGroupArn.hashCode();
                return result;
            }
        }
    }
    /**
     * A label is a name:value pair used to add context to ingested metrics.
     * <p>
     * This structure defines the name and value for one label that is used in a label set. You can set ingestion limits on time series that match defined label sets, to help prevent a workspace from being overwhelmed with unexpected spikes in time series ingestion.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.aps.*;
     * LabelProperty labelProperty = LabelProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-label.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-label.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_aps.CfnWorkspace.LabelProperty")
    @software.amazon.jsii.Jsii.Proxy(LabelProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LabelProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name for this label.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-label.html#cfn-aps-workspace-label-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-label.html#cfn-aps-workspace-label-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value for this label.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-label.html#cfn-aps-workspace-label-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-label.html#cfn-aps-workspace-label-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link LabelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LabelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LabelProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link LabelProperty#getName}
             * @param name The name for this label. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link LabelProperty#getValue}
             * @param value The value for this label. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LabelProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LabelProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LabelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LabelProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_aps.CfnWorkspace.LabelProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LabelProperty.Jsii$Proxy that = (LabelProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * This structure contains the limits that apply to time series that match one label set.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.aps.*;
     * LimitsPerLabelSetEntryProperty limitsPerLabelSetEntryProperty = LimitsPerLabelSetEntryProperty.builder()
     *         .maxSeries(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-limitsperlabelsetentry.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-limitsperlabelsetentry.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_aps.CfnWorkspace.LimitsPerLabelSetEntryProperty")
    @software.amazon.jsii.Jsii.Proxy(LimitsPerLabelSetEntryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LimitsPerLabelSetEntryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of active series that can be ingested that match this label set.
         * <p>
         * Setting this to 0 causes no label set limit to be enforced, but it does cause Amazon Managed Service for Prometheus to vend label set metrics to CloudWatch
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-limitsperlabelsetentry.html#cfn-aps-workspace-limitsperlabelsetentry-maxseries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-limitsperlabelsetentry.html#cfn-aps-workspace-limitsperlabelsetentry-maxseries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxSeries() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LimitsPerLabelSetEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LimitsPerLabelSetEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LimitsPerLabelSetEntryProperty> {
            java.lang.Number maxSeries;

            /**
             * Sets the value of {@link LimitsPerLabelSetEntryProperty#getMaxSeries}
             * @param maxSeries The maximum number of active series that can be ingested that match this label set.
             *                  Setting this to 0 causes no label set limit to be enforced, but it does cause Amazon Managed Service for Prometheus to vend label set metrics to CloudWatch
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxSeries(java.lang.Number maxSeries) {
                this.maxSeries = maxSeries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LimitsPerLabelSetEntryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LimitsPerLabelSetEntryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LimitsPerLabelSetEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LimitsPerLabelSetEntryProperty {
            private final java.lang.Number maxSeries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxSeries = software.amazon.jsii.Kernel.get(this, "maxSeries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxSeries = builder.maxSeries;
            }

            @Override
            public final java.lang.Number getMaxSeries() {
                return this.maxSeries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxSeries() != null) {
                    data.set("maxSeries", om.valueToTree(this.getMaxSeries()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_aps.CfnWorkspace.LimitsPerLabelSetEntryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LimitsPerLabelSetEntryProperty.Jsii$Proxy that = (LimitsPerLabelSetEntryProperty.Jsii$Proxy) o;

                return this.maxSeries != null ? this.maxSeries.equals(that.maxSeries) : that.maxSeries == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxSeries != null ? this.maxSeries.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * This defines a label set for the workspace, and defines the ingestion limit for active time series that match that label set.
     * <p>
     * Each label name in a label set must be unique.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.aps.*;
     * LimitsPerLabelSetProperty limitsPerLabelSetProperty = LimitsPerLabelSetProperty.builder()
     *         .labelSet(List.of(LabelProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .limits(LimitsPerLabelSetEntryProperty.builder()
     *                 .maxSeries(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-limitsperlabelset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-limitsperlabelset.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_aps.CfnWorkspace.LimitsPerLabelSetProperty")
    @software.amazon.jsii.Jsii.Proxy(LimitsPerLabelSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LimitsPerLabelSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This defines one label set that will have an enforced ingestion limit.
         * <p>
         * You can set ingestion limits on time series that match defined label sets, to help prevent a workspace from being overwhelmed with unexpected spikes in time series ingestion.
         * <p>
         * Label values accept all UTF-8 characters with one exception. If the label name is metric name label <code>__ *name* __</code> , then the <em>metric</em> part of the name must conform to the following pattern: <code>[a-zA-Z_:][a-zA-Z0-9_:]*</code>
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.aps.CfnWorkspace.LabelProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-limitsperlabelset.html#cfn-aps-workspace-limitsperlabelset-labelset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-limitsperlabelset.html#cfn-aps-workspace-limitsperlabelset-labelset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLabelSet();

        /**
         * This structure contains the information about the limits that apply to time series that match this label set.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.aps.CfnWorkspace.LimitsPerLabelSetEntryProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-limitsperlabelset.html#cfn-aps-workspace-limitsperlabelset-limits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-limitsperlabelset.html#cfn-aps-workspace-limitsperlabelset-limits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLimits();

        /**
         * @return a {@link Builder} of {@link LimitsPerLabelSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LimitsPerLabelSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LimitsPerLabelSetProperty> {
            java.lang.Object labelSet;
            java.lang.Object limits;

            /**
             * Sets the value of {@link LimitsPerLabelSetProperty#getLabelSet}
             * @param labelSet This defines one label set that will have an enforced ingestion limit. This parameter is required.
             *                 You can set ingestion limits on time series that match defined label sets, to help prevent a workspace from being overwhelmed with unexpected spikes in time series ingestion.
             *                 <p>
             *                 Label values accept all UTF-8 characters with one exception. If the label name is metric name label <code>__ *name* __</code> , then the <em>metric</em> part of the name must conform to the following pattern: <code>[a-zA-Z_:][a-zA-Z0-9_:]*</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labelSet(software.amazon.awscdk.IResolvable labelSet) {
                this.labelSet = labelSet;
                return this;
            }

            /**
             * Sets the value of {@link LimitsPerLabelSetProperty#getLabelSet}
             * @param labelSet This defines one label set that will have an enforced ingestion limit. This parameter is required.
             *                 You can set ingestion limits on time series that match defined label sets, to help prevent a workspace from being overwhelmed with unexpected spikes in time series ingestion.
             *                 <p>
             *                 Label values accept all UTF-8 characters with one exception. If the label name is metric name label <code>__ *name* __</code> , then the <em>metric</em> part of the name must conform to the following pattern: <code>[a-zA-Z_:][a-zA-Z0-9_:]*</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labelSet(java.util.List<? extends java.lang.Object> labelSet) {
                this.labelSet = labelSet;
                return this;
            }

            /**
             * Sets the value of {@link LimitsPerLabelSetProperty#getLimits}
             * @param limits This structure contains the information about the limits that apply to time series that match this label set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder limits(software.amazon.awscdk.IResolvable limits) {
                this.limits = limits;
                return this;
            }

            /**
             * Sets the value of {@link LimitsPerLabelSetProperty#getLimits}
             * @param limits This structure contains the information about the limits that apply to time series that match this label set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder limits(software.amazon.awscdk.services.aps.CfnWorkspace.LimitsPerLabelSetEntryProperty limits) {
                this.limits = limits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LimitsPerLabelSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LimitsPerLabelSetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LimitsPerLabelSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LimitsPerLabelSetProperty {
            private final java.lang.Object labelSet;
            private final java.lang.Object limits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.labelSet = software.amazon.jsii.Kernel.get(this, "labelSet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.limits = software.amazon.jsii.Kernel.get(this, "limits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.labelSet = java.util.Objects.requireNonNull(builder.labelSet, "labelSet is required");
                this.limits = java.util.Objects.requireNonNull(builder.limits, "limits is required");
            }

            @Override
            public final java.lang.Object getLabelSet() {
                return this.labelSet;
            }

            @Override
            public final java.lang.Object getLimits() {
                return this.limits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("labelSet", om.valueToTree(this.getLabelSet()));
                data.set("limits", om.valueToTree(this.getLimits()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_aps.CfnWorkspace.LimitsPerLabelSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LimitsPerLabelSetProperty.Jsii$Proxy that = (LimitsPerLabelSetProperty.Jsii$Proxy) o;

                if (!labelSet.equals(that.labelSet)) return false;
                return this.limits.equals(that.limits);
            }

            @Override
            public final int hashCode() {
                int result = this.labelSet.hashCode();
                result = 31 * result + (this.limits.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains information about the rules and alerting logging configuration for the workspace.
     * <p>
     * <blockquote>
     * <p>
     * These logging configurations are only for rules and alerting logs.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.aps.*;
     * LoggingConfigurationProperty loggingConfigurationProperty = LoggingConfigurationProperty.builder()
     *         .logGroupArn("logGroupArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-loggingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-loggingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_aps.CfnWorkspace.LoggingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the CloudWatch log group to which the vended log data will be published.
         * <p>
         * This log group must exist prior to calling this operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-loggingconfiguration.html#cfn-aps-workspace-loggingconfiguration-loggrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-loggingconfiguration.html#cfn-aps-workspace-loggingconfiguration-loggrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogGroupArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingConfigurationProperty> {
            java.lang.String logGroupArn;

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getLogGroupArn}
             * @param logGroupArn The ARN of the CloudWatch log group to which the vended log data will be published.
             *                    This log group must exist prior to calling this operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupArn(java.lang.String logGroupArn) {
                this.logGroupArn = logGroupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingConfigurationProperty {
            private final java.lang.String logGroupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logGroupArn = software.amazon.jsii.Kernel.get(this, "logGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logGroupArn = builder.logGroupArn;
            }

            @Override
            public final java.lang.String getLogGroupArn() {
                return this.logGroupArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLogGroupArn() != null) {
                    data.set("logGroupArn", om.valueToTree(this.getLogGroupArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_aps.CfnWorkspace.LoggingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingConfigurationProperty.Jsii$Proxy that = (LoggingConfigurationProperty.Jsii$Proxy) o;

                return this.logGroupArn != null ? this.logGroupArn.equals(that.logGroupArn) : that.logGroupArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logGroupArn != null ? this.logGroupArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The logging destination in an Amazon Managed Service for Prometheus workspace.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.aps.*;
     * LoggingDestinationProperty loggingDestinationProperty = LoggingDestinationProperty.builder()
     *         .cloudWatchLogs(CloudWatchLogDestinationProperty.builder()
     *                 .logGroupArn("logGroupArn")
     *                 .build())
     *         .filters(LoggingFilterProperty.builder()
     *                 .qspThreshold(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-loggingdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-loggingdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_aps.CfnWorkspace.LoggingDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration details for logging to CloudWatch Logs.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.aps.CfnWorkspace.CloudWatchLogDestinationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-loggingdestination.html#cfn-aps-workspace-loggingdestination-cloudwatchlogs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-loggingdestination.html#cfn-aps-workspace-loggingdestination-cloudwatchlogs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCloudWatchLogs();

        /**
         * Filtering criteria that determine which queries are logged.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.aps.CfnWorkspace.LoggingFilterProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-loggingdestination.html#cfn-aps-workspace-loggingdestination-filters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-loggingdestination.html#cfn-aps-workspace-loggingdestination-filters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFilters();

        /**
         * @return a {@link Builder} of {@link LoggingDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingDestinationProperty> {
            java.lang.Object cloudWatchLogs;
            java.lang.Object filters;

            /**
             * Sets the value of {@link LoggingDestinationProperty#getCloudWatchLogs}
             * @param cloudWatchLogs Configuration details for logging to CloudWatch Logs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogs(software.amazon.awscdk.IResolvable cloudWatchLogs) {
                this.cloudWatchLogs = cloudWatchLogs;
                return this;
            }

            /**
             * Sets the value of {@link LoggingDestinationProperty#getCloudWatchLogs}
             * @param cloudWatchLogs Configuration details for logging to CloudWatch Logs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogs(software.amazon.awscdk.services.aps.CfnWorkspace.CloudWatchLogDestinationProperty cloudWatchLogs) {
                this.cloudWatchLogs = cloudWatchLogs;
                return this;
            }

            /**
             * Sets the value of {@link LoggingDestinationProperty#getFilters}
             * @param filters Filtering criteria that determine which queries are logged. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filters(software.amazon.awscdk.IResolvable filters) {
                this.filters = filters;
                return this;
            }

            /**
             * Sets the value of {@link LoggingDestinationProperty#getFilters}
             * @param filters Filtering criteria that determine which queries are logged. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filters(software.amazon.awscdk.services.aps.CfnWorkspace.LoggingFilterProperty filters) {
                this.filters = filters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingDestinationProperty {
            private final java.lang.Object cloudWatchLogs;
            private final java.lang.Object filters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogs = software.amazon.jsii.Kernel.get(this, "cloudWatchLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filters = software.amazon.jsii.Kernel.get(this, "filters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogs = java.util.Objects.requireNonNull(builder.cloudWatchLogs, "cloudWatchLogs is required");
                this.filters = java.util.Objects.requireNonNull(builder.filters, "filters is required");
            }

            @Override
            public final java.lang.Object getCloudWatchLogs() {
                return this.cloudWatchLogs;
            }

            @Override
            public final java.lang.Object getFilters() {
                return this.filters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cloudWatchLogs", om.valueToTree(this.getCloudWatchLogs()));
                data.set("filters", om.valueToTree(this.getFilters()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_aps.CfnWorkspace.LoggingDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingDestinationProperty.Jsii$Proxy that = (LoggingDestinationProperty.Jsii$Proxy) o;

                if (!cloudWatchLogs.equals(that.cloudWatchLogs)) return false;
                return this.filters.equals(that.filters);
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogs.hashCode();
                result = 31 * result + (this.filters.hashCode());
                return result;
            }
        }
    }
    /**
     * Filtering criteria that determine which queries are logged.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.aps.*;
     * LoggingFilterProperty loggingFilterProperty = LoggingFilterProperty.builder()
     *         .qspThreshold(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-loggingfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-loggingfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_aps.CfnWorkspace.LoggingFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Query Samples Processed (QSP) threshold above which queries will be logged.
         * <p>
         * Queries processing more samples than this threshold will be captured in logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-loggingfilter.html#cfn-aps-workspace-loggingfilter-qspthreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-loggingfilter.html#cfn-aps-workspace-loggingfilter-qspthreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getQspThreshold();

        /**
         * @return a {@link Builder} of {@link LoggingFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingFilterProperty> {
            java.lang.Number qspThreshold;

            /**
             * Sets the value of {@link LoggingFilterProperty#getQspThreshold}
             * @param qspThreshold The Query Samples Processed (QSP) threshold above which queries will be logged. This parameter is required.
             *                     Queries processing more samples than this threshold will be captured in logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder qspThreshold(java.lang.Number qspThreshold) {
                this.qspThreshold = qspThreshold;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingFilterProperty {
            private final java.lang.Number qspThreshold;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.qspThreshold = software.amazon.jsii.Kernel.get(this, "qspThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.qspThreshold = java.util.Objects.requireNonNull(builder.qspThreshold, "qspThreshold is required");
            }

            @Override
            public final java.lang.Number getQspThreshold() {
                return this.qspThreshold;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("qspThreshold", om.valueToTree(this.getQspThreshold()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_aps.CfnWorkspace.LoggingFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingFilterProperty.Jsii$Proxy that = (LoggingFilterProperty.Jsii$Proxy) o;

                return this.qspThreshold.equals(that.qspThreshold);
            }

            @Override
            public final int hashCode() {
                int result = this.qspThreshold.hashCode();
                return result;
            }
        }
    }
    /**
     * The query logging configuration in an Amazon Managed Service for Prometheus workspace.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.aps.*;
     * QueryLoggingConfigurationProperty queryLoggingConfigurationProperty = QueryLoggingConfigurationProperty.builder()
     *         .destinations(List.of(LoggingDestinationProperty.builder()
     *                 .cloudWatchLogs(CloudWatchLogDestinationProperty.builder()
     *                         .logGroupArn("logGroupArn")
     *                         .build())
     *                 .filters(LoggingFilterProperty.builder()
     *                         .qspThreshold(123)
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-queryloggingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-queryloggingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_aps.CfnWorkspace.QueryLoggingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(QueryLoggingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryLoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines a destination and its associated filtering criteria for query logging.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.aps.CfnWorkspace.LoggingDestinationProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-queryloggingconfiguration.html#cfn-aps-workspace-queryloggingconfiguration-destinations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-queryloggingconfiguration.html#cfn-aps-workspace-queryloggingconfiguration-destinations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestinations();

        /**
         * @return a {@link Builder} of {@link QueryLoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryLoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueryLoggingConfigurationProperty> {
            java.lang.Object destinations;

            /**
             * Sets the value of {@link QueryLoggingConfigurationProperty#getDestinations}
             * @param destinations Defines a destination and its associated filtering criteria for query logging. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinations(software.amazon.awscdk.IResolvable destinations) {
                this.destinations = destinations;
                return this;
            }

            /**
             * Sets the value of {@link QueryLoggingConfigurationProperty#getDestinations}
             * @param destinations Defines a destination and its associated filtering criteria for query logging. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinations(java.util.List<? extends java.lang.Object> destinations) {
                this.destinations = destinations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryLoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueryLoggingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueryLoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryLoggingConfigurationProperty {
            private final java.lang.Object destinations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinations = software.amazon.jsii.Kernel.get(this, "destinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinations = java.util.Objects.requireNonNull(builder.destinations, "destinations is required");
            }

            @Override
            public final java.lang.Object getDestinations() {
                return this.destinations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinations", om.valueToTree(this.getDestinations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_aps.CfnWorkspace.QueryLoggingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryLoggingConfigurationProperty.Jsii$Proxy that = (QueryLoggingConfigurationProperty.Jsii$Proxy) o;

                return this.destinations.equals(that.destinations);
            }

            @Override
            public final int hashCode() {
                int result = this.destinations.hashCode();
                return result;
            }
        }
    }
    /**
     * Use this structure to define label sets and the ingestion limits for time series that match label sets, and to specify the retention period of the workspace.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.aps.*;
     * WorkspaceConfigurationProperty workspaceConfigurationProperty = WorkspaceConfigurationProperty.builder()
     *         .limitsPerLabelSets(List.of(LimitsPerLabelSetProperty.builder()
     *                 .labelSet(List.of(LabelProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .limits(LimitsPerLabelSetEntryProperty.builder()
     *                         .maxSeries(123)
     *                         .build())
     *                 .build()))
     *         .retentionPeriodInDays(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-workspaceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-workspaceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_aps.CfnWorkspace.WorkspaceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkspaceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkspaceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This is an array of structures, where each structure defines a label set for the workspace, and defines the ingestion limit for active time series for each of those label sets.
         * <p>
         * Each label name in a label set must be unique.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.aps.CfnWorkspace.LimitsPerLabelSetProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-workspaceconfiguration.html#cfn-aps-workspace-workspaceconfiguration-limitsperlabelsets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-workspaceconfiguration.html#cfn-aps-workspace-workspaceconfiguration-limitsperlabelsets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLimitsPerLabelSets() {
            return null;
        }

        /**
         * Specifies how many days that metrics will be retained in the workspace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-workspaceconfiguration.html#cfn-aps-workspace-workspaceconfiguration-retentionperiodindays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-aps-workspace-workspaceconfiguration.html#cfn-aps-workspace-workspaceconfiguration-retentionperiodindays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRetentionPeriodInDays() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkspaceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkspaceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkspaceConfigurationProperty> {
            java.lang.Object limitsPerLabelSets;
            java.lang.Number retentionPeriodInDays;

            /**
             * Sets the value of {@link WorkspaceConfigurationProperty#getLimitsPerLabelSets}
             * @param limitsPerLabelSets This is an array of structures, where each structure defines a label set for the workspace, and defines the ingestion limit for active time series for each of those label sets.
             *                           Each label name in a label set must be unique.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder limitsPerLabelSets(software.amazon.awscdk.IResolvable limitsPerLabelSets) {
                this.limitsPerLabelSets = limitsPerLabelSets;
                return this;
            }

            /**
             * Sets the value of {@link WorkspaceConfigurationProperty#getLimitsPerLabelSets}
             * @param limitsPerLabelSets This is an array of structures, where each structure defines a label set for the workspace, and defines the ingestion limit for active time series for each of those label sets.
             *                           Each label name in a label set must be unique.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder limitsPerLabelSets(java.util.List<? extends java.lang.Object> limitsPerLabelSets) {
                this.limitsPerLabelSets = limitsPerLabelSets;
                return this;
            }

            /**
             * Sets the value of {@link WorkspaceConfigurationProperty#getRetentionPeriodInDays}
             * @param retentionPeriodInDays Specifies how many days that metrics will be retained in the workspace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retentionPeriodInDays(java.lang.Number retentionPeriodInDays) {
                this.retentionPeriodInDays = retentionPeriodInDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkspaceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkspaceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkspaceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkspaceConfigurationProperty {
            private final java.lang.Object limitsPerLabelSets;
            private final java.lang.Number retentionPeriodInDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.limitsPerLabelSets = software.amazon.jsii.Kernel.get(this, "limitsPerLabelSets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retentionPeriodInDays = software.amazon.jsii.Kernel.get(this, "retentionPeriodInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.limitsPerLabelSets = builder.limitsPerLabelSets;
                this.retentionPeriodInDays = builder.retentionPeriodInDays;
            }

            @Override
            public final java.lang.Object getLimitsPerLabelSets() {
                return this.limitsPerLabelSets;
            }

            @Override
            public final java.lang.Number getRetentionPeriodInDays() {
                return this.retentionPeriodInDays;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLimitsPerLabelSets() != null) {
                    data.set("limitsPerLabelSets", om.valueToTree(this.getLimitsPerLabelSets()));
                }
                if (this.getRetentionPeriodInDays() != null) {
                    data.set("retentionPeriodInDays", om.valueToTree(this.getRetentionPeriodInDays()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_aps.CfnWorkspace.WorkspaceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkspaceConfigurationProperty.Jsii$Proxy that = (WorkspaceConfigurationProperty.Jsii$Proxy) o;

                if (this.limitsPerLabelSets != null ? !this.limitsPerLabelSets.equals(that.limitsPerLabelSets) : that.limitsPerLabelSets != null) return false;
                return this.retentionPeriodInDays != null ? this.retentionPeriodInDays.equals(that.retentionPeriodInDays) : that.retentionPeriodInDays == null;
            }

            @Override
            public final int hashCode() {
                int result = this.limitsPerLabelSets != null ? this.limitsPerLabelSets.hashCode() : 0;
                result = 31 * result + (this.retentionPeriodInDays != null ? this.retentionPeriodInDays.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.aps.CfnWorkspace}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.aps.CfnWorkspace> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.aps.CfnWorkspaceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The alert manager definition, a YAML configuration for the alert manager in your Amazon Managed Service for Prometheus workspace.
         * <p>
         * For details about the alert manager definition, see <a href="https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-alertmanager-config.html">Creating an alert manager configuration files</a> in the <em>Amazon Managed Service for Prometheus User Guide</em> .
         * <p>
         * The following example shows part of a CloudFormation YAML file with an embedded alert manager definition (following the <code>- |-</code> ).
         * <p>
         * <code>Workspace: Type: AWS::APS::Workspace .... Properties: .... AlertManagerDefinition: Fn::Sub: - |- alertmanager_config: | templates: - 'default_template' route: receiver: example-sns receivers: - name: example-sns sns_configs: - topic_arn: 'arn:aws:sns:${AWS::Region}:${AWS::AccountId}:${TopicName}' -</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-alertmanagerdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-alertmanagerdefinition</a>
         * @param alertManagerDefinition The alert manager definition, a YAML configuration for the alert manager in your Amazon Managed Service for Prometheus workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alertManagerDefinition(final java.lang.String alertManagerDefinition) {
            this.props().alertManagerDefinition(alertManagerDefinition);
            return this;
        }

        /**
         * The alias that is assigned to this workspace to help identify it.
         * <p>
         * It does not need to be unique.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-alias</a>
         * @param alias The alias that is assigned to this workspace to help identify it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alias(final java.lang.String alias) {
            this.props().alias(alias);
            return this;
        }

        /**
         * (optional) The ARN for a customer managed AWS KMS key to use for encrypting data within your workspace.
         * <p>
         * For more information about using your own key in your workspace, see <a href="https://docs.aws.amazon.com/prometheus/latest/userguide/encryption-at-rest-Amazon-Service-Prometheus.html">Encryption at rest</a> in the <em>Amazon Managed Service for Prometheus User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-kmskeyarn</a>
         * @param kmsKeyArn (optional) The ARN for a customer managed AWS KMS key to use for encrypting data within your workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(final java.lang.String kmsKeyArn) {
            this.props().kmsKeyArn(kmsKeyArn);
            return this;
        }

        /**
         * Contains information about the logging configuration for the workspace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-loggingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-loggingconfiguration</a>
         * @param loggingConfiguration Contains information about the logging configuration for the workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(final software.amazon.awscdk.IResolvable loggingConfiguration) {
            this.props().loggingConfiguration(loggingConfiguration);
            return this;
        }
        /**
         * Contains information about the logging configuration for the workspace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-loggingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-loggingconfiguration</a>
         * @param loggingConfiguration Contains information about the logging configuration for the workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(final software.amazon.awscdk.services.aps.CfnWorkspace.LoggingConfigurationProperty loggingConfiguration) {
            this.props().loggingConfiguration(loggingConfiguration);
            return this;
        }

        /**
         * The definition of logging configuration in an Amazon Managed Service for Prometheus workspace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-queryloggingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-queryloggingconfiguration</a>
         * @param queryLoggingConfiguration The definition of logging configuration in an Amazon Managed Service for Prometheus workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLoggingConfiguration(final software.amazon.awscdk.IResolvable queryLoggingConfiguration) {
            this.props().queryLoggingConfiguration(queryLoggingConfiguration);
            return this;
        }
        /**
         * The definition of logging configuration in an Amazon Managed Service for Prometheus workspace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-queryloggingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-queryloggingconfiguration</a>
         * @param queryLoggingConfiguration The definition of logging configuration in an Amazon Managed Service for Prometheus workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLoggingConfiguration(final software.amazon.awscdk.services.aps.CfnWorkspace.QueryLoggingConfigurationProperty queryLoggingConfiguration) {
            this.props().queryLoggingConfiguration(queryLoggingConfiguration);
            return this;
        }

        /**
         * The list of tag keys and values that are associated with the workspace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-tags</a>
         * @param tags The list of tag keys and values that are associated with the workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * Use this structure to define label sets and the ingestion limits for time series that match label sets, and to specify the retention period of the workspace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-workspaceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-workspaceconfiguration</a>
         * @param workspaceConfiguration Use this structure to define label sets and the ingestion limits for time series that match label sets, and to specify the retention period of the workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workspaceConfiguration(final software.amazon.awscdk.IResolvable workspaceConfiguration) {
            this.props().workspaceConfiguration(workspaceConfiguration);
            return this;
        }
        /**
         * Use this structure to define label sets and the ingestion limits for time series that match label sets, and to specify the retention period of the workspace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-workspaceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-workspaceconfiguration</a>
         * @param workspaceConfiguration Use this structure to define label sets and the ingestion limits for time series that match label sets, and to specify the retention period of the workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workspaceConfiguration(final software.amazon.awscdk.services.aps.CfnWorkspace.WorkspaceConfigurationProperty workspaceConfiguration) {
            this.props().workspaceConfiguration(workspaceConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.aps.CfnWorkspace}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.aps.CfnWorkspace build() {
            return new software.amazon.awscdk.services.aps.CfnWorkspace(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.aps.CfnWorkspaceProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.aps.CfnWorkspaceProps.Builder();
            }
            return this.props;
        }
    }
}
