package software.amazon.awscdk.services.autoscaling;

/**
 * A reference to a LifecycleHook resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * LifecycleHookReference lifecycleHookReference = LifecycleHookReference.builder()
 *         .autoScalingGroupName("autoScalingGroupName")
 *         .lifecycleHookName("lifecycleHookName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:58.889Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.LifecycleHookReference")
@software.amazon.jsii.Jsii.Proxy(LifecycleHookReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LifecycleHookReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AutoScalingGroupName of the LifecycleHook resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupName();

    /**
     * The LifecycleHookName of the LifecycleHook resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLifecycleHookName();

    /**
     * @return a {@link Builder} of {@link LifecycleHookReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LifecycleHookReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LifecycleHookReference> {
        java.lang.String autoScalingGroupName;
        java.lang.String lifecycleHookName;

        /**
         * Sets the value of {@link LifecycleHookReference#getAutoScalingGroupName}
         * @param autoScalingGroupName The AutoScalingGroupName of the LifecycleHook resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupName(java.lang.String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleHookReference#getLifecycleHookName}
         * @param lifecycleHookName The LifecycleHookName of the LifecycleHook resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleHookName(java.lang.String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LifecycleHookReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LifecycleHookReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LifecycleHookReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LifecycleHookReference {
        private final java.lang.String autoScalingGroupName;
        private final java.lang.String lifecycleHookName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoScalingGroupName = software.amazon.jsii.Kernel.get(this, "autoScalingGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lifecycleHookName = software.amazon.jsii.Kernel.get(this, "lifecycleHookName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoScalingGroupName = java.util.Objects.requireNonNull(builder.autoScalingGroupName, "autoScalingGroupName is required");
            this.lifecycleHookName = java.util.Objects.requireNonNull(builder.lifecycleHookName, "lifecycleHookName is required");
        }

        @Override
        public final java.lang.String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final java.lang.String getLifecycleHookName() {
            return this.lifecycleHookName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("autoScalingGroupName", om.valueToTree(this.getAutoScalingGroupName()));
            data.set("lifecycleHookName", om.valueToTree(this.getLifecycleHookName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.LifecycleHookReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LifecycleHookReference.Jsii$Proxy that = (LifecycleHookReference.Jsii$Proxy) o;

            if (!autoScalingGroupName.equals(that.autoScalingGroupName)) return false;
            return this.lifecycleHookName.equals(that.lifecycleHookName);
        }

        @Override
        public final int hashCode() {
            int result = this.autoScalingGroupName.hashCode();
            result = 31 * result + (this.lifecycleHookName.hashCode());
            return result;
        }
    }
}
