package software.amazon.awscdk.services.autoscaling;

/**
 * A reference to a ScalingPolicy resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * ScalingPolicyReference scalingPolicyReference = ScalingPolicyReference.builder()
 *         .scalingPolicyArn("scalingPolicyArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:58.895Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.ScalingPolicyReference")
@software.amazon.jsii.Jsii.Proxy(ScalingPolicyReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ScalingPolicyReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the ScalingPolicy resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScalingPolicyArn();

    /**
     * @return a {@link Builder} of {@link ScalingPolicyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScalingPolicyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ScalingPolicyReference> {
        java.lang.String scalingPolicyArn;

        /**
         * Sets the value of {@link ScalingPolicyReference#getScalingPolicyArn}
         * @param scalingPolicyArn The Arn of the ScalingPolicy resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingPolicyArn(java.lang.String scalingPolicyArn) {
            this.scalingPolicyArn = scalingPolicyArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScalingPolicyReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ScalingPolicyReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ScalingPolicyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingPolicyReference {
        private final java.lang.String scalingPolicyArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.scalingPolicyArn = software.amazon.jsii.Kernel.get(this, "scalingPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.scalingPolicyArn = java.util.Objects.requireNonNull(builder.scalingPolicyArn, "scalingPolicyArn is required");
        }

        @Override
        public final java.lang.String getScalingPolicyArn() {
            return this.scalingPolicyArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("scalingPolicyArn", om.valueToTree(this.getScalingPolicyArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.ScalingPolicyReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScalingPolicyReference.Jsii$Proxy that = (ScalingPolicyReference.Jsii$Proxy) o;

            return this.scalingPolicyArn.equals(that.scalingPolicyArn);
        }

        @Override
        public final int hashCode() {
            int result = this.scalingPolicyArn.hashCode();
            return result;
        }
    }
}
