package software.amazon.awscdk.services.autoscaling.hooktargets;

/**
 * Use a Lambda Function as a hook target.
 * <p>
 * Internally creates a Topic to make the connection.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.hooktargets.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.lambda.*;
 * Function function_;
 * Key key;
 * FunctionHook functionHook = new FunctionHook(function_, key);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:58.920Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling_hooktargets.FunctionHook")
public class FunctionHook extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget {

    protected FunctionHook(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FunctionHook(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param fn Function to invoke in response to a lifecycle event. This parameter is required.
     * @param encryptionKey If provided, this key is used to encrypt the contents of the SNS topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FunctionHook(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction fn, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey encryptionKey) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(fn, "fn is required"), encryptionKey });
    }

    /**
     * @param fn Function to invoke in response to a lifecycle event. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FunctionHook(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction fn) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(fn, "fn is required") });
    }

    /**
     * If the <code>IRole</code> does not exist in <code>options</code>, will create an <code>IRole</code> and an SNS Topic and attach both to the lifecycle hook.
     * <p>
     * If the <code>IRole</code> does exist in <code>options</code>, will only create an SNS Topic and attach it to the lifecycle hook.
     * <p>
     * @param _scope This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.LifecycleHookTargetConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BindHookTargetOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.LifecycleHookTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }
}
