package software.amazon.awscdk.services.b2bi;

/**
 * Creates a partnership between a customer and a trading partner, based on the supplied parameters.
 * <p>
 * A partnership represents the connection between you and your trading partner. It ties together a profile and one or more trading capabilities.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.b2bi.*;
 * CfnPartnership cfnPartnership = CfnPartnership.Builder.create(this, "MyCfnPartnership")
 *         .capabilities(List.of("capabilities"))
 *         .email("email")
 *         .name("name")
 *         .profileId("profileId")
 *         // the properties below are optional
 *         .capabilityOptions(CapabilityOptionsProperty.builder()
 *                 .inboundEdi(InboundEdiOptionsProperty.builder()
 *                         .x12(X12InboundEdiOptionsProperty.builder()
 *                                 .acknowledgmentOptions(X12AcknowledgmentOptionsProperty.builder()
 *                                         .functionalAcknowledgment("functionalAcknowledgment")
 *                                         .technicalAcknowledgment("technicalAcknowledgment")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .outboundEdi(OutboundEdiOptionsProperty.builder()
 *                         .x12(X12EnvelopeProperty.builder()
 *                                 .common(X12OutboundEdiHeadersProperty.builder()
 *                                         .controlNumbers(X12ControlNumbersProperty.builder()
 *                                                 .startingFunctionalGroupControlNumber(123)
 *                                                 .startingInterchangeControlNumber(123)
 *                                                 .startingTransactionSetControlNumber(123)
 *                                                 .build())
 *                                         .delimiters(X12DelimitersProperty.builder()
 *                                                 .componentSeparator("componentSeparator")
 *                                                 .dataElementSeparator("dataElementSeparator")
 *                                                 .segmentTerminator("segmentTerminator")
 *                                                 .build())
 *                                         .functionalGroupHeaders(X12FunctionalGroupHeadersProperty.builder()
 *                                                 .applicationReceiverCode("applicationReceiverCode")
 *                                                 .applicationSenderCode("applicationSenderCode")
 *                                                 .responsibleAgencyCode("responsibleAgencyCode")
 *                                                 .build())
 *                                         .gs05TimeFormat("gs05TimeFormat")
 *                                         .interchangeControlHeaders(X12InterchangeControlHeadersProperty.builder()
 *                                                 .acknowledgmentRequestedCode("acknowledgmentRequestedCode")
 *                                                 .receiverId("receiverId")
 *                                                 .receiverIdQualifier("receiverIdQualifier")
 *                                                 .repetitionSeparator("repetitionSeparator")
 *                                                 .senderId("senderId")
 *                                                 .senderIdQualifier("senderIdQualifier")
 *                                                 .usageIndicatorCode("usageIndicatorCode")
 *                                                 .build())
 *                                         .validateEdi(false)
 *                                         .build())
 *                                 .wrapOptions(WrapOptionsProperty.builder()
 *                                         .lineLength(123)
 *                                         .lineTerminator("lineTerminator")
 *                                         .wrapBy("wrapBy")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .phone("phone")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:58.938Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnPartnership")
public class CfnPartnership extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.b2bi.IPartnershipRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnPartnership(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPartnership(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.b2bi.CfnPartnership.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPartnership(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.b2bi.CfnPartnershipProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns a timestamp for creation date and time of the partnership.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns a timestamp that identifies the most recent date and time that the partnership was modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrModifiedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrModifiedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns an Amazon Resource Name (ARN) for a specific AWS resource, such as a capability, partnership, profile, or transformer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPartnershipArn() {
        return software.amazon.jsii.Kernel.get(this, "attrPartnershipArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the unique, system-generated identifier for a partnership.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPartnershipId() {
        return software.amazon.jsii.Kernel.get(this, "attrPartnershipId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the unique, system-generated identifier for a trading partner.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTradingPartnerId() {
        return software.amazon.jsii.Kernel.get(this, "attrTradingPartnerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a Partnership resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.b2bi.PartnershipReference getPartnershipRef() {
        return software.amazon.jsii.Kernel.get(this, "partnershipRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.b2bi.PartnershipReference.class));
    }

    /**
     * Returns one or more capabilities associated with this partnership.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCapabilities() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "capabilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Returns one or more capabilities associated with this partnership.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapabilities(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "capabilities", java.util.Objects.requireNonNull(value, "capabilities is required"));
    }

    /**
     * Specifies the email address associated with this trading partner.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEmail() {
        return software.amazon.jsii.Kernel.get(this, "email", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the email address associated with this trading partner.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEmail(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "email", java.util.Objects.requireNonNull(value, "email is required"));
    }

    /**
     * Returns the name of the partnership.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the name of the partnership.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Returns the unique, system-generated identifier for the profile connected to this partnership.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProfileId() {
        return software.amazon.jsii.Kernel.get(this, "profileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the unique, system-generated identifier for the profile connected to this partnership.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProfileId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "profileId", java.util.Objects.requireNonNull(value, "profileId is required"));
    }

    /**
     * Contains the details for an Outbound EDI capability.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.b2bi.CfnPartnership.CapabilityOptionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCapabilityOptions() {
        return software.amazon.jsii.Kernel.get(this, "capabilityOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains the details for an Outbound EDI capability.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapabilityOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "capabilityOptions", value);
    }

    /**
     * Contains the details for an Outbound EDI capability.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapabilityOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.b2bi.CfnPartnership.CapabilityOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "capabilityOptions", value);
    }

    /**
     * Specifies the phone number associated with the partnership.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPhone() {
        return software.amazon.jsii.Kernel.get(this, "phone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the phone number associated with the partnership.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPhone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "phone", value);
    }

    /**
     * A key-value pair for a specific partnership.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A key-value pair for a specific partnership.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Contains the details for an Outbound EDI capability.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * CapabilityOptionsProperty capabilityOptionsProperty = CapabilityOptionsProperty.builder()
     *         .inboundEdi(InboundEdiOptionsProperty.builder()
     *                 .x12(X12InboundEdiOptionsProperty.builder()
     *                         .acknowledgmentOptions(X12AcknowledgmentOptionsProperty.builder()
     *                                 .functionalAcknowledgment("functionalAcknowledgment")
     *                                 .technicalAcknowledgment("technicalAcknowledgment")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .outboundEdi(OutboundEdiOptionsProperty.builder()
     *                 .x12(X12EnvelopeProperty.builder()
     *                         .common(X12OutboundEdiHeadersProperty.builder()
     *                                 .controlNumbers(X12ControlNumbersProperty.builder()
     *                                         .startingFunctionalGroupControlNumber(123)
     *                                         .startingInterchangeControlNumber(123)
     *                                         .startingTransactionSetControlNumber(123)
     *                                         .build())
     *                                 .delimiters(X12DelimitersProperty.builder()
     *                                         .componentSeparator("componentSeparator")
     *                                         .dataElementSeparator("dataElementSeparator")
     *                                         .segmentTerminator("segmentTerminator")
     *                                         .build())
     *                                 .functionalGroupHeaders(X12FunctionalGroupHeadersProperty.builder()
     *                                         .applicationReceiverCode("applicationReceiverCode")
     *                                         .applicationSenderCode("applicationSenderCode")
     *                                         .responsibleAgencyCode("responsibleAgencyCode")
     *                                         .build())
     *                                 .gs05TimeFormat("gs05TimeFormat")
     *                                 .interchangeControlHeaders(X12InterchangeControlHeadersProperty.builder()
     *                                         .acknowledgmentRequestedCode("acknowledgmentRequestedCode")
     *                                         .receiverId("receiverId")
     *                                         .receiverIdQualifier("receiverIdQualifier")
     *                                         .repetitionSeparator("repetitionSeparator")
     *                                         .senderId("senderId")
     *                                         .senderIdQualifier("senderIdQualifier")
     *                                         .usageIndicatorCode("usageIndicatorCode")
     *                                         .build())
     *                                 .validateEdi(false)
     *                                 .build())
     *                         .wrapOptions(WrapOptionsProperty.builder()
     *                                 .lineLength(123)
     *                                 .lineTerminator("lineTerminator")
     *                                 .wrapBy("wrapBy")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-capabilityoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-capabilityoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnPartnership.CapabilityOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(CapabilityOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapabilityOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A structure that contains the inbound EDI options for the capability.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.b2bi.CfnPartnership.InboundEdiOptionsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-capabilityoptions.html#cfn-b2bi-partnership-capabilityoptions-inboundedi">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-capabilityoptions.html#cfn-b2bi-partnership-capabilityoptions-inboundedi</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInboundEdi() {
            return null;
        }

        /**
         * A structure that contains the outbound EDI options.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.b2bi.CfnPartnership.OutboundEdiOptionsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-capabilityoptions.html#cfn-b2bi-partnership-capabilityoptions-outboundedi">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-capabilityoptions.html#cfn-b2bi-partnership-capabilityoptions-outboundedi</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutboundEdi() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapabilityOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapabilityOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapabilityOptionsProperty> {
            java.lang.Object inboundEdi;
            java.lang.Object outboundEdi;

            /**
             * Sets the value of {@link CapabilityOptionsProperty#getInboundEdi}
             * @param inboundEdi A structure that contains the inbound EDI options for the capability.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inboundEdi(software.amazon.awscdk.IResolvable inboundEdi) {
                this.inboundEdi = inboundEdi;
                return this;
            }

            /**
             * Sets the value of {@link CapabilityOptionsProperty#getInboundEdi}
             * @param inboundEdi A structure that contains the inbound EDI options for the capability.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inboundEdi(software.amazon.awscdk.services.b2bi.CfnPartnership.InboundEdiOptionsProperty inboundEdi) {
                this.inboundEdi = inboundEdi;
                return this;
            }

            /**
             * Sets the value of {@link CapabilityOptionsProperty#getOutboundEdi}
             * @param outboundEdi A structure that contains the outbound EDI options.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundEdi(software.amazon.awscdk.IResolvable outboundEdi) {
                this.outboundEdi = outboundEdi;
                return this;
            }

            /**
             * Sets the value of {@link CapabilityOptionsProperty#getOutboundEdi}
             * @param outboundEdi A structure that contains the outbound EDI options.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundEdi(software.amazon.awscdk.services.b2bi.CfnPartnership.OutboundEdiOptionsProperty outboundEdi) {
                this.outboundEdi = outboundEdi;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapabilityOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapabilityOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapabilityOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapabilityOptionsProperty {
            private final java.lang.Object inboundEdi;
            private final java.lang.Object outboundEdi;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inboundEdi = software.amazon.jsii.Kernel.get(this, "inboundEdi", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outboundEdi = software.amazon.jsii.Kernel.get(this, "outboundEdi", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inboundEdi = builder.inboundEdi;
                this.outboundEdi = builder.outboundEdi;
            }

            @Override
            public final java.lang.Object getInboundEdi() {
                return this.inboundEdi;
            }

            @Override
            public final java.lang.Object getOutboundEdi() {
                return this.outboundEdi;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInboundEdi() != null) {
                    data.set("inboundEdi", om.valueToTree(this.getInboundEdi()));
                }
                if (this.getOutboundEdi() != null) {
                    data.set("outboundEdi", om.valueToTree(this.getOutboundEdi()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnPartnership.CapabilityOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapabilityOptionsProperty.Jsii$Proxy that = (CapabilityOptionsProperty.Jsii$Proxy) o;

                if (this.inboundEdi != null ? !this.inboundEdi.equals(that.inboundEdi) : that.inboundEdi != null) return false;
                return this.outboundEdi != null ? this.outboundEdi.equals(that.outboundEdi) : that.outboundEdi == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inboundEdi != null ? this.inboundEdi.hashCode() : 0;
                result = 31 * result + (this.outboundEdi != null ? this.outboundEdi.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains options for processing inbound EDI files.
     * <p>
     * These options allow for customizing how incoming EDI documents are processed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * InboundEdiOptionsProperty inboundEdiOptionsProperty = InboundEdiOptionsProperty.builder()
     *         .x12(X12InboundEdiOptionsProperty.builder()
     *                 .acknowledgmentOptions(X12AcknowledgmentOptionsProperty.builder()
     *                         .functionalAcknowledgment("functionalAcknowledgment")
     *                         .technicalAcknowledgment("technicalAcknowledgment")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-inboundedioptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-inboundedioptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnPartnership.InboundEdiOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(InboundEdiOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InboundEdiOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A structure that contains X12-specific options for processing inbound X12 EDI files.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.b2bi.CfnPartnership.X12InboundEdiOptionsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-inboundedioptions.html#cfn-b2bi-partnership-inboundedioptions-x12">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-inboundedioptions.html#cfn-b2bi-partnership-inboundedioptions-x12</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getX12() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InboundEdiOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InboundEdiOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InboundEdiOptionsProperty> {
            java.lang.Object x12;

            /**
             * Sets the value of {@link InboundEdiOptionsProperty#getX12}
             * @param x12 A structure that contains X12-specific options for processing inbound X12 EDI files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder x12(software.amazon.awscdk.IResolvable x12) {
                this.x12 = x12;
                return this;
            }

            /**
             * Sets the value of {@link InboundEdiOptionsProperty#getX12}
             * @param x12 A structure that contains X12-specific options for processing inbound X12 EDI files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder x12(software.amazon.awscdk.services.b2bi.CfnPartnership.X12InboundEdiOptionsProperty x12) {
                this.x12 = x12;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InboundEdiOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InboundEdiOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InboundEdiOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InboundEdiOptionsProperty {
            private final java.lang.Object x12;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.x12 = software.amazon.jsii.Kernel.get(this, "x12", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.x12 = builder.x12;
            }

            @Override
            public final java.lang.Object getX12() {
                return this.x12;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getX12() != null) {
                    data.set("x12", om.valueToTree(this.getX12()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnPartnership.InboundEdiOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InboundEdiOptionsProperty.Jsii$Proxy that = (InboundEdiOptionsProperty.Jsii$Proxy) o;

                return this.x12 != null ? this.x12.equals(that.x12) : that.x12 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.x12 != null ? this.x12.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A container for outbound EDI options.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * OutboundEdiOptionsProperty outboundEdiOptionsProperty = OutboundEdiOptionsProperty.builder()
     *         .x12(X12EnvelopeProperty.builder()
     *                 .common(X12OutboundEdiHeadersProperty.builder()
     *                         .controlNumbers(X12ControlNumbersProperty.builder()
     *                                 .startingFunctionalGroupControlNumber(123)
     *                                 .startingInterchangeControlNumber(123)
     *                                 .startingTransactionSetControlNumber(123)
     *                                 .build())
     *                         .delimiters(X12DelimitersProperty.builder()
     *                                 .componentSeparator("componentSeparator")
     *                                 .dataElementSeparator("dataElementSeparator")
     *                                 .segmentTerminator("segmentTerminator")
     *                                 .build())
     *                         .functionalGroupHeaders(X12FunctionalGroupHeadersProperty.builder()
     *                                 .applicationReceiverCode("applicationReceiverCode")
     *                                 .applicationSenderCode("applicationSenderCode")
     *                                 .responsibleAgencyCode("responsibleAgencyCode")
     *                                 .build())
     *                         .gs05TimeFormat("gs05TimeFormat")
     *                         .interchangeControlHeaders(X12InterchangeControlHeadersProperty.builder()
     *                                 .acknowledgmentRequestedCode("acknowledgmentRequestedCode")
     *                                 .receiverId("receiverId")
     *                                 .receiverIdQualifier("receiverIdQualifier")
     *                                 .repetitionSeparator("repetitionSeparator")
     *                                 .senderId("senderId")
     *                                 .senderIdQualifier("senderIdQualifier")
     *                                 .usageIndicatorCode("usageIndicatorCode")
     *                                 .build())
     *                         .validateEdi(false)
     *                         .build())
     *                 .wrapOptions(WrapOptionsProperty.builder()
     *                         .lineLength(123)
     *                         .lineTerminator("lineTerminator")
     *                         .wrapBy("wrapBy")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-outboundedioptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-outboundedioptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnPartnership.OutboundEdiOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(OutboundEdiOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutboundEdiOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A structure that contains an X12 envelope structure.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.b2bi.CfnPartnership.X12EnvelopeProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-outboundedioptions.html#cfn-b2bi-partnership-outboundedioptions-x12">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-outboundedioptions.html#cfn-b2bi-partnership-outboundedioptions-x12</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getX12();

        /**
         * @return a {@link Builder} of {@link OutboundEdiOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutboundEdiOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutboundEdiOptionsProperty> {
            java.lang.Object x12;

            /**
             * Sets the value of {@link OutboundEdiOptionsProperty#getX12}
             * @param x12 A structure that contains an X12 envelope structure. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder x12(software.amazon.awscdk.IResolvable x12) {
                this.x12 = x12;
                return this;
            }

            /**
             * Sets the value of {@link OutboundEdiOptionsProperty#getX12}
             * @param x12 A structure that contains an X12 envelope structure. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder x12(software.amazon.awscdk.services.b2bi.CfnPartnership.X12EnvelopeProperty x12) {
                this.x12 = x12;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutboundEdiOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutboundEdiOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutboundEdiOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutboundEdiOptionsProperty {
            private final java.lang.Object x12;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.x12 = software.amazon.jsii.Kernel.get(this, "x12", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.x12 = java.util.Objects.requireNonNull(builder.x12, "x12 is required");
            }

            @Override
            public final java.lang.Object getX12() {
                return this.x12;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("x12", om.valueToTree(this.getX12()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnPartnership.OutboundEdiOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutboundEdiOptionsProperty.Jsii$Proxy that = (OutboundEdiOptionsProperty.Jsii$Proxy) o;

                return this.x12.equals(that.x12);
            }

            @Override
            public final int hashCode() {
                int result = this.x12.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains options for wrapping (line folding) in X12 EDI files.
     * <p>
     * Wrapping controls how long lines are handled in the EDI output.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * WrapOptionsProperty wrapOptionsProperty = WrapOptionsProperty.builder()
     *         .lineLength(123)
     *         .lineTerminator("lineTerminator")
     *         .wrapBy("wrapBy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-wrapoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-wrapoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnPartnership.WrapOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(WrapOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WrapOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the maximum length of a line before wrapping occurs.
         * <p>
         * This value is used when <code>wrapBy</code> is set to <code>LINE_LENGTH</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-wrapoptions.html#cfn-b2bi-partnership-wrapoptions-linelength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-wrapoptions.html#cfn-b2bi-partnership-wrapoptions-linelength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLineLength() {
            return null;
        }

        /**
         * Specifies the character sequence used to terminate lines when wrapping. Valid values:.
         * <p>
         * <ul>
         * <li><code>CRLF</code> : carriage return and line feed</li>
         * <li><code>LF</code> : line feed)</li>
         * <li><code>CR</code> : carriage return</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-wrapoptions.html#cfn-b2bi-partnership-wrapoptions-lineterminator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-wrapoptions.html#cfn-b2bi-partnership-wrapoptions-lineterminator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLineTerminator() {
            return null;
        }

        /**
         * Specifies the method used for wrapping lines in the EDI output. Valid values:.
         * <p>
         * <ul>
         * <li><code>SEGMENT</code> : Wraps by segment.</li>
         * <li><code>ONE_LINE</code> : Indicates that the entire content is on a single line.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * When you specify <code>ONE_LINE</code> , do not provide either the line length nor the line terminator value.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><code>LINE_LENGTH</code> : Wraps by character count, as specified by <code>lineLength</code> value.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-wrapoptions.html#cfn-b2bi-partnership-wrapoptions-wrapby">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-wrapoptions.html#cfn-b2bi-partnership-wrapoptions-wrapby</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWrapBy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WrapOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WrapOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WrapOptionsProperty> {
            java.lang.Number lineLength;
            java.lang.String lineTerminator;
            java.lang.String wrapBy;

            /**
             * Sets the value of {@link WrapOptionsProperty#getLineLength}
             * @param lineLength Specifies the maximum length of a line before wrapping occurs.
             *                   This value is used when <code>wrapBy</code> is set to <code>LINE_LENGTH</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lineLength(java.lang.Number lineLength) {
                this.lineLength = lineLength;
                return this;
            }

            /**
             * Sets the value of {@link WrapOptionsProperty#getLineTerminator}
             * @param lineTerminator Specifies the character sequence used to terminate lines when wrapping. Valid values:.
             *                       <ul>
             *                       <li><code>CRLF</code> : carriage return and line feed</li>
             *                       <li><code>LF</code> : line feed)</li>
             *                       <li><code>CR</code> : carriage return</li>
             *                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lineTerminator(java.lang.String lineTerminator) {
                this.lineTerminator = lineTerminator;
                return this;
            }

            /**
             * Sets the value of {@link WrapOptionsProperty#getWrapBy}
             * @param wrapBy Specifies the method used for wrapping lines in the EDI output. Valid values:.
             *               <ul>
             *               <li><code>SEGMENT</code> : Wraps by segment.</li>
             *               <li><code>ONE_LINE</code> : Indicates that the entire content is on a single line.</li>
             *               </ul>
             *               <p>
             *               <blockquote>
             *               <p>
             *               When you specify <code>ONE_LINE</code> , do not provide either the line length nor the line terminator value.
             *               <p>
             *               </blockquote>
             *               <p>
             *               <ul>
             *               <li><code>LINE_LENGTH</code> : Wraps by character count, as specified by <code>lineLength</code> value.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder wrapBy(java.lang.String wrapBy) {
                this.wrapBy = wrapBy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WrapOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WrapOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WrapOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WrapOptionsProperty {
            private final java.lang.Number lineLength;
            private final java.lang.String lineTerminator;
            private final java.lang.String wrapBy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lineLength = software.amazon.jsii.Kernel.get(this, "lineLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.lineTerminator = software.amazon.jsii.Kernel.get(this, "lineTerminator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.wrapBy = software.amazon.jsii.Kernel.get(this, "wrapBy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lineLength = builder.lineLength;
                this.lineTerminator = builder.lineTerminator;
                this.wrapBy = builder.wrapBy;
            }

            @Override
            public final java.lang.Number getLineLength() {
                return this.lineLength;
            }

            @Override
            public final java.lang.String getLineTerminator() {
                return this.lineTerminator;
            }

            @Override
            public final java.lang.String getWrapBy() {
                return this.wrapBy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLineLength() != null) {
                    data.set("lineLength", om.valueToTree(this.getLineLength()));
                }
                if (this.getLineTerminator() != null) {
                    data.set("lineTerminator", om.valueToTree(this.getLineTerminator()));
                }
                if (this.getWrapBy() != null) {
                    data.set("wrapBy", om.valueToTree(this.getWrapBy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnPartnership.WrapOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WrapOptionsProperty.Jsii$Proxy that = (WrapOptionsProperty.Jsii$Proxy) o;

                if (this.lineLength != null ? !this.lineLength.equals(that.lineLength) : that.lineLength != null) return false;
                if (this.lineTerminator != null ? !this.lineTerminator.equals(that.lineTerminator) : that.lineTerminator != null) return false;
                return this.wrapBy != null ? this.wrapBy.equals(that.wrapBy) : that.wrapBy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.lineLength != null ? this.lineLength.hashCode() : 0;
                result = 31 * result + (this.lineTerminator != null ? this.lineTerminator.hashCode() : 0);
                result = 31 * result + (this.wrapBy != null ? this.wrapBy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains options for configuring X12 acknowledgments.
     * <p>
     * These options control how functional and technical acknowledgments are handled.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * X12AcknowledgmentOptionsProperty x12AcknowledgmentOptionsProperty = X12AcknowledgmentOptionsProperty.builder()
     *         .functionalAcknowledgment("functionalAcknowledgment")
     *         .technicalAcknowledgment("technicalAcknowledgment")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12acknowledgmentoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12acknowledgmentoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnPartnership.X12AcknowledgmentOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(X12AcknowledgmentOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface X12AcknowledgmentOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether functional acknowledgments (997/999) should be generated for incoming X12 transactions.
         * <p>
         * Valid values are <code>DO_NOT_GENERATE</code> , <code>GENERATE_ALL_SEGMENTS</code> and <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code> .
         * <p>
         * If you choose <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code> , AWS B2B Data Interchange skips the AK2_Loop when generating an acknowledgment document.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12acknowledgmentoptions.html#cfn-b2bi-partnership-x12acknowledgmentoptions-functionalacknowledgment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12acknowledgmentoptions.html#cfn-b2bi-partnership-x12acknowledgmentoptions-functionalacknowledgment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFunctionalAcknowledgment();

        /**
         * Specifies whether technical acknowledgments (TA1) should be generated for incoming X12 interchanges.
         * <p>
         * Valid values are <code>DO_NOT_GENERATE</code> and <code>GENERATE_ALL_SEGMENTS</code> and.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12acknowledgmentoptions.html#cfn-b2bi-partnership-x12acknowledgmentoptions-technicalacknowledgment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12acknowledgmentoptions.html#cfn-b2bi-partnership-x12acknowledgmentoptions-technicalacknowledgment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTechnicalAcknowledgment();

        /**
         * @return a {@link Builder} of {@link X12AcknowledgmentOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link X12AcknowledgmentOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<X12AcknowledgmentOptionsProperty> {
            java.lang.String functionalAcknowledgment;
            java.lang.String technicalAcknowledgment;

            /**
             * Sets the value of {@link X12AcknowledgmentOptionsProperty#getFunctionalAcknowledgment}
             * @param functionalAcknowledgment Specifies whether functional acknowledgments (997/999) should be generated for incoming X12 transactions. This parameter is required.
             *                                 Valid values are <code>DO_NOT_GENERATE</code> , <code>GENERATE_ALL_SEGMENTS</code> and <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code> .
             *                                 <p>
             *                                 If you choose <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code> , AWS B2B Data Interchange skips the AK2_Loop when generating an acknowledgment document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionalAcknowledgment(java.lang.String functionalAcknowledgment) {
                this.functionalAcknowledgment = functionalAcknowledgment;
                return this;
            }

            /**
             * Sets the value of {@link X12AcknowledgmentOptionsProperty#getTechnicalAcknowledgment}
             * @param technicalAcknowledgment Specifies whether technical acknowledgments (TA1) should be generated for incoming X12 interchanges. This parameter is required.
             *                                Valid values are <code>DO_NOT_GENERATE</code> and <code>GENERATE_ALL_SEGMENTS</code> and.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder technicalAcknowledgment(java.lang.String technicalAcknowledgment) {
                this.technicalAcknowledgment = technicalAcknowledgment;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link X12AcknowledgmentOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public X12AcknowledgmentOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link X12AcknowledgmentOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements X12AcknowledgmentOptionsProperty {
            private final java.lang.String functionalAcknowledgment;
            private final java.lang.String technicalAcknowledgment;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.functionalAcknowledgment = software.amazon.jsii.Kernel.get(this, "functionalAcknowledgment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.technicalAcknowledgment = software.amazon.jsii.Kernel.get(this, "technicalAcknowledgment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.functionalAcknowledgment = java.util.Objects.requireNonNull(builder.functionalAcknowledgment, "functionalAcknowledgment is required");
                this.technicalAcknowledgment = java.util.Objects.requireNonNull(builder.technicalAcknowledgment, "technicalAcknowledgment is required");
            }

            @Override
            public final java.lang.String getFunctionalAcknowledgment() {
                return this.functionalAcknowledgment;
            }

            @Override
            public final java.lang.String getTechnicalAcknowledgment() {
                return this.technicalAcknowledgment;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("functionalAcknowledgment", om.valueToTree(this.getFunctionalAcknowledgment()));
                data.set("technicalAcknowledgment", om.valueToTree(this.getTechnicalAcknowledgment()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnPartnership.X12AcknowledgmentOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                X12AcknowledgmentOptionsProperty.Jsii$Proxy that = (X12AcknowledgmentOptionsProperty.Jsii$Proxy) o;

                if (!functionalAcknowledgment.equals(that.functionalAcknowledgment)) return false;
                return this.technicalAcknowledgment.equals(that.technicalAcknowledgment);
            }

            @Override
            public final int hashCode() {
                int result = this.functionalAcknowledgment.hashCode();
                result = 31 * result + (this.technicalAcknowledgment.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains configuration for X12 control numbers used in X12 EDI generation.
     * <p>
     * Control numbers are used to uniquely identify interchanges, functional groups, and transaction sets.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * X12ControlNumbersProperty x12ControlNumbersProperty = X12ControlNumbersProperty.builder()
     *         .startingFunctionalGroupControlNumber(123)
     *         .startingInterchangeControlNumber(123)
     *         .startingTransactionSetControlNumber(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12controlnumbers.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12controlnumbers.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnPartnership.X12ControlNumbersProperty")
    @software.amazon.jsii.Jsii.Proxy(X12ControlNumbersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface X12ControlNumbersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the starting functional group control number (GS06) to use for X12 EDI generation.
         * <p>
         * This number is incremented for each new functional group. For the GS (functional group) envelope, AWS B2B Data Interchange generates a functional group control number that is unique to the sender ID, receiver ID, and functional identifier code combination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12controlnumbers.html#cfn-b2bi-partnership-x12controlnumbers-startingfunctionalgroupcontrolnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12controlnumbers.html#cfn-b2bi-partnership-x12controlnumbers-startingfunctionalgroupcontrolnumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStartingFunctionalGroupControlNumber() {
            return null;
        }

        /**
         * Specifies the starting interchange control number (ISA13) to use for X12 EDI generation.
         * <p>
         * This number is incremented for each new interchange. For the ISA (interchange) envelope, AWS B2B Data Interchange generates an interchange control number that is unique for the ISA05 and ISA06 (sender) &amp; ISA07 and ISA08 (receiver) combination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12controlnumbers.html#cfn-b2bi-partnership-x12controlnumbers-startinginterchangecontrolnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12controlnumbers.html#cfn-b2bi-partnership-x12controlnumbers-startinginterchangecontrolnumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStartingInterchangeControlNumber() {
            return null;
        }

        /**
         * Specifies the starting transaction set control number (ST02) to use for X12 EDI generation.
         * <p>
         * This number is incremented for each new transaction set.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12controlnumbers.html#cfn-b2bi-partnership-x12controlnumbers-startingtransactionsetcontrolnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12controlnumbers.html#cfn-b2bi-partnership-x12controlnumbers-startingtransactionsetcontrolnumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStartingTransactionSetControlNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link X12ControlNumbersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link X12ControlNumbersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<X12ControlNumbersProperty> {
            java.lang.Number startingFunctionalGroupControlNumber;
            java.lang.Number startingInterchangeControlNumber;
            java.lang.Number startingTransactionSetControlNumber;

            /**
             * Sets the value of {@link X12ControlNumbersProperty#getStartingFunctionalGroupControlNumber}
             * @param startingFunctionalGroupControlNumber Specifies the starting functional group control number (GS06) to use for X12 EDI generation.
             *                                             This number is incremented for each new functional group. For the GS (functional group) envelope, AWS B2B Data Interchange generates a functional group control number that is unique to the sender ID, receiver ID, and functional identifier code combination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startingFunctionalGroupControlNumber(java.lang.Number startingFunctionalGroupControlNumber) {
                this.startingFunctionalGroupControlNumber = startingFunctionalGroupControlNumber;
                return this;
            }

            /**
             * Sets the value of {@link X12ControlNumbersProperty#getStartingInterchangeControlNumber}
             * @param startingInterchangeControlNumber Specifies the starting interchange control number (ISA13) to use for X12 EDI generation.
             *                                         This number is incremented for each new interchange. For the ISA (interchange) envelope, AWS B2B Data Interchange generates an interchange control number that is unique for the ISA05 and ISA06 (sender) &amp; ISA07 and ISA08 (receiver) combination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startingInterchangeControlNumber(java.lang.Number startingInterchangeControlNumber) {
                this.startingInterchangeControlNumber = startingInterchangeControlNumber;
                return this;
            }

            /**
             * Sets the value of {@link X12ControlNumbersProperty#getStartingTransactionSetControlNumber}
             * @param startingTransactionSetControlNumber Specifies the starting transaction set control number (ST02) to use for X12 EDI generation.
             *                                            This number is incremented for each new transaction set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startingTransactionSetControlNumber(java.lang.Number startingTransactionSetControlNumber) {
                this.startingTransactionSetControlNumber = startingTransactionSetControlNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link X12ControlNumbersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public X12ControlNumbersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link X12ControlNumbersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements X12ControlNumbersProperty {
            private final java.lang.Number startingFunctionalGroupControlNumber;
            private final java.lang.Number startingInterchangeControlNumber;
            private final java.lang.Number startingTransactionSetControlNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.startingFunctionalGroupControlNumber = software.amazon.jsii.Kernel.get(this, "startingFunctionalGroupControlNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.startingInterchangeControlNumber = software.amazon.jsii.Kernel.get(this, "startingInterchangeControlNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.startingTransactionSetControlNumber = software.amazon.jsii.Kernel.get(this, "startingTransactionSetControlNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.startingFunctionalGroupControlNumber = builder.startingFunctionalGroupControlNumber;
                this.startingInterchangeControlNumber = builder.startingInterchangeControlNumber;
                this.startingTransactionSetControlNumber = builder.startingTransactionSetControlNumber;
            }

            @Override
            public final java.lang.Number getStartingFunctionalGroupControlNumber() {
                return this.startingFunctionalGroupControlNumber;
            }

            @Override
            public final java.lang.Number getStartingInterchangeControlNumber() {
                return this.startingInterchangeControlNumber;
            }

            @Override
            public final java.lang.Number getStartingTransactionSetControlNumber() {
                return this.startingTransactionSetControlNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStartingFunctionalGroupControlNumber() != null) {
                    data.set("startingFunctionalGroupControlNumber", om.valueToTree(this.getStartingFunctionalGroupControlNumber()));
                }
                if (this.getStartingInterchangeControlNumber() != null) {
                    data.set("startingInterchangeControlNumber", om.valueToTree(this.getStartingInterchangeControlNumber()));
                }
                if (this.getStartingTransactionSetControlNumber() != null) {
                    data.set("startingTransactionSetControlNumber", om.valueToTree(this.getStartingTransactionSetControlNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnPartnership.X12ControlNumbersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                X12ControlNumbersProperty.Jsii$Proxy that = (X12ControlNumbersProperty.Jsii$Proxy) o;

                if (this.startingFunctionalGroupControlNumber != null ? !this.startingFunctionalGroupControlNumber.equals(that.startingFunctionalGroupControlNumber) : that.startingFunctionalGroupControlNumber != null) return false;
                if (this.startingInterchangeControlNumber != null ? !this.startingInterchangeControlNumber.equals(that.startingInterchangeControlNumber) : that.startingInterchangeControlNumber != null) return false;
                return this.startingTransactionSetControlNumber != null ? this.startingTransactionSetControlNumber.equals(that.startingTransactionSetControlNumber) : that.startingTransactionSetControlNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.startingFunctionalGroupControlNumber != null ? this.startingFunctionalGroupControlNumber.hashCode() : 0;
                result = 31 * result + (this.startingInterchangeControlNumber != null ? this.startingInterchangeControlNumber.hashCode() : 0);
                result = 31 * result + (this.startingTransactionSetControlNumber != null ? this.startingTransactionSetControlNumber.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * In X12 EDI messages, delimiters are used to mark the end of segments or elements, and are defined in the interchange control header.
     * <p>
     * The delimiters are part of the message's syntax and divide up its different elements.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * X12DelimitersProperty x12DelimitersProperty = X12DelimitersProperty.builder()
     *         .componentSeparator("componentSeparator")
     *         .dataElementSeparator("dataElementSeparator")
     *         .segmentTerminator("segmentTerminator")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12delimiters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12delimiters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnPartnership.X12DelimitersProperty")
    @software.amazon.jsii.Jsii.Proxy(X12DelimitersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface X12DelimitersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The component, or sub-element, separator.
         * <p>
         * The default value is <code>:</code> (colon).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12delimiters.html#cfn-b2bi-partnership-x12delimiters-componentseparator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12delimiters.html#cfn-b2bi-partnership-x12delimiters-componentseparator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentSeparator() {
            return null;
        }

        /**
         * The data element separator.
         * <p>
         * The default value is <code>*</code> (asterisk).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12delimiters.html#cfn-b2bi-partnership-x12delimiters-dataelementseparator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12delimiters.html#cfn-b2bi-partnership-x12delimiters-dataelementseparator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataElementSeparator() {
            return null;
        }

        /**
         * The segment terminator.
         * <p>
         * The default value is <code>~</code> (tilde).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12delimiters.html#cfn-b2bi-partnership-x12delimiters-segmentterminator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12delimiters.html#cfn-b2bi-partnership-x12delimiters-segmentterminator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSegmentTerminator() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link X12DelimitersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link X12DelimitersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<X12DelimitersProperty> {
            java.lang.String componentSeparator;
            java.lang.String dataElementSeparator;
            java.lang.String segmentTerminator;

            /**
             * Sets the value of {@link X12DelimitersProperty#getComponentSeparator}
             * @param componentSeparator The component, or sub-element, separator.
             *                           The default value is <code>:</code> (colon).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentSeparator(java.lang.String componentSeparator) {
                this.componentSeparator = componentSeparator;
                return this;
            }

            /**
             * Sets the value of {@link X12DelimitersProperty#getDataElementSeparator}
             * @param dataElementSeparator The data element separator.
             *                             The default value is <code>*</code> (asterisk).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataElementSeparator(java.lang.String dataElementSeparator) {
                this.dataElementSeparator = dataElementSeparator;
                return this;
            }

            /**
             * Sets the value of {@link X12DelimitersProperty#getSegmentTerminator}
             * @param segmentTerminator The segment terminator.
             *                          The default value is <code>~</code> (tilde).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentTerminator(java.lang.String segmentTerminator) {
                this.segmentTerminator = segmentTerminator;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link X12DelimitersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public X12DelimitersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link X12DelimitersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements X12DelimitersProperty {
            private final java.lang.String componentSeparator;
            private final java.lang.String dataElementSeparator;
            private final java.lang.String segmentTerminator;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.componentSeparator = software.amazon.jsii.Kernel.get(this, "componentSeparator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataElementSeparator = software.amazon.jsii.Kernel.get(this, "dataElementSeparator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.segmentTerminator = software.amazon.jsii.Kernel.get(this, "segmentTerminator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.componentSeparator = builder.componentSeparator;
                this.dataElementSeparator = builder.dataElementSeparator;
                this.segmentTerminator = builder.segmentTerminator;
            }

            @Override
            public final java.lang.String getComponentSeparator() {
                return this.componentSeparator;
            }

            @Override
            public final java.lang.String getDataElementSeparator() {
                return this.dataElementSeparator;
            }

            @Override
            public final java.lang.String getSegmentTerminator() {
                return this.segmentTerminator;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComponentSeparator() != null) {
                    data.set("componentSeparator", om.valueToTree(this.getComponentSeparator()));
                }
                if (this.getDataElementSeparator() != null) {
                    data.set("dataElementSeparator", om.valueToTree(this.getDataElementSeparator()));
                }
                if (this.getSegmentTerminator() != null) {
                    data.set("segmentTerminator", om.valueToTree(this.getSegmentTerminator()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnPartnership.X12DelimitersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                X12DelimitersProperty.Jsii$Proxy that = (X12DelimitersProperty.Jsii$Proxy) o;

                if (this.componentSeparator != null ? !this.componentSeparator.equals(that.componentSeparator) : that.componentSeparator != null) return false;
                if (this.dataElementSeparator != null ? !this.dataElementSeparator.equals(that.dataElementSeparator) : that.dataElementSeparator != null) return false;
                return this.segmentTerminator != null ? this.segmentTerminator.equals(that.segmentTerminator) : that.segmentTerminator == null;
            }

            @Override
            public final int hashCode() {
                int result = this.componentSeparator != null ? this.componentSeparator.hashCode() : 0;
                result = 31 * result + (this.dataElementSeparator != null ? this.dataElementSeparator.hashCode() : 0);
                result = 31 * result + (this.segmentTerminator != null ? this.segmentTerminator.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A wrapper structure for an X12 definition object.
     * <p>
     * the X12 envelope ensures the integrity of the data and the efficiency of the information exchange. The X12 message structure has hierarchical levels. From highest to the lowest, they are:
     * <p>
     * <ul>
     * <li>Interchange Envelope</li>
     * <li>Functional Group</li>
     * <li>Transaction Set</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * X12EnvelopeProperty x12EnvelopeProperty = X12EnvelopeProperty.builder()
     *         .common(X12OutboundEdiHeadersProperty.builder()
     *                 .controlNumbers(X12ControlNumbersProperty.builder()
     *                         .startingFunctionalGroupControlNumber(123)
     *                         .startingInterchangeControlNumber(123)
     *                         .startingTransactionSetControlNumber(123)
     *                         .build())
     *                 .delimiters(X12DelimitersProperty.builder()
     *                         .componentSeparator("componentSeparator")
     *                         .dataElementSeparator("dataElementSeparator")
     *                         .segmentTerminator("segmentTerminator")
     *                         .build())
     *                 .functionalGroupHeaders(X12FunctionalGroupHeadersProperty.builder()
     *                         .applicationReceiverCode("applicationReceiverCode")
     *                         .applicationSenderCode("applicationSenderCode")
     *                         .responsibleAgencyCode("responsibleAgencyCode")
     *                         .build())
     *                 .gs05TimeFormat("gs05TimeFormat")
     *                 .interchangeControlHeaders(X12InterchangeControlHeadersProperty.builder()
     *                         .acknowledgmentRequestedCode("acknowledgmentRequestedCode")
     *                         .receiverId("receiverId")
     *                         .receiverIdQualifier("receiverIdQualifier")
     *                         .repetitionSeparator("repetitionSeparator")
     *                         .senderId("senderId")
     *                         .senderIdQualifier("senderIdQualifier")
     *                         .usageIndicatorCode("usageIndicatorCode")
     *                         .build())
     *                 .validateEdi(false)
     *                 .build())
     *         .wrapOptions(WrapOptionsProperty.builder()
     *                 .lineLength(123)
     *                 .lineTerminator("lineTerminator")
     *                 .wrapBy("wrapBy")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12envelope.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12envelope.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnPartnership.X12EnvelopeProperty")
    @software.amazon.jsii.Jsii.Proxy(X12EnvelopeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface X12EnvelopeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A container for the X12 outbound EDI headers.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.b2bi.CfnPartnership.X12OutboundEdiHeadersProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12envelope.html#cfn-b2bi-partnership-x12envelope-common">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12envelope.html#cfn-b2bi-partnership-x12envelope-common</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCommon() {
            return null;
        }

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.b2bi.CfnPartnership.WrapOptionsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12envelope.html#cfn-b2bi-partnership-x12envelope-wrapoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12envelope.html#cfn-b2bi-partnership-x12envelope-wrapoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWrapOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link X12EnvelopeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link X12EnvelopeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<X12EnvelopeProperty> {
            java.lang.Object common;
            java.lang.Object wrapOptions;

            /**
             * Sets the value of {@link X12EnvelopeProperty#getCommon}
             * @param common A container for the X12 outbound EDI headers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder common(software.amazon.awscdk.IResolvable common) {
                this.common = common;
                return this;
            }

            /**
             * Sets the value of {@link X12EnvelopeProperty#getCommon}
             * @param common A container for the X12 outbound EDI headers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder common(software.amazon.awscdk.services.b2bi.CfnPartnership.X12OutboundEdiHeadersProperty common) {
                this.common = common;
                return this;
            }

            /**
             * Sets the value of {@link X12EnvelopeProperty#getWrapOptions}
             * @param wrapOptions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder wrapOptions(software.amazon.awscdk.IResolvable wrapOptions) {
                this.wrapOptions = wrapOptions;
                return this;
            }

            /**
             * Sets the value of {@link X12EnvelopeProperty#getWrapOptions}
             * @param wrapOptions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder wrapOptions(software.amazon.awscdk.services.b2bi.CfnPartnership.WrapOptionsProperty wrapOptions) {
                this.wrapOptions = wrapOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link X12EnvelopeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public X12EnvelopeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link X12EnvelopeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements X12EnvelopeProperty {
            private final java.lang.Object common;
            private final java.lang.Object wrapOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.common = software.amazon.jsii.Kernel.get(this, "common", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.wrapOptions = software.amazon.jsii.Kernel.get(this, "wrapOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.common = builder.common;
                this.wrapOptions = builder.wrapOptions;
            }

            @Override
            public final java.lang.Object getCommon() {
                return this.common;
            }

            @Override
            public final java.lang.Object getWrapOptions() {
                return this.wrapOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCommon() != null) {
                    data.set("common", om.valueToTree(this.getCommon()));
                }
                if (this.getWrapOptions() != null) {
                    data.set("wrapOptions", om.valueToTree(this.getWrapOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnPartnership.X12EnvelopeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                X12EnvelopeProperty.Jsii$Proxy that = (X12EnvelopeProperty.Jsii$Proxy) o;

                if (this.common != null ? !this.common.equals(that.common) : that.common != null) return false;
                return this.wrapOptions != null ? this.wrapOptions.equals(that.wrapOptions) : that.wrapOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.common != null ? this.common.hashCode() : 0;
                result = 31 * result + (this.wrapOptions != null ? this.wrapOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Part of the X12 message structure.
     * <p>
     * These are the functional group headers for the X12 EDI object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * X12FunctionalGroupHeadersProperty x12FunctionalGroupHeadersProperty = X12FunctionalGroupHeadersProperty.builder()
     *         .applicationReceiverCode("applicationReceiverCode")
     *         .applicationSenderCode("applicationSenderCode")
     *         .responsibleAgencyCode("responsibleAgencyCode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12functionalgroupheaders.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12functionalgroupheaders.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnPartnership.X12FunctionalGroupHeadersProperty")
    @software.amazon.jsii.Jsii.Proxy(X12FunctionalGroupHeadersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface X12FunctionalGroupHeadersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A value representing the code used to identify the party receiving a message, at position GS-03.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12functionalgroupheaders.html#cfn-b2bi-partnership-x12functionalgroupheaders-applicationreceivercode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12functionalgroupheaders.html#cfn-b2bi-partnership-x12functionalgroupheaders-applicationreceivercode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApplicationReceiverCode() {
            return null;
        }

        /**
         * A value representing the code used to identify the party transmitting a message, at position GS-02.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12functionalgroupheaders.html#cfn-b2bi-partnership-x12functionalgroupheaders-applicationsendercode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12functionalgroupheaders.html#cfn-b2bi-partnership-x12functionalgroupheaders-applicationsendercode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApplicationSenderCode() {
            return null;
        }

        /**
         * A code that identifies the issuer of the standard, at position GS-07.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12functionalgroupheaders.html#cfn-b2bi-partnership-x12functionalgroupheaders-responsibleagencycode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12functionalgroupheaders.html#cfn-b2bi-partnership-x12functionalgroupheaders-responsibleagencycode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResponsibleAgencyCode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link X12FunctionalGroupHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link X12FunctionalGroupHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<X12FunctionalGroupHeadersProperty> {
            java.lang.String applicationReceiverCode;
            java.lang.String applicationSenderCode;
            java.lang.String responsibleAgencyCode;

            /**
             * Sets the value of {@link X12FunctionalGroupHeadersProperty#getApplicationReceiverCode}
             * @param applicationReceiverCode A value representing the code used to identify the party receiving a message, at position GS-03.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationReceiverCode(java.lang.String applicationReceiverCode) {
                this.applicationReceiverCode = applicationReceiverCode;
                return this;
            }

            /**
             * Sets the value of {@link X12FunctionalGroupHeadersProperty#getApplicationSenderCode}
             * @param applicationSenderCode A value representing the code used to identify the party transmitting a message, at position GS-02.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationSenderCode(java.lang.String applicationSenderCode) {
                this.applicationSenderCode = applicationSenderCode;
                return this;
            }

            /**
             * Sets the value of {@link X12FunctionalGroupHeadersProperty#getResponsibleAgencyCode}
             * @param responsibleAgencyCode A code that identifies the issuer of the standard, at position GS-07.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responsibleAgencyCode(java.lang.String responsibleAgencyCode) {
                this.responsibleAgencyCode = responsibleAgencyCode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link X12FunctionalGroupHeadersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public X12FunctionalGroupHeadersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link X12FunctionalGroupHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements X12FunctionalGroupHeadersProperty {
            private final java.lang.String applicationReceiverCode;
            private final java.lang.String applicationSenderCode;
            private final java.lang.String responsibleAgencyCode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applicationReceiverCode = software.amazon.jsii.Kernel.get(this, "applicationReceiverCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.applicationSenderCode = software.amazon.jsii.Kernel.get(this, "applicationSenderCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.responsibleAgencyCode = software.amazon.jsii.Kernel.get(this, "responsibleAgencyCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationReceiverCode = builder.applicationReceiverCode;
                this.applicationSenderCode = builder.applicationSenderCode;
                this.responsibleAgencyCode = builder.responsibleAgencyCode;
            }

            @Override
            public final java.lang.String getApplicationReceiverCode() {
                return this.applicationReceiverCode;
            }

            @Override
            public final java.lang.String getApplicationSenderCode() {
                return this.applicationSenderCode;
            }

            @Override
            public final java.lang.String getResponsibleAgencyCode() {
                return this.responsibleAgencyCode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApplicationReceiverCode() != null) {
                    data.set("applicationReceiverCode", om.valueToTree(this.getApplicationReceiverCode()));
                }
                if (this.getApplicationSenderCode() != null) {
                    data.set("applicationSenderCode", om.valueToTree(this.getApplicationSenderCode()));
                }
                if (this.getResponsibleAgencyCode() != null) {
                    data.set("responsibleAgencyCode", om.valueToTree(this.getResponsibleAgencyCode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnPartnership.X12FunctionalGroupHeadersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                X12FunctionalGroupHeadersProperty.Jsii$Proxy that = (X12FunctionalGroupHeadersProperty.Jsii$Proxy) o;

                if (this.applicationReceiverCode != null ? !this.applicationReceiverCode.equals(that.applicationReceiverCode) : that.applicationReceiverCode != null) return false;
                if (this.applicationSenderCode != null ? !this.applicationSenderCode.equals(that.applicationSenderCode) : that.applicationSenderCode != null) return false;
                return this.responsibleAgencyCode != null ? this.responsibleAgencyCode.equals(that.responsibleAgencyCode) : that.responsibleAgencyCode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.applicationReceiverCode != null ? this.applicationReceiverCode.hashCode() : 0;
                result = 31 * result + (this.applicationSenderCode != null ? this.applicationSenderCode.hashCode() : 0);
                result = 31 * result + (this.responsibleAgencyCode != null ? this.responsibleAgencyCode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains options specific to processing inbound X12 EDI files.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * X12InboundEdiOptionsProperty x12InboundEdiOptionsProperty = X12InboundEdiOptionsProperty.builder()
     *         .acknowledgmentOptions(X12AcknowledgmentOptionsProperty.builder()
     *                 .functionalAcknowledgment("functionalAcknowledgment")
     *                 .technicalAcknowledgment("technicalAcknowledgment")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12inboundedioptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12inboundedioptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnPartnership.X12InboundEdiOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(X12InboundEdiOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface X12InboundEdiOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies acknowledgment options for inbound X12 EDI files.
         * <p>
         * These options control how functional and technical acknowledgments are handled.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.b2bi.CfnPartnership.X12AcknowledgmentOptionsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12inboundedioptions.html#cfn-b2bi-partnership-x12inboundedioptions-acknowledgmentoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12inboundedioptions.html#cfn-b2bi-partnership-x12inboundedioptions-acknowledgmentoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcknowledgmentOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link X12InboundEdiOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link X12InboundEdiOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<X12InboundEdiOptionsProperty> {
            java.lang.Object acknowledgmentOptions;

            /**
             * Sets the value of {@link X12InboundEdiOptionsProperty#getAcknowledgmentOptions}
             * @param acknowledgmentOptions Specifies acknowledgment options for inbound X12 EDI files.
             *                              These options control how functional and technical acknowledgments are handled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acknowledgmentOptions(software.amazon.awscdk.IResolvable acknowledgmentOptions) {
                this.acknowledgmentOptions = acknowledgmentOptions;
                return this;
            }

            /**
             * Sets the value of {@link X12InboundEdiOptionsProperty#getAcknowledgmentOptions}
             * @param acknowledgmentOptions Specifies acknowledgment options for inbound X12 EDI files.
             *                              These options control how functional and technical acknowledgments are handled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acknowledgmentOptions(software.amazon.awscdk.services.b2bi.CfnPartnership.X12AcknowledgmentOptionsProperty acknowledgmentOptions) {
                this.acknowledgmentOptions = acknowledgmentOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link X12InboundEdiOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public X12InboundEdiOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link X12InboundEdiOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements X12InboundEdiOptionsProperty {
            private final java.lang.Object acknowledgmentOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.acknowledgmentOptions = software.amazon.jsii.Kernel.get(this, "acknowledgmentOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.acknowledgmentOptions = builder.acknowledgmentOptions;
            }

            @Override
            public final java.lang.Object getAcknowledgmentOptions() {
                return this.acknowledgmentOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAcknowledgmentOptions() != null) {
                    data.set("acknowledgmentOptions", om.valueToTree(this.getAcknowledgmentOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnPartnership.X12InboundEdiOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                X12InboundEdiOptionsProperty.Jsii$Proxy that = (X12InboundEdiOptionsProperty.Jsii$Proxy) o;

                return this.acknowledgmentOptions != null ? this.acknowledgmentOptions.equals(that.acknowledgmentOptions) : that.acknowledgmentOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.acknowledgmentOptions != null ? this.acknowledgmentOptions.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * In X12, the Interchange Control Header is the first segment of an EDI document and is part of the Interchange Envelope.
     * <p>
     * It contains information about the sender and receiver, the date and time of transmission, and the X12 version being used. It also includes delivery information, such as the sender and receiver IDs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * X12InterchangeControlHeadersProperty x12InterchangeControlHeadersProperty = X12InterchangeControlHeadersProperty.builder()
     *         .acknowledgmentRequestedCode("acknowledgmentRequestedCode")
     *         .receiverId("receiverId")
     *         .receiverIdQualifier("receiverIdQualifier")
     *         .repetitionSeparator("repetitionSeparator")
     *         .senderId("senderId")
     *         .senderIdQualifier("senderIdQualifier")
     *         .usageIndicatorCode("usageIndicatorCode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12interchangecontrolheaders.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12interchangecontrolheaders.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnPartnership.X12InterchangeControlHeadersProperty")
    @software.amazon.jsii.Jsii.Proxy(X12InterchangeControlHeadersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface X12InterchangeControlHeadersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Located at position ISA-14 in the header.
         * <p>
         * The value "1" indicates that the sender is requesting an interchange acknowledgment at receipt of the interchange. The value "0" is used otherwise.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12interchangecontrolheaders.html#cfn-b2bi-partnership-x12interchangecontrolheaders-acknowledgmentrequestedcode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12interchangecontrolheaders.html#cfn-b2bi-partnership-x12interchangecontrolheaders-acknowledgmentrequestedcode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAcknowledgmentRequestedCode() {
            return null;
        }

        /**
         * Located at position ISA-08 in the header.
         * <p>
         * This value (along with the <code>receiverIdQualifier</code> ) identifies the intended recipient of the interchange.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12interchangecontrolheaders.html#cfn-b2bi-partnership-x12interchangecontrolheaders-receiverid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12interchangecontrolheaders.html#cfn-b2bi-partnership-x12interchangecontrolheaders-receiverid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReceiverId() {
            return null;
        }

        /**
         * Located at position ISA-07 in the header.
         * <p>
         * Qualifier for the receiver ID. Together, the ID and qualifier uniquely identify the receiving trading partner.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12interchangecontrolheaders.html#cfn-b2bi-partnership-x12interchangecontrolheaders-receiveridqualifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12interchangecontrolheaders.html#cfn-b2bi-partnership-x12interchangecontrolheaders-receiveridqualifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReceiverIdQualifier() {
            return null;
        }

        /**
         * Located at position ISA-11 in the header.
         * <p>
         * This string makes it easier when you need to group similar adjacent element values together without using extra segments.
         * <p>
         * <blockquote>
         * <p>
         * This parameter is only honored for version greater than 401 ( <code>VERSION_4010</code> and higher).
         * <p>
         * For versions less than 401, this field is called <a href="https://docs.aws.amazon.com/https://www.stedi.com/edi/x12-004010/segment/ISA#ISA-11">StandardsId</a> , in which case our service sets the value to <code>U</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12interchangecontrolheaders.html#cfn-b2bi-partnership-x12interchangecontrolheaders-repetitionseparator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12interchangecontrolheaders.html#cfn-b2bi-partnership-x12interchangecontrolheaders-repetitionseparator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRepetitionSeparator() {
            return null;
        }

        /**
         * Located at position ISA-06 in the header.
         * <p>
         * This value (along with the <code>senderIdQualifier</code> ) identifies the sender of the interchange.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12interchangecontrolheaders.html#cfn-b2bi-partnership-x12interchangecontrolheaders-senderid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12interchangecontrolheaders.html#cfn-b2bi-partnership-x12interchangecontrolheaders-senderid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSenderId() {
            return null;
        }

        /**
         * Located at position ISA-05 in the header.
         * <p>
         * Qualifier for the sender ID. Together, the ID and qualifier uniquely identify the sending trading partner.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12interchangecontrolheaders.html#cfn-b2bi-partnership-x12interchangecontrolheaders-senderidqualifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12interchangecontrolheaders.html#cfn-b2bi-partnership-x12interchangecontrolheaders-senderidqualifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSenderIdQualifier() {
            return null;
        }

        /**
         * Located at position ISA-15 in the header. Specifies how this interchange is being used:.
         * <p>
         * <ul>
         * <li><code>T</code> indicates this interchange is for testing.</li>
         * <li><code>P</code> indicates this interchange is for production.</li>
         * <li><code>I</code> indicates this interchange is informational.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12interchangecontrolheaders.html#cfn-b2bi-partnership-x12interchangecontrolheaders-usageindicatorcode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12interchangecontrolheaders.html#cfn-b2bi-partnership-x12interchangecontrolheaders-usageindicatorcode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsageIndicatorCode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link X12InterchangeControlHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link X12InterchangeControlHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<X12InterchangeControlHeadersProperty> {
            java.lang.String acknowledgmentRequestedCode;
            java.lang.String receiverId;
            java.lang.String receiverIdQualifier;
            java.lang.String repetitionSeparator;
            java.lang.String senderId;
            java.lang.String senderIdQualifier;
            java.lang.String usageIndicatorCode;

            /**
             * Sets the value of {@link X12InterchangeControlHeadersProperty#getAcknowledgmentRequestedCode}
             * @param acknowledgmentRequestedCode Located at position ISA-14 in the header.
             *                                    The value "1" indicates that the sender is requesting an interchange acknowledgment at receipt of the interchange. The value "0" is used otherwise.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acknowledgmentRequestedCode(java.lang.String acknowledgmentRequestedCode) {
                this.acknowledgmentRequestedCode = acknowledgmentRequestedCode;
                return this;
            }

            /**
             * Sets the value of {@link X12InterchangeControlHeadersProperty#getReceiverId}
             * @param receiverId Located at position ISA-08 in the header.
             *                   This value (along with the <code>receiverIdQualifier</code> ) identifies the intended recipient of the interchange.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder receiverId(java.lang.String receiverId) {
                this.receiverId = receiverId;
                return this;
            }

            /**
             * Sets the value of {@link X12InterchangeControlHeadersProperty#getReceiverIdQualifier}
             * @param receiverIdQualifier Located at position ISA-07 in the header.
             *                            Qualifier for the receiver ID. Together, the ID and qualifier uniquely identify the receiving trading partner.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder receiverIdQualifier(java.lang.String receiverIdQualifier) {
                this.receiverIdQualifier = receiverIdQualifier;
                return this;
            }

            /**
             * Sets the value of {@link X12InterchangeControlHeadersProperty#getRepetitionSeparator}
             * @param repetitionSeparator Located at position ISA-11 in the header.
             *                            This string makes it easier when you need to group similar adjacent element values together without using extra segments.
             *                            <p>
             *                            <blockquote>
             *                            <p>
             *                            This parameter is only honored for version greater than 401 ( <code>VERSION_4010</code> and higher).
             *                            <p>
             *                            For versions less than 401, this field is called <a href="https://docs.aws.amazon.com/https://www.stedi.com/edi/x12-004010/segment/ISA#ISA-11">StandardsId</a> , in which case our service sets the value to <code>U</code> .
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repetitionSeparator(java.lang.String repetitionSeparator) {
                this.repetitionSeparator = repetitionSeparator;
                return this;
            }

            /**
             * Sets the value of {@link X12InterchangeControlHeadersProperty#getSenderId}
             * @param senderId Located at position ISA-06 in the header.
             *                 This value (along with the <code>senderIdQualifier</code> ) identifies the sender of the interchange.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder senderId(java.lang.String senderId) {
                this.senderId = senderId;
                return this;
            }

            /**
             * Sets the value of {@link X12InterchangeControlHeadersProperty#getSenderIdQualifier}
             * @param senderIdQualifier Located at position ISA-05 in the header.
             *                          Qualifier for the sender ID. Together, the ID and qualifier uniquely identify the sending trading partner.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder senderIdQualifier(java.lang.String senderIdQualifier) {
                this.senderIdQualifier = senderIdQualifier;
                return this;
            }

            /**
             * Sets the value of {@link X12InterchangeControlHeadersProperty#getUsageIndicatorCode}
             * @param usageIndicatorCode Located at position ISA-15 in the header. Specifies how this interchange is being used:.
             *                           <ul>
             *                           <li><code>T</code> indicates this interchange is for testing.</li>
             *                           <li><code>P</code> indicates this interchange is for production.</li>
             *                           <li><code>I</code> indicates this interchange is informational.</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usageIndicatorCode(java.lang.String usageIndicatorCode) {
                this.usageIndicatorCode = usageIndicatorCode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link X12InterchangeControlHeadersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public X12InterchangeControlHeadersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link X12InterchangeControlHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements X12InterchangeControlHeadersProperty {
            private final java.lang.String acknowledgmentRequestedCode;
            private final java.lang.String receiverId;
            private final java.lang.String receiverIdQualifier;
            private final java.lang.String repetitionSeparator;
            private final java.lang.String senderId;
            private final java.lang.String senderIdQualifier;
            private final java.lang.String usageIndicatorCode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.acknowledgmentRequestedCode = software.amazon.jsii.Kernel.get(this, "acknowledgmentRequestedCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.receiverId = software.amazon.jsii.Kernel.get(this, "receiverId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.receiverIdQualifier = software.amazon.jsii.Kernel.get(this, "receiverIdQualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.repetitionSeparator = software.amazon.jsii.Kernel.get(this, "repetitionSeparator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.senderId = software.amazon.jsii.Kernel.get(this, "senderId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.senderIdQualifier = software.amazon.jsii.Kernel.get(this, "senderIdQualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.usageIndicatorCode = software.amazon.jsii.Kernel.get(this, "usageIndicatorCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.acknowledgmentRequestedCode = builder.acknowledgmentRequestedCode;
                this.receiverId = builder.receiverId;
                this.receiverIdQualifier = builder.receiverIdQualifier;
                this.repetitionSeparator = builder.repetitionSeparator;
                this.senderId = builder.senderId;
                this.senderIdQualifier = builder.senderIdQualifier;
                this.usageIndicatorCode = builder.usageIndicatorCode;
            }

            @Override
            public final java.lang.String getAcknowledgmentRequestedCode() {
                return this.acknowledgmentRequestedCode;
            }

            @Override
            public final java.lang.String getReceiverId() {
                return this.receiverId;
            }

            @Override
            public final java.lang.String getReceiverIdQualifier() {
                return this.receiverIdQualifier;
            }

            @Override
            public final java.lang.String getRepetitionSeparator() {
                return this.repetitionSeparator;
            }

            @Override
            public final java.lang.String getSenderId() {
                return this.senderId;
            }

            @Override
            public final java.lang.String getSenderIdQualifier() {
                return this.senderIdQualifier;
            }

            @Override
            public final java.lang.String getUsageIndicatorCode() {
                return this.usageIndicatorCode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAcknowledgmentRequestedCode() != null) {
                    data.set("acknowledgmentRequestedCode", om.valueToTree(this.getAcknowledgmentRequestedCode()));
                }
                if (this.getReceiverId() != null) {
                    data.set("receiverId", om.valueToTree(this.getReceiverId()));
                }
                if (this.getReceiverIdQualifier() != null) {
                    data.set("receiverIdQualifier", om.valueToTree(this.getReceiverIdQualifier()));
                }
                if (this.getRepetitionSeparator() != null) {
                    data.set("repetitionSeparator", om.valueToTree(this.getRepetitionSeparator()));
                }
                if (this.getSenderId() != null) {
                    data.set("senderId", om.valueToTree(this.getSenderId()));
                }
                if (this.getSenderIdQualifier() != null) {
                    data.set("senderIdQualifier", om.valueToTree(this.getSenderIdQualifier()));
                }
                if (this.getUsageIndicatorCode() != null) {
                    data.set("usageIndicatorCode", om.valueToTree(this.getUsageIndicatorCode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnPartnership.X12InterchangeControlHeadersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                X12InterchangeControlHeadersProperty.Jsii$Proxy that = (X12InterchangeControlHeadersProperty.Jsii$Proxy) o;

                if (this.acknowledgmentRequestedCode != null ? !this.acknowledgmentRequestedCode.equals(that.acknowledgmentRequestedCode) : that.acknowledgmentRequestedCode != null) return false;
                if (this.receiverId != null ? !this.receiverId.equals(that.receiverId) : that.receiverId != null) return false;
                if (this.receiverIdQualifier != null ? !this.receiverIdQualifier.equals(that.receiverIdQualifier) : that.receiverIdQualifier != null) return false;
                if (this.repetitionSeparator != null ? !this.repetitionSeparator.equals(that.repetitionSeparator) : that.repetitionSeparator != null) return false;
                if (this.senderId != null ? !this.senderId.equals(that.senderId) : that.senderId != null) return false;
                if (this.senderIdQualifier != null ? !this.senderIdQualifier.equals(that.senderIdQualifier) : that.senderIdQualifier != null) return false;
                return this.usageIndicatorCode != null ? this.usageIndicatorCode.equals(that.usageIndicatorCode) : that.usageIndicatorCode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.acknowledgmentRequestedCode != null ? this.acknowledgmentRequestedCode.hashCode() : 0;
                result = 31 * result + (this.receiverId != null ? this.receiverId.hashCode() : 0);
                result = 31 * result + (this.receiverIdQualifier != null ? this.receiverIdQualifier.hashCode() : 0);
                result = 31 * result + (this.repetitionSeparator != null ? this.repetitionSeparator.hashCode() : 0);
                result = 31 * result + (this.senderId != null ? this.senderId.hashCode() : 0);
                result = 31 * result + (this.senderIdQualifier != null ? this.senderIdQualifier.hashCode() : 0);
                result = 31 * result + (this.usageIndicatorCode != null ? this.usageIndicatorCode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure containing the details for an outbound EDI object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * X12OutboundEdiHeadersProperty x12OutboundEdiHeadersProperty = X12OutboundEdiHeadersProperty.builder()
     *         .controlNumbers(X12ControlNumbersProperty.builder()
     *                 .startingFunctionalGroupControlNumber(123)
     *                 .startingInterchangeControlNumber(123)
     *                 .startingTransactionSetControlNumber(123)
     *                 .build())
     *         .delimiters(X12DelimitersProperty.builder()
     *                 .componentSeparator("componentSeparator")
     *                 .dataElementSeparator("dataElementSeparator")
     *                 .segmentTerminator("segmentTerminator")
     *                 .build())
     *         .functionalGroupHeaders(X12FunctionalGroupHeadersProperty.builder()
     *                 .applicationReceiverCode("applicationReceiverCode")
     *                 .applicationSenderCode("applicationSenderCode")
     *                 .responsibleAgencyCode("responsibleAgencyCode")
     *                 .build())
     *         .gs05TimeFormat("gs05TimeFormat")
     *         .interchangeControlHeaders(X12InterchangeControlHeadersProperty.builder()
     *                 .acknowledgmentRequestedCode("acknowledgmentRequestedCode")
     *                 .receiverId("receiverId")
     *                 .receiverIdQualifier("receiverIdQualifier")
     *                 .repetitionSeparator("repetitionSeparator")
     *                 .senderId("senderId")
     *                 .senderIdQualifier("senderIdQualifier")
     *                 .usageIndicatorCode("usageIndicatorCode")
     *                 .build())
     *         .validateEdi(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12outboundediheaders.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12outboundediheaders.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnPartnership.X12OutboundEdiHeadersProperty")
    @software.amazon.jsii.Jsii.Proxy(X12OutboundEdiHeadersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface X12OutboundEdiHeadersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies control number configuration for outbound X12 EDI headers.
         * <p>
         * These settings determine the starting values for interchange, functional group, and transaction set control numbers.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.b2bi.CfnPartnership.X12ControlNumbersProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12outboundediheaders.html#cfn-b2bi-partnership-x12outboundediheaders-controlnumbers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12outboundediheaders.html#cfn-b2bi-partnership-x12outboundediheaders-controlnumbers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getControlNumbers() {
            return null;
        }

        /**
         * The delimiters, for example semicolon ( <code>;</code> ), that separates sections of the headers for the X12 object.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.b2bi.CfnPartnership.X12DelimitersProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12outboundediheaders.html#cfn-b2bi-partnership-x12outboundediheaders-delimiters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12outboundediheaders.html#cfn-b2bi-partnership-x12outboundediheaders-delimiters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDelimiters() {
            return null;
        }

        /**
         * The functional group headers for the X12 object.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.b2bi.CfnPartnership.X12FunctionalGroupHeadersProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12outboundediheaders.html#cfn-b2bi-partnership-x12outboundediheaders-functionalgroupheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12outboundediheaders.html#cfn-b2bi-partnership-x12outboundediheaders-functionalgroupheaders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFunctionalGroupHeaders() {
            return null;
        }

        /**
         * Specifies the time format in the GS05 element (time) of the functional group header.
         * <p>
         * The following formats use 24-hour clock time:
         * <p>
         * <ul>
         * <li><code>HHMM</code> - Hours and minutes</li>
         * <li><code>HHMMSS</code> - Hours, minutes, and seconds</li>
         * <li><code>HHMMSSDD</code> - Hours, minutes, seconds, and decimal seconds</li>
         * </ul>
         * <p>
         * Where:
         * <p>
         * <ul>
         * <li><code>HH</code> - Hours (00-23)</li>
         * <li><code>MM</code> - Minutes (00-59)</li>
         * <li><code>SS</code> - Seconds (00-59)</li>
         * <li><code>DD</code> - Hundredths of seconds (00-99)</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12outboundediheaders.html#cfn-b2bi-partnership-x12outboundediheaders-gs05timeformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12outboundediheaders.html#cfn-b2bi-partnership-x12outboundediheaders-gs05timeformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGs05TimeFormat() {
            return null;
        }

        /**
         * In X12 EDI messages, delimiters are used to mark the end of segments or elements, and are defined in the interchange control header.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.b2bi.CfnPartnership.X12InterchangeControlHeadersProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12outboundediheaders.html#cfn-b2bi-partnership-x12outboundediheaders-interchangecontrolheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12outboundediheaders.html#cfn-b2bi-partnership-x12outboundediheaders-interchangecontrolheaders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInterchangeControlHeaders() {
            return null;
        }

        /**
         * Specifies whether or not to validate the EDI for this X12 object: <code>TRUE</code> or <code>FALSE</code> .
         * <p>
         * When enabled, this performs both standard EDI validation and applies any configured custom validation rules including element length constraints, code list validations, and element requirement checks. Validation results are returned in the response validation messages.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12outboundediheaders.html#cfn-b2bi-partnership-x12outboundediheaders-validateedi">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-partnership-x12outboundediheaders.html#cfn-b2bi-partnership-x12outboundediheaders-validateedi</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValidateEdi() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link X12OutboundEdiHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link X12OutboundEdiHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<X12OutboundEdiHeadersProperty> {
            java.lang.Object controlNumbers;
            java.lang.Object delimiters;
            java.lang.Object functionalGroupHeaders;
            java.lang.String gs05TimeFormat;
            java.lang.Object interchangeControlHeaders;
            java.lang.Object validateEdi;

            /**
             * Sets the value of {@link X12OutboundEdiHeadersProperty#getControlNumbers}
             * @param controlNumbers Specifies control number configuration for outbound X12 EDI headers.
             *                       These settings determine the starting values for interchange, functional group, and transaction set control numbers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder controlNumbers(software.amazon.awscdk.IResolvable controlNumbers) {
                this.controlNumbers = controlNumbers;
                return this;
            }

            /**
             * Sets the value of {@link X12OutboundEdiHeadersProperty#getControlNumbers}
             * @param controlNumbers Specifies control number configuration for outbound X12 EDI headers.
             *                       These settings determine the starting values for interchange, functional group, and transaction set control numbers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder controlNumbers(software.amazon.awscdk.services.b2bi.CfnPartnership.X12ControlNumbersProperty controlNumbers) {
                this.controlNumbers = controlNumbers;
                return this;
            }

            /**
             * Sets the value of {@link X12OutboundEdiHeadersProperty#getDelimiters}
             * @param delimiters The delimiters, for example semicolon ( <code>;</code> ), that separates sections of the headers for the X12 object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delimiters(software.amazon.awscdk.IResolvable delimiters) {
                this.delimiters = delimiters;
                return this;
            }

            /**
             * Sets the value of {@link X12OutboundEdiHeadersProperty#getDelimiters}
             * @param delimiters The delimiters, for example semicolon ( <code>;</code> ), that separates sections of the headers for the X12 object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delimiters(software.amazon.awscdk.services.b2bi.CfnPartnership.X12DelimitersProperty delimiters) {
                this.delimiters = delimiters;
                return this;
            }

            /**
             * Sets the value of {@link X12OutboundEdiHeadersProperty#getFunctionalGroupHeaders}
             * @param functionalGroupHeaders The functional group headers for the X12 object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionalGroupHeaders(software.amazon.awscdk.IResolvable functionalGroupHeaders) {
                this.functionalGroupHeaders = functionalGroupHeaders;
                return this;
            }

            /**
             * Sets the value of {@link X12OutboundEdiHeadersProperty#getFunctionalGroupHeaders}
             * @param functionalGroupHeaders The functional group headers for the X12 object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionalGroupHeaders(software.amazon.awscdk.services.b2bi.CfnPartnership.X12FunctionalGroupHeadersProperty functionalGroupHeaders) {
                this.functionalGroupHeaders = functionalGroupHeaders;
                return this;
            }

            /**
             * Sets the value of {@link X12OutboundEdiHeadersProperty#getGs05TimeFormat}
             * @param gs05TimeFormat Specifies the time format in the GS05 element (time) of the functional group header.
             *                       The following formats use 24-hour clock time:
             *                       <p>
             *                       <ul>
             *                       <li><code>HHMM</code> - Hours and minutes</li>
             *                       <li><code>HHMMSS</code> - Hours, minutes, and seconds</li>
             *                       <li><code>HHMMSSDD</code> - Hours, minutes, seconds, and decimal seconds</li>
             *                       </ul>
             *                       <p>
             *                       Where:
             *                       <p>
             *                       <ul>
             *                       <li><code>HH</code> - Hours (00-23)</li>
             *                       <li><code>MM</code> - Minutes (00-59)</li>
             *                       <li><code>SS</code> - Seconds (00-59)</li>
             *                       <li><code>DD</code> - Hundredths of seconds (00-99)</li>
             *                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gs05TimeFormat(java.lang.String gs05TimeFormat) {
                this.gs05TimeFormat = gs05TimeFormat;
                return this;
            }

            /**
             * Sets the value of {@link X12OutboundEdiHeadersProperty#getInterchangeControlHeaders}
             * @param interchangeControlHeaders In X12 EDI messages, delimiters are used to mark the end of segments or elements, and are defined in the interchange control header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interchangeControlHeaders(software.amazon.awscdk.IResolvable interchangeControlHeaders) {
                this.interchangeControlHeaders = interchangeControlHeaders;
                return this;
            }

            /**
             * Sets the value of {@link X12OutboundEdiHeadersProperty#getInterchangeControlHeaders}
             * @param interchangeControlHeaders In X12 EDI messages, delimiters are used to mark the end of segments or elements, and are defined in the interchange control header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interchangeControlHeaders(software.amazon.awscdk.services.b2bi.CfnPartnership.X12InterchangeControlHeadersProperty interchangeControlHeaders) {
                this.interchangeControlHeaders = interchangeControlHeaders;
                return this;
            }

            /**
             * Sets the value of {@link X12OutboundEdiHeadersProperty#getValidateEdi}
             * @param validateEdi Specifies whether or not to validate the EDI for this X12 object: <code>TRUE</code> or <code>FALSE</code> .
             *                    When enabled, this performs both standard EDI validation and applies any configured custom validation rules including element length constraints, code list validations, and element requirement checks. Validation results are returned in the response validation messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validateEdi(java.lang.Boolean validateEdi) {
                this.validateEdi = validateEdi;
                return this;
            }

            /**
             * Sets the value of {@link X12OutboundEdiHeadersProperty#getValidateEdi}
             * @param validateEdi Specifies whether or not to validate the EDI for this X12 object: <code>TRUE</code> or <code>FALSE</code> .
             *                    When enabled, this performs both standard EDI validation and applies any configured custom validation rules including element length constraints, code list validations, and element requirement checks. Validation results are returned in the response validation messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validateEdi(software.amazon.awscdk.IResolvable validateEdi) {
                this.validateEdi = validateEdi;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link X12OutboundEdiHeadersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public X12OutboundEdiHeadersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link X12OutboundEdiHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements X12OutboundEdiHeadersProperty {
            private final java.lang.Object controlNumbers;
            private final java.lang.Object delimiters;
            private final java.lang.Object functionalGroupHeaders;
            private final java.lang.String gs05TimeFormat;
            private final java.lang.Object interchangeControlHeaders;
            private final java.lang.Object validateEdi;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.controlNumbers = software.amazon.jsii.Kernel.get(this, "controlNumbers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.delimiters = software.amazon.jsii.Kernel.get(this, "delimiters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.functionalGroupHeaders = software.amazon.jsii.Kernel.get(this, "functionalGroupHeaders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.gs05TimeFormat = software.amazon.jsii.Kernel.get(this, "gs05TimeFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.interchangeControlHeaders = software.amazon.jsii.Kernel.get(this, "interchangeControlHeaders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.validateEdi = software.amazon.jsii.Kernel.get(this, "validateEdi", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.controlNumbers = builder.controlNumbers;
                this.delimiters = builder.delimiters;
                this.functionalGroupHeaders = builder.functionalGroupHeaders;
                this.gs05TimeFormat = builder.gs05TimeFormat;
                this.interchangeControlHeaders = builder.interchangeControlHeaders;
                this.validateEdi = builder.validateEdi;
            }

            @Override
            public final java.lang.Object getControlNumbers() {
                return this.controlNumbers;
            }

            @Override
            public final java.lang.Object getDelimiters() {
                return this.delimiters;
            }

            @Override
            public final java.lang.Object getFunctionalGroupHeaders() {
                return this.functionalGroupHeaders;
            }

            @Override
            public final java.lang.String getGs05TimeFormat() {
                return this.gs05TimeFormat;
            }

            @Override
            public final java.lang.Object getInterchangeControlHeaders() {
                return this.interchangeControlHeaders;
            }

            @Override
            public final java.lang.Object getValidateEdi() {
                return this.validateEdi;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getControlNumbers() != null) {
                    data.set("controlNumbers", om.valueToTree(this.getControlNumbers()));
                }
                if (this.getDelimiters() != null) {
                    data.set("delimiters", om.valueToTree(this.getDelimiters()));
                }
                if (this.getFunctionalGroupHeaders() != null) {
                    data.set("functionalGroupHeaders", om.valueToTree(this.getFunctionalGroupHeaders()));
                }
                if (this.getGs05TimeFormat() != null) {
                    data.set("gs05TimeFormat", om.valueToTree(this.getGs05TimeFormat()));
                }
                if (this.getInterchangeControlHeaders() != null) {
                    data.set("interchangeControlHeaders", om.valueToTree(this.getInterchangeControlHeaders()));
                }
                if (this.getValidateEdi() != null) {
                    data.set("validateEdi", om.valueToTree(this.getValidateEdi()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnPartnership.X12OutboundEdiHeadersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                X12OutboundEdiHeadersProperty.Jsii$Proxy that = (X12OutboundEdiHeadersProperty.Jsii$Proxy) o;

                if (this.controlNumbers != null ? !this.controlNumbers.equals(that.controlNumbers) : that.controlNumbers != null) return false;
                if (this.delimiters != null ? !this.delimiters.equals(that.delimiters) : that.delimiters != null) return false;
                if (this.functionalGroupHeaders != null ? !this.functionalGroupHeaders.equals(that.functionalGroupHeaders) : that.functionalGroupHeaders != null) return false;
                if (this.gs05TimeFormat != null ? !this.gs05TimeFormat.equals(that.gs05TimeFormat) : that.gs05TimeFormat != null) return false;
                if (this.interchangeControlHeaders != null ? !this.interchangeControlHeaders.equals(that.interchangeControlHeaders) : that.interchangeControlHeaders != null) return false;
                return this.validateEdi != null ? this.validateEdi.equals(that.validateEdi) : that.validateEdi == null;
            }

            @Override
            public final int hashCode() {
                int result = this.controlNumbers != null ? this.controlNumbers.hashCode() : 0;
                result = 31 * result + (this.delimiters != null ? this.delimiters.hashCode() : 0);
                result = 31 * result + (this.functionalGroupHeaders != null ? this.functionalGroupHeaders.hashCode() : 0);
                result = 31 * result + (this.gs05TimeFormat != null ? this.gs05TimeFormat.hashCode() : 0);
                result = 31 * result + (this.interchangeControlHeaders != null ? this.interchangeControlHeaders.hashCode() : 0);
                result = 31 * result + (this.validateEdi != null ? this.validateEdi.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.b2bi.CfnPartnership}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.b2bi.CfnPartnership> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.b2bi.CfnPartnershipProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.b2bi.CfnPartnershipProps.Builder();
        }

        /**
         * Returns one or more capabilities associated with this partnership.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html#cfn-b2bi-partnership-capabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html#cfn-b2bi-partnership-capabilities</a>
         * @param capabilities Returns one or more capabilities associated with this partnership. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capabilities(final java.util.List<java.lang.String> capabilities) {
            this.props.capabilities(capabilities);
            return this;
        }

        /**
         * Specifies the email address associated with this trading partner.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html#cfn-b2bi-partnership-email">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html#cfn-b2bi-partnership-email</a>
         * @param email Specifies the email address associated with this trading partner. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder email(final java.lang.String email) {
            this.props.email(email);
            return this;
        }

        /**
         * Returns the name of the partnership.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html#cfn-b2bi-partnership-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html#cfn-b2bi-partnership-name</a>
         * @param name Returns the name of the partnership. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Returns the unique, system-generated identifier for the profile connected to this partnership.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html#cfn-b2bi-partnership-profileid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html#cfn-b2bi-partnership-profileid</a>
         * @param profileId Returns the unique, system-generated identifier for the profile connected to this partnership. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profileId(final java.lang.String profileId) {
            this.props.profileId(profileId);
            return this;
        }

        /**
         * Contains the details for an Outbound EDI capability.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html#cfn-b2bi-partnership-capabilityoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html#cfn-b2bi-partnership-capabilityoptions</a>
         * @param capabilityOptions Contains the details for an Outbound EDI capability. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capabilityOptions(final software.amazon.awscdk.IResolvable capabilityOptions) {
            this.props.capabilityOptions(capabilityOptions);
            return this;
        }
        /**
         * Contains the details for an Outbound EDI capability.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html#cfn-b2bi-partnership-capabilityoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html#cfn-b2bi-partnership-capabilityoptions</a>
         * @param capabilityOptions Contains the details for an Outbound EDI capability. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capabilityOptions(final software.amazon.awscdk.services.b2bi.CfnPartnership.CapabilityOptionsProperty capabilityOptions) {
            this.props.capabilityOptions(capabilityOptions);
            return this;
        }

        /**
         * Specifies the phone number associated with the partnership.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html#cfn-b2bi-partnership-phone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html#cfn-b2bi-partnership-phone</a>
         * @param phone Specifies the phone number associated with the partnership. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder phone(final java.lang.String phone) {
            this.props.phone(phone);
            return this;
        }

        /**
         * A key-value pair for a specific partnership.
         * <p>
         * Tags are metadata that you can use to search for and group capabilities for various purposes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html#cfn-b2bi-partnership-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-partnership.html#cfn-b2bi-partnership-tags</a>
         * @param tags A key-value pair for a specific partnership. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.b2bi.CfnPartnership}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.b2bi.CfnPartnership build() {
            return new software.amazon.awscdk.services.b2bi.CfnPartnership(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
