package software.amazon.awscdk.services.backup;

/**
 * A reference to a BackupVault resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.backup.*;
 * BackupVaultReference backupVaultReference = BackupVaultReference.builder()
 *         .backupVaultArn("backupVaultArn")
 *         .backupVaultName("backupVaultName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:59.003Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.BackupVaultReference")
@software.amazon.jsii.Jsii.Proxy(BackupVaultReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BackupVaultReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the BackupVault resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBackupVaultArn();

    /**
     * The BackupVaultName of the BackupVault resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBackupVaultName();

    /**
     * @return a {@link Builder} of {@link BackupVaultReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BackupVaultReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BackupVaultReference> {
        java.lang.String backupVaultArn;
        java.lang.String backupVaultName;

        /**
         * Sets the value of {@link BackupVaultReference#getBackupVaultArn}
         * @param backupVaultArn The ARN of the BackupVault resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupVaultArn(java.lang.String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        /**
         * Sets the value of {@link BackupVaultReference#getBackupVaultName}
         * @param backupVaultName The BackupVaultName of the BackupVault resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupVaultName(java.lang.String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BackupVaultReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BackupVaultReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BackupVaultReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackupVaultReference {
        private final java.lang.String backupVaultArn;
        private final java.lang.String backupVaultName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.backupVaultArn = software.amazon.jsii.Kernel.get(this, "backupVaultArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.backupVaultName = software.amazon.jsii.Kernel.get(this, "backupVaultName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.backupVaultArn = java.util.Objects.requireNonNull(builder.backupVaultArn, "backupVaultArn is required");
            this.backupVaultName = java.util.Objects.requireNonNull(builder.backupVaultName, "backupVaultName is required");
        }

        @Override
        public final java.lang.String getBackupVaultArn() {
            return this.backupVaultArn;
        }

        @Override
        public final java.lang.String getBackupVaultName() {
            return this.backupVaultName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("backupVaultArn", om.valueToTree(this.getBackupVaultArn()));
            data.set("backupVaultName", om.valueToTree(this.getBackupVaultName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.BackupVaultReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BackupVaultReference.Jsii$Proxy that = (BackupVaultReference.Jsii$Proxy) o;

            if (!backupVaultArn.equals(that.backupVaultArn)) return false;
            return this.backupVaultName.equals(that.backupVaultName);
        }

        @Override
        public final int hashCode() {
            int result = this.backupVaultArn.hashCode();
            result = 31 * result + (this.backupVaultName.hashCode());
            return result;
        }
    }
}
