package software.amazon.awscdk.services.backup;

/**
 * Properties for defining a <code>CfnLogicallyAirGappedBackupVault</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.backup.*;
 * Object accessPolicy;
 * CfnLogicallyAirGappedBackupVaultProps cfnLogicallyAirGappedBackupVaultProps = CfnLogicallyAirGappedBackupVaultProps.builder()
 *         .backupVaultName("backupVaultName")
 *         .maxRetentionDays(123)
 *         .minRetentionDays(123)
 *         // the properties below are optional
 *         .accessPolicy(accessPolicy)
 *         .backupVaultTags(Map.of(
 *                 "backupVaultTagsKey", "backupVaultTags"))
 *         .notifications(NotificationObjectTypeProperty.builder()
 *                 .backupVaultEvents(List.of("backupVaultEvents"))
 *                 .snsTopicArn("snsTopicArn")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:59.023Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnLogicallyAirGappedBackupVaultProps")
@software.amazon.jsii.Jsii.Proxy(CfnLogicallyAirGappedBackupVaultProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLogicallyAirGappedBackupVaultProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of a logical container where backups are stored.
     * <p>
     * Logically air-gapped backup vaults are identified by names that are unique to the account used to create them and the Region where they are created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-backupvaultname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-backupvaultname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBackupVaultName();

    /**
     * The maximum retention period that the vault retains its recovery points.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-maxretentiondays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-maxretentiondays</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxRetentionDays();

    /**
     * This setting specifies the minimum retention period that the vault retains its recovery points.
     * <p>
     * The minimum value accepted is 7 days.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-minretentiondays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-minretentiondays</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMinRetentionDays();

    /**
     * The backup vault access policy document in JSON format.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-accesspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-accesspolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccessPolicy() {
        return null;
    }

    /**
     * The tags to assign to the vault.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-backupvaulttags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-backupvaulttags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getBackupVaultTags() {
        return null;
    }

    /**
     * Returns event notifications for the specified backup vault.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.backup.CfnLogicallyAirGappedBackupVault.NotificationObjectTypeProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-notifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-logicallyairgappedbackupvault.html#cfn-backup-logicallyairgappedbackupvault-notifications</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNotifications() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLogicallyAirGappedBackupVaultProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLogicallyAirGappedBackupVaultProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLogicallyAirGappedBackupVaultProps> {
        java.lang.String backupVaultName;
        java.lang.Number maxRetentionDays;
        java.lang.Number minRetentionDays;
        java.lang.Object accessPolicy;
        java.util.Map<java.lang.String, java.lang.String> backupVaultTags;
        java.lang.Object notifications;

        /**
         * Sets the value of {@link CfnLogicallyAirGappedBackupVaultProps#getBackupVaultName}
         * @param backupVaultName The name of a logical container where backups are stored. This parameter is required.
         *                        Logically air-gapped backup vaults are identified by names that are unique to the account used to create them and the Region where they are created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupVaultName(java.lang.String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogicallyAirGappedBackupVaultProps#getMaxRetentionDays}
         * @param maxRetentionDays The maximum retention period that the vault retains its recovery points. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRetentionDays(java.lang.Number maxRetentionDays) {
            this.maxRetentionDays = maxRetentionDays;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogicallyAirGappedBackupVaultProps#getMinRetentionDays}
         * @param minRetentionDays This setting specifies the minimum retention period that the vault retains its recovery points. This parameter is required.
         *                         The minimum value accepted is 7 days.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minRetentionDays(java.lang.Number minRetentionDays) {
            this.minRetentionDays = minRetentionDays;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogicallyAirGappedBackupVaultProps#getAccessPolicy}
         * @param accessPolicy The backup vault access policy document in JSON format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicy(java.lang.Object accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogicallyAirGappedBackupVaultProps#getBackupVaultTags}
         * @param backupVaultTags The tags to assign to the vault.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupVaultTags(java.util.Map<java.lang.String, java.lang.String> backupVaultTags) {
            this.backupVaultTags = backupVaultTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogicallyAirGappedBackupVaultProps#getNotifications}
         * @param notifications Returns event notifications for the specified backup vault.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifications(software.amazon.awscdk.IResolvable notifications) {
            this.notifications = notifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnLogicallyAirGappedBackupVaultProps#getNotifications}
         * @param notifications Returns event notifications for the specified backup vault.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifications(software.amazon.awscdk.services.backup.CfnLogicallyAirGappedBackupVault.NotificationObjectTypeProperty notifications) {
            this.notifications = notifications;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLogicallyAirGappedBackupVaultProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLogicallyAirGappedBackupVaultProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLogicallyAirGappedBackupVaultProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLogicallyAirGappedBackupVaultProps {
        private final java.lang.String backupVaultName;
        private final java.lang.Number maxRetentionDays;
        private final java.lang.Number minRetentionDays;
        private final java.lang.Object accessPolicy;
        private final java.util.Map<java.lang.String, java.lang.String> backupVaultTags;
        private final java.lang.Object notifications;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.backupVaultName = software.amazon.jsii.Kernel.get(this, "backupVaultName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxRetentionDays = software.amazon.jsii.Kernel.get(this, "maxRetentionDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minRetentionDays = software.amazon.jsii.Kernel.get(this, "minRetentionDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.accessPolicy = software.amazon.jsii.Kernel.get(this, "accessPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.backupVaultTags = software.amazon.jsii.Kernel.get(this, "backupVaultTags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.notifications = software.amazon.jsii.Kernel.get(this, "notifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.backupVaultName = java.util.Objects.requireNonNull(builder.backupVaultName, "backupVaultName is required");
            this.maxRetentionDays = java.util.Objects.requireNonNull(builder.maxRetentionDays, "maxRetentionDays is required");
            this.minRetentionDays = java.util.Objects.requireNonNull(builder.minRetentionDays, "minRetentionDays is required");
            this.accessPolicy = builder.accessPolicy;
            this.backupVaultTags = builder.backupVaultTags;
            this.notifications = builder.notifications;
        }

        @Override
        public final java.lang.String getBackupVaultName() {
            return this.backupVaultName;
        }

        @Override
        public final java.lang.Number getMaxRetentionDays() {
            return this.maxRetentionDays;
        }

        @Override
        public final java.lang.Number getMinRetentionDays() {
            return this.minRetentionDays;
        }

        @Override
        public final java.lang.Object getAccessPolicy() {
            return this.accessPolicy;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getBackupVaultTags() {
            return this.backupVaultTags;
        }

        @Override
        public final java.lang.Object getNotifications() {
            return this.notifications;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("backupVaultName", om.valueToTree(this.getBackupVaultName()));
            data.set("maxRetentionDays", om.valueToTree(this.getMaxRetentionDays()));
            data.set("minRetentionDays", om.valueToTree(this.getMinRetentionDays()));
            if (this.getAccessPolicy() != null) {
                data.set("accessPolicy", om.valueToTree(this.getAccessPolicy()));
            }
            if (this.getBackupVaultTags() != null) {
                data.set("backupVaultTags", om.valueToTree(this.getBackupVaultTags()));
            }
            if (this.getNotifications() != null) {
                data.set("notifications", om.valueToTree(this.getNotifications()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.CfnLogicallyAirGappedBackupVaultProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLogicallyAirGappedBackupVaultProps.Jsii$Proxy that = (CfnLogicallyAirGappedBackupVaultProps.Jsii$Proxy) o;

            if (!backupVaultName.equals(that.backupVaultName)) return false;
            if (!maxRetentionDays.equals(that.maxRetentionDays)) return false;
            if (!minRetentionDays.equals(that.minRetentionDays)) return false;
            if (this.accessPolicy != null ? !this.accessPolicy.equals(that.accessPolicy) : that.accessPolicy != null) return false;
            if (this.backupVaultTags != null ? !this.backupVaultTags.equals(that.backupVaultTags) : that.backupVaultTags != null) return false;
            return this.notifications != null ? this.notifications.equals(that.notifications) : that.notifications == null;
        }

        @Override
        public final int hashCode() {
            int result = this.backupVaultName.hashCode();
            result = 31 * result + (this.maxRetentionDays.hashCode());
            result = 31 * result + (this.minRetentionDays.hashCode());
            result = 31 * result + (this.accessPolicy != null ? this.accessPolicy.hashCode() : 0);
            result = 31 * result + (this.backupVaultTags != null ? this.backupVaultTags.hashCode() : 0);
            result = 31 * result + (this.notifications != null ? this.notifications.hashCode() : 0);
            return result;
        }
    }
}
