package software.amazon.awscdk.services.backup;

/**
 * Creates a restore testing plan.
 * <p>
 * The first of two steps to create a restore testing plan. After this request is successful, finish the procedure using CreateRestoreTestingSelection.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.backup.*;
 * CfnRestoreTestingPlan cfnRestoreTestingPlan = CfnRestoreTestingPlan.Builder.create(this, "MyCfnRestoreTestingPlan")
 *         .recoveryPointSelection(RestoreTestingRecoveryPointSelectionProperty.builder()
 *                 .algorithm("algorithm")
 *                 .includeVaults(List.of("includeVaults"))
 *                 .recoveryPointTypes(List.of("recoveryPointTypes"))
 *                 // the properties below are optional
 *                 .excludeVaults(List.of("excludeVaults"))
 *                 .selectionWindowDays(123)
 *                 .build())
 *         .restoreTestingPlanName("restoreTestingPlanName")
 *         .scheduleExpression("scheduleExpression")
 *         // the properties below are optional
 *         .scheduleExpressionTimezone("scheduleExpressionTimezone")
 *         .startWindowHours(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:59.026Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnRestoreTestingPlan")
public class CfnRestoreTestingPlan extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.backup.IRestoreTestingPlanRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnRestoreTestingPlan(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRestoreTestingPlan(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.backup.CfnRestoreTestingPlan.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRestoreTestingPlan(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.CfnRestoreTestingPlanProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a restore testing plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRestoreTestingPlanArn() {
        return software.amazon.jsii.Kernel.get(this, "attrRestoreTestingPlanArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a RestoreTestingPlan resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.RestoreTestingPlanReference getRestoreTestingPlanRef() {
        return software.amazon.jsii.Kernel.get(this, "restoreTestingPlanRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.RestoreTestingPlanReference.class));
    }

    /**
     * The specified criteria to assign a set of resources, such as recovery point types or backup vaults.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.backup.CfnRestoreTestingPlan.RestoreTestingRecoveryPointSelectionProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRecoveryPointSelection() {
        return software.amazon.jsii.Kernel.get(this, "recoveryPointSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The specified criteria to assign a set of resources, such as recovery point types or backup vaults.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecoveryPointSelection(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "recoveryPointSelection", java.util.Objects.requireNonNull(value, "recoveryPointSelection is required"));
    }

    /**
     * The specified criteria to assign a set of resources, such as recovery point types or backup vaults.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecoveryPointSelection(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.CfnRestoreTestingPlan.RestoreTestingRecoveryPointSelectionProperty value) {
        software.amazon.jsii.Kernel.set(this, "recoveryPointSelection", java.util.Objects.requireNonNull(value, "recoveryPointSelection is required"));
    }

    /**
     * The RestoreTestingPlanName is a unique string that is the name of the restore testing plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestoreTestingPlanName() {
        return software.amazon.jsii.Kernel.get(this, "restoreTestingPlanName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The RestoreTestingPlanName is a unique string that is the name of the restore testing plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestoreTestingPlanName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "restoreTestingPlanName", java.util.Objects.requireNonNull(value, "restoreTestingPlanName is required"));
    }

    /**
     * A CRON expression in specified timezone when a restore testing plan is executed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScheduleExpression() {
        return software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A CRON expression in specified timezone when a restore testing plan is executed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduleExpression(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scheduleExpression", java.util.Objects.requireNonNull(value, "scheduleExpression is required"));
    }

    /**
     * Optional.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getScheduleExpressionTimezone() {
        return software.amazon.jsii.Kernel.get(this, "scheduleExpressionTimezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Optional.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduleExpressionTimezone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scheduleExpressionTimezone", value);
    }

    /**
     * Defaults to 24 hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getStartWindowHours() {
        return software.amazon.jsii.Kernel.get(this, "startWindowHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Defaults to 24 hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStartWindowHours(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "startWindowHours", value);
    }

    /**
     * Optional tags to include.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Optional tags to include.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * <code>RecoveryPointSelection</code> has five parameters (three required and two optional).
     * <p>
     * The values you specify determine which recovery point is included in the restore test. You must indicate with <code>Algorithm</code> if you want the latest recovery point within your <code>SelectionWindowDays</code> or if you want a random recovery point, and you must indicate through <code>IncludeVaults</code> from which vaults the recovery points can be chosen.
     * <p>
     * <code>Algorithm</code> ( <em>required</em> ) Valid values: " <code>LATEST_WITHIN_WINDOW</code> " or " <code>RANDOM_WITHIN_WINDOW</code> ".
     * <p>
     * <code>Recovery point types</code> ( <em>required</em> ) Valid values: " <code>SNAPSHOT</code> " and/or " <code>CONTINUOUS</code> ". Include <code>SNAPSHOT</code> to restore only snapshot recovery points; include <code>CONTINUOUS</code> to restore continuous recovery points (point in time restore / PITR); use both to restore either a snapshot or a continuous recovery point. The recovery point will be determined by the value for <code>Algorithm</code> .
     * <p>
     * <code>IncludeVaults</code> ( <em>required</em> ). You must include one or more backup vaults. Use the wildcard ["*"] or specific ARNs.
     * <p>
     * <code>SelectionWindowDays</code> ( <em>optional</em> ) Value must be an integer (in days) from 1 to 365. If not included, the value defaults to <code>30</code> .
     * <p>
     * <code>ExcludeVaults</code> ( <em>optional</em> ). You can choose to input one or more specific backup vault ARNs to exclude those vaults' contents from restore eligibility. Or, you can include a list of selectors. If this parameter and its value are not included, it defaults to empty list.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.backup.*;
     * RestoreTestingRecoveryPointSelectionProperty restoreTestingRecoveryPointSelectionProperty = RestoreTestingRecoveryPointSelectionProperty.builder()
     *         .algorithm("algorithm")
     *         .includeVaults(List.of("includeVaults"))
     *         .recoveryPointTypes(List.of("recoveryPointTypes"))
     *         // the properties below are optional
     *         .excludeVaults(List.of("excludeVaults"))
     *         .selectionWindowDays(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingplan-restoretestingrecoverypointselection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingplan-restoretestingrecoverypointselection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnRestoreTestingPlan.RestoreTestingRecoveryPointSelectionProperty")
    @software.amazon.jsii.Jsii.Proxy(RestoreTestingRecoveryPointSelectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RestoreTestingRecoveryPointSelectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Acceptable values include "LATEST_WITHIN_WINDOW" or "RANDOM_WITHIN_WINDOW".
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingplan-restoretestingrecoverypointselection.html#cfn-backup-restoretestingplan-restoretestingrecoverypointselection-algorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingplan-restoretestingrecoverypointselection.html#cfn-backup-restoretestingplan-restoretestingrecoverypointselection-algorithm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlgorithm();

        /**
         * Accepted values include wildcard ["<em>"] or by specific ARNs or ARN wilcard replacement ["arn:aws:backup:us-west-2:123456789012:backup-vault:asdf", ...] ["arn:aws:backup:</em>:<em>:backup-vault:asdf-</em>", ...].
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingplan-restoretestingrecoverypointselection.html#cfn-backup-restoretestingplan-restoretestingrecoverypointselection-includevaults">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingplan-restoretestingrecoverypointselection.html#cfn-backup-restoretestingplan-restoretestingrecoverypointselection-includevaults</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getIncludeVaults();

        /**
         * These are the types of recovery points.
         * <p>
         * Include <code>SNAPSHOT</code> to restore only snapshot recovery points; include <code>CONTINUOUS</code> to restore continuous recovery points (point in time restore / PITR); use both to restore either a snapshot or a continuous recovery point. The recovery point will be determined by the value for <code>Algorithm</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingplan-restoretestingrecoverypointselection.html#cfn-backup-restoretestingplan-restoretestingrecoverypointselection-recoverypointtypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingplan-restoretestingrecoverypointselection.html#cfn-backup-restoretestingplan-restoretestingrecoverypointselection-recoverypointtypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getRecoveryPointTypes();

        /**
         * Accepted values include specific ARNs or list of selectors.
         * <p>
         * Defaults to empty list if not listed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingplan-restoretestingrecoverypointselection.html#cfn-backup-restoretestingplan-restoretestingrecoverypointselection-excludevaults">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingplan-restoretestingrecoverypointselection.html#cfn-backup-restoretestingplan-restoretestingrecoverypointselection-excludevaults</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludeVaults() {
            return null;
        }

        /**
         * Accepted values are integers from 1 to 365.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingplan-restoretestingrecoverypointselection.html#cfn-backup-restoretestingplan-restoretestingrecoverypointselection-selectionwindowdays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-restoretestingplan-restoretestingrecoverypointselection.html#cfn-backup-restoretestingplan-restoretestingrecoverypointselection-selectionwindowdays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSelectionWindowDays() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RestoreTestingRecoveryPointSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RestoreTestingRecoveryPointSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RestoreTestingRecoveryPointSelectionProperty> {
            java.lang.String algorithm;
            java.util.List<java.lang.String> includeVaults;
            java.util.List<java.lang.String> recoveryPointTypes;
            java.util.List<java.lang.String> excludeVaults;
            java.lang.Number selectionWindowDays;

            /**
             * Sets the value of {@link RestoreTestingRecoveryPointSelectionProperty#getAlgorithm}
             * @param algorithm Acceptable values include "LATEST_WITHIN_WINDOW" or "RANDOM_WITHIN_WINDOW". This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithm(java.lang.String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            /**
             * Sets the value of {@link RestoreTestingRecoveryPointSelectionProperty#getIncludeVaults}
             * @param includeVaults Accepted values include wildcard ["<em>"] or by specific ARNs or ARN wilcard replacement ["arn:aws:backup:us-west-2:123456789012:backup-vault:asdf", ...] ["arn:aws:backup:</em>:<em>:backup-vault:asdf-</em>", ...]. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeVaults(java.util.List<java.lang.String> includeVaults) {
                this.includeVaults = includeVaults;
                return this;
            }

            /**
             * Sets the value of {@link RestoreTestingRecoveryPointSelectionProperty#getRecoveryPointTypes}
             * @param recoveryPointTypes These are the types of recovery points. This parameter is required.
             *                           Include <code>SNAPSHOT</code> to restore only snapshot recovery points; include <code>CONTINUOUS</code> to restore continuous recovery points (point in time restore / PITR); use both to restore either a snapshot or a continuous recovery point. The recovery point will be determined by the value for <code>Algorithm</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recoveryPointTypes(java.util.List<java.lang.String> recoveryPointTypes) {
                this.recoveryPointTypes = recoveryPointTypes;
                return this;
            }

            /**
             * Sets the value of {@link RestoreTestingRecoveryPointSelectionProperty#getExcludeVaults}
             * @param excludeVaults Accepted values include specific ARNs or list of selectors.
             *                      Defaults to empty list if not listed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeVaults(java.util.List<java.lang.String> excludeVaults) {
                this.excludeVaults = excludeVaults;
                return this;
            }

            /**
             * Sets the value of {@link RestoreTestingRecoveryPointSelectionProperty#getSelectionWindowDays}
             * @param selectionWindowDays Accepted values are integers from 1 to 365.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectionWindowDays(java.lang.Number selectionWindowDays) {
                this.selectionWindowDays = selectionWindowDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RestoreTestingRecoveryPointSelectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RestoreTestingRecoveryPointSelectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RestoreTestingRecoveryPointSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RestoreTestingRecoveryPointSelectionProperty {
            private final java.lang.String algorithm;
            private final java.util.List<java.lang.String> includeVaults;
            private final java.util.List<java.lang.String> recoveryPointTypes;
            private final java.util.List<java.lang.String> excludeVaults;
            private final java.lang.Number selectionWindowDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.algorithm = software.amazon.jsii.Kernel.get(this, "algorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeVaults = software.amazon.jsii.Kernel.get(this, "includeVaults", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.recoveryPointTypes = software.amazon.jsii.Kernel.get(this, "recoveryPointTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.excludeVaults = software.amazon.jsii.Kernel.get(this, "excludeVaults", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.selectionWindowDays = software.amazon.jsii.Kernel.get(this, "selectionWindowDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.algorithm = java.util.Objects.requireNonNull(builder.algorithm, "algorithm is required");
                this.includeVaults = java.util.Objects.requireNonNull(builder.includeVaults, "includeVaults is required");
                this.recoveryPointTypes = java.util.Objects.requireNonNull(builder.recoveryPointTypes, "recoveryPointTypes is required");
                this.excludeVaults = builder.excludeVaults;
                this.selectionWindowDays = builder.selectionWindowDays;
            }

            @Override
            public final java.lang.String getAlgorithm() {
                return this.algorithm;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludeVaults() {
                return this.includeVaults;
            }

            @Override
            public final java.util.List<java.lang.String> getRecoveryPointTypes() {
                return this.recoveryPointTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludeVaults() {
                return this.excludeVaults;
            }

            @Override
            public final java.lang.Number getSelectionWindowDays() {
                return this.selectionWindowDays;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("algorithm", om.valueToTree(this.getAlgorithm()));
                data.set("includeVaults", om.valueToTree(this.getIncludeVaults()));
                data.set("recoveryPointTypes", om.valueToTree(this.getRecoveryPointTypes()));
                if (this.getExcludeVaults() != null) {
                    data.set("excludeVaults", om.valueToTree(this.getExcludeVaults()));
                }
                if (this.getSelectionWindowDays() != null) {
                    data.set("selectionWindowDays", om.valueToTree(this.getSelectionWindowDays()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.CfnRestoreTestingPlan.RestoreTestingRecoveryPointSelectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RestoreTestingRecoveryPointSelectionProperty.Jsii$Proxy that = (RestoreTestingRecoveryPointSelectionProperty.Jsii$Proxy) o;

                if (!algorithm.equals(that.algorithm)) return false;
                if (!includeVaults.equals(that.includeVaults)) return false;
                if (!recoveryPointTypes.equals(that.recoveryPointTypes)) return false;
                if (this.excludeVaults != null ? !this.excludeVaults.equals(that.excludeVaults) : that.excludeVaults != null) return false;
                return this.selectionWindowDays != null ? this.selectionWindowDays.equals(that.selectionWindowDays) : that.selectionWindowDays == null;
            }

            @Override
            public final int hashCode() {
                int result = this.algorithm.hashCode();
                result = 31 * result + (this.includeVaults.hashCode());
                result = 31 * result + (this.recoveryPointTypes.hashCode());
                result = 31 * result + (this.excludeVaults != null ? this.excludeVaults.hashCode() : 0);
                result = 31 * result + (this.selectionWindowDays != null ? this.selectionWindowDays.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.backup.CfnRestoreTestingPlan}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.backup.CfnRestoreTestingPlan> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.backup.CfnRestoreTestingPlanProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.backup.CfnRestoreTestingPlanProps.Builder();
        }

        /**
         * The specified criteria to assign a set of resources, such as recovery point types or backup vaults.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-recoverypointselection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-recoverypointselection</a>
         * @param recoveryPointSelection The specified criteria to assign a set of resources, such as recovery point types or backup vaults. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recoveryPointSelection(final software.amazon.awscdk.IResolvable recoveryPointSelection) {
            this.props.recoveryPointSelection(recoveryPointSelection);
            return this;
        }
        /**
         * The specified criteria to assign a set of resources, such as recovery point types or backup vaults.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-recoverypointselection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-recoverypointselection</a>
         * @param recoveryPointSelection The specified criteria to assign a set of resources, such as recovery point types or backup vaults. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recoveryPointSelection(final software.amazon.awscdk.services.backup.CfnRestoreTestingPlan.RestoreTestingRecoveryPointSelectionProperty recoveryPointSelection) {
            this.props.recoveryPointSelection(recoveryPointSelection);
            return this;
        }

        /**
         * The RestoreTestingPlanName is a unique string that is the name of the restore testing plan.
         * <p>
         * This cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-restoretestingplanname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-restoretestingplanname</a>
         * @param restoreTestingPlanName The RestoreTestingPlanName is a unique string that is the name of the restore testing plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreTestingPlanName(final java.lang.String restoreTestingPlanName) {
            this.props.restoreTestingPlanName(restoreTestingPlanName);
            return this;
        }

        /**
         * A CRON expression in specified timezone when a restore testing plan is executed.
         * <p>
         * When no CRON expression is provided, AWS Backup will use the default expression <code>cron(0 5 ? * * *)</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-scheduleexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-scheduleexpression</a>
         * @param scheduleExpression A CRON expression in specified timezone when a restore testing plan is executed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleExpression(final java.lang.String scheduleExpression) {
            this.props.scheduleExpression(scheduleExpression);
            return this;
        }

        /**
         * Optional.
         * <p>
         * This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-scheduleexpressiontimezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-scheduleexpressiontimezone</a>
         * @param scheduleExpressionTimezone Optional. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleExpressionTimezone(final java.lang.String scheduleExpressionTimezone) {
            this.props.scheduleExpressionTimezone(scheduleExpressionTimezone);
            return this;
        }

        /**
         * Defaults to 24 hours.
         * <p>
         * A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-startwindowhours">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-startwindowhours</a>
         * @param startWindowHours Defaults to 24 hours. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startWindowHours(final java.lang.Number startWindowHours) {
            this.props.startWindowHours(startWindowHours);
            return this;
        }

        /**
         * Optional tags to include.
         * <p>
         * A tag is a key-value pair you can use to manage, filter, and search for your resources. Allowed characters include UTF-8 letters,numbers, spaces, and the following characters: <code>+ - = . _ : /.</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-tags</a>
         * @param tags Optional tags to include. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.backup.CfnRestoreTestingPlan}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.backup.CfnRestoreTestingPlan build() {
            return new software.amazon.awscdk.services.backup.CfnRestoreTestingPlan(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
