package software.amazon.awscdk.services.bedrock;

/**
 * A reference to a ApplicationInferenceProfile resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * ApplicationInferenceProfileReference applicationInferenceProfileReference = ApplicationInferenceProfileReference.builder()
 *         .inferenceProfileIdentifier("inferenceProfileIdentifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:59.312Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.ApplicationInferenceProfileReference")
@software.amazon.jsii.Jsii.Proxy(ApplicationInferenceProfileReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationInferenceProfileReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The InferenceProfileIdentifier of the ApplicationInferenceProfile resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInferenceProfileIdentifier();

    /**
     * @return a {@link Builder} of {@link ApplicationInferenceProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationInferenceProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationInferenceProfileReference> {
        java.lang.String inferenceProfileIdentifier;

        /**
         * Sets the value of {@link ApplicationInferenceProfileReference#getInferenceProfileIdentifier}
         * @param inferenceProfileIdentifier The InferenceProfileIdentifier of the ApplicationInferenceProfile resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceProfileIdentifier(java.lang.String inferenceProfileIdentifier) {
            this.inferenceProfileIdentifier = inferenceProfileIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationInferenceProfileReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplicationInferenceProfileReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplicationInferenceProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationInferenceProfileReference {
        private final java.lang.String inferenceProfileIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.inferenceProfileIdentifier = software.amazon.jsii.Kernel.get(this, "inferenceProfileIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.inferenceProfileIdentifier = java.util.Objects.requireNonNull(builder.inferenceProfileIdentifier, "inferenceProfileIdentifier is required");
        }

        @Override
        public final java.lang.String getInferenceProfileIdentifier() {
            return this.inferenceProfileIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("inferenceProfileIdentifier", om.valueToTree(this.getInferenceProfileIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.ApplicationInferenceProfileReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationInferenceProfileReference.Jsii$Proxy that = (ApplicationInferenceProfileReference.Jsii$Proxy) o;

            return this.inferenceProfileIdentifier.equals(that.inferenceProfileIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.inferenceProfileIdentifier.hashCode();
            return result;
        }
    }
}
