package software.amazon.awscdk.services.bedrock;

/**
 * A data automation project.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * CfnDataAutomationProject cfnDataAutomationProject = CfnDataAutomationProject.Builder.create(this, "MyCfnDataAutomationProject")
 *         .projectName("projectName")
 *         // the properties below are optional
 *         .customOutputConfiguration(CustomOutputConfigurationProperty.builder()
 *                 .blueprints(List.of(BlueprintItemProperty.builder()
 *                         .blueprintArn("blueprintArn")
 *                         // the properties below are optional
 *                         .blueprintStage("blueprintStage")
 *                         .blueprintVersion("blueprintVersion")
 *                         .build()))
 *                 .build())
 *         .kmsEncryptionContext(Map.of(
 *                 "kmsEncryptionContextKey", "kmsEncryptionContext"))
 *         .kmsKeyId("kmsKeyId")
 *         .overrideConfiguration(OverrideConfigurationProperty.builder()
 *                 .audio(AudioOverrideConfigurationProperty.builder()
 *                         .modalityProcessing(ModalityProcessingConfigurationProperty.builder()
 *                                 .state("state")
 *                                 .build())
 *                         .build())
 *                 .document(DocumentOverrideConfigurationProperty.builder()
 *                         .modalityProcessing(ModalityProcessingConfigurationProperty.builder()
 *                                 .state("state")
 *                                 .build())
 *                         .splitter(SplitterConfigurationProperty.builder()
 *                                 .state("state")
 *                                 .build())
 *                         .build())
 *                 .image(ImageOverrideConfigurationProperty.builder()
 *                         .modalityProcessing(ModalityProcessingConfigurationProperty.builder()
 *                                 .state("state")
 *                                 .build())
 *                         .build())
 *                 .modalityRouting(ModalityRoutingConfigurationProperty.builder()
 *                         .jpeg("jpeg")
 *                         .mov("mov")
 *                         .mp4("mp4")
 *                         .png("png")
 *                         .build())
 *                 .video(VideoOverrideConfigurationProperty.builder()
 *                         .modalityProcessing(ModalityProcessingConfigurationProperty.builder()
 *                                 .state("state")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .projectDescription("projectDescription")
 *         .standardOutputConfiguration(StandardOutputConfigurationProperty.builder()
 *                 .audio(AudioStandardOutputConfigurationProperty.builder()
 *                         .extraction(AudioStandardExtractionProperty.builder()
 *                                 .category(AudioExtractionCategoryProperty.builder()
 *                                         .state("state")
 *                                         // the properties below are optional
 *                                         .typeConfiguration(AudioExtractionCategoryTypeConfigurationProperty.builder()
 *                                                 .transcript(TranscriptConfigurationProperty.builder()
 *                                                         .channelLabeling(ChannelLabelingConfigurationProperty.builder()
 *                                                                 .state("state")
 *                                                                 .build())
 *                                                         .speakerLabeling(SpeakerLabelingConfigurationProperty.builder()
 *                                                                 .state("state")
 *                                                                 .build())
 *                                                         .build())
 *                                                 .build())
 *                                         .types(List.of("types"))
 *                                         .build())
 *                                 .build())
 *                         .generativeField(AudioStandardGenerativeFieldProperty.builder()
 *                                 .state("state")
 *                                 // the properties below are optional
 *                                 .types(List.of("types"))
 *                                 .build())
 *                         .build())
 *                 .document(DocumentStandardOutputConfigurationProperty.builder()
 *                         .extraction(DocumentStandardExtractionProperty.builder()
 *                                 .boundingBox(DocumentBoundingBoxProperty.builder()
 *                                         .state("state")
 *                                         .build())
 *                                 .granularity(DocumentExtractionGranularityProperty.builder()
 *                                         .types(List.of("types"))
 *                                         .build())
 *                                 .build())
 *                         .generativeField(DocumentStandardGenerativeFieldProperty.builder()
 *                                 .state("state")
 *                                 .build())
 *                         .outputFormat(DocumentOutputFormatProperty.builder()
 *                                 .additionalFileFormat(DocumentOutputAdditionalFileFormatProperty.builder()
 *                                         .state("state")
 *                                         .build())
 *                                 .textFormat(DocumentOutputTextFormatProperty.builder()
 *                                         .types(List.of("types"))
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .image(ImageStandardOutputConfigurationProperty.builder()
 *                         .extraction(ImageStandardExtractionProperty.builder()
 *                                 .boundingBox(ImageBoundingBoxProperty.builder()
 *                                         .state("state")
 *                                         .build())
 *                                 .category(ImageExtractionCategoryProperty.builder()
 *                                         .state("state")
 *                                         // the properties below are optional
 *                                         .types(List.of("types"))
 *                                         .build())
 *                                 .build())
 *                         .generativeField(ImageStandardGenerativeFieldProperty.builder()
 *                                 .state("state")
 *                                 // the properties below are optional
 *                                 .types(List.of("types"))
 *                                 .build())
 *                         .build())
 *                 .video(VideoStandardOutputConfigurationProperty.builder()
 *                         .extraction(VideoStandardExtractionProperty.builder()
 *                                 .boundingBox(VideoBoundingBoxProperty.builder()
 *                                         .state("state")
 *                                         .build())
 *                                 .category(VideoExtractionCategoryProperty.builder()
 *                                         .state("state")
 *                                         // the properties below are optional
 *                                         .types(List.of("types"))
 *                                         .build())
 *                                 .build())
 *                         .generativeField(VideoStandardGenerativeFieldProperty.builder()
 *                                 .state("state")
 *                                 // the properties below are optional
 *                                 .types(List.of("types"))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:59.356Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject")
public class CfnDataAutomationProject extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.bedrock.IDataAutomationProjectRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnDataAutomationProject(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataAutomationProject(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataAutomationProject(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.CfnDataAutomationProjectProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * When the project was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * When the project was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModifiedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The project's ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProjectArn() {
        return software.amazon.jsii.Kernel.get(this, "attrProjectArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The project's stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProjectStage() {
        return software.amazon.jsii.Kernel.get(this, "attrProjectStage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The project's status.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a DataAutomationProject resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.DataAutomationProjectReference getDataAutomationProjectRef() {
        return software.amazon.jsii.Kernel.get(this, "dataAutomationProjectRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.DataAutomationProjectReference.class));
    }

    /**
     * The project's name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProjectName() {
        return software.amazon.jsii.Kernel.get(this, "projectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The project's name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProjectName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "projectName", java.util.Objects.requireNonNull(value, "projectName is required"));
    }

    /**
     * Blueprints to apply to objects processed by the project.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.CustomOutputConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomOutputConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "customOutputConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Blueprints to apply to objects processed by the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomOutputConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customOutputConfiguration", value);
    }

    /**
     * Blueprints to apply to objects processed by the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomOutputConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.CustomOutputConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "customOutputConfiguration", value);
    }

    /**
     * The AWS KMS encryption context to use for encryption.
     * <p>
     * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKmsEncryptionContext() {
        return software.amazon.jsii.Kernel.get(this, "kmsEncryptionContext", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The AWS KMS encryption context to use for encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsEncryptionContext(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "kmsEncryptionContext", value);
    }

    /**
     * The AWS KMS encryption context to use for encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsEncryptionContext(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kmsEncryptionContext", value);
    }

    /**
     * The AWS KMS key to use for encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS KMS key to use for encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * Additional settings for the project.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.OverrideConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOverrideConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "overrideConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Additional settings for the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOverrideConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "overrideConfiguration", value);
    }

    /**
     * Additional settings for the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOverrideConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.OverrideConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "overrideConfiguration", value);
    }

    /**
     * The project's description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProjectDescription() {
        return software.amazon.jsii.Kernel.get(this, "projectDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The project's description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProjectDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "projectDescription", value);
    }

    /**
     * The project's standard output configuration.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.StandardOutputConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStandardOutputConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "standardOutputConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The project's standard output configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStandardOutputConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "standardOutputConfiguration", value);
    }

    /**
     * The project's standard output configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStandardOutputConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.StandardOutputConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "standardOutputConfiguration", value);
    }

    /**
     * List of Tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * List of Tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Settings for generating data from audio.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * AudioExtractionCategoryProperty audioExtractionCategoryProperty = AudioExtractionCategoryProperty.builder()
     *         .state("state")
     *         // the properties below are optional
     *         .typeConfiguration(AudioExtractionCategoryTypeConfigurationProperty.builder()
     *                 .transcript(TranscriptConfigurationProperty.builder()
     *                         .channelLabeling(ChannelLabelingConfigurationProperty.builder()
     *                                 .state("state")
     *                                 .build())
     *                         .speakerLabeling(SpeakerLabelingConfigurationProperty.builder()
     *                                 .state("state")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .types(List.of("types"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audioextractioncategory.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audioextractioncategory.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.AudioExtractionCategoryProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioExtractionCategoryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioExtractionCategoryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether generating categorical data from audio is enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audioextractioncategory.html#cfn-bedrock-dataautomationproject-audioextractioncategory-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audioextractioncategory.html#cfn-bedrock-dataautomationproject-audioextractioncategory-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getState();

        /**
         * This element contains information about extractions from different types.
         * <p>
         * Used to enable speaker and channel labeling for transcripts.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.AudioExtractionCategoryTypeConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audioextractioncategory.html#cfn-bedrock-dataautomationproject-audioextractioncategory-typeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audioextractioncategory.html#cfn-bedrock-dataautomationproject-audioextractioncategory-typeconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTypeConfiguration() {
            return null;
        }

        /**
         * The types of data to generate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audioextractioncategory.html#cfn-bedrock-dataautomationproject-audioextractioncategory-types">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audioextractioncategory.html#cfn-bedrock-dataautomationproject-audioextractioncategory-types</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioExtractionCategoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioExtractionCategoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioExtractionCategoryProperty> {
            java.lang.String state;
            java.lang.Object typeConfiguration;
            java.util.List<java.lang.String> types;

            /**
             * Sets the value of {@link AudioExtractionCategoryProperty#getState}
             * @param state Whether generating categorical data from audio is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Sets the value of {@link AudioExtractionCategoryProperty#getTypeConfiguration}
             * @param typeConfiguration This element contains information about extractions from different types.
             *                          Used to enable speaker and channel labeling for transcripts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeConfiguration(software.amazon.awscdk.IResolvable typeConfiguration) {
                this.typeConfiguration = typeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AudioExtractionCategoryProperty#getTypeConfiguration}
             * @param typeConfiguration This element contains information about extractions from different types.
             *                          Used to enable speaker and channel labeling for transcripts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeConfiguration(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.AudioExtractionCategoryTypeConfigurationProperty typeConfiguration) {
                this.typeConfiguration = typeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AudioExtractionCategoryProperty#getTypes}
             * @param types The types of data to generate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder types(java.util.List<java.lang.String> types) {
                this.types = types;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioExtractionCategoryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioExtractionCategoryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioExtractionCategoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioExtractionCategoryProperty {
            private final java.lang.String state;
            private final java.lang.Object typeConfiguration;
            private final java.util.List<java.lang.String> types;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.typeConfiguration = software.amazon.jsii.Kernel.get(this, "typeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.types = software.amazon.jsii.Kernel.get(this, "types", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.state = java.util.Objects.requireNonNull(builder.state, "state is required");
                this.typeConfiguration = builder.typeConfiguration;
                this.types = builder.types;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            public final java.lang.Object getTypeConfiguration() {
                return this.typeConfiguration;
            }

            @Override
            public final java.util.List<java.lang.String> getTypes() {
                return this.types;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("state", om.valueToTree(this.getState()));
                if (this.getTypeConfiguration() != null) {
                    data.set("typeConfiguration", om.valueToTree(this.getTypeConfiguration()));
                }
                if (this.getTypes() != null) {
                    data.set("types", om.valueToTree(this.getTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.AudioExtractionCategoryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioExtractionCategoryProperty.Jsii$Proxy that = (AudioExtractionCategoryProperty.Jsii$Proxy) o;

                if (!state.equals(that.state)) return false;
                if (this.typeConfiguration != null ? !this.typeConfiguration.equals(that.typeConfiguration) : that.typeConfiguration != null) return false;
                return this.types != null ? this.types.equals(that.types) : that.types == null;
            }

            @Override
            public final int hashCode() {
                int result = this.state.hashCode();
                result = 31 * result + (this.typeConfiguration != null ? this.typeConfiguration.hashCode() : 0);
                result = 31 * result + (this.types != null ? this.types.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Allows configuration of extractions for different types of data, such as transcript and content moderation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * AudioExtractionCategoryTypeConfigurationProperty audioExtractionCategoryTypeConfigurationProperty = AudioExtractionCategoryTypeConfigurationProperty.builder()
     *         .transcript(TranscriptConfigurationProperty.builder()
     *                 .channelLabeling(ChannelLabelingConfigurationProperty.builder()
     *                         .state("state")
     *                         .build())
     *                 .speakerLabeling(SpeakerLabelingConfigurationProperty.builder()
     *                         .state("state")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audioextractioncategorytypeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audioextractioncategorytypeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.AudioExtractionCategoryTypeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioExtractionCategoryTypeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioExtractionCategoryTypeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This element allows you to configure different extractions for your transcript data, such as speaker and channel labeling.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.TranscriptConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audioextractioncategorytypeconfiguration.html#cfn-bedrock-dataautomationproject-audioextractioncategorytypeconfiguration-transcript">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audioextractioncategorytypeconfiguration.html#cfn-bedrock-dataautomationproject-audioextractioncategorytypeconfiguration-transcript</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTranscript() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioExtractionCategoryTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioExtractionCategoryTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioExtractionCategoryTypeConfigurationProperty> {
            java.lang.Object transcript;

            /**
             * Sets the value of {@link AudioExtractionCategoryTypeConfigurationProperty#getTranscript}
             * @param transcript This element allows you to configure different extractions for your transcript data, such as speaker and channel labeling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transcript(software.amazon.awscdk.IResolvable transcript) {
                this.transcript = transcript;
                return this;
            }

            /**
             * Sets the value of {@link AudioExtractionCategoryTypeConfigurationProperty#getTranscript}
             * @param transcript This element allows you to configure different extractions for your transcript data, such as speaker and channel labeling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transcript(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.TranscriptConfigurationProperty transcript) {
                this.transcript = transcript;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioExtractionCategoryTypeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioExtractionCategoryTypeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioExtractionCategoryTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioExtractionCategoryTypeConfigurationProperty {
            private final java.lang.Object transcript;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.transcript = software.amazon.jsii.Kernel.get(this, "transcript", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.transcript = builder.transcript;
            }

            @Override
            public final java.lang.Object getTranscript() {
                return this.transcript;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTranscript() != null) {
                    data.set("transcript", om.valueToTree(this.getTranscript()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.AudioExtractionCategoryTypeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioExtractionCategoryTypeConfigurationProperty.Jsii$Proxy that = (AudioExtractionCategoryTypeConfigurationProperty.Jsii$Proxy) o;

                return this.transcript != null ? this.transcript.equals(that.transcript) : that.transcript == null;
            }

            @Override
            public final int hashCode() {
                int result = this.transcript != null ? this.transcript.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Sets whether your project will process audio or not.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * AudioOverrideConfigurationProperty audioOverrideConfigurationProperty = AudioOverrideConfigurationProperty.builder()
     *         .modalityProcessing(ModalityProcessingConfigurationProperty.builder()
     *                 .state("state")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiooverrideconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiooverrideconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.AudioOverrideConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioOverrideConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioOverrideConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Sets modality processing for audio files.
         * <p>
         * All modalities are enabled by default.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ModalityProcessingConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiooverrideconfiguration.html#cfn-bedrock-dataautomationproject-audiooverrideconfiguration-modalityprocessing">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiooverrideconfiguration.html#cfn-bedrock-dataautomationproject-audiooverrideconfiguration-modalityprocessing</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getModalityProcessing() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioOverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioOverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioOverrideConfigurationProperty> {
            java.lang.Object modalityProcessing;

            /**
             * Sets the value of {@link AudioOverrideConfigurationProperty#getModalityProcessing}
             * @param modalityProcessing Sets modality processing for audio files.
             *                           All modalities are enabled by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modalityProcessing(software.amazon.awscdk.IResolvable modalityProcessing) {
                this.modalityProcessing = modalityProcessing;
                return this;
            }

            /**
             * Sets the value of {@link AudioOverrideConfigurationProperty#getModalityProcessing}
             * @param modalityProcessing Sets modality processing for audio files.
             *                           All modalities are enabled by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modalityProcessing(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ModalityProcessingConfigurationProperty modalityProcessing) {
                this.modalityProcessing = modalityProcessing;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioOverrideConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioOverrideConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioOverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioOverrideConfigurationProperty {
            private final java.lang.Object modalityProcessing;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.modalityProcessing = software.amazon.jsii.Kernel.get(this, "modalityProcessing", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.modalityProcessing = builder.modalityProcessing;
            }

            @Override
            public final java.lang.Object getModalityProcessing() {
                return this.modalityProcessing;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getModalityProcessing() != null) {
                    data.set("modalityProcessing", om.valueToTree(this.getModalityProcessing()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.AudioOverrideConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioOverrideConfigurationProperty.Jsii$Proxy that = (AudioOverrideConfigurationProperty.Jsii$Proxy) o;

                return this.modalityProcessing != null ? this.modalityProcessing.equals(that.modalityProcessing) : that.modalityProcessing == null;
            }

            @Override
            public final int hashCode() {
                int result = this.modalityProcessing != null ? this.modalityProcessing.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Settings for generating data from audio.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * AudioStandardExtractionProperty audioStandardExtractionProperty = AudioStandardExtractionProperty.builder()
     *         .category(AudioExtractionCategoryProperty.builder()
     *                 .state("state")
     *                 // the properties below are optional
     *                 .typeConfiguration(AudioExtractionCategoryTypeConfigurationProperty.builder()
     *                         .transcript(TranscriptConfigurationProperty.builder()
     *                                 .channelLabeling(ChannelLabelingConfigurationProperty.builder()
     *                                         .state("state")
     *                                         .build())
     *                                 .speakerLabeling(SpeakerLabelingConfigurationProperty.builder()
     *                                         .state("state")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .types(List.of("types"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiostandardextraction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiostandardextraction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.AudioStandardExtractionProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioStandardExtractionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioStandardExtractionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings for generating data from audio.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.AudioExtractionCategoryProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiostandardextraction.html#cfn-bedrock-dataautomationproject-audiostandardextraction-category">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiostandardextraction.html#cfn-bedrock-dataautomationproject-audiostandardextraction-category</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCategory();

        /**
         * @return a {@link Builder} of {@link AudioStandardExtractionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioStandardExtractionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioStandardExtractionProperty> {
            java.lang.Object category;

            /**
             * Sets the value of {@link AudioStandardExtractionProperty#getCategory}
             * @param category Settings for generating data from audio. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder category(software.amazon.awscdk.IResolvable category) {
                this.category = category;
                return this;
            }

            /**
             * Sets the value of {@link AudioStandardExtractionProperty#getCategory}
             * @param category Settings for generating data from audio. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder category(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.AudioExtractionCategoryProperty category) {
                this.category = category;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioStandardExtractionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioStandardExtractionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioStandardExtractionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioStandardExtractionProperty {
            private final java.lang.Object category;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.category = software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.category = java.util.Objects.requireNonNull(builder.category, "category is required");
            }

            @Override
            public final java.lang.Object getCategory() {
                return this.category;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("category", om.valueToTree(this.getCategory()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.AudioStandardExtractionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioStandardExtractionProperty.Jsii$Proxy that = (AudioStandardExtractionProperty.Jsii$Proxy) o;

                return this.category.equals(that.category);
            }

            @Override
            public final int hashCode() {
                int result = this.category.hashCode();
                return result;
            }
        }
    }
    /**
     * Settings for generating descriptions of audio.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * AudioStandardGenerativeFieldProperty audioStandardGenerativeFieldProperty = AudioStandardGenerativeFieldProperty.builder()
     *         .state("state")
     *         // the properties below are optional
     *         .types(List.of("types"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiostandardgenerativefield.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiostandardgenerativefield.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.AudioStandardGenerativeFieldProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioStandardGenerativeFieldProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioStandardGenerativeFieldProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether generating descriptions is enabled for audio.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiostandardgenerativefield.html#cfn-bedrock-dataautomationproject-audiostandardgenerativefield-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiostandardgenerativefield.html#cfn-bedrock-dataautomationproject-audiostandardgenerativefield-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getState();

        /**
         * The types of description to generate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiostandardgenerativefield.html#cfn-bedrock-dataautomationproject-audiostandardgenerativefield-types">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiostandardgenerativefield.html#cfn-bedrock-dataautomationproject-audiostandardgenerativefield-types</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioStandardGenerativeFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioStandardGenerativeFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioStandardGenerativeFieldProperty> {
            java.lang.String state;
            java.util.List<java.lang.String> types;

            /**
             * Sets the value of {@link AudioStandardGenerativeFieldProperty#getState}
             * @param state Whether generating descriptions is enabled for audio. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Sets the value of {@link AudioStandardGenerativeFieldProperty#getTypes}
             * @param types The types of description to generate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder types(java.util.List<java.lang.String> types) {
                this.types = types;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioStandardGenerativeFieldProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioStandardGenerativeFieldProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioStandardGenerativeFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioStandardGenerativeFieldProperty {
            private final java.lang.String state;
            private final java.util.List<java.lang.String> types;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.types = software.amazon.jsii.Kernel.get(this, "types", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.state = java.util.Objects.requireNonNull(builder.state, "state is required");
                this.types = builder.types;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            public final java.util.List<java.lang.String> getTypes() {
                return this.types;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("state", om.valueToTree(this.getState()));
                if (this.getTypes() != null) {
                    data.set("types", om.valueToTree(this.getTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.AudioStandardGenerativeFieldProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioStandardGenerativeFieldProperty.Jsii$Proxy that = (AudioStandardGenerativeFieldProperty.Jsii$Proxy) o;

                if (!state.equals(that.state)) return false;
                return this.types != null ? this.types.equals(that.types) : that.types == null;
            }

            @Override
            public final int hashCode() {
                int result = this.state.hashCode();
                result = 31 * result + (this.types != null ? this.types.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Output settings for processing audio.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * AudioStandardOutputConfigurationProperty audioStandardOutputConfigurationProperty = AudioStandardOutputConfigurationProperty.builder()
     *         .extraction(AudioStandardExtractionProperty.builder()
     *                 .category(AudioExtractionCategoryProperty.builder()
     *                         .state("state")
     *                         // the properties below are optional
     *                         .typeConfiguration(AudioExtractionCategoryTypeConfigurationProperty.builder()
     *                                 .transcript(TranscriptConfigurationProperty.builder()
     *                                         .channelLabeling(ChannelLabelingConfigurationProperty.builder()
     *                                                 .state("state")
     *                                                 .build())
     *                                         .speakerLabeling(SpeakerLabelingConfigurationProperty.builder()
     *                                                 .state("state")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .types(List.of("types"))
     *                         .build())
     *                 .build())
     *         .generativeField(AudioStandardGenerativeFieldProperty.builder()
     *                 .state("state")
     *                 // the properties below are optional
     *                 .types(List.of("types"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiostandardoutputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiostandardoutputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.AudioStandardOutputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioStandardOutputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioStandardOutputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings for populating data fields that describe the audio.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.AudioStandardExtractionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiostandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-audiostandardoutputconfiguration-extraction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiostandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-audiostandardoutputconfiguration-extraction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExtraction() {
            return null;
        }

        /**
         * Whether to generate descriptions of the data.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.AudioStandardGenerativeFieldProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiostandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-audiostandardoutputconfiguration-generativefield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-audiostandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-audiostandardoutputconfiguration-generativefield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGenerativeField() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioStandardOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioStandardOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioStandardOutputConfigurationProperty> {
            java.lang.Object extraction;
            java.lang.Object generativeField;

            /**
             * Sets the value of {@link AudioStandardOutputConfigurationProperty#getExtraction}
             * @param extraction Settings for populating data fields that describe the audio.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extraction(software.amazon.awscdk.IResolvable extraction) {
                this.extraction = extraction;
                return this;
            }

            /**
             * Sets the value of {@link AudioStandardOutputConfigurationProperty#getExtraction}
             * @param extraction Settings for populating data fields that describe the audio.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extraction(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.AudioStandardExtractionProperty extraction) {
                this.extraction = extraction;
                return this;
            }

            /**
             * Sets the value of {@link AudioStandardOutputConfigurationProperty#getGenerativeField}
             * @param generativeField Whether to generate descriptions of the data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generativeField(software.amazon.awscdk.IResolvable generativeField) {
                this.generativeField = generativeField;
                return this;
            }

            /**
             * Sets the value of {@link AudioStandardOutputConfigurationProperty#getGenerativeField}
             * @param generativeField Whether to generate descriptions of the data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generativeField(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.AudioStandardGenerativeFieldProperty generativeField) {
                this.generativeField = generativeField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioStandardOutputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioStandardOutputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioStandardOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioStandardOutputConfigurationProperty {
            private final java.lang.Object extraction;
            private final java.lang.Object generativeField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.extraction = software.amazon.jsii.Kernel.get(this, "extraction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.generativeField = software.amazon.jsii.Kernel.get(this, "generativeField", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.extraction = builder.extraction;
                this.generativeField = builder.generativeField;
            }

            @Override
            public final java.lang.Object getExtraction() {
                return this.extraction;
            }

            @Override
            public final java.lang.Object getGenerativeField() {
                return this.generativeField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExtraction() != null) {
                    data.set("extraction", om.valueToTree(this.getExtraction()));
                }
                if (this.getGenerativeField() != null) {
                    data.set("generativeField", om.valueToTree(this.getGenerativeField()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.AudioStandardOutputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioStandardOutputConfigurationProperty.Jsii$Proxy that = (AudioStandardOutputConfigurationProperty.Jsii$Proxy) o;

                if (this.extraction != null ? !this.extraction.equals(that.extraction) : that.extraction != null) return false;
                return this.generativeField != null ? this.generativeField.equals(that.generativeField) : that.generativeField == null;
            }

            @Override
            public final int hashCode() {
                int result = this.extraction != null ? this.extraction.hashCode() : 0;
                result = 31 * result + (this.generativeField != null ? this.generativeField.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An abbreviated summary of a blueprint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * BlueprintItemProperty blueprintItemProperty = BlueprintItemProperty.builder()
     *         .blueprintArn("blueprintArn")
     *         // the properties below are optional
     *         .blueprintStage("blueprintStage")
     *         .blueprintVersion("blueprintVersion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-blueprintitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-blueprintitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.BlueprintItemProperty")
    @software.amazon.jsii.Jsii.Proxy(BlueprintItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BlueprintItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The blueprint's ARN.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-blueprintitem.html#cfn-bedrock-dataautomationproject-blueprintitem-blueprintarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-blueprintitem.html#cfn-bedrock-dataautomationproject-blueprintitem-blueprintarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBlueprintArn();

        /**
         * The blueprint's stage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-blueprintitem.html#cfn-bedrock-dataautomationproject-blueprintitem-blueprintstage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-blueprintitem.html#cfn-bedrock-dataautomationproject-blueprintitem-blueprintstage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBlueprintStage() {
            return null;
        }

        /**
         * The blueprint's version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-blueprintitem.html#cfn-bedrock-dataautomationproject-blueprintitem-blueprintversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-blueprintitem.html#cfn-bedrock-dataautomationproject-blueprintitem-blueprintversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBlueprintVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BlueprintItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BlueprintItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BlueprintItemProperty> {
            java.lang.String blueprintArn;
            java.lang.String blueprintStage;
            java.lang.String blueprintVersion;

            /**
             * Sets the value of {@link BlueprintItemProperty#getBlueprintArn}
             * @param blueprintArn The blueprint's ARN. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blueprintArn(java.lang.String blueprintArn) {
                this.blueprintArn = blueprintArn;
                return this;
            }

            /**
             * Sets the value of {@link BlueprintItemProperty#getBlueprintStage}
             * @param blueprintStage The blueprint's stage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blueprintStage(java.lang.String blueprintStage) {
                this.blueprintStage = blueprintStage;
                return this;
            }

            /**
             * Sets the value of {@link BlueprintItemProperty#getBlueprintVersion}
             * @param blueprintVersion The blueprint's version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blueprintVersion(java.lang.String blueprintVersion) {
                this.blueprintVersion = blueprintVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlueprintItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BlueprintItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BlueprintItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlueprintItemProperty {
            private final java.lang.String blueprintArn;
            private final java.lang.String blueprintStage;
            private final java.lang.String blueprintVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blueprintArn = software.amazon.jsii.Kernel.get(this, "blueprintArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.blueprintStage = software.amazon.jsii.Kernel.get(this, "blueprintStage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.blueprintVersion = software.amazon.jsii.Kernel.get(this, "blueprintVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blueprintArn = java.util.Objects.requireNonNull(builder.blueprintArn, "blueprintArn is required");
                this.blueprintStage = builder.blueprintStage;
                this.blueprintVersion = builder.blueprintVersion;
            }

            @Override
            public final java.lang.String getBlueprintArn() {
                return this.blueprintArn;
            }

            @Override
            public final java.lang.String getBlueprintStage() {
                return this.blueprintStage;
            }

            @Override
            public final java.lang.String getBlueprintVersion() {
                return this.blueprintVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("blueprintArn", om.valueToTree(this.getBlueprintArn()));
                if (this.getBlueprintStage() != null) {
                    data.set("blueprintStage", om.valueToTree(this.getBlueprintStage()));
                }
                if (this.getBlueprintVersion() != null) {
                    data.set("blueprintVersion", om.valueToTree(this.getBlueprintVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.BlueprintItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlueprintItemProperty.Jsii$Proxy that = (BlueprintItemProperty.Jsii$Proxy) o;

                if (!blueprintArn.equals(that.blueprintArn)) return false;
                if (this.blueprintStage != null ? !this.blueprintStage.equals(that.blueprintStage) : that.blueprintStage != null) return false;
                return this.blueprintVersion != null ? this.blueprintVersion.equals(that.blueprintVersion) : that.blueprintVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blueprintArn.hashCode();
                result = 31 * result + (this.blueprintStage != null ? this.blueprintStage.hashCode() : 0);
                result = 31 * result + (this.blueprintVersion != null ? this.blueprintVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Enables or disables channel labeling.
     * <p>
     * Channel labeling, when enabled will assign a number to each audio channel, and indicate which channel is being used in each portion of the transcript. This appears in the response as "ch_0" for the first channel, and "ch_1" for the second.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ChannelLabelingConfigurationProperty channelLabelingConfigurationProperty = ChannelLabelingConfigurationProperty.builder()
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-channellabelingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-channellabelingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ChannelLabelingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ChannelLabelingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ChannelLabelingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * State of channel labeling, either enabled or disabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-channellabelingconfiguration.html#cfn-bedrock-dataautomationproject-channellabelingconfiguration-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-channellabelingconfiguration.html#cfn-bedrock-dataautomationproject-channellabelingconfiguration-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getState();

        /**
         * @return a {@link Builder} of {@link ChannelLabelingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ChannelLabelingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ChannelLabelingConfigurationProperty> {
            java.lang.String state;

            /**
             * Sets the value of {@link ChannelLabelingConfigurationProperty#getState}
             * @param state State of channel labeling, either enabled or disabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ChannelLabelingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ChannelLabelingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ChannelLabelingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChannelLabelingConfigurationProperty {
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.state = java.util.Objects.requireNonNull(builder.state, "state is required");
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("state", om.valueToTree(this.getState()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ChannelLabelingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ChannelLabelingConfigurationProperty.Jsii$Proxy that = (ChannelLabelingConfigurationProperty.Jsii$Proxy) o;

                return this.state.equals(that.state);
            }

            @Override
            public final int hashCode() {
                int result = this.state.hashCode();
                return result;
            }
        }
    }
    /**
     * Blueprints to apply to objects processed by the project.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * CustomOutputConfigurationProperty customOutputConfigurationProperty = CustomOutputConfigurationProperty.builder()
     *         .blueprints(List.of(BlueprintItemProperty.builder()
     *                 .blueprintArn("blueprintArn")
     *                 // the properties below are optional
     *                 .blueprintStage("blueprintStage")
     *                 .blueprintVersion("blueprintVersion")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-customoutputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-customoutputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.CustomOutputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomOutputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomOutputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of blueprints.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.BlueprintItemProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-customoutputconfiguration.html#cfn-bedrock-dataautomationproject-customoutputconfiguration-blueprints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-customoutputconfiguration.html#cfn-bedrock-dataautomationproject-customoutputconfiguration-blueprints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlueprints() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomOutputConfigurationProperty> {
            java.lang.Object blueprints;

            /**
             * Sets the value of {@link CustomOutputConfigurationProperty#getBlueprints}
             * @param blueprints A list of blueprints.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blueprints(software.amazon.awscdk.IResolvable blueprints) {
                this.blueprints = blueprints;
                return this;
            }

            /**
             * Sets the value of {@link CustomOutputConfigurationProperty#getBlueprints}
             * @param blueprints A list of blueprints.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blueprints(java.util.List<? extends java.lang.Object> blueprints) {
                this.blueprints = blueprints;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomOutputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomOutputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomOutputConfigurationProperty {
            private final java.lang.Object blueprints;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blueprints = software.amazon.jsii.Kernel.get(this, "blueprints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blueprints = builder.blueprints;
            }

            @Override
            public final java.lang.Object getBlueprints() {
                return this.blueprints;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlueprints() != null) {
                    data.set("blueprints", om.valueToTree(this.getBlueprints()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.CustomOutputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomOutputConfigurationProperty.Jsii$Proxy that = (CustomOutputConfigurationProperty.Jsii$Proxy) o;

                return this.blueprints != null ? this.blueprints.equals(that.blueprints) : that.blueprints == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blueprints != null ? this.blueprints.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Bounding box settings for documents.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * DocumentBoundingBoxProperty documentBoundingBoxProperty = DocumentBoundingBoxProperty.builder()
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentboundingbox.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentboundingbox.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentBoundingBoxProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentBoundingBoxProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentBoundingBoxProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether bounding boxes are enabled for documents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentboundingbox.html#cfn-bedrock-dataautomationproject-documentboundingbox-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentboundingbox.html#cfn-bedrock-dataautomationproject-documentboundingbox-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getState();

        /**
         * @return a {@link Builder} of {@link DocumentBoundingBoxProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentBoundingBoxProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentBoundingBoxProperty> {
            java.lang.String state;

            /**
             * Sets the value of {@link DocumentBoundingBoxProperty#getState}
             * @param state Whether bounding boxes are enabled for documents. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentBoundingBoxProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentBoundingBoxProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentBoundingBoxProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentBoundingBoxProperty {
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.state = java.util.Objects.requireNonNull(builder.state, "state is required");
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("state", om.valueToTree(this.getState()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentBoundingBoxProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentBoundingBoxProperty.Jsii$Proxy that = (DocumentBoundingBoxProperty.Jsii$Proxy) o;

                return this.state.equals(that.state);
            }

            @Override
            public final int hashCode() {
                int result = this.state.hashCode();
                return result;
            }
        }
    }
    /**
     * Granularity settings for documents.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * DocumentExtractionGranularityProperty documentExtractionGranularityProperty = DocumentExtractionGranularityProperty.builder()
     *         .types(List.of("types"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentextractiongranularity.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentextractiongranularity.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentExtractionGranularityProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentExtractionGranularityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentExtractionGranularityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Granularity settings for documents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentextractiongranularity.html#cfn-bedrock-dataautomationproject-documentextractiongranularity-types">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentextractiongranularity.html#cfn-bedrock-dataautomationproject-documentextractiongranularity-types</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentExtractionGranularityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentExtractionGranularityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentExtractionGranularityProperty> {
            java.util.List<java.lang.String> types;

            /**
             * Sets the value of {@link DocumentExtractionGranularityProperty#getTypes}
             * @param types Granularity settings for documents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder types(java.util.List<java.lang.String> types) {
                this.types = types;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentExtractionGranularityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentExtractionGranularityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentExtractionGranularityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentExtractionGranularityProperty {
            private final java.util.List<java.lang.String> types;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.types = software.amazon.jsii.Kernel.get(this, "types", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.types = builder.types;
            }

            @Override
            public final java.util.List<java.lang.String> getTypes() {
                return this.types;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTypes() != null) {
                    data.set("types", om.valueToTree(this.getTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentExtractionGranularityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentExtractionGranularityProperty.Jsii$Proxy that = (DocumentExtractionGranularityProperty.Jsii$Proxy) o;

                return this.types != null ? this.types.equals(that.types) : that.types == null;
            }

            @Override
            public final int hashCode() {
                int result = this.types != null ? this.types.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Output settings for additional file formats.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * DocumentOutputAdditionalFileFormatProperty documentOutputAdditionalFileFormatProperty = DocumentOutputAdditionalFileFormatProperty.builder()
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoutputadditionalfileformat.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoutputadditionalfileformat.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentOutputAdditionalFileFormatProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentOutputAdditionalFileFormatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentOutputAdditionalFileFormatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether additional file formats are enabled for a project.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoutputadditionalfileformat.html#cfn-bedrock-dataautomationproject-documentoutputadditionalfileformat-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoutputadditionalfileformat.html#cfn-bedrock-dataautomationproject-documentoutputadditionalfileformat-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getState();

        /**
         * @return a {@link Builder} of {@link DocumentOutputAdditionalFileFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentOutputAdditionalFileFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentOutputAdditionalFileFormatProperty> {
            java.lang.String state;

            /**
             * Sets the value of {@link DocumentOutputAdditionalFileFormatProperty#getState}
             * @param state Whether additional file formats are enabled for a project. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentOutputAdditionalFileFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentOutputAdditionalFileFormatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentOutputAdditionalFileFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentOutputAdditionalFileFormatProperty {
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.state = java.util.Objects.requireNonNull(builder.state, "state is required");
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("state", om.valueToTree(this.getState()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentOutputAdditionalFileFormatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentOutputAdditionalFileFormatProperty.Jsii$Proxy that = (DocumentOutputAdditionalFileFormatProperty.Jsii$Proxy) o;

                return this.state.equals(that.state);
            }

            @Override
            public final int hashCode() {
                int result = this.state.hashCode();
                return result;
            }
        }
    }
    /**
     * A document output format.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * DocumentOutputFormatProperty documentOutputFormatProperty = DocumentOutputFormatProperty.builder()
     *         .additionalFileFormat(DocumentOutputAdditionalFileFormatProperty.builder()
     *                 .state("state")
     *                 .build())
     *         .textFormat(DocumentOutputTextFormatProperty.builder()
     *                 .types(List.of("types"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoutputformat.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoutputformat.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentOutputFormatProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentOutputFormatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentOutputFormatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Output settings for additional file formats.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentOutputAdditionalFileFormatProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoutputformat.html#cfn-bedrock-dataautomationproject-documentoutputformat-additionalfileformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoutputformat.html#cfn-bedrock-dataautomationproject-documentoutputformat-additionalfileformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAdditionalFileFormat();

        /**
         * An output text format.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentOutputTextFormatProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoutputformat.html#cfn-bedrock-dataautomationproject-documentoutputformat-textformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoutputformat.html#cfn-bedrock-dataautomationproject-documentoutputformat-textformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTextFormat();

        /**
         * @return a {@link Builder} of {@link DocumentOutputFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentOutputFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentOutputFormatProperty> {
            java.lang.Object additionalFileFormat;
            java.lang.Object textFormat;

            /**
             * Sets the value of {@link DocumentOutputFormatProperty#getAdditionalFileFormat}
             * @param additionalFileFormat Output settings for additional file formats. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalFileFormat(software.amazon.awscdk.IResolvable additionalFileFormat) {
                this.additionalFileFormat = additionalFileFormat;
                return this;
            }

            /**
             * Sets the value of {@link DocumentOutputFormatProperty#getAdditionalFileFormat}
             * @param additionalFileFormat Output settings for additional file formats. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalFileFormat(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentOutputAdditionalFileFormatProperty additionalFileFormat) {
                this.additionalFileFormat = additionalFileFormat;
                return this;
            }

            /**
             * Sets the value of {@link DocumentOutputFormatProperty#getTextFormat}
             * @param textFormat An output text format. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textFormat(software.amazon.awscdk.IResolvable textFormat) {
                this.textFormat = textFormat;
                return this;
            }

            /**
             * Sets the value of {@link DocumentOutputFormatProperty#getTextFormat}
             * @param textFormat An output text format. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textFormat(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentOutputTextFormatProperty textFormat) {
                this.textFormat = textFormat;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentOutputFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentOutputFormatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentOutputFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentOutputFormatProperty {
            private final java.lang.Object additionalFileFormat;
            private final java.lang.Object textFormat;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.additionalFileFormat = software.amazon.jsii.Kernel.get(this, "additionalFileFormat", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.textFormat = software.amazon.jsii.Kernel.get(this, "textFormat", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.additionalFileFormat = java.util.Objects.requireNonNull(builder.additionalFileFormat, "additionalFileFormat is required");
                this.textFormat = java.util.Objects.requireNonNull(builder.textFormat, "textFormat is required");
            }

            @Override
            public final java.lang.Object getAdditionalFileFormat() {
                return this.additionalFileFormat;
            }

            @Override
            public final java.lang.Object getTextFormat() {
                return this.textFormat;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("additionalFileFormat", om.valueToTree(this.getAdditionalFileFormat()));
                data.set("textFormat", om.valueToTree(this.getTextFormat()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentOutputFormatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentOutputFormatProperty.Jsii$Proxy that = (DocumentOutputFormatProperty.Jsii$Proxy) o;

                if (!additionalFileFormat.equals(that.additionalFileFormat)) return false;
                return this.textFormat.equals(that.textFormat);
            }

            @Override
            public final int hashCode() {
                int result = this.additionalFileFormat.hashCode();
                result = 31 * result + (this.textFormat.hashCode());
                return result;
            }
        }
    }
    /**
     * An output text format.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * DocumentOutputTextFormatProperty documentOutputTextFormatProperty = DocumentOutputTextFormatProperty.builder()
     *         .types(List.of("types"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoutputtextformat.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoutputtextformat.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentOutputTextFormatProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentOutputTextFormatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentOutputTextFormatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The types of output text to generate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoutputtextformat.html#cfn-bedrock-dataautomationproject-documentoutputtextformat-types">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoutputtextformat.html#cfn-bedrock-dataautomationproject-documentoutputtextformat-types</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentOutputTextFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentOutputTextFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentOutputTextFormatProperty> {
            java.util.List<java.lang.String> types;

            /**
             * Sets the value of {@link DocumentOutputTextFormatProperty#getTypes}
             * @param types The types of output text to generate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder types(java.util.List<java.lang.String> types) {
                this.types = types;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentOutputTextFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentOutputTextFormatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentOutputTextFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentOutputTextFormatProperty {
            private final java.util.List<java.lang.String> types;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.types = software.amazon.jsii.Kernel.get(this, "types", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.types = builder.types;
            }

            @Override
            public final java.util.List<java.lang.String> getTypes() {
                return this.types;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTypes() != null) {
                    data.set("types", om.valueToTree(this.getTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentOutputTextFormatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentOutputTextFormatProperty.Jsii$Proxy that = (DocumentOutputTextFormatProperty.Jsii$Proxy) o;

                return this.types != null ? this.types.equals(that.types) : that.types == null;
            }

            @Override
            public final int hashCode() {
                int result = this.types != null ? this.types.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Additional settings for a project.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * DocumentOverrideConfigurationProperty documentOverrideConfigurationProperty = DocumentOverrideConfigurationProperty.builder()
     *         .modalityProcessing(ModalityProcessingConfigurationProperty.builder()
     *                 .state("state")
     *                 .build())
     *         .splitter(SplitterConfigurationProperty.builder()
     *                 .state("state")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoverrideconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoverrideconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentOverrideConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentOverrideConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentOverrideConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Sets modality processing for document files.
         * <p>
         * All modalities are enabled by default.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ModalityProcessingConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoverrideconfiguration.html#cfn-bedrock-dataautomationproject-documentoverrideconfiguration-modalityprocessing">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoverrideconfiguration.html#cfn-bedrock-dataautomationproject-documentoverrideconfiguration-modalityprocessing</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getModalityProcessing() {
            return null;
        }

        /**
         * Whether document splitter is enabled for a project.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.SplitterConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoverrideconfiguration.html#cfn-bedrock-dataautomationproject-documentoverrideconfiguration-splitter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentoverrideconfiguration.html#cfn-bedrock-dataautomationproject-documentoverrideconfiguration-splitter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSplitter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentOverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentOverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentOverrideConfigurationProperty> {
            java.lang.Object modalityProcessing;
            java.lang.Object splitter;

            /**
             * Sets the value of {@link DocumentOverrideConfigurationProperty#getModalityProcessing}
             * @param modalityProcessing Sets modality processing for document files.
             *                           All modalities are enabled by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modalityProcessing(software.amazon.awscdk.IResolvable modalityProcessing) {
                this.modalityProcessing = modalityProcessing;
                return this;
            }

            /**
             * Sets the value of {@link DocumentOverrideConfigurationProperty#getModalityProcessing}
             * @param modalityProcessing Sets modality processing for document files.
             *                           All modalities are enabled by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modalityProcessing(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ModalityProcessingConfigurationProperty modalityProcessing) {
                this.modalityProcessing = modalityProcessing;
                return this;
            }

            /**
             * Sets the value of {@link DocumentOverrideConfigurationProperty#getSplitter}
             * @param splitter Whether document splitter is enabled for a project.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder splitter(software.amazon.awscdk.IResolvable splitter) {
                this.splitter = splitter;
                return this;
            }

            /**
             * Sets the value of {@link DocumentOverrideConfigurationProperty#getSplitter}
             * @param splitter Whether document splitter is enabled for a project.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder splitter(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.SplitterConfigurationProperty splitter) {
                this.splitter = splitter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentOverrideConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentOverrideConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentOverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentOverrideConfigurationProperty {
            private final java.lang.Object modalityProcessing;
            private final java.lang.Object splitter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.modalityProcessing = software.amazon.jsii.Kernel.get(this, "modalityProcessing", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.splitter = software.amazon.jsii.Kernel.get(this, "splitter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.modalityProcessing = builder.modalityProcessing;
                this.splitter = builder.splitter;
            }

            @Override
            public final java.lang.Object getModalityProcessing() {
                return this.modalityProcessing;
            }

            @Override
            public final java.lang.Object getSplitter() {
                return this.splitter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getModalityProcessing() != null) {
                    data.set("modalityProcessing", om.valueToTree(this.getModalityProcessing()));
                }
                if (this.getSplitter() != null) {
                    data.set("splitter", om.valueToTree(this.getSplitter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentOverrideConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentOverrideConfigurationProperty.Jsii$Proxy that = (DocumentOverrideConfigurationProperty.Jsii$Proxy) o;

                if (this.modalityProcessing != null ? !this.modalityProcessing.equals(that.modalityProcessing) : that.modalityProcessing != null) return false;
                return this.splitter != null ? this.splitter.equals(that.splitter) : that.splitter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.modalityProcessing != null ? this.modalityProcessing.hashCode() : 0;
                result = 31 * result + (this.splitter != null ? this.splitter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings for generating data from documents.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * DocumentStandardExtractionProperty documentStandardExtractionProperty = DocumentStandardExtractionProperty.builder()
     *         .boundingBox(DocumentBoundingBoxProperty.builder()
     *                 .state("state")
     *                 .build())
     *         .granularity(DocumentExtractionGranularityProperty.builder()
     *                 .types(List.of("types"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardextraction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardextraction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentStandardExtractionProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentStandardExtractionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentStandardExtractionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to generate bounding boxes.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentBoundingBoxProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardextraction.html#cfn-bedrock-dataautomationproject-documentstandardextraction-boundingbox">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardextraction.html#cfn-bedrock-dataautomationproject-documentstandardextraction-boundingbox</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getBoundingBox();

        /**
         * Which granularities to generate data for.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentExtractionGranularityProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardextraction.html#cfn-bedrock-dataautomationproject-documentstandardextraction-granularity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardextraction.html#cfn-bedrock-dataautomationproject-documentstandardextraction-granularity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getGranularity();

        /**
         * @return a {@link Builder} of {@link DocumentStandardExtractionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentStandardExtractionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentStandardExtractionProperty> {
            java.lang.Object boundingBox;
            java.lang.Object granularity;

            /**
             * Sets the value of {@link DocumentStandardExtractionProperty#getBoundingBox}
             * @param boundingBox Whether to generate bounding boxes. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder boundingBox(software.amazon.awscdk.IResolvable boundingBox) {
                this.boundingBox = boundingBox;
                return this;
            }

            /**
             * Sets the value of {@link DocumentStandardExtractionProperty#getBoundingBox}
             * @param boundingBox Whether to generate bounding boxes. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder boundingBox(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentBoundingBoxProperty boundingBox) {
                this.boundingBox = boundingBox;
                return this;
            }

            /**
             * Sets the value of {@link DocumentStandardExtractionProperty#getGranularity}
             * @param granularity Which granularities to generate data for. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder granularity(software.amazon.awscdk.IResolvable granularity) {
                this.granularity = granularity;
                return this;
            }

            /**
             * Sets the value of {@link DocumentStandardExtractionProperty#getGranularity}
             * @param granularity Which granularities to generate data for. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder granularity(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentExtractionGranularityProperty granularity) {
                this.granularity = granularity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentStandardExtractionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentStandardExtractionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentStandardExtractionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentStandardExtractionProperty {
            private final java.lang.Object boundingBox;
            private final java.lang.Object granularity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.boundingBox = software.amazon.jsii.Kernel.get(this, "boundingBox", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.granularity = software.amazon.jsii.Kernel.get(this, "granularity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.boundingBox = java.util.Objects.requireNonNull(builder.boundingBox, "boundingBox is required");
                this.granularity = java.util.Objects.requireNonNull(builder.granularity, "granularity is required");
            }

            @Override
            public final java.lang.Object getBoundingBox() {
                return this.boundingBox;
            }

            @Override
            public final java.lang.Object getGranularity() {
                return this.granularity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("boundingBox", om.valueToTree(this.getBoundingBox()));
                data.set("granularity", om.valueToTree(this.getGranularity()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentStandardExtractionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentStandardExtractionProperty.Jsii$Proxy that = (DocumentStandardExtractionProperty.Jsii$Proxy) o;

                if (!boundingBox.equals(that.boundingBox)) return false;
                return this.granularity.equals(that.granularity);
            }

            @Override
            public final int hashCode() {
                int result = this.boundingBox.hashCode();
                result = 31 * result + (this.granularity.hashCode());
                return result;
            }
        }
    }
    /**
     * Settings for generating descriptions of documents.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * DocumentStandardGenerativeFieldProperty documentStandardGenerativeFieldProperty = DocumentStandardGenerativeFieldProperty.builder()
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardgenerativefield.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardgenerativefield.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentStandardGenerativeFieldProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentStandardGenerativeFieldProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentStandardGenerativeFieldProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether generating descriptions is enabled for documents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardgenerativefield.html#cfn-bedrock-dataautomationproject-documentstandardgenerativefield-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardgenerativefield.html#cfn-bedrock-dataautomationproject-documentstandardgenerativefield-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getState();

        /**
         * @return a {@link Builder} of {@link DocumentStandardGenerativeFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentStandardGenerativeFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentStandardGenerativeFieldProperty> {
            java.lang.String state;

            /**
             * Sets the value of {@link DocumentStandardGenerativeFieldProperty#getState}
             * @param state Whether generating descriptions is enabled for documents. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentStandardGenerativeFieldProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentStandardGenerativeFieldProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentStandardGenerativeFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentStandardGenerativeFieldProperty {
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.state = java.util.Objects.requireNonNull(builder.state, "state is required");
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("state", om.valueToTree(this.getState()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentStandardGenerativeFieldProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentStandardGenerativeFieldProperty.Jsii$Proxy that = (DocumentStandardGenerativeFieldProperty.Jsii$Proxy) o;

                return this.state.equals(that.state);
            }

            @Override
            public final int hashCode() {
                int result = this.state.hashCode();
                return result;
            }
        }
    }
    /**
     * Output settings for processing documents.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * DocumentStandardOutputConfigurationProperty documentStandardOutputConfigurationProperty = DocumentStandardOutputConfigurationProperty.builder()
     *         .extraction(DocumentStandardExtractionProperty.builder()
     *                 .boundingBox(DocumentBoundingBoxProperty.builder()
     *                         .state("state")
     *                         .build())
     *                 .granularity(DocumentExtractionGranularityProperty.builder()
     *                         .types(List.of("types"))
     *                         .build())
     *                 .build())
     *         .generativeField(DocumentStandardGenerativeFieldProperty.builder()
     *                 .state("state")
     *                 .build())
     *         .outputFormat(DocumentOutputFormatProperty.builder()
     *                 .additionalFileFormat(DocumentOutputAdditionalFileFormatProperty.builder()
     *                         .state("state")
     *                         .build())
     *                 .textFormat(DocumentOutputTextFormatProperty.builder()
     *                         .types(List.of("types"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardoutputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardoutputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentStandardOutputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentStandardOutputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentStandardOutputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings for populating data fields that describe the document.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentStandardExtractionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-documentstandardoutputconfiguration-extraction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-documentstandardoutputconfiguration-extraction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExtraction() {
            return null;
        }

        /**
         * Whether to generate descriptions.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentStandardGenerativeFieldProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-documentstandardoutputconfiguration-generativefield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-documentstandardoutputconfiguration-generativefield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGenerativeField() {
            return null;
        }

        /**
         * The output format to generate.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentOutputFormatProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-documentstandardoutputconfiguration-outputformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-documentstandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-documentstandardoutputconfiguration-outputformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentStandardOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentStandardOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentStandardOutputConfigurationProperty> {
            java.lang.Object extraction;
            java.lang.Object generativeField;
            java.lang.Object outputFormat;

            /**
             * Sets the value of {@link DocumentStandardOutputConfigurationProperty#getExtraction}
             * @param extraction Settings for populating data fields that describe the document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extraction(software.amazon.awscdk.IResolvable extraction) {
                this.extraction = extraction;
                return this;
            }

            /**
             * Sets the value of {@link DocumentStandardOutputConfigurationProperty#getExtraction}
             * @param extraction Settings for populating data fields that describe the document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extraction(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentStandardExtractionProperty extraction) {
                this.extraction = extraction;
                return this;
            }

            /**
             * Sets the value of {@link DocumentStandardOutputConfigurationProperty#getGenerativeField}
             * @param generativeField Whether to generate descriptions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generativeField(software.amazon.awscdk.IResolvable generativeField) {
                this.generativeField = generativeField;
                return this;
            }

            /**
             * Sets the value of {@link DocumentStandardOutputConfigurationProperty#getGenerativeField}
             * @param generativeField Whether to generate descriptions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generativeField(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentStandardGenerativeFieldProperty generativeField) {
                this.generativeField = generativeField;
                return this;
            }

            /**
             * Sets the value of {@link DocumentStandardOutputConfigurationProperty#getOutputFormat}
             * @param outputFormat The output format to generate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputFormat(software.amazon.awscdk.IResolvable outputFormat) {
                this.outputFormat = outputFormat;
                return this;
            }

            /**
             * Sets the value of {@link DocumentStandardOutputConfigurationProperty#getOutputFormat}
             * @param outputFormat The output format to generate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputFormat(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentOutputFormatProperty outputFormat) {
                this.outputFormat = outputFormat;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentStandardOutputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentStandardOutputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentStandardOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentStandardOutputConfigurationProperty {
            private final java.lang.Object extraction;
            private final java.lang.Object generativeField;
            private final java.lang.Object outputFormat;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.extraction = software.amazon.jsii.Kernel.get(this, "extraction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.generativeField = software.amazon.jsii.Kernel.get(this, "generativeField", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputFormat = software.amazon.jsii.Kernel.get(this, "outputFormat", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.extraction = builder.extraction;
                this.generativeField = builder.generativeField;
                this.outputFormat = builder.outputFormat;
            }

            @Override
            public final java.lang.Object getExtraction() {
                return this.extraction;
            }

            @Override
            public final java.lang.Object getGenerativeField() {
                return this.generativeField;
            }

            @Override
            public final java.lang.Object getOutputFormat() {
                return this.outputFormat;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExtraction() != null) {
                    data.set("extraction", om.valueToTree(this.getExtraction()));
                }
                if (this.getGenerativeField() != null) {
                    data.set("generativeField", om.valueToTree(this.getGenerativeField()));
                }
                if (this.getOutputFormat() != null) {
                    data.set("outputFormat", om.valueToTree(this.getOutputFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.DocumentStandardOutputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentStandardOutputConfigurationProperty.Jsii$Proxy that = (DocumentStandardOutputConfigurationProperty.Jsii$Proxy) o;

                if (this.extraction != null ? !this.extraction.equals(that.extraction) : that.extraction != null) return false;
                if (this.generativeField != null ? !this.generativeField.equals(that.generativeField) : that.generativeField != null) return false;
                return this.outputFormat != null ? this.outputFormat.equals(that.outputFormat) : that.outputFormat == null;
            }

            @Override
            public final int hashCode() {
                int result = this.extraction != null ? this.extraction.hashCode() : 0;
                result = 31 * result + (this.generativeField != null ? this.generativeField.hashCode() : 0);
                result = 31 * result + (this.outputFormat != null ? this.outputFormat.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Bounding box settings for a project.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ImageBoundingBoxProperty imageBoundingBoxProperty = ImageBoundingBoxProperty.builder()
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imageboundingbox.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imageboundingbox.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ImageBoundingBoxProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageBoundingBoxProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageBoundingBoxProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Bounding box settings for a project.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imageboundingbox.html#cfn-bedrock-dataautomationproject-imageboundingbox-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imageboundingbox.html#cfn-bedrock-dataautomationproject-imageboundingbox-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getState();

        /**
         * @return a {@link Builder} of {@link ImageBoundingBoxProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageBoundingBoxProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageBoundingBoxProperty> {
            java.lang.String state;

            /**
             * Sets the value of {@link ImageBoundingBoxProperty#getState}
             * @param state Bounding box settings for a project. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageBoundingBoxProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageBoundingBoxProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImageBoundingBoxProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageBoundingBoxProperty {
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.state = java.util.Objects.requireNonNull(builder.state, "state is required");
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("state", om.valueToTree(this.getState()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ImageBoundingBoxProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageBoundingBoxProperty.Jsii$Proxy that = (ImageBoundingBoxProperty.Jsii$Proxy) o;

                return this.state.equals(that.state);
            }

            @Override
            public final int hashCode() {
                int result = this.state.hashCode();
                return result;
            }
        }
    }
    /**
     * Settings for generating categorical data from images.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ImageExtractionCategoryProperty imageExtractionCategoryProperty = ImageExtractionCategoryProperty.builder()
     *         .state("state")
     *         // the properties below are optional
     *         .types(List.of("types"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imageextractioncategory.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imageextractioncategory.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ImageExtractionCategoryProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageExtractionCategoryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageExtractionCategoryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether generating categorical data from images is enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imageextractioncategory.html#cfn-bedrock-dataautomationproject-imageextractioncategory-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imageextractioncategory.html#cfn-bedrock-dataautomationproject-imageextractioncategory-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getState();

        /**
         * The types of data to generate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imageextractioncategory.html#cfn-bedrock-dataautomationproject-imageextractioncategory-types">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imageextractioncategory.html#cfn-bedrock-dataautomationproject-imageextractioncategory-types</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImageExtractionCategoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageExtractionCategoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageExtractionCategoryProperty> {
            java.lang.String state;
            java.util.List<java.lang.String> types;

            /**
             * Sets the value of {@link ImageExtractionCategoryProperty#getState}
             * @param state Whether generating categorical data from images is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Sets the value of {@link ImageExtractionCategoryProperty#getTypes}
             * @param types The types of data to generate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder types(java.util.List<java.lang.String> types) {
                this.types = types;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageExtractionCategoryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageExtractionCategoryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImageExtractionCategoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageExtractionCategoryProperty {
            private final java.lang.String state;
            private final java.util.List<java.lang.String> types;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.types = software.amazon.jsii.Kernel.get(this, "types", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.state = java.util.Objects.requireNonNull(builder.state, "state is required");
                this.types = builder.types;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            public final java.util.List<java.lang.String> getTypes() {
                return this.types;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("state", om.valueToTree(this.getState()));
                if (this.getTypes() != null) {
                    data.set("types", om.valueToTree(this.getTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ImageExtractionCategoryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageExtractionCategoryProperty.Jsii$Proxy that = (ImageExtractionCategoryProperty.Jsii$Proxy) o;

                if (!state.equals(that.state)) return false;
                return this.types != null ? this.types.equals(that.types) : that.types == null;
            }

            @Override
            public final int hashCode() {
                int result = this.state.hashCode();
                result = 31 * result + (this.types != null ? this.types.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Sets whether your project will process images or not.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ImageOverrideConfigurationProperty imageOverrideConfigurationProperty = ImageOverrideConfigurationProperty.builder()
     *         .modalityProcessing(ModalityProcessingConfigurationProperty.builder()
     *                 .state("state")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imageoverrideconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imageoverrideconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ImageOverrideConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageOverrideConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageOverrideConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Sets modality processing for image files.
         * <p>
         * All modalities are enabled by default.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ModalityProcessingConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imageoverrideconfiguration.html#cfn-bedrock-dataautomationproject-imageoverrideconfiguration-modalityprocessing">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imageoverrideconfiguration.html#cfn-bedrock-dataautomationproject-imageoverrideconfiguration-modalityprocessing</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getModalityProcessing() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImageOverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageOverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageOverrideConfigurationProperty> {
            java.lang.Object modalityProcessing;

            /**
             * Sets the value of {@link ImageOverrideConfigurationProperty#getModalityProcessing}
             * @param modalityProcessing Sets modality processing for image files.
             *                           All modalities are enabled by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modalityProcessing(software.amazon.awscdk.IResolvable modalityProcessing) {
                this.modalityProcessing = modalityProcessing;
                return this;
            }

            /**
             * Sets the value of {@link ImageOverrideConfigurationProperty#getModalityProcessing}
             * @param modalityProcessing Sets modality processing for image files.
             *                           All modalities are enabled by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modalityProcessing(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ModalityProcessingConfigurationProperty modalityProcessing) {
                this.modalityProcessing = modalityProcessing;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageOverrideConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageOverrideConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImageOverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageOverrideConfigurationProperty {
            private final java.lang.Object modalityProcessing;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.modalityProcessing = software.amazon.jsii.Kernel.get(this, "modalityProcessing", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.modalityProcessing = builder.modalityProcessing;
            }

            @Override
            public final java.lang.Object getModalityProcessing() {
                return this.modalityProcessing;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getModalityProcessing() != null) {
                    data.set("modalityProcessing", om.valueToTree(this.getModalityProcessing()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ImageOverrideConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageOverrideConfigurationProperty.Jsii$Proxy that = (ImageOverrideConfigurationProperty.Jsii$Proxy) o;

                return this.modalityProcessing != null ? this.modalityProcessing.equals(that.modalityProcessing) : that.modalityProcessing == null;
            }

            @Override
            public final int hashCode() {
                int result = this.modalityProcessing != null ? this.modalityProcessing.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Settings for generating data from images.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ImageStandardExtractionProperty imageStandardExtractionProperty = ImageStandardExtractionProperty.builder()
     *         .boundingBox(ImageBoundingBoxProperty.builder()
     *                 .state("state")
     *                 .build())
     *         .category(ImageExtractionCategoryProperty.builder()
     *                 .state("state")
     *                 // the properties below are optional
     *                 .types(List.of("types"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardextraction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardextraction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ImageStandardExtractionProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageStandardExtractionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageStandardExtractionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings for generating bounding boxes.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ImageBoundingBoxProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardextraction.html#cfn-bedrock-dataautomationproject-imagestandardextraction-boundingbox">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardextraction.html#cfn-bedrock-dataautomationproject-imagestandardextraction-boundingbox</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getBoundingBox();

        /**
         * Settings for generating categorical data.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ImageExtractionCategoryProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardextraction.html#cfn-bedrock-dataautomationproject-imagestandardextraction-category">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardextraction.html#cfn-bedrock-dataautomationproject-imagestandardextraction-category</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCategory();

        /**
         * @return a {@link Builder} of {@link ImageStandardExtractionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageStandardExtractionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageStandardExtractionProperty> {
            java.lang.Object boundingBox;
            java.lang.Object category;

            /**
             * Sets the value of {@link ImageStandardExtractionProperty#getBoundingBox}
             * @param boundingBox Settings for generating bounding boxes. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder boundingBox(software.amazon.awscdk.IResolvable boundingBox) {
                this.boundingBox = boundingBox;
                return this;
            }

            /**
             * Sets the value of {@link ImageStandardExtractionProperty#getBoundingBox}
             * @param boundingBox Settings for generating bounding boxes. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder boundingBox(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ImageBoundingBoxProperty boundingBox) {
                this.boundingBox = boundingBox;
                return this;
            }

            /**
             * Sets the value of {@link ImageStandardExtractionProperty#getCategory}
             * @param category Settings for generating categorical data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder category(software.amazon.awscdk.IResolvable category) {
                this.category = category;
                return this;
            }

            /**
             * Sets the value of {@link ImageStandardExtractionProperty#getCategory}
             * @param category Settings for generating categorical data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder category(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ImageExtractionCategoryProperty category) {
                this.category = category;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageStandardExtractionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageStandardExtractionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImageStandardExtractionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageStandardExtractionProperty {
            private final java.lang.Object boundingBox;
            private final java.lang.Object category;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.boundingBox = software.amazon.jsii.Kernel.get(this, "boundingBox", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.category = software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.boundingBox = java.util.Objects.requireNonNull(builder.boundingBox, "boundingBox is required");
                this.category = java.util.Objects.requireNonNull(builder.category, "category is required");
            }

            @Override
            public final java.lang.Object getBoundingBox() {
                return this.boundingBox;
            }

            @Override
            public final java.lang.Object getCategory() {
                return this.category;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("boundingBox", om.valueToTree(this.getBoundingBox()));
                data.set("category", om.valueToTree(this.getCategory()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ImageStandardExtractionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageStandardExtractionProperty.Jsii$Proxy that = (ImageStandardExtractionProperty.Jsii$Proxy) o;

                if (!boundingBox.equals(that.boundingBox)) return false;
                return this.category.equals(that.category);
            }

            @Override
            public final int hashCode() {
                int result = this.boundingBox.hashCode();
                result = 31 * result + (this.category.hashCode());
                return result;
            }
        }
    }
    /**
     * Settings for generating descriptions of images.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ImageStandardGenerativeFieldProperty imageStandardGenerativeFieldProperty = ImageStandardGenerativeFieldProperty.builder()
     *         .state("state")
     *         // the properties below are optional
     *         .types(List.of("types"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardgenerativefield.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardgenerativefield.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ImageStandardGenerativeFieldProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageStandardGenerativeFieldProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageStandardGenerativeFieldProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether generating descriptions is enabled for images.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardgenerativefield.html#cfn-bedrock-dataautomationproject-imagestandardgenerativefield-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardgenerativefield.html#cfn-bedrock-dataautomationproject-imagestandardgenerativefield-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getState();

        /**
         * Settings for generating descriptions of images.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardgenerativefield.html#cfn-bedrock-dataautomationproject-imagestandardgenerativefield-types">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardgenerativefield.html#cfn-bedrock-dataautomationproject-imagestandardgenerativefield-types</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImageStandardGenerativeFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageStandardGenerativeFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageStandardGenerativeFieldProperty> {
            java.lang.String state;
            java.util.List<java.lang.String> types;

            /**
             * Sets the value of {@link ImageStandardGenerativeFieldProperty#getState}
             * @param state Whether generating descriptions is enabled for images. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Sets the value of {@link ImageStandardGenerativeFieldProperty#getTypes}
             * @param types Settings for generating descriptions of images.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder types(java.util.List<java.lang.String> types) {
                this.types = types;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageStandardGenerativeFieldProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageStandardGenerativeFieldProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImageStandardGenerativeFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageStandardGenerativeFieldProperty {
            private final java.lang.String state;
            private final java.util.List<java.lang.String> types;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.types = software.amazon.jsii.Kernel.get(this, "types", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.state = java.util.Objects.requireNonNull(builder.state, "state is required");
                this.types = builder.types;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            public final java.util.List<java.lang.String> getTypes() {
                return this.types;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("state", om.valueToTree(this.getState()));
                if (this.getTypes() != null) {
                    data.set("types", om.valueToTree(this.getTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ImageStandardGenerativeFieldProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageStandardGenerativeFieldProperty.Jsii$Proxy that = (ImageStandardGenerativeFieldProperty.Jsii$Proxy) o;

                if (!state.equals(that.state)) return false;
                return this.types != null ? this.types.equals(that.types) : that.types == null;
            }

            @Override
            public final int hashCode() {
                int result = this.state.hashCode();
                result = 31 * result + (this.types != null ? this.types.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Output settings for processing images.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ImageStandardOutputConfigurationProperty imageStandardOutputConfigurationProperty = ImageStandardOutputConfigurationProperty.builder()
     *         .extraction(ImageStandardExtractionProperty.builder()
     *                 .boundingBox(ImageBoundingBoxProperty.builder()
     *                         .state("state")
     *                         .build())
     *                 .category(ImageExtractionCategoryProperty.builder()
     *                         .state("state")
     *                         // the properties below are optional
     *                         .types(List.of("types"))
     *                         .build())
     *                 .build())
     *         .generativeField(ImageStandardGenerativeFieldProperty.builder()
     *                 .state("state")
     *                 // the properties below are optional
     *                 .types(List.of("types"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardoutputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardoutputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ImageStandardOutputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageStandardOutputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageStandardOutputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings for populating data fields that describe the image.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ImageStandardExtractionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-imagestandardoutputconfiguration-extraction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-imagestandardoutputconfiguration-extraction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExtraction() {
            return null;
        }

        /**
         * Whether to generate descriptions of the data.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ImageStandardGenerativeFieldProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-imagestandardoutputconfiguration-generativefield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-imagestandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-imagestandardoutputconfiguration-generativefield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGenerativeField() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImageStandardOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageStandardOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageStandardOutputConfigurationProperty> {
            java.lang.Object extraction;
            java.lang.Object generativeField;

            /**
             * Sets the value of {@link ImageStandardOutputConfigurationProperty#getExtraction}
             * @param extraction Settings for populating data fields that describe the image.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extraction(software.amazon.awscdk.IResolvable extraction) {
                this.extraction = extraction;
                return this;
            }

            /**
             * Sets the value of {@link ImageStandardOutputConfigurationProperty#getExtraction}
             * @param extraction Settings for populating data fields that describe the image.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extraction(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ImageStandardExtractionProperty extraction) {
                this.extraction = extraction;
                return this;
            }

            /**
             * Sets the value of {@link ImageStandardOutputConfigurationProperty#getGenerativeField}
             * @param generativeField Whether to generate descriptions of the data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generativeField(software.amazon.awscdk.IResolvable generativeField) {
                this.generativeField = generativeField;
                return this;
            }

            /**
             * Sets the value of {@link ImageStandardOutputConfigurationProperty#getGenerativeField}
             * @param generativeField Whether to generate descriptions of the data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generativeField(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ImageStandardGenerativeFieldProperty generativeField) {
                this.generativeField = generativeField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageStandardOutputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageStandardOutputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImageStandardOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageStandardOutputConfigurationProperty {
            private final java.lang.Object extraction;
            private final java.lang.Object generativeField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.extraction = software.amazon.jsii.Kernel.get(this, "extraction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.generativeField = software.amazon.jsii.Kernel.get(this, "generativeField", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.extraction = builder.extraction;
                this.generativeField = builder.generativeField;
            }

            @Override
            public final java.lang.Object getExtraction() {
                return this.extraction;
            }

            @Override
            public final java.lang.Object getGenerativeField() {
                return this.generativeField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExtraction() != null) {
                    data.set("extraction", om.valueToTree(this.getExtraction()));
                }
                if (this.getGenerativeField() != null) {
                    data.set("generativeField", om.valueToTree(this.getGenerativeField()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ImageStandardOutputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageStandardOutputConfigurationProperty.Jsii$Proxy that = (ImageStandardOutputConfigurationProperty.Jsii$Proxy) o;

                if (this.extraction != null ? !this.extraction.equals(that.extraction) : that.extraction != null) return false;
                return this.generativeField != null ? this.generativeField.equals(that.generativeField) : that.generativeField == null;
            }

            @Override
            public final int hashCode() {
                int result = this.extraction != null ? this.extraction.hashCode() : 0;
                result = 31 * result + (this.generativeField != null ? this.generativeField.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This element is used to determine if the modality it is associated with is enabled or disabled.
     * <p>
     * All modalities are enabled by default.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ModalityProcessingConfigurationProperty modalityProcessingConfigurationProperty = ModalityProcessingConfigurationProperty.builder()
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-modalityprocessingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-modalityprocessingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ModalityProcessingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ModalityProcessingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ModalityProcessingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Stores the state of the modality for your project, set to either enabled or disabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-modalityprocessingconfiguration.html#cfn-bedrock-dataautomationproject-modalityprocessingconfiguration-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-modalityprocessingconfiguration.html#cfn-bedrock-dataautomationproject-modalityprocessingconfiguration-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ModalityProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ModalityProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ModalityProcessingConfigurationProperty> {
            java.lang.String state;

            /**
             * Sets the value of {@link ModalityProcessingConfigurationProperty#getState}
             * @param state Stores the state of the modality for your project, set to either enabled or disabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ModalityProcessingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ModalityProcessingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ModalityProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModalityProcessingConfigurationProperty {
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.state = builder.state;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ModalityProcessingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ModalityProcessingConfigurationProperty.Jsii$Proxy that = (ModalityProcessingConfigurationProperty.Jsii$Proxy) o;

                return this.state != null ? this.state.equals(that.state) : that.state == null;
            }

            @Override
            public final int hashCode() {
                int result = this.state != null ? this.state.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * This element allows you to set up where JPEG, PNG, MOV, and MP4 files get routed to for processing.
     * <p>
     * JPEG routing applies to both "JPEG" and "JPG" file extensions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ModalityRoutingConfigurationProperty modalityRoutingConfigurationProperty = ModalityRoutingConfigurationProperty.builder()
     *         .jpeg("jpeg")
     *         .mov("mov")
     *         .mp4("mp4")
     *         .png("png")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-modalityroutingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-modalityroutingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ModalityRoutingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ModalityRoutingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ModalityRoutingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Sets whether JPEG files are routed to document or image processing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-modalityroutingconfiguration.html#cfn-bedrock-dataautomationproject-modalityroutingconfiguration-jpeg">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-modalityroutingconfiguration.html#cfn-bedrock-dataautomationproject-modalityroutingconfiguration-jpeg</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJpeg() {
            return null;
        }

        /**
         * Sets whether MOV files are routed to audio or video processing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-modalityroutingconfiguration.html#cfn-bedrock-dataautomationproject-modalityroutingconfiguration-mov">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-modalityroutingconfiguration.html#cfn-bedrock-dataautomationproject-modalityroutingconfiguration-mov</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMov() {
            return null;
        }

        /**
         * Sets whether MP4 files are routed to audio or video processing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-modalityroutingconfiguration.html#cfn-bedrock-dataautomationproject-modalityroutingconfiguration-mp4">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-modalityroutingconfiguration.html#cfn-bedrock-dataautomationproject-modalityroutingconfiguration-mp4</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMp4() {
            return null;
        }

        /**
         * Sets whether PNG files are routed to document or image processing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-modalityroutingconfiguration.html#cfn-bedrock-dataautomationproject-modalityroutingconfiguration-png">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-modalityroutingconfiguration.html#cfn-bedrock-dataautomationproject-modalityroutingconfiguration-png</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPng() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ModalityRoutingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ModalityRoutingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ModalityRoutingConfigurationProperty> {
            java.lang.String jpeg;
            java.lang.String mov;
            java.lang.String mp4;
            java.lang.String png;

            /**
             * Sets the value of {@link ModalityRoutingConfigurationProperty#getJpeg}
             * @param jpeg Sets whether JPEG files are routed to document or image processing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jpeg(java.lang.String jpeg) {
                this.jpeg = jpeg;
                return this;
            }

            /**
             * Sets the value of {@link ModalityRoutingConfigurationProperty#getMov}
             * @param mov Sets whether MOV files are routed to audio or video processing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mov(java.lang.String mov) {
                this.mov = mov;
                return this;
            }

            /**
             * Sets the value of {@link ModalityRoutingConfigurationProperty#getMp4}
             * @param mp4 Sets whether MP4 files are routed to audio or video processing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mp4(java.lang.String mp4) {
                this.mp4 = mp4;
                return this;
            }

            /**
             * Sets the value of {@link ModalityRoutingConfigurationProperty#getPng}
             * @param png Sets whether PNG files are routed to document or image processing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder png(java.lang.String png) {
                this.png = png;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ModalityRoutingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ModalityRoutingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ModalityRoutingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModalityRoutingConfigurationProperty {
            private final java.lang.String jpeg;
            private final java.lang.String mov;
            private final java.lang.String mp4;
            private final java.lang.String png;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.jpeg = software.amazon.jsii.Kernel.get(this, "jpeg", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mov = software.amazon.jsii.Kernel.get(this, "mov", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mp4 = software.amazon.jsii.Kernel.get(this, "mp4", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.png = software.amazon.jsii.Kernel.get(this, "png", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.jpeg = builder.jpeg;
                this.mov = builder.mov;
                this.mp4 = builder.mp4;
                this.png = builder.png;
            }

            @Override
            public final java.lang.String getJpeg() {
                return this.jpeg;
            }

            @Override
            public final java.lang.String getMov() {
                return this.mov;
            }

            @Override
            public final java.lang.String getMp4() {
                return this.mp4;
            }

            @Override
            public final java.lang.String getPng() {
                return this.png;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getJpeg() != null) {
                    data.set("jpeg", om.valueToTree(this.getJpeg()));
                }
                if (this.getMov() != null) {
                    data.set("mov", om.valueToTree(this.getMov()));
                }
                if (this.getMp4() != null) {
                    data.set("mp4", om.valueToTree(this.getMp4()));
                }
                if (this.getPng() != null) {
                    data.set("png", om.valueToTree(this.getPng()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.ModalityRoutingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ModalityRoutingConfigurationProperty.Jsii$Proxy that = (ModalityRoutingConfigurationProperty.Jsii$Proxy) o;

                if (this.jpeg != null ? !this.jpeg.equals(that.jpeg) : that.jpeg != null) return false;
                if (this.mov != null ? !this.mov.equals(that.mov) : that.mov != null) return false;
                if (this.mp4 != null ? !this.mp4.equals(that.mp4) : that.mp4 != null) return false;
                return this.png != null ? this.png.equals(that.png) : that.png == null;
            }

            @Override
            public final int hashCode() {
                int result = this.jpeg != null ? this.jpeg.hashCode() : 0;
                result = 31 * result + (this.mov != null ? this.mov.hashCode() : 0);
                result = 31 * result + (this.mp4 != null ? this.mp4.hashCode() : 0);
                result = 31 * result + (this.png != null ? this.png.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Additional settings for a project.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * OverrideConfigurationProperty overrideConfigurationProperty = OverrideConfigurationProperty.builder()
     *         .audio(AudioOverrideConfigurationProperty.builder()
     *                 .modalityProcessing(ModalityProcessingConfigurationProperty.builder()
     *                         .state("state")
     *                         .build())
     *                 .build())
     *         .document(DocumentOverrideConfigurationProperty.builder()
     *                 .modalityProcessing(ModalityProcessingConfigurationProperty.builder()
     *                         .state("state")
     *                         .build())
     *                 .splitter(SplitterConfigurationProperty.builder()
     *                         .state("state")
     *                         .build())
     *                 .build())
     *         .image(ImageOverrideConfigurationProperty.builder()
     *                 .modalityProcessing(ModalityProcessingConfigurationProperty.builder()
     *                         .state("state")
     *                         .build())
     *                 .build())
     *         .modalityRouting(ModalityRoutingConfigurationProperty.builder()
     *                 .jpeg("jpeg")
     *                 .mov("mov")
     *                 .mp4("mp4")
     *                 .png("png")
     *                 .build())
     *         .video(VideoOverrideConfigurationProperty.builder()
     *                 .modalityProcessing(ModalityProcessingConfigurationProperty.builder()
     *                         .state("state")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-overrideconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-overrideconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.OverrideConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OverrideConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OverrideConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This element declares whether your project will process audio files.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.AudioOverrideConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-overrideconfiguration.html#cfn-bedrock-dataautomationproject-overrideconfiguration-audio">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-overrideconfiguration.html#cfn-bedrock-dataautomationproject-overrideconfiguration-audio</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudio() {
            return null;
        }

        /**
         * Additional settings for a project.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentOverrideConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-overrideconfiguration.html#cfn-bedrock-dataautomationproject-overrideconfiguration-document">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-overrideconfiguration.html#cfn-bedrock-dataautomationproject-overrideconfiguration-document</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDocument() {
            return null;
        }

        /**
         * This element declares whether your project will process image files.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ImageOverrideConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-overrideconfiguration.html#cfn-bedrock-dataautomationproject-overrideconfiguration-image">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-overrideconfiguration.html#cfn-bedrock-dataautomationproject-overrideconfiguration-image</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImage() {
            return null;
        }

        /**
         * Lets you set which modalities certain file types are processed as.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ModalityRoutingConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-overrideconfiguration.html#cfn-bedrock-dataautomationproject-overrideconfiguration-modalityrouting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-overrideconfiguration.html#cfn-bedrock-dataautomationproject-overrideconfiguration-modalityrouting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getModalityRouting() {
            return null;
        }

        /**
         * This element declares whether your project will process video files.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.VideoOverrideConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-overrideconfiguration.html#cfn-bedrock-dataautomationproject-overrideconfiguration-video">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-overrideconfiguration.html#cfn-bedrock-dataautomationproject-overrideconfiguration-video</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVideo() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OverrideConfigurationProperty> {
            java.lang.Object audio;
            java.lang.Object document;
            java.lang.Object image;
            java.lang.Object modalityRouting;
            java.lang.Object video;

            /**
             * Sets the value of {@link OverrideConfigurationProperty#getAudio}
             * @param audio This element declares whether your project will process audio files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audio(software.amazon.awscdk.IResolvable audio) {
                this.audio = audio;
                return this;
            }

            /**
             * Sets the value of {@link OverrideConfigurationProperty#getAudio}
             * @param audio This element declares whether your project will process audio files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audio(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.AudioOverrideConfigurationProperty audio) {
                this.audio = audio;
                return this;
            }

            /**
             * Sets the value of {@link OverrideConfigurationProperty#getDocument}
             * @param document Additional settings for a project.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder document(software.amazon.awscdk.IResolvable document) {
                this.document = document;
                return this;
            }

            /**
             * Sets the value of {@link OverrideConfigurationProperty#getDocument}
             * @param document Additional settings for a project.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder document(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentOverrideConfigurationProperty document) {
                this.document = document;
                return this;
            }

            /**
             * Sets the value of {@link OverrideConfigurationProperty#getImage}
             * @param image This element declares whether your project will process image files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(software.amazon.awscdk.IResolvable image) {
                this.image = image;
                return this;
            }

            /**
             * Sets the value of {@link OverrideConfigurationProperty#getImage}
             * @param image This element declares whether your project will process image files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ImageOverrideConfigurationProperty image) {
                this.image = image;
                return this;
            }

            /**
             * Sets the value of {@link OverrideConfigurationProperty#getModalityRouting}
             * @param modalityRouting Lets you set which modalities certain file types are processed as.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modalityRouting(software.amazon.awscdk.IResolvable modalityRouting) {
                this.modalityRouting = modalityRouting;
                return this;
            }

            /**
             * Sets the value of {@link OverrideConfigurationProperty#getModalityRouting}
             * @param modalityRouting Lets you set which modalities certain file types are processed as.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modalityRouting(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ModalityRoutingConfigurationProperty modalityRouting) {
                this.modalityRouting = modalityRouting;
                return this;
            }

            /**
             * Sets the value of {@link OverrideConfigurationProperty#getVideo}
             * @param video This element declares whether your project will process video files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder video(software.amazon.awscdk.IResolvable video) {
                this.video = video;
                return this;
            }

            /**
             * Sets the value of {@link OverrideConfigurationProperty#getVideo}
             * @param video This element declares whether your project will process video files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder video(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.VideoOverrideConfigurationProperty video) {
                this.video = video;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OverrideConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OverrideConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OverrideConfigurationProperty {
            private final java.lang.Object audio;
            private final java.lang.Object document;
            private final java.lang.Object image;
            private final java.lang.Object modalityRouting;
            private final java.lang.Object video;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audio = software.amazon.jsii.Kernel.get(this, "audio", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.document = software.amazon.jsii.Kernel.get(this, "document", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.modalityRouting = software.amazon.jsii.Kernel.get(this, "modalityRouting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.video = software.amazon.jsii.Kernel.get(this, "video", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audio = builder.audio;
                this.document = builder.document;
                this.image = builder.image;
                this.modalityRouting = builder.modalityRouting;
                this.video = builder.video;
            }

            @Override
            public final java.lang.Object getAudio() {
                return this.audio;
            }

            @Override
            public final java.lang.Object getDocument() {
                return this.document;
            }

            @Override
            public final java.lang.Object getImage() {
                return this.image;
            }

            @Override
            public final java.lang.Object getModalityRouting() {
                return this.modalityRouting;
            }

            @Override
            public final java.lang.Object getVideo() {
                return this.video;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudio() != null) {
                    data.set("audio", om.valueToTree(this.getAudio()));
                }
                if (this.getDocument() != null) {
                    data.set("document", om.valueToTree(this.getDocument()));
                }
                if (this.getImage() != null) {
                    data.set("image", om.valueToTree(this.getImage()));
                }
                if (this.getModalityRouting() != null) {
                    data.set("modalityRouting", om.valueToTree(this.getModalityRouting()));
                }
                if (this.getVideo() != null) {
                    data.set("video", om.valueToTree(this.getVideo()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.OverrideConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OverrideConfigurationProperty.Jsii$Proxy that = (OverrideConfigurationProperty.Jsii$Proxy) o;

                if (this.audio != null ? !this.audio.equals(that.audio) : that.audio != null) return false;
                if (this.document != null ? !this.document.equals(that.document) : that.document != null) return false;
                if (this.image != null ? !this.image.equals(that.image) : that.image != null) return false;
                if (this.modalityRouting != null ? !this.modalityRouting.equals(that.modalityRouting) : that.modalityRouting != null) return false;
                return this.video != null ? this.video.equals(that.video) : that.video == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audio != null ? this.audio.hashCode() : 0;
                result = 31 * result + (this.document != null ? this.document.hashCode() : 0);
                result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
                result = 31 * result + (this.modalityRouting != null ? this.modalityRouting.hashCode() : 0);
                result = 31 * result + (this.video != null ? this.video.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Enables or disables speaker labeling.
     * <p>
     * Speaker labeling, when enabled will assign a number to each speaker, and indicate which speaker is talking in each portion of the transcript. This appears in the response as "spk_0" for the first speaker, "spk_1" for the second, and so on for up to 30 speakers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * SpeakerLabelingConfigurationProperty speakerLabelingConfigurationProperty = SpeakerLabelingConfigurationProperty.builder()
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-speakerlabelingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-speakerlabelingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.SpeakerLabelingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SpeakerLabelingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpeakerLabelingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * State of speaker labeling, either enabled or disabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-speakerlabelingconfiguration.html#cfn-bedrock-dataautomationproject-speakerlabelingconfiguration-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-speakerlabelingconfiguration.html#cfn-bedrock-dataautomationproject-speakerlabelingconfiguration-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getState();

        /**
         * @return a {@link Builder} of {@link SpeakerLabelingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpeakerLabelingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpeakerLabelingConfigurationProperty> {
            java.lang.String state;

            /**
             * Sets the value of {@link SpeakerLabelingConfigurationProperty#getState}
             * @param state State of speaker labeling, either enabled or disabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpeakerLabelingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpeakerLabelingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpeakerLabelingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpeakerLabelingConfigurationProperty {
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.state = java.util.Objects.requireNonNull(builder.state, "state is required");
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("state", om.valueToTree(this.getState()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.SpeakerLabelingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpeakerLabelingConfigurationProperty.Jsii$Proxy that = (SpeakerLabelingConfigurationProperty.Jsii$Proxy) o;

                return this.state.equals(that.state);
            }

            @Override
            public final int hashCode() {
                int result = this.state.hashCode();
                return result;
            }
        }
    }
    /**
     * Document splitter settings.
     * <p>
     * If a document is too large to be processed in one pass, the document splitter splits it into smaller documents.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * SplitterConfigurationProperty splitterConfigurationProperty = SplitterConfigurationProperty.builder()
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-splitterconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-splitterconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.SplitterConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SplitterConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SplitterConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether document splitter is enabled for a project.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-splitterconfiguration.html#cfn-bedrock-dataautomationproject-splitterconfiguration-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-splitterconfiguration.html#cfn-bedrock-dataautomationproject-splitterconfiguration-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SplitterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SplitterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SplitterConfigurationProperty> {
            java.lang.String state;

            /**
             * Sets the value of {@link SplitterConfigurationProperty#getState}
             * @param state Whether document splitter is enabled for a project.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SplitterConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SplitterConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SplitterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SplitterConfigurationProperty {
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.state = builder.state;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.SplitterConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SplitterConfigurationProperty.Jsii$Proxy that = (SplitterConfigurationProperty.Jsii$Proxy) o;

                return this.state != null ? this.state.equals(that.state) : that.state == null;
            }

            @Override
            public final int hashCode() {
                int result = this.state != null ? this.state.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The project's standard output configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * StandardOutputConfigurationProperty standardOutputConfigurationProperty = StandardOutputConfigurationProperty.builder()
     *         .audio(AudioStandardOutputConfigurationProperty.builder()
     *                 .extraction(AudioStandardExtractionProperty.builder()
     *                         .category(AudioExtractionCategoryProperty.builder()
     *                                 .state("state")
     *                                 // the properties below are optional
     *                                 .typeConfiguration(AudioExtractionCategoryTypeConfigurationProperty.builder()
     *                                         .transcript(TranscriptConfigurationProperty.builder()
     *                                                 .channelLabeling(ChannelLabelingConfigurationProperty.builder()
     *                                                         .state("state")
     *                                                         .build())
     *                                                 .speakerLabeling(SpeakerLabelingConfigurationProperty.builder()
     *                                                         .state("state")
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 .types(List.of("types"))
     *                                 .build())
     *                         .build())
     *                 .generativeField(AudioStandardGenerativeFieldProperty.builder()
     *                         .state("state")
     *                         // the properties below are optional
     *                         .types(List.of("types"))
     *                         .build())
     *                 .build())
     *         .document(DocumentStandardOutputConfigurationProperty.builder()
     *                 .extraction(DocumentStandardExtractionProperty.builder()
     *                         .boundingBox(DocumentBoundingBoxProperty.builder()
     *                                 .state("state")
     *                                 .build())
     *                         .granularity(DocumentExtractionGranularityProperty.builder()
     *                                 .types(List.of("types"))
     *                                 .build())
     *                         .build())
     *                 .generativeField(DocumentStandardGenerativeFieldProperty.builder()
     *                         .state("state")
     *                         .build())
     *                 .outputFormat(DocumentOutputFormatProperty.builder()
     *                         .additionalFileFormat(DocumentOutputAdditionalFileFormatProperty.builder()
     *                                 .state("state")
     *                                 .build())
     *                         .textFormat(DocumentOutputTextFormatProperty.builder()
     *                                 .types(List.of("types"))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .image(ImageStandardOutputConfigurationProperty.builder()
     *                 .extraction(ImageStandardExtractionProperty.builder()
     *                         .boundingBox(ImageBoundingBoxProperty.builder()
     *                                 .state("state")
     *                                 .build())
     *                         .category(ImageExtractionCategoryProperty.builder()
     *                                 .state("state")
     *                                 // the properties below are optional
     *                                 .types(List.of("types"))
     *                                 .build())
     *                         .build())
     *                 .generativeField(ImageStandardGenerativeFieldProperty.builder()
     *                         .state("state")
     *                         // the properties below are optional
     *                         .types(List.of("types"))
     *                         .build())
     *                 .build())
     *         .video(VideoStandardOutputConfigurationProperty.builder()
     *                 .extraction(VideoStandardExtractionProperty.builder()
     *                         .boundingBox(VideoBoundingBoxProperty.builder()
     *                                 .state("state")
     *                                 .build())
     *                         .category(VideoExtractionCategoryProperty.builder()
     *                                 .state("state")
     *                                 // the properties below are optional
     *                                 .types(List.of("types"))
     *                                 .build())
     *                         .build())
     *                 .generativeField(VideoStandardGenerativeFieldProperty.builder()
     *                         .state("state")
     *                         // the properties below are optional
     *                         .types(List.of("types"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-standardoutputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-standardoutputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.StandardOutputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StandardOutputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StandardOutputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings for processing audio.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.AudioStandardOutputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-standardoutputconfiguration.html#cfn-bedrock-dataautomationproject-standardoutputconfiguration-audio">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-standardoutputconfiguration.html#cfn-bedrock-dataautomationproject-standardoutputconfiguration-audio</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudio() {
            return null;
        }

        /**
         * Settings for processing documents.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentStandardOutputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-standardoutputconfiguration.html#cfn-bedrock-dataautomationproject-standardoutputconfiguration-document">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-standardoutputconfiguration.html#cfn-bedrock-dataautomationproject-standardoutputconfiguration-document</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDocument() {
            return null;
        }

        /**
         * Settings for processing images.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ImageStandardOutputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-standardoutputconfiguration.html#cfn-bedrock-dataautomationproject-standardoutputconfiguration-image">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-standardoutputconfiguration.html#cfn-bedrock-dataautomationproject-standardoutputconfiguration-image</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImage() {
            return null;
        }

        /**
         * Settings for processing video.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.VideoStandardOutputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-standardoutputconfiguration.html#cfn-bedrock-dataautomationproject-standardoutputconfiguration-video">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-standardoutputconfiguration.html#cfn-bedrock-dataautomationproject-standardoutputconfiguration-video</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVideo() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StandardOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StandardOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StandardOutputConfigurationProperty> {
            java.lang.Object audio;
            java.lang.Object document;
            java.lang.Object image;
            java.lang.Object video;

            /**
             * Sets the value of {@link StandardOutputConfigurationProperty#getAudio}
             * @param audio Settings for processing audio.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audio(software.amazon.awscdk.IResolvable audio) {
                this.audio = audio;
                return this;
            }

            /**
             * Sets the value of {@link StandardOutputConfigurationProperty#getAudio}
             * @param audio Settings for processing audio.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audio(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.AudioStandardOutputConfigurationProperty audio) {
                this.audio = audio;
                return this;
            }

            /**
             * Sets the value of {@link StandardOutputConfigurationProperty#getDocument}
             * @param document Settings for processing documents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder document(software.amazon.awscdk.IResolvable document) {
                this.document = document;
                return this;
            }

            /**
             * Sets the value of {@link StandardOutputConfigurationProperty#getDocument}
             * @param document Settings for processing documents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder document(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.DocumentStandardOutputConfigurationProperty document) {
                this.document = document;
                return this;
            }

            /**
             * Sets the value of {@link StandardOutputConfigurationProperty#getImage}
             * @param image Settings for processing images.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(software.amazon.awscdk.IResolvable image) {
                this.image = image;
                return this;
            }

            /**
             * Sets the value of {@link StandardOutputConfigurationProperty#getImage}
             * @param image Settings for processing images.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ImageStandardOutputConfigurationProperty image) {
                this.image = image;
                return this;
            }

            /**
             * Sets the value of {@link StandardOutputConfigurationProperty#getVideo}
             * @param video Settings for processing video.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder video(software.amazon.awscdk.IResolvable video) {
                this.video = video;
                return this;
            }

            /**
             * Sets the value of {@link StandardOutputConfigurationProperty#getVideo}
             * @param video Settings for processing video.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder video(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.VideoStandardOutputConfigurationProperty video) {
                this.video = video;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StandardOutputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StandardOutputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StandardOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StandardOutputConfigurationProperty {
            private final java.lang.Object audio;
            private final java.lang.Object document;
            private final java.lang.Object image;
            private final java.lang.Object video;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audio = software.amazon.jsii.Kernel.get(this, "audio", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.document = software.amazon.jsii.Kernel.get(this, "document", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.video = software.amazon.jsii.Kernel.get(this, "video", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audio = builder.audio;
                this.document = builder.document;
                this.image = builder.image;
                this.video = builder.video;
            }

            @Override
            public final java.lang.Object getAudio() {
                return this.audio;
            }

            @Override
            public final java.lang.Object getDocument() {
                return this.document;
            }

            @Override
            public final java.lang.Object getImage() {
                return this.image;
            }

            @Override
            public final java.lang.Object getVideo() {
                return this.video;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudio() != null) {
                    data.set("audio", om.valueToTree(this.getAudio()));
                }
                if (this.getDocument() != null) {
                    data.set("document", om.valueToTree(this.getDocument()));
                }
                if (this.getImage() != null) {
                    data.set("image", om.valueToTree(this.getImage()));
                }
                if (this.getVideo() != null) {
                    data.set("video", om.valueToTree(this.getVideo()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.StandardOutputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StandardOutputConfigurationProperty.Jsii$Proxy that = (StandardOutputConfigurationProperty.Jsii$Proxy) o;

                if (this.audio != null ? !this.audio.equals(that.audio) : that.audio != null) return false;
                if (this.document != null ? !this.document.equals(that.document) : that.document != null) return false;
                if (this.image != null ? !this.image.equals(that.image) : that.image != null) return false;
                return this.video != null ? this.video.equals(that.video) : that.video == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audio != null ? this.audio.hashCode() : 0;
                result = 31 * result + (this.document != null ? this.document.hashCode() : 0);
                result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
                result = 31 * result + (this.video != null ? this.video.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for transcript options.
     * <p>
     * This option allows you to enable speaker labeling and channel labeling.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * TranscriptConfigurationProperty transcriptConfigurationProperty = TranscriptConfigurationProperty.builder()
     *         .channelLabeling(ChannelLabelingConfigurationProperty.builder()
     *                 .state("state")
     *                 .build())
     *         .speakerLabeling(SpeakerLabelingConfigurationProperty.builder()
     *                 .state("state")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-transcriptconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-transcriptconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.TranscriptConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TranscriptConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TranscriptConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables channel labeling.
         * <p>
         * Each audio channel will be labeled with a number, and the transcript will indicate which channel is being used.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ChannelLabelingConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-transcriptconfiguration.html#cfn-bedrock-dataautomationproject-transcriptconfiguration-channellabeling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-transcriptconfiguration.html#cfn-bedrock-dataautomationproject-transcriptconfiguration-channellabeling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getChannelLabeling() {
            return null;
        }

        /**
         * Enables speaker labeling.
         * <p>
         * Each speaker within a transcript will recieve a number, and the transcript will note which speaker is talking.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.SpeakerLabelingConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-transcriptconfiguration.html#cfn-bedrock-dataautomationproject-transcriptconfiguration-speakerlabeling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-transcriptconfiguration.html#cfn-bedrock-dataautomationproject-transcriptconfiguration-speakerlabeling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSpeakerLabeling() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TranscriptConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TranscriptConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TranscriptConfigurationProperty> {
            java.lang.Object channelLabeling;
            java.lang.Object speakerLabeling;

            /**
             * Sets the value of {@link TranscriptConfigurationProperty#getChannelLabeling}
             * @param channelLabeling Enables channel labeling.
             *                        Each audio channel will be labeled with a number, and the transcript will indicate which channel is being used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channelLabeling(software.amazon.awscdk.IResolvable channelLabeling) {
                this.channelLabeling = channelLabeling;
                return this;
            }

            /**
             * Sets the value of {@link TranscriptConfigurationProperty#getChannelLabeling}
             * @param channelLabeling Enables channel labeling.
             *                        Each audio channel will be labeled with a number, and the transcript will indicate which channel is being used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channelLabeling(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ChannelLabelingConfigurationProperty channelLabeling) {
                this.channelLabeling = channelLabeling;
                return this;
            }

            /**
             * Sets the value of {@link TranscriptConfigurationProperty#getSpeakerLabeling}
             * @param speakerLabeling Enables speaker labeling.
             *                        Each speaker within a transcript will recieve a number, and the transcript will note which speaker is talking.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder speakerLabeling(software.amazon.awscdk.IResolvable speakerLabeling) {
                this.speakerLabeling = speakerLabeling;
                return this;
            }

            /**
             * Sets the value of {@link TranscriptConfigurationProperty#getSpeakerLabeling}
             * @param speakerLabeling Enables speaker labeling.
             *                        Each speaker within a transcript will recieve a number, and the transcript will note which speaker is talking.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder speakerLabeling(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.SpeakerLabelingConfigurationProperty speakerLabeling) {
                this.speakerLabeling = speakerLabeling;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TranscriptConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TranscriptConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TranscriptConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TranscriptConfigurationProperty {
            private final java.lang.Object channelLabeling;
            private final java.lang.Object speakerLabeling;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.channelLabeling = software.amazon.jsii.Kernel.get(this, "channelLabeling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.speakerLabeling = software.amazon.jsii.Kernel.get(this, "speakerLabeling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.channelLabeling = builder.channelLabeling;
                this.speakerLabeling = builder.speakerLabeling;
            }

            @Override
            public final java.lang.Object getChannelLabeling() {
                return this.channelLabeling;
            }

            @Override
            public final java.lang.Object getSpeakerLabeling() {
                return this.speakerLabeling;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getChannelLabeling() != null) {
                    data.set("channelLabeling", om.valueToTree(this.getChannelLabeling()));
                }
                if (this.getSpeakerLabeling() != null) {
                    data.set("speakerLabeling", om.valueToTree(this.getSpeakerLabeling()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.TranscriptConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TranscriptConfigurationProperty.Jsii$Proxy that = (TranscriptConfigurationProperty.Jsii$Proxy) o;

                if (this.channelLabeling != null ? !this.channelLabeling.equals(that.channelLabeling) : that.channelLabeling != null) return false;
                return this.speakerLabeling != null ? this.speakerLabeling.equals(that.speakerLabeling) : that.speakerLabeling == null;
            }

            @Override
            public final int hashCode() {
                int result = this.channelLabeling != null ? this.channelLabeling.hashCode() : 0;
                result = 31 * result + (this.speakerLabeling != null ? this.speakerLabeling.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Bounding box settings for video.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * VideoBoundingBoxProperty videoBoundingBoxProperty = VideoBoundingBoxProperty.builder()
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videoboundingbox.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videoboundingbox.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.VideoBoundingBoxProperty")
    @software.amazon.jsii.Jsii.Proxy(VideoBoundingBoxProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VideoBoundingBoxProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether bounding boxes are enabled for video.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videoboundingbox.html#cfn-bedrock-dataautomationproject-videoboundingbox-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videoboundingbox.html#cfn-bedrock-dataautomationproject-videoboundingbox-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getState();

        /**
         * @return a {@link Builder} of {@link VideoBoundingBoxProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VideoBoundingBoxProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VideoBoundingBoxProperty> {
            java.lang.String state;

            /**
             * Sets the value of {@link VideoBoundingBoxProperty#getState}
             * @param state Whether bounding boxes are enabled for video. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VideoBoundingBoxProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VideoBoundingBoxProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VideoBoundingBoxProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VideoBoundingBoxProperty {
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.state = java.util.Objects.requireNonNull(builder.state, "state is required");
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("state", om.valueToTree(this.getState()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.VideoBoundingBoxProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VideoBoundingBoxProperty.Jsii$Proxy that = (VideoBoundingBoxProperty.Jsii$Proxy) o;

                return this.state.equals(that.state);
            }

            @Override
            public final int hashCode() {
                int result = this.state.hashCode();
                return result;
            }
        }
    }
    /**
     * Settings for generating categorical data from video.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * VideoExtractionCategoryProperty videoExtractionCategoryProperty = VideoExtractionCategoryProperty.builder()
     *         .state("state")
     *         // the properties below are optional
     *         .types(List.of("types"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videoextractioncategory.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videoextractioncategory.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.VideoExtractionCategoryProperty")
    @software.amazon.jsii.Jsii.Proxy(VideoExtractionCategoryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VideoExtractionCategoryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether generating categorical data from video is enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videoextractioncategory.html#cfn-bedrock-dataautomationproject-videoextractioncategory-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videoextractioncategory.html#cfn-bedrock-dataautomationproject-videoextractioncategory-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getState();

        /**
         * The types of data to generate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videoextractioncategory.html#cfn-bedrock-dataautomationproject-videoextractioncategory-types">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videoextractioncategory.html#cfn-bedrock-dataautomationproject-videoextractioncategory-types</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VideoExtractionCategoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VideoExtractionCategoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VideoExtractionCategoryProperty> {
            java.lang.String state;
            java.util.List<java.lang.String> types;

            /**
             * Sets the value of {@link VideoExtractionCategoryProperty#getState}
             * @param state Whether generating categorical data from video is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Sets the value of {@link VideoExtractionCategoryProperty#getTypes}
             * @param types The types of data to generate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder types(java.util.List<java.lang.String> types) {
                this.types = types;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VideoExtractionCategoryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VideoExtractionCategoryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VideoExtractionCategoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VideoExtractionCategoryProperty {
            private final java.lang.String state;
            private final java.util.List<java.lang.String> types;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.types = software.amazon.jsii.Kernel.get(this, "types", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.state = java.util.Objects.requireNonNull(builder.state, "state is required");
                this.types = builder.types;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            public final java.util.List<java.lang.String> getTypes() {
                return this.types;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("state", om.valueToTree(this.getState()));
                if (this.getTypes() != null) {
                    data.set("types", om.valueToTree(this.getTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.VideoExtractionCategoryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VideoExtractionCategoryProperty.Jsii$Proxy that = (VideoExtractionCategoryProperty.Jsii$Proxy) o;

                if (!state.equals(that.state)) return false;
                return this.types != null ? this.types.equals(that.types) : that.types == null;
            }

            @Override
            public final int hashCode() {
                int result = this.state.hashCode();
                result = 31 * result + (this.types != null ? this.types.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Sets whether your project will process videos or not.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * VideoOverrideConfigurationProperty videoOverrideConfigurationProperty = VideoOverrideConfigurationProperty.builder()
     *         .modalityProcessing(ModalityProcessingConfigurationProperty.builder()
     *                 .state("state")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videooverrideconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videooverrideconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.VideoOverrideConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VideoOverrideConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VideoOverrideConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Sets modality processing for video files.
         * <p>
         * All modalities are enabled by default.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ModalityProcessingConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videooverrideconfiguration.html#cfn-bedrock-dataautomationproject-videooverrideconfiguration-modalityprocessing">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videooverrideconfiguration.html#cfn-bedrock-dataautomationproject-videooverrideconfiguration-modalityprocessing</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getModalityProcessing() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VideoOverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VideoOverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VideoOverrideConfigurationProperty> {
            java.lang.Object modalityProcessing;

            /**
             * Sets the value of {@link VideoOverrideConfigurationProperty#getModalityProcessing}
             * @param modalityProcessing Sets modality processing for video files.
             *                           All modalities are enabled by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modalityProcessing(software.amazon.awscdk.IResolvable modalityProcessing) {
                this.modalityProcessing = modalityProcessing;
                return this;
            }

            /**
             * Sets the value of {@link VideoOverrideConfigurationProperty#getModalityProcessing}
             * @param modalityProcessing Sets modality processing for video files.
             *                           All modalities are enabled by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modalityProcessing(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.ModalityProcessingConfigurationProperty modalityProcessing) {
                this.modalityProcessing = modalityProcessing;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VideoOverrideConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VideoOverrideConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VideoOverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VideoOverrideConfigurationProperty {
            private final java.lang.Object modalityProcessing;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.modalityProcessing = software.amazon.jsii.Kernel.get(this, "modalityProcessing", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.modalityProcessing = builder.modalityProcessing;
            }

            @Override
            public final java.lang.Object getModalityProcessing() {
                return this.modalityProcessing;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getModalityProcessing() != null) {
                    data.set("modalityProcessing", om.valueToTree(this.getModalityProcessing()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.VideoOverrideConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VideoOverrideConfigurationProperty.Jsii$Proxy that = (VideoOverrideConfigurationProperty.Jsii$Proxy) o;

                return this.modalityProcessing != null ? this.modalityProcessing.equals(that.modalityProcessing) : that.modalityProcessing == null;
            }

            @Override
            public final int hashCode() {
                int result = this.modalityProcessing != null ? this.modalityProcessing.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Settings for generating data from video.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * VideoStandardExtractionProperty videoStandardExtractionProperty = VideoStandardExtractionProperty.builder()
     *         .boundingBox(VideoBoundingBoxProperty.builder()
     *                 .state("state")
     *                 .build())
     *         .category(VideoExtractionCategoryProperty.builder()
     *                 .state("state")
     *                 // the properties below are optional
     *                 .types(List.of("types"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardextraction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardextraction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.VideoStandardExtractionProperty")
    @software.amazon.jsii.Jsii.Proxy(VideoStandardExtractionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VideoStandardExtractionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings for generating bounding boxes.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.VideoBoundingBoxProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardextraction.html#cfn-bedrock-dataautomationproject-videostandardextraction-boundingbox">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardextraction.html#cfn-bedrock-dataautomationproject-videostandardextraction-boundingbox</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getBoundingBox();

        /**
         * Settings for generating categorical data.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.VideoExtractionCategoryProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardextraction.html#cfn-bedrock-dataautomationproject-videostandardextraction-category">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardextraction.html#cfn-bedrock-dataautomationproject-videostandardextraction-category</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCategory();

        /**
         * @return a {@link Builder} of {@link VideoStandardExtractionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VideoStandardExtractionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VideoStandardExtractionProperty> {
            java.lang.Object boundingBox;
            java.lang.Object category;

            /**
             * Sets the value of {@link VideoStandardExtractionProperty#getBoundingBox}
             * @param boundingBox Settings for generating bounding boxes. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder boundingBox(software.amazon.awscdk.IResolvable boundingBox) {
                this.boundingBox = boundingBox;
                return this;
            }

            /**
             * Sets the value of {@link VideoStandardExtractionProperty#getBoundingBox}
             * @param boundingBox Settings for generating bounding boxes. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder boundingBox(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.VideoBoundingBoxProperty boundingBox) {
                this.boundingBox = boundingBox;
                return this;
            }

            /**
             * Sets the value of {@link VideoStandardExtractionProperty#getCategory}
             * @param category Settings for generating categorical data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder category(software.amazon.awscdk.IResolvable category) {
                this.category = category;
                return this;
            }

            /**
             * Sets the value of {@link VideoStandardExtractionProperty#getCategory}
             * @param category Settings for generating categorical data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder category(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.VideoExtractionCategoryProperty category) {
                this.category = category;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VideoStandardExtractionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VideoStandardExtractionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VideoStandardExtractionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VideoStandardExtractionProperty {
            private final java.lang.Object boundingBox;
            private final java.lang.Object category;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.boundingBox = software.amazon.jsii.Kernel.get(this, "boundingBox", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.category = software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.boundingBox = java.util.Objects.requireNonNull(builder.boundingBox, "boundingBox is required");
                this.category = java.util.Objects.requireNonNull(builder.category, "category is required");
            }

            @Override
            public final java.lang.Object getBoundingBox() {
                return this.boundingBox;
            }

            @Override
            public final java.lang.Object getCategory() {
                return this.category;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("boundingBox", om.valueToTree(this.getBoundingBox()));
                data.set("category", om.valueToTree(this.getCategory()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.VideoStandardExtractionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VideoStandardExtractionProperty.Jsii$Proxy that = (VideoStandardExtractionProperty.Jsii$Proxy) o;

                if (!boundingBox.equals(that.boundingBox)) return false;
                return this.category.equals(that.category);
            }

            @Override
            public final int hashCode() {
                int result = this.boundingBox.hashCode();
                result = 31 * result + (this.category.hashCode());
                return result;
            }
        }
    }
    /**
     * Settings for generating descriptions of video.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * VideoStandardGenerativeFieldProperty videoStandardGenerativeFieldProperty = VideoStandardGenerativeFieldProperty.builder()
     *         .state("state")
     *         // the properties below are optional
     *         .types(List.of("types"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardgenerativefield.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardgenerativefield.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.VideoStandardGenerativeFieldProperty")
    @software.amazon.jsii.Jsii.Proxy(VideoStandardGenerativeFieldProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VideoStandardGenerativeFieldProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether generating descriptions is enabled for video.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardgenerativefield.html#cfn-bedrock-dataautomationproject-videostandardgenerativefield-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardgenerativefield.html#cfn-bedrock-dataautomationproject-videostandardgenerativefield-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getState();

        /**
         * The types of description to generate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardgenerativefield.html#cfn-bedrock-dataautomationproject-videostandardgenerativefield-types">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardgenerativefield.html#cfn-bedrock-dataautomationproject-videostandardgenerativefield-types</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VideoStandardGenerativeFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VideoStandardGenerativeFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VideoStandardGenerativeFieldProperty> {
            java.lang.String state;
            java.util.List<java.lang.String> types;

            /**
             * Sets the value of {@link VideoStandardGenerativeFieldProperty#getState}
             * @param state Whether generating descriptions is enabled for video. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Sets the value of {@link VideoStandardGenerativeFieldProperty#getTypes}
             * @param types The types of description to generate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder types(java.util.List<java.lang.String> types) {
                this.types = types;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VideoStandardGenerativeFieldProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VideoStandardGenerativeFieldProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VideoStandardGenerativeFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VideoStandardGenerativeFieldProperty {
            private final java.lang.String state;
            private final java.util.List<java.lang.String> types;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.types = software.amazon.jsii.Kernel.get(this, "types", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.state = java.util.Objects.requireNonNull(builder.state, "state is required");
                this.types = builder.types;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            public final java.util.List<java.lang.String> getTypes() {
                return this.types;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("state", om.valueToTree(this.getState()));
                if (this.getTypes() != null) {
                    data.set("types", om.valueToTree(this.getTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.VideoStandardGenerativeFieldProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VideoStandardGenerativeFieldProperty.Jsii$Proxy that = (VideoStandardGenerativeFieldProperty.Jsii$Proxy) o;

                if (!state.equals(that.state)) return false;
                return this.types != null ? this.types.equals(that.types) : that.types == null;
            }

            @Override
            public final int hashCode() {
                int result = this.state.hashCode();
                result = 31 * result + (this.types != null ? this.types.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Output settings for processing video.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * VideoStandardOutputConfigurationProperty videoStandardOutputConfigurationProperty = VideoStandardOutputConfigurationProperty.builder()
     *         .extraction(VideoStandardExtractionProperty.builder()
     *                 .boundingBox(VideoBoundingBoxProperty.builder()
     *                         .state("state")
     *                         .build())
     *                 .category(VideoExtractionCategoryProperty.builder()
     *                         .state("state")
     *                         // the properties below are optional
     *                         .types(List.of("types"))
     *                         .build())
     *                 .build())
     *         .generativeField(VideoStandardGenerativeFieldProperty.builder()
     *                 .state("state")
     *                 // the properties below are optional
     *                 .types(List.of("types"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardoutputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardoutputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.VideoStandardOutputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VideoStandardOutputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VideoStandardOutputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings for populating data fields that describe the video.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.VideoStandardExtractionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-videostandardoutputconfiguration-extraction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-videostandardoutputconfiguration-extraction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExtraction() {
            return null;
        }

        /**
         * Whether to generate descriptions of the video.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.VideoStandardGenerativeFieldProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-videostandardoutputconfiguration-generativefield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-dataautomationproject-videostandardoutputconfiguration.html#cfn-bedrock-dataautomationproject-videostandardoutputconfiguration-generativefield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGenerativeField() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VideoStandardOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VideoStandardOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VideoStandardOutputConfigurationProperty> {
            java.lang.Object extraction;
            java.lang.Object generativeField;

            /**
             * Sets the value of {@link VideoStandardOutputConfigurationProperty#getExtraction}
             * @param extraction Settings for populating data fields that describe the video.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extraction(software.amazon.awscdk.IResolvable extraction) {
                this.extraction = extraction;
                return this;
            }

            /**
             * Sets the value of {@link VideoStandardOutputConfigurationProperty#getExtraction}
             * @param extraction Settings for populating data fields that describe the video.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extraction(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.VideoStandardExtractionProperty extraction) {
                this.extraction = extraction;
                return this;
            }

            /**
             * Sets the value of {@link VideoStandardOutputConfigurationProperty#getGenerativeField}
             * @param generativeField Whether to generate descriptions of the video.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generativeField(software.amazon.awscdk.IResolvable generativeField) {
                this.generativeField = generativeField;
                return this;
            }

            /**
             * Sets the value of {@link VideoStandardOutputConfigurationProperty#getGenerativeField}
             * @param generativeField Whether to generate descriptions of the video.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generativeField(software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.VideoStandardGenerativeFieldProperty generativeField) {
                this.generativeField = generativeField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VideoStandardOutputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VideoStandardOutputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VideoStandardOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VideoStandardOutputConfigurationProperty {
            private final java.lang.Object extraction;
            private final java.lang.Object generativeField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.extraction = software.amazon.jsii.Kernel.get(this, "extraction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.generativeField = software.amazon.jsii.Kernel.get(this, "generativeField", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.extraction = builder.extraction;
                this.generativeField = builder.generativeField;
            }

            @Override
            public final java.lang.Object getExtraction() {
                return this.extraction;
            }

            @Override
            public final java.lang.Object getGenerativeField() {
                return this.generativeField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExtraction() != null) {
                    data.set("extraction", om.valueToTree(this.getExtraction()));
                }
                if (this.getGenerativeField() != null) {
                    data.set("generativeField", om.valueToTree(this.getGenerativeField()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnDataAutomationProject.VideoStandardOutputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VideoStandardOutputConfigurationProperty.Jsii$Proxy that = (VideoStandardOutputConfigurationProperty.Jsii$Proxy) o;

                if (this.extraction != null ? !this.extraction.equals(that.extraction) : that.extraction != null) return false;
                return this.generativeField != null ? this.generativeField.equals(that.generativeField) : that.generativeField == null;
            }

            @Override
            public final int hashCode() {
                int result = this.extraction != null ? this.extraction.hashCode() : 0;
                result = 31 * result + (this.generativeField != null ? this.generativeField.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.bedrock.CfnDataAutomationProject> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.bedrock.CfnDataAutomationProjectProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.bedrock.CfnDataAutomationProjectProps.Builder();
        }

        /**
         * The project's name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-projectname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-projectname</a>
         * @param projectName The project's name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectName(final java.lang.String projectName) {
            this.props.projectName(projectName);
            return this;
        }

        /**
         * Blueprints to apply to objects processed by the project.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-customoutputconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-customoutputconfiguration</a>
         * @param customOutputConfiguration Blueprints to apply to objects processed by the project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customOutputConfiguration(final software.amazon.awscdk.IResolvable customOutputConfiguration) {
            this.props.customOutputConfiguration(customOutputConfiguration);
            return this;
        }
        /**
         * Blueprints to apply to objects processed by the project.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-customoutputconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-customoutputconfiguration</a>
         * @param customOutputConfiguration Blueprints to apply to objects processed by the project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customOutputConfiguration(final software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.CustomOutputConfigurationProperty customOutputConfiguration) {
            this.props.customOutputConfiguration(customOutputConfiguration);
            return this;
        }

        /**
         * The AWS KMS encryption context to use for encryption.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-kmsencryptioncontext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-kmsencryptioncontext</a>
         * @param kmsEncryptionContext The AWS KMS encryption context to use for encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsEncryptionContext(final java.util.Map<java.lang.String, java.lang.String> kmsEncryptionContext) {
            this.props.kmsEncryptionContext(kmsEncryptionContext);
            return this;
        }
        /**
         * The AWS KMS encryption context to use for encryption.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-kmsencryptioncontext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-kmsencryptioncontext</a>
         * @param kmsEncryptionContext The AWS KMS encryption context to use for encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsEncryptionContext(final software.amazon.awscdk.IResolvable kmsEncryptionContext) {
            this.props.kmsEncryptionContext(kmsEncryptionContext);
            return this;
        }

        /**
         * The AWS KMS key to use for encryption.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-kmskeyid</a>
         * @param kmsKeyId The AWS KMS key to use for encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * Additional settings for the project.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-overrideconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-overrideconfiguration</a>
         * @param overrideConfiguration Additional settings for the project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overrideConfiguration(final software.amazon.awscdk.IResolvable overrideConfiguration) {
            this.props.overrideConfiguration(overrideConfiguration);
            return this;
        }
        /**
         * Additional settings for the project.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-overrideconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-overrideconfiguration</a>
         * @param overrideConfiguration Additional settings for the project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overrideConfiguration(final software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.OverrideConfigurationProperty overrideConfiguration) {
            this.props.overrideConfiguration(overrideConfiguration);
            return this;
        }

        /**
         * The project's description.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-projectdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-projectdescription</a>
         * @param projectDescription The project's description. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectDescription(final java.lang.String projectDescription) {
            this.props.projectDescription(projectDescription);
            return this;
        }

        /**
         * The project's standard output configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-standardoutputconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-standardoutputconfiguration</a>
         * @param standardOutputConfiguration The project's standard output configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder standardOutputConfiguration(final software.amazon.awscdk.IResolvable standardOutputConfiguration) {
            this.props.standardOutputConfiguration(standardOutputConfiguration);
            return this;
        }
        /**
         * The project's standard output configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-standardoutputconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-standardoutputconfiguration</a>
         * @param standardOutputConfiguration The project's standard output configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder standardOutputConfiguration(final software.amazon.awscdk.services.bedrock.CfnDataAutomationProject.StandardOutputConfigurationProperty standardOutputConfiguration) {
            this.props.standardOutputConfiguration(standardOutputConfiguration);
            return this;
        }

        /**
         * List of Tags.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-dataautomationproject.html#cfn-bedrock-dataautomationproject-tags</a>
         * @param tags List of Tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.bedrock.CfnDataAutomationProject}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.bedrock.CfnDataAutomationProject build() {
            return new software.amazon.awscdk.services.bedrock.CfnDataAutomationProject(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
