package software.amazon.awscdk.services.bedrock;

/**
 * A reference to a Guardrail resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * GuardrailReference guardrailReference = GuardrailReference.builder()
 *         .guardrailArn("guardrailArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:59.606Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.GuardrailReference")
@software.amazon.jsii.Jsii.Proxy(GuardrailReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GuardrailReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The GuardrailArn of the Guardrail resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGuardrailArn();

    /**
     * @return a {@link Builder} of {@link GuardrailReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GuardrailReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GuardrailReference> {
        java.lang.String guardrailArn;

        /**
         * Sets the value of {@link GuardrailReference#getGuardrailArn}
         * @param guardrailArn The GuardrailArn of the Guardrail resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder guardrailArn(java.lang.String guardrailArn) {
            this.guardrailArn = guardrailArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GuardrailReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GuardrailReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GuardrailReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GuardrailReference {
        private final java.lang.String guardrailArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.guardrailArn = software.amazon.jsii.Kernel.get(this, "guardrailArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.guardrailArn = java.util.Objects.requireNonNull(builder.guardrailArn, "guardrailArn is required");
        }

        @Override
        public final java.lang.String getGuardrailArn() {
            return this.guardrailArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("guardrailArn", om.valueToTree(this.getGuardrailArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.GuardrailReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GuardrailReference.Jsii$Proxy that = (GuardrailReference.Jsii$Proxy) o;

            return this.guardrailArn.equals(that.guardrailArn);
        }

        @Override
        public final int hashCode() {
            int result = this.guardrailArn.hashCode();
            return result;
        }
    }
}
