package software.amazon.awscdk.services.billingconductor;

/**
 * A reference to a PricingPlan resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.billingconductor.*;
 * PricingPlanReference pricingPlanReference = PricingPlanReference.builder()
 *         .pricingPlanArn("pricingPlanArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:59.697Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_billingconductor.PricingPlanReference")
@software.amazon.jsii.Jsii.Proxy(PricingPlanReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PricingPlanReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the PricingPlan resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPricingPlanArn();

    /**
     * @return a {@link Builder} of {@link PricingPlanReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PricingPlanReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PricingPlanReference> {
        java.lang.String pricingPlanArn;

        /**
         * Sets the value of {@link PricingPlanReference#getPricingPlanArn}
         * @param pricingPlanArn The Arn of the PricingPlan resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pricingPlanArn(java.lang.String pricingPlanArn) {
            this.pricingPlanArn = pricingPlanArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PricingPlanReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PricingPlanReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PricingPlanReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PricingPlanReference {
        private final java.lang.String pricingPlanArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.pricingPlanArn = software.amazon.jsii.Kernel.get(this, "pricingPlanArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.pricingPlanArn = java.util.Objects.requireNonNull(builder.pricingPlanArn, "pricingPlanArn is required");
        }

        @Override
        public final java.lang.String getPricingPlanArn() {
            return this.pricingPlanArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("pricingPlanArn", om.valueToTree(this.getPricingPlanArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_billingconductor.PricingPlanReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PricingPlanReference.Jsii$Proxy that = (PricingPlanReference.Jsii$Proxy) o;

            return this.pricingPlanArn.equals(that.pricingPlanArn);
        }

        @Override
        public final int hashCode() {
            int result = this.pricingPlanArn.hashCode();
            return result;
        }
    }
}
