package software.amazon.awscdk.services.cleanrooms;

/**
 * A reference to a IdMappingTable resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cleanrooms.*;
 * IdMappingTableReference idMappingTableReference = IdMappingTableReference.builder()
 *         .idMappingTableArn("idMappingTableArn")
 *         .idMappingTableIdentifier("idMappingTableIdentifier")
 *         .membershipIdentifier("membershipIdentifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:59.898Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.IdMappingTableReference")
@software.amazon.jsii.Jsii.Proxy(IdMappingTableReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IdMappingTableReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the IdMappingTable resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdMappingTableArn();

    /**
     * The IdMappingTableIdentifier of the IdMappingTable resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdMappingTableIdentifier();

    /**
     * The MembershipIdentifier of the IdMappingTable resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMembershipIdentifier();

    /**
     * @return a {@link Builder} of {@link IdMappingTableReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IdMappingTableReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IdMappingTableReference> {
        java.lang.String idMappingTableArn;
        java.lang.String idMappingTableIdentifier;
        java.lang.String membershipIdentifier;

        /**
         * Sets the value of {@link IdMappingTableReference#getIdMappingTableArn}
         * @param idMappingTableArn The ARN of the IdMappingTable resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idMappingTableArn(java.lang.String idMappingTableArn) {
            this.idMappingTableArn = idMappingTableArn;
            return this;
        }

        /**
         * Sets the value of {@link IdMappingTableReference#getIdMappingTableIdentifier}
         * @param idMappingTableIdentifier The IdMappingTableIdentifier of the IdMappingTable resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idMappingTableIdentifier(java.lang.String idMappingTableIdentifier) {
            this.idMappingTableIdentifier = idMappingTableIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link IdMappingTableReference#getMembershipIdentifier}
         * @param membershipIdentifier The MembershipIdentifier of the IdMappingTable resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder membershipIdentifier(java.lang.String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IdMappingTableReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IdMappingTableReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IdMappingTableReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdMappingTableReference {
        private final java.lang.String idMappingTableArn;
        private final java.lang.String idMappingTableIdentifier;
        private final java.lang.String membershipIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.idMappingTableArn = software.amazon.jsii.Kernel.get(this, "idMappingTableArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.idMappingTableIdentifier = software.amazon.jsii.Kernel.get(this, "idMappingTableIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.membershipIdentifier = software.amazon.jsii.Kernel.get(this, "membershipIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.idMappingTableArn = java.util.Objects.requireNonNull(builder.idMappingTableArn, "idMappingTableArn is required");
            this.idMappingTableIdentifier = java.util.Objects.requireNonNull(builder.idMappingTableIdentifier, "idMappingTableIdentifier is required");
            this.membershipIdentifier = java.util.Objects.requireNonNull(builder.membershipIdentifier, "membershipIdentifier is required");
        }

        @Override
        public final java.lang.String getIdMappingTableArn() {
            return this.idMappingTableArn;
        }

        @Override
        public final java.lang.String getIdMappingTableIdentifier() {
            return this.idMappingTableIdentifier;
        }

        @Override
        public final java.lang.String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("idMappingTableArn", om.valueToTree(this.getIdMappingTableArn()));
            data.set("idMappingTableIdentifier", om.valueToTree(this.getIdMappingTableIdentifier()));
            data.set("membershipIdentifier", om.valueToTree(this.getMembershipIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.IdMappingTableReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IdMappingTableReference.Jsii$Proxy that = (IdMappingTableReference.Jsii$Proxy) o;

            if (!idMappingTableArn.equals(that.idMappingTableArn)) return false;
            if (!idMappingTableIdentifier.equals(that.idMappingTableIdentifier)) return false;
            return this.membershipIdentifier.equals(that.membershipIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.idMappingTableArn.hashCode();
            result = 31 * result + (this.idMappingTableIdentifier.hashCode());
            result = 31 * result + (this.membershipIdentifier.hashCode());
            return result;
        }
    }
}
