package software.amazon.awscdk.services.cleanrooms;

/**
 * A reference to a Membership resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cleanrooms.*;
 * MembershipReference membershipReference = MembershipReference.builder()
 *         .membershipArn("membershipArn")
 *         .membershipIdentifier("membershipIdentifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:59.899Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.MembershipReference")
@software.amazon.jsii.Jsii.Proxy(MembershipReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MembershipReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Membership resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMembershipArn();

    /**
     * The MembershipIdentifier of the Membership resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMembershipIdentifier();

    /**
     * @return a {@link Builder} of {@link MembershipReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MembershipReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MembershipReference> {
        java.lang.String membershipArn;
        java.lang.String membershipIdentifier;

        /**
         * Sets the value of {@link MembershipReference#getMembershipArn}
         * @param membershipArn The ARN of the Membership resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder membershipArn(java.lang.String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        /**
         * Sets the value of {@link MembershipReference#getMembershipIdentifier}
         * @param membershipIdentifier The MembershipIdentifier of the Membership resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder membershipIdentifier(java.lang.String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MembershipReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MembershipReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MembershipReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MembershipReference {
        private final java.lang.String membershipArn;
        private final java.lang.String membershipIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.membershipArn = software.amazon.jsii.Kernel.get(this, "membershipArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.membershipIdentifier = software.amazon.jsii.Kernel.get(this, "membershipIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.membershipArn = java.util.Objects.requireNonNull(builder.membershipArn, "membershipArn is required");
            this.membershipIdentifier = java.util.Objects.requireNonNull(builder.membershipIdentifier, "membershipIdentifier is required");
        }

        @Override
        public final java.lang.String getMembershipArn() {
            return this.membershipArn;
        }

        @Override
        public final java.lang.String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("membershipArn", om.valueToTree(this.getMembershipArn()));
            data.set("membershipIdentifier", om.valueToTree(this.getMembershipIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.MembershipReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MembershipReference.Jsii$Proxy that = (MembershipReference.Jsii$Proxy) o;

            if (!membershipArn.equals(that.membershipArn)) return false;
            return this.membershipIdentifier.equals(that.membershipIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.membershipArn.hashCode();
            result = 31 * result + (this.membershipIdentifier.hashCode());
            return result;
        }
    }
}
