package software.amazon.awscdk.services.cloud9;

/**
 * A reference to a EnvironmentEC2 resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloud9.*;
 * EnvironmentEC2Reference environmentEC2Reference = EnvironmentEC2Reference.builder()
 *         .environmentEc2Arn("environmentEc2Arn")
 *         .environmentEc2Id("environmentEc2Id")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:59.909Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloud9.EnvironmentEC2Reference")
@software.amazon.jsii.Jsii.Proxy(EnvironmentEC2Reference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EnvironmentEC2Reference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the EnvironmentEC2 resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentEc2Arn();

    /**
     * The Id of the EnvironmentEC2 resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentEc2Id();

    /**
     * @return a {@link Builder} of {@link EnvironmentEC2Reference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EnvironmentEC2Reference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EnvironmentEC2Reference> {
        java.lang.String environmentEc2Arn;
        java.lang.String environmentEc2Id;

        /**
         * Sets the value of {@link EnvironmentEC2Reference#getEnvironmentEc2Arn}
         * @param environmentEc2Arn The ARN of the EnvironmentEC2 resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentEc2Arn(java.lang.String environmentEc2Arn) {
            this.environmentEc2Arn = environmentEc2Arn;
            return this;
        }

        /**
         * Sets the value of {@link EnvironmentEC2Reference#getEnvironmentEc2Id}
         * @param environmentEc2Id The Id of the EnvironmentEC2 resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentEc2Id(java.lang.String environmentEc2Id) {
            this.environmentEc2Id = environmentEc2Id;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EnvironmentEC2Reference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EnvironmentEC2Reference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EnvironmentEC2Reference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentEC2Reference {
        private final java.lang.String environmentEc2Arn;
        private final java.lang.String environmentEc2Id;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.environmentEc2Arn = software.amazon.jsii.Kernel.get(this, "environmentEc2Arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentEc2Id = software.amazon.jsii.Kernel.get(this, "environmentEc2Id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.environmentEc2Arn = java.util.Objects.requireNonNull(builder.environmentEc2Arn, "environmentEc2Arn is required");
            this.environmentEc2Id = java.util.Objects.requireNonNull(builder.environmentEc2Id, "environmentEc2Id is required");
        }

        @Override
        public final java.lang.String getEnvironmentEc2Arn() {
            return this.environmentEc2Arn;
        }

        @Override
        public final java.lang.String getEnvironmentEc2Id() {
            return this.environmentEc2Id;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("environmentEc2Arn", om.valueToTree(this.getEnvironmentEc2Arn()));
            data.set("environmentEc2Id", om.valueToTree(this.getEnvironmentEc2Id()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloud9.EnvironmentEC2Reference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EnvironmentEC2Reference.Jsii$Proxy that = (EnvironmentEC2Reference.Jsii$Proxy) o;

            if (!environmentEc2Arn.equals(that.environmentEc2Arn)) return false;
            return this.environmentEc2Id.equals(that.environmentEc2Id);
        }

        @Override
        public final int hashCode() {
            int result = this.environmentEc2Arn.hashCode();
            result = 31 * result + (this.environmentEc2Id.hashCode());
            return result;
        }
    }
}
