package software.amazon.awscdk.services.cloudformation;

/**
 * Properties for defining a <code>CfnResourceDefaultVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudformation.*;
 * CfnResourceDefaultVersionProps cfnResourceDefaultVersionProps = CfnResourceDefaultVersionProps.builder()
 *         .typeName("typeName")
 *         .typeVersionArn("typeVersionArn")
 *         .versionId("versionId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourcedefaultversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourcedefaultversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:59.958Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudformation.CfnResourceDefaultVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnResourceDefaultVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResourceDefaultVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the resource.
     * <p>
     * Conditional: You must specify either <code>TypeVersionArn</code> , or <code>TypeName</code> and <code>VersionId</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourcedefaultversion.html#cfn-cloudformation-resourcedefaultversion-typename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourcedefaultversion.html#cfn-cloudformation-resourcedefaultversion-typename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTypeName() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the resource version.
     * <p>
     * Conditional: You must specify either <code>TypeVersionArn</code> , or <code>TypeName</code> and <code>VersionId</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourcedefaultversion.html#cfn-cloudformation-resourcedefaultversion-typeversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourcedefaultversion.html#cfn-cloudformation-resourcedefaultversion-typeversionarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTypeVersionArn() {
        return null;
    }

    /**
     * The ID of a specific version of the resource.
     * <p>
     * The version ID is the value at the end of the Amazon Resource Name (ARN) assigned to the resource version when it's registered.
     * <p>
     * Conditional: You must specify either <code>TypeVersionArn</code> , or <code>TypeName</code> and <code>VersionId</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourcedefaultversion.html#cfn-cloudformation-resourcedefaultversion-versionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourcedefaultversion.html#cfn-cloudformation-resourcedefaultversion-versionid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersionId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnResourceDefaultVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResourceDefaultVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResourceDefaultVersionProps> {
        java.lang.String typeName;
        java.lang.String typeVersionArn;
        java.lang.String versionId;

        /**
         * Sets the value of {@link CfnResourceDefaultVersionProps#getTypeName}
         * @param typeName The name of the resource.
         *                 Conditional: You must specify either <code>TypeVersionArn</code> , or <code>TypeName</code> and <code>VersionId</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeName(java.lang.String typeName) {
            this.typeName = typeName;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceDefaultVersionProps#getTypeVersionArn}
         * @param typeVersionArn The Amazon Resource Name (ARN) of the resource version.
         *                       Conditional: You must specify either <code>TypeVersionArn</code> , or <code>TypeName</code> and <code>VersionId</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeVersionArn(java.lang.String typeVersionArn) {
            this.typeVersionArn = typeVersionArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceDefaultVersionProps#getVersionId}
         * @param versionId The ID of a specific version of the resource.
         *                  The version ID is the value at the end of the Amazon Resource Name (ARN) assigned to the resource version when it's registered.
         *                  <p>
         *                  Conditional: You must specify either <code>TypeVersionArn</code> , or <code>TypeName</code> and <code>VersionId</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionId(java.lang.String versionId) {
            this.versionId = versionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResourceDefaultVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResourceDefaultVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResourceDefaultVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResourceDefaultVersionProps {
        private final java.lang.String typeName;
        private final java.lang.String typeVersionArn;
        private final java.lang.String versionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.typeName = software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.typeVersionArn = software.amazon.jsii.Kernel.get(this, "typeVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.versionId = software.amazon.jsii.Kernel.get(this, "versionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.typeName = builder.typeName;
            this.typeVersionArn = builder.typeVersionArn;
            this.versionId = builder.versionId;
        }

        @Override
        public final java.lang.String getTypeName() {
            return this.typeName;
        }

        @Override
        public final java.lang.String getTypeVersionArn() {
            return this.typeVersionArn;
        }

        @Override
        public final java.lang.String getVersionId() {
            return this.versionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getTypeName() != null) {
                data.set("typeName", om.valueToTree(this.getTypeName()));
            }
            if (this.getTypeVersionArn() != null) {
                data.set("typeVersionArn", om.valueToTree(this.getTypeVersionArn()));
            }
            if (this.getVersionId() != null) {
                data.set("versionId", om.valueToTree(this.getVersionId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudformation.CfnResourceDefaultVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResourceDefaultVersionProps.Jsii$Proxy that = (CfnResourceDefaultVersionProps.Jsii$Proxy) o;

            if (this.typeName != null ? !this.typeName.equals(that.typeName) : that.typeName != null) return false;
            if (this.typeVersionArn != null ? !this.typeVersionArn.equals(that.typeVersionArn) : that.typeVersionArn != null) return false;
            return this.versionId != null ? this.versionId.equals(that.versionId) : that.versionId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.typeName != null ? this.typeName.hashCode() : 0;
            result = 31 * result + (this.typeVersionArn != null ? this.typeVersionArn.hashCode() : 0);
            result = 31 * result + (this.versionId != null ? this.versionId.hashCode() : 0);
            return result;
        }
    }
}
