package software.amazon.awscdk.services.cloudfront;

/**
 * An import source from a local file.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.cloudfront.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.kms.*;
 * DockerImage dockerImage;
 * IGrantable grantable;
 * IKeyRef keyRef;
 * ILocalBundling localBundling;
 * ImportSource assetImportSource = AssetImportSource.fromAsset("path", AssetOptions.builder()
 *         .assetHash("assetHash")
 *         .assetHashType(AssetHashType.SOURCE)
 *         .bundling(BundlingOptions.builder()
 *                 .image(dockerImage)
 *                 // the properties below are optional
 *                 .bundlingFileAccess(BundlingFileAccess.VOLUME_COPY)
 *                 .command(List.of("command"))
 *                 .entrypoint(List.of("entrypoint"))
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .local(localBundling)
 *                 .network("network")
 *                 .outputType(BundlingOutput.ARCHIVED)
 *                 .platform("platform")
 *                 .securityOpt("securityOpt")
 *                 .user("user")
 *                 .volumes(List.of(DockerVolume.builder()
 *                         .containerPath("containerPath")
 *                         .hostPath("hostPath")
 *                         // the properties below are optional
 *                         .consistency(DockerVolumeConsistency.CONSISTENT)
 *                         .build()))
 *                 .volumesFrom(List.of("volumesFrom"))
 *                 .workingDirectory("workingDirectory")
 *                 .build())
 *         .deployTime(false)
 *         .displayName("displayName")
 *         .exclude(List.of("exclude"))
 *         .followSymlinks(SymlinkFollowMode.NEVER)
 *         .ignoreMode(IgnoreMode.GLOB)
 *         .readers(List.of(grantable))
 *         .sourceKMSKey(keyRef)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:00.023Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.AssetImportSource")
public class AssetImportSource extends software.amazon.awscdk.services.cloudfront.ImportSource {

    protected AssetImportSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetImportSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param path the path to the local file. This parameter is required.
     * @param options the configuration for the temporarily created S3 file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AssetImportSource(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * @param path the path to the local file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AssetImportSource(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * the path to the local file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPath() {
        return software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.AssetImportSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.AssetImportSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param path the path to the local file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String path) {
            return new Builder(path);
        }

        private final java.lang.String path;
        private software.amazon.awscdk.services.s3.assets.AssetOptions.Builder options;

        private Builder(final java.lang.String path) {
            this.path = path;
        }

        /**
         * Specify a custom hash for this asset.
         * <p>
         * If <code>assetHashType</code> is set it must
         * be set to <code>AssetHashType.CUSTOM</code>. For consistency, this custom hash will
         * be SHA256 hashed and encoded as hex. The resulting hash will be the asset
         * hash.
         * <p>
         * NOTE: the hash is used in order to identify a specific revision of the asset, and
         * used for optimizing and caching deployment activities related to this asset such as
         * packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
         * need to make sure it is updated every time the asset changes, or otherwise it is
         * possible that some deployments will not be invalidated.
         * <p>
         * Default: - based on `assetHashType`
         * <p>
         * @return {@code this}
         * @param assetHash Specify a custom hash for this asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHash(final java.lang.String assetHash) {
            this.options().assetHash(assetHash);
            return this;
        }

        /**
         * Specifies the type of hash to calculate for this asset.
         * <p>
         * If <code>assetHash</code> is configured, this option must be <code>undefined</code> or
         * <code>AssetHashType.CUSTOM</code>.
         * <p>
         * Default: - the default is `AssetHashType.SOURCE`, but if `assetHash` is
         * explicitly specified this value defaults to `AssetHashType.CUSTOM`.
         * <p>
         * @return {@code this}
         * @param assetHashType Specifies the type of hash to calculate for this asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHashType(final software.amazon.awscdk.AssetHashType assetHashType) {
            this.options().assetHashType(assetHashType);
            return this;
        }

        /**
         * Bundle the asset by executing a command in a Docker container or a custom bundling provider.
         * <p>
         * The asset path will be mounted at <code>/asset-input</code>. The Docker
         * container is responsible for putting content at <code>/asset-output</code>.
         * The content at <code>/asset-output</code> will be zipped and used as the
         * final asset.
         * <p>
         * Default: - uploaded as-is to S3 if the asset is a regular file or a .zip file,
         * archived into a .zip file and uploaded to S3 otherwise
         * <p>
         * @return {@code this}
         * @param bundling Bundle the asset by executing a command in a Docker container or a custom bundling provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundling(final software.amazon.awscdk.BundlingOptions bundling) {
            this.options().bundling(bundling);
            return this;
        }

        /**
         * File paths matching the patterns will be excluded.
         * <p>
         * See <code>ignoreMode</code> to set the matching behavior.
         * Has no effect on Assets bundled using the <code>bundling</code> property.
         * <p>
         * Default: - nothing is excluded
         * <p>
         * @return {@code this}
         * @param exclude File paths matching the patterns will be excluded. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(final java.util.List<java.lang.String> exclude) {
            this.options().exclude(exclude);
            return this;
        }

        /**
         * A strategy for how to handle symlinks.
         * <p>
         * Default: SymlinkFollowMode.NEVER
         * <p>
         * @return {@code this}
         * @param followSymlinks A strategy for how to handle symlinks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder followSymlinks(final software.amazon.awscdk.SymlinkFollowMode followSymlinks) {
            this.options().followSymlinks(followSymlinks);
            return this;
        }

        /**
         * The ignore behavior to use for <code>exclude</code> patterns.
         * <p>
         * Default: IgnoreMode.GLOB
         * <p>
         * @return {@code this}
         * @param ignoreMode The ignore behavior to use for <code>exclude</code> patterns. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreMode(final software.amazon.awscdk.IgnoreMode ignoreMode) {
            this.options().ignoreMode(ignoreMode);
            return this;
        }

        /**
         * Whether or not the asset needs to exist beyond deployment time;
         * <p>
         * i.e.
         * are copied over to a different location and not needed afterwards.
         * Setting this property to true has an impact on the lifecycle of the asset,
         * because we will assume that it is safe to delete after the CloudFormation
         * deployment succeeds.
         * <p>
         * For example, Lambda Function assets are copied over to Lambda during
         * deployment. Therefore, it is not necessary to store the asset in S3, so
         * we consider those deployTime assets.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param deployTime Whether or not the asset needs to exist beyond deployment time;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployTime(final java.lang.Boolean deployTime) {
            this.options().deployTime(deployTime);
            return this;
        }

        /**
         * A display name for this asset.
         * <p>
         * If supplied, the display name will be used in locations where the asset
         * identifier is printed, like in the CLI progress information. If the same
         * asset is added multiple times, the display name of the first occurrence is
         * used.
         * <p>
         * The default is the construct path of the Asset construct, with respect to
         * the enclosing stack. If the asset is produced by a construct helper
         * function (such as <code>lambda.Code.fromAsset()</code>), this will look like
         * <code>MyFunction/Code</code>.
         * <p>
         * We use the stack-relative construct path so that in the common case where
         * you have multiple stacks with the same asset, we won't show something like
         * <code>/MyBetaStack/MyFunction/Code</code> when you are actually deploying to
         * production.
         * <p>
         * Default: - Stack-relative construct path
         * <p>
         * @return {@code this}
         * @param displayName A display name for this asset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.options().displayName(displayName);
            return this;
        }

        /**
         * A list of principals that should be able to read this asset from S3.
         * <p>
         * You can use <code>asset.grantRead(principal)</code> to grant read permissions later.
         * <p>
         * Default: - No principals that can read file asset.
         * <p>
         * @return {@code this}
         * @param readers A list of principals that should be able to read this asset from S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readers(final java.util.List<? extends software.amazon.awscdk.services.iam.IGrantable> readers) {
            this.options().readers(readers);
            return this;
        }

        /**
         * The ARN of the KMS key used to encrypt the handler code.
         * <p>
         * Default: - the default server-side encryption with Amazon S3 managed keys(SSE-S3) key will be used.
         * <p>
         * @return {@code this}
         * @param sourceKmsKey The ARN of the KMS key used to encrypt the handler code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceKmsKey(final software.amazon.awscdk.services.kms.IKeyRef sourceKmsKey) {
            this.options().sourceKmsKey(sourceKmsKey);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.AssetImportSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.AssetImportSource build() {
            return new software.amazon.awscdk.services.cloudfront.AssetImportSource(
                this.path,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.s3.assets.AssetOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.s3.assets.AssetOptions.Builder();
            }
            return this.options;
        }
    }
}
