package software.amazon.awscdk.services.cloudfront;

/**
 * An origin request policy.
 * <p>
 * When it's attached to a cache behavior, the origin request policy determines the values that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to the origin includes the following:
 * <p>
 * <ul>
 * <li>The request body and the URL path (without the domain name) from the viewer request.</li>
 * <li>The headers that CloudFront automatically includes in every origin request, including <code>Host</code> , <code>User-Agent</code> , and <code>X-Amz-Cf-Id</code> .</li>
 * <li>All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request policy. These can include items from the viewer request and, in the case of headers, additional ones that are added by CloudFront.</li>
 * </ul>
 * <p>
 * CloudFront sends a request when it can't find an object in its cache that matches the request. If you want to send values to the origin and also include them in the cache key, use <code>CachePolicy</code> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * CfnOriginRequestPolicy cfnOriginRequestPolicy = CfnOriginRequestPolicy.Builder.create(this, "MyCfnOriginRequestPolicy")
 *         .originRequestPolicyConfig(OriginRequestPolicyConfigProperty.builder()
 *                 .cookiesConfig(CookiesConfigProperty.builder()
 *                         .cookieBehavior("cookieBehavior")
 *                         // the properties below are optional
 *                         .cookies(List.of("cookies"))
 *                         .build())
 *                 .headersConfig(HeadersConfigProperty.builder()
 *                         .headerBehavior("headerBehavior")
 *                         // the properties below are optional
 *                         .headers(List.of("headers"))
 *                         .build())
 *                 .name("name")
 *                 .queryStringsConfig(QueryStringsConfigProperty.builder()
 *                         .queryStringBehavior("queryStringBehavior")
 *                         // the properties below are optional
 *                         .queryStrings(List.of("queryStrings"))
 *                         .build())
 *                 // the properties below are optional
 *                 .comment("comment")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:00.134Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnOriginRequestPolicy")
public class CfnOriginRequestPolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.cloudfront.IOriginRequestPolicyRef {

    protected CfnOriginRequestPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnOriginRequestPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnOriginRequestPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The unique identifier for the origin request policy.
     * <p>
     * For example: <code>befd7079-9bbc-4ebf-8ade-498a3694176c</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time when the origin request policy was last modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModifiedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a OriginRequestPolicy resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.OriginRequestPolicyReference getOriginRequestPolicyRef() {
        return software.amazon.jsii.Kernel.get(this, "originRequestPolicyRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginRequestPolicyReference.class));
    }

    /**
     * The origin request policy configuration.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicy.OriginRequestPolicyConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getOriginRequestPolicyConfig() {
        return software.amazon.jsii.Kernel.get(this, "originRequestPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The origin request policy configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOriginRequestPolicyConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "originRequestPolicyConfig", java.util.Objects.requireNonNull(value, "originRequestPolicyConfig is required"));
    }

    /**
     * The origin request policy configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOriginRequestPolicyConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicy.OriginRequestPolicyConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "originRequestPolicyConfig", java.util.Objects.requireNonNull(value, "originRequestPolicyConfig is required"));
    }
    /**
     * An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in requests that CloudFront sends to the origin.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * CookiesConfigProperty cookiesConfigProperty = CookiesConfigProperty.builder()
     *         .cookieBehavior("cookieBehavior")
     *         // the properties below are optional
     *         .cookies(List.of("cookies"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-cookiesconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-cookiesconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnOriginRequestPolicy.CookiesConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CookiesConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CookiesConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether cookies in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:.
         * <p>
         * <ul>
         * <li><code>none</code> – No cookies in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code> , any cookies that are listed in a <code>CachePolicy</code> <em>are</em> included in origin requests.</li>
         * <li><code>whitelist</code> – Only the cookies in viewer requests that are listed in the <code>CookieNames</code> type are included in requests that CloudFront sends to the origin.</li>
         * <li><code>all</code> – All cookies in viewer requests are included in requests that CloudFront sends to the origin.</li>
         * <li><code>allExcept</code> – All cookies in viewer requests are included in requests that CloudFront sends to the origin, <strong>except</strong> for those listed in the <code>CookieNames</code> type, which are not included.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-cookiesconfig.html#cfn-cloudfront-originrequestpolicy-cookiesconfig-cookiebehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-cookiesconfig.html#cfn-cloudfront-originrequestpolicy-cookiesconfig-cookiebehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCookieBehavior();

        /**
         * Contains a list of cookie names.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-cookiesconfig.html#cfn-cloudfront-originrequestpolicy-cookiesconfig-cookies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-cookiesconfig.html#cfn-cloudfront-originrequestpolicy-cookiesconfig-cookies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCookies() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CookiesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CookiesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CookiesConfigProperty> {
            java.lang.String cookieBehavior;
            java.util.List<java.lang.String> cookies;

            /**
             * Sets the value of {@link CookiesConfigProperty#getCookieBehavior}
             * @param cookieBehavior Determines whether cookies in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:. This parameter is required.
             *                       <ul>
             *                       <li><code>none</code> – No cookies in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code> , any cookies that are listed in a <code>CachePolicy</code> <em>are</em> included in origin requests.</li>
             *                       <li><code>whitelist</code> – Only the cookies in viewer requests that are listed in the <code>CookieNames</code> type are included in requests that CloudFront sends to the origin.</li>
             *                       <li><code>all</code> – All cookies in viewer requests are included in requests that CloudFront sends to the origin.</li>
             *                       <li><code>allExcept</code> – All cookies in viewer requests are included in requests that CloudFront sends to the origin, <strong>except</strong> for those listed in the <code>CookieNames</code> type, which are not included.</li>
             *                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookieBehavior(java.lang.String cookieBehavior) {
                this.cookieBehavior = cookieBehavior;
                return this;
            }

            /**
             * Sets the value of {@link CookiesConfigProperty#getCookies}
             * @param cookies Contains a list of cookie names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookies(java.util.List<java.lang.String> cookies) {
                this.cookies = cookies;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CookiesConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CookiesConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CookiesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CookiesConfigProperty {
            private final java.lang.String cookieBehavior;
            private final java.util.List<java.lang.String> cookies;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cookieBehavior = software.amazon.jsii.Kernel.get(this, "cookieBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cookies = software.amazon.jsii.Kernel.get(this, "cookies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cookieBehavior = java.util.Objects.requireNonNull(builder.cookieBehavior, "cookieBehavior is required");
                this.cookies = builder.cookies;
            }

            @Override
            public final java.lang.String getCookieBehavior() {
                return this.cookieBehavior;
            }

            @Override
            public final java.util.List<java.lang.String> getCookies() {
                return this.cookies;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cookieBehavior", om.valueToTree(this.getCookieBehavior()));
                if (this.getCookies() != null) {
                    data.set("cookies", om.valueToTree(this.getCookies()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnOriginRequestPolicy.CookiesConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CookiesConfigProperty.Jsii$Proxy that = (CookiesConfigProperty.Jsii$Proxy) o;

                if (!cookieBehavior.equals(that.cookieBehavior)) return false;
                return this.cookies != null ? this.cookies.equals(that.cookies) : that.cookies == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cookieBehavior.hashCode();
                result = 31 * result + (this.cookies != null ? this.cookies.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that determines whether any HTTP headers (and if so, which headers) are included in requests that CloudFront sends to the origin.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * HeadersConfigProperty headersConfigProperty = HeadersConfigProperty.builder()
     *         .headerBehavior("headerBehavior")
     *         // the properties below are optional
     *         .headers(List.of("headers"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-headersconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-headersconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnOriginRequestPolicy.HeadersConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(HeadersConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HeadersConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether any HTTP headers are included in requests that CloudFront sends to the origin. Valid values are:.
         * <p>
         * <ul>
         * <li><code>none</code> – No HTTP headers in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code> , any headers that are listed in a <code>CachePolicy</code> <em>are</em> included in origin requests.</li>
         * <li><code>whitelist</code> – Only the HTTP headers that are listed in the <code>Headers</code> type are included in requests that CloudFront sends to the origin.</li>
         * <li><code>allViewer</code> – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin.</li>
         * <li><code>allViewerAndWhitelistCloudFront</code> – All HTTP headers in viewer requests and the additional CloudFront headers that are listed in the <code>Headers</code> type are included in requests that CloudFront sends to the origin. The additional headers are added by CloudFront.</li>
         * <li><code>allExcept</code> – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin, <strong>except</strong> for those listed in the <code>Headers</code> type, which are not included.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-headersconfig.html#cfn-cloudfront-originrequestpolicy-headersconfig-headerbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-headersconfig.html#cfn-cloudfront-originrequestpolicy-headersconfig-headerbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeaderBehavior();

        /**
         * Contains a list of HTTP header names.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-headersconfig.html#cfn-cloudfront-originrequestpolicy-headersconfig-headers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-headersconfig.html#cfn-cloudfront-originrequestpolicy-headersconfig-headers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHeaders() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HeadersConfigProperty> {
            java.lang.String headerBehavior;
            java.util.List<java.lang.String> headers;

            /**
             * Sets the value of {@link HeadersConfigProperty#getHeaderBehavior}
             * @param headerBehavior Determines whether any HTTP headers are included in requests that CloudFront sends to the origin. Valid values are:. This parameter is required.
             *                       <ul>
             *                       <li><code>none</code> – No HTTP headers in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code> , any headers that are listed in a <code>CachePolicy</code> <em>are</em> included in origin requests.</li>
             *                       <li><code>whitelist</code> – Only the HTTP headers that are listed in the <code>Headers</code> type are included in requests that CloudFront sends to the origin.</li>
             *                       <li><code>allViewer</code> – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin.</li>
             *                       <li><code>allViewerAndWhitelistCloudFront</code> – All HTTP headers in viewer requests and the additional CloudFront headers that are listed in the <code>Headers</code> type are included in requests that CloudFront sends to the origin. The additional headers are added by CloudFront.</li>
             *                       <li><code>allExcept</code> – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin, <strong>except</strong> for those listed in the <code>Headers</code> type, which are not included.</li>
             *                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerBehavior(java.lang.String headerBehavior) {
                this.headerBehavior = headerBehavior;
                return this;
            }

            /**
             * Sets the value of {@link HeadersConfigProperty#getHeaders}
             * @param headers Contains a list of HTTP header names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(java.util.List<java.lang.String> headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HeadersConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HeadersConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HeadersConfigProperty {
            private final java.lang.String headerBehavior;
            private final java.util.List<java.lang.String> headers;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.headerBehavior = software.amazon.jsii.Kernel.get(this, "headerBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.headerBehavior = java.util.Objects.requireNonNull(builder.headerBehavior, "headerBehavior is required");
                this.headers = builder.headers;
            }

            @Override
            public final java.lang.String getHeaderBehavior() {
                return this.headerBehavior;
            }

            @Override
            public final java.util.List<java.lang.String> getHeaders() {
                return this.headers;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("headerBehavior", om.valueToTree(this.getHeaderBehavior()));
                if (this.getHeaders() != null) {
                    data.set("headers", om.valueToTree(this.getHeaders()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnOriginRequestPolicy.HeadersConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HeadersConfigProperty.Jsii$Proxy that = (HeadersConfigProperty.Jsii$Proxy) o;

                if (!headerBehavior.equals(that.headerBehavior)) return false;
                return this.headers != null ? this.headers.equals(that.headers) : that.headers == null;
            }

            @Override
            public final int hashCode() {
                int result = this.headerBehavior.hashCode();
                result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An origin request policy configuration.
     * <p>
     * This configuration determines the values that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to the origin includes the following:
     * <p>
     * <ul>
     * <li>The request body and the URL path (without the domain name) from the viewer request.</li>
     * <li>The headers that CloudFront automatically includes in every origin request, including <code>Host</code> , <code>User-Agent</code> , and <code>X-Amz-Cf-Id</code> .</li>
     * <li>All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request policy. These can include items from the viewer request and, in the case of headers, additional ones that are added by CloudFront.</li>
     * </ul>
     * <p>
     * CloudFront sends a request when it can't find an object in its cache that matches the request. If you want to send values to the origin and also include them in the cache key, use <code>CachePolicy</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * OriginRequestPolicyConfigProperty originRequestPolicyConfigProperty = OriginRequestPolicyConfigProperty.builder()
     *         .cookiesConfig(CookiesConfigProperty.builder()
     *                 .cookieBehavior("cookieBehavior")
     *                 // the properties below are optional
     *                 .cookies(List.of("cookies"))
     *                 .build())
     *         .headersConfig(HeadersConfigProperty.builder()
     *                 .headerBehavior("headerBehavior")
     *                 // the properties below are optional
     *                 .headers(List.of("headers"))
     *                 .build())
     *         .name("name")
     *         .queryStringsConfig(QueryStringsConfigProperty.builder()
     *                 .queryStringBehavior("queryStringBehavior")
     *                 // the properties below are optional
     *                 .queryStrings(List.of("queryStrings"))
     *                 .build())
     *         // the properties below are optional
     *         .comment("comment")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnOriginRequestPolicy.OriginRequestPolicyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginRequestPolicyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginRequestPolicyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The cookies from viewer requests to include in origin requests.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicy.CookiesConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig-cookiesconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig-cookiesconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCookiesConfig();

        /**
         * The HTTP headers to include in origin requests.
         * <p>
         * These can include headers from viewer requests and additional headers added by CloudFront.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicy.HeadersConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig-headersconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig-headersconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getHeadersConfig();

        /**
         * A unique name to identify the origin request policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The URL query strings from viewer requests to include in origin requests.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicy.QueryStringsConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig-querystringsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig-querystringsconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getQueryStringsConfig();

        /**
         * A comment to describe the origin request policy.
         * <p>
         * The comment cannot be longer than 128 characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig-comment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig-comment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OriginRequestPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginRequestPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginRequestPolicyConfigProperty> {
            java.lang.Object cookiesConfig;
            java.lang.Object headersConfig;
            java.lang.String name;
            java.lang.Object queryStringsConfig;
            java.lang.String comment;

            /**
             * Sets the value of {@link OriginRequestPolicyConfigProperty#getCookiesConfig}
             * @param cookiesConfig The cookies from viewer requests to include in origin requests. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookiesConfig(software.amazon.awscdk.IResolvable cookiesConfig) {
                this.cookiesConfig = cookiesConfig;
                return this;
            }

            /**
             * Sets the value of {@link OriginRequestPolicyConfigProperty#getCookiesConfig}
             * @param cookiesConfig The cookies from viewer requests to include in origin requests. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookiesConfig(software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicy.CookiesConfigProperty cookiesConfig) {
                this.cookiesConfig = cookiesConfig;
                return this;
            }

            /**
             * Sets the value of {@link OriginRequestPolicyConfigProperty#getHeadersConfig}
             * @param headersConfig The HTTP headers to include in origin requests. This parameter is required.
             *                      These can include headers from viewer requests and additional headers added by CloudFront.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headersConfig(software.amazon.awscdk.IResolvable headersConfig) {
                this.headersConfig = headersConfig;
                return this;
            }

            /**
             * Sets the value of {@link OriginRequestPolicyConfigProperty#getHeadersConfig}
             * @param headersConfig The HTTP headers to include in origin requests. This parameter is required.
             *                      These can include headers from viewer requests and additional headers added by CloudFront.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headersConfig(software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicy.HeadersConfigProperty headersConfig) {
                this.headersConfig = headersConfig;
                return this;
            }

            /**
             * Sets the value of {@link OriginRequestPolicyConfigProperty#getName}
             * @param name A unique name to identify the origin request policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link OriginRequestPolicyConfigProperty#getQueryStringsConfig}
             * @param queryStringsConfig The URL query strings from viewer requests to include in origin requests. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringsConfig(software.amazon.awscdk.IResolvable queryStringsConfig) {
                this.queryStringsConfig = queryStringsConfig;
                return this;
            }

            /**
             * Sets the value of {@link OriginRequestPolicyConfigProperty#getQueryStringsConfig}
             * @param queryStringsConfig The URL query strings from viewer requests to include in origin requests. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringsConfig(software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicy.QueryStringsConfigProperty queryStringsConfig) {
                this.queryStringsConfig = queryStringsConfig;
                return this;
            }

            /**
             * Sets the value of {@link OriginRequestPolicyConfigProperty#getComment}
             * @param comment A comment to describe the origin request policy.
             *                The comment cannot be longer than 128 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comment(java.lang.String comment) {
                this.comment = comment;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginRequestPolicyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginRequestPolicyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OriginRequestPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginRequestPolicyConfigProperty {
            private final java.lang.Object cookiesConfig;
            private final java.lang.Object headersConfig;
            private final java.lang.String name;
            private final java.lang.Object queryStringsConfig;
            private final java.lang.String comment;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cookiesConfig = software.amazon.jsii.Kernel.get(this, "cookiesConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.headersConfig = software.amazon.jsii.Kernel.get(this, "headersConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queryStringsConfig = software.amazon.jsii.Kernel.get(this, "queryStringsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cookiesConfig = java.util.Objects.requireNonNull(builder.cookiesConfig, "cookiesConfig is required");
                this.headersConfig = java.util.Objects.requireNonNull(builder.headersConfig, "headersConfig is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.queryStringsConfig = java.util.Objects.requireNonNull(builder.queryStringsConfig, "queryStringsConfig is required");
                this.comment = builder.comment;
            }

            @Override
            public final java.lang.Object getCookiesConfig() {
                return this.cookiesConfig;
            }

            @Override
            public final java.lang.Object getHeadersConfig() {
                return this.headersConfig;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getQueryStringsConfig() {
                return this.queryStringsConfig;
            }

            @Override
            public final java.lang.String getComment() {
                return this.comment;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cookiesConfig", om.valueToTree(this.getCookiesConfig()));
                data.set("headersConfig", om.valueToTree(this.getHeadersConfig()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("queryStringsConfig", om.valueToTree(this.getQueryStringsConfig()));
                if (this.getComment() != null) {
                    data.set("comment", om.valueToTree(this.getComment()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnOriginRequestPolicy.OriginRequestPolicyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginRequestPolicyConfigProperty.Jsii$Proxy that = (OriginRequestPolicyConfigProperty.Jsii$Proxy) o;

                if (!cookiesConfig.equals(that.cookiesConfig)) return false;
                if (!headersConfig.equals(that.headersConfig)) return false;
                if (!name.equals(that.name)) return false;
                if (!queryStringsConfig.equals(that.queryStringsConfig)) return false;
                return this.comment != null ? this.comment.equals(that.comment) : that.comment == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cookiesConfig.hashCode();
                result = 31 * result + (this.headersConfig.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.queryStringsConfig.hashCode());
                result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in requests that CloudFront sends to the origin.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * QueryStringsConfigProperty queryStringsConfigProperty = QueryStringsConfigProperty.builder()
     *         .queryStringBehavior("queryStringBehavior")
     *         // the properties below are optional
     *         .queryStrings(List.of("queryStrings"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-querystringsconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-querystringsconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnOriginRequestPolicy.QueryStringsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(QueryStringsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryStringsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether any URL query strings in viewer requests are included in requests that CloudFront sends to the origin.
         * <p>
         * Valid values are:
         * <p>
         * <ul>
         * <li><code>none</code> – No query strings in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code> , any query strings that are listed in a <code>CachePolicy</code> <em>are</em> included in origin requests.</li>
         * <li><code>whitelist</code> – Only the query strings in viewer requests that are listed in the <code>QueryStringNames</code> type are included in requests that CloudFront sends to the origin.</li>
         * <li><code>all</code> – All query strings in viewer requests are included in requests that CloudFront sends to the origin.</li>
         * <li><code>allExcept</code> – All query strings in viewer requests are included in requests that CloudFront sends to the origin, <strong>except</strong> for those listed in the <code>QueryStringNames</code> type, which are not included.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-querystringsconfig.html#cfn-cloudfront-originrequestpolicy-querystringsconfig-querystringbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-querystringsconfig.html#cfn-cloudfront-originrequestpolicy-querystringsconfig-querystringbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueryStringBehavior();

        /**
         * Contains a list of query string names.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-querystringsconfig.html#cfn-cloudfront-originrequestpolicy-querystringsconfig-querystrings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-querystringsconfig.html#cfn-cloudfront-originrequestpolicy-querystringsconfig-querystrings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getQueryStrings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link QueryStringsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryStringsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueryStringsConfigProperty> {
            java.lang.String queryStringBehavior;
            java.util.List<java.lang.String> queryStrings;

            /**
             * Sets the value of {@link QueryStringsConfigProperty#getQueryStringBehavior}
             * @param queryStringBehavior Determines whether any URL query strings in viewer requests are included in requests that CloudFront sends to the origin. This parameter is required.
             *                            Valid values are:
             *                            <p>
             *                            <ul>
             *                            <li><code>none</code> – No query strings in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code> , any query strings that are listed in a <code>CachePolicy</code> <em>are</em> included in origin requests.</li>
             *                            <li><code>whitelist</code> – Only the query strings in viewer requests that are listed in the <code>QueryStringNames</code> type are included in requests that CloudFront sends to the origin.</li>
             *                            <li><code>all</code> – All query strings in viewer requests are included in requests that CloudFront sends to the origin.</li>
             *                            <li><code>allExcept</code> – All query strings in viewer requests are included in requests that CloudFront sends to the origin, <strong>except</strong> for those listed in the <code>QueryStringNames</code> type, which are not included.</li>
             *                            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringBehavior(java.lang.String queryStringBehavior) {
                this.queryStringBehavior = queryStringBehavior;
                return this;
            }

            /**
             * Sets the value of {@link QueryStringsConfigProperty#getQueryStrings}
             * @param queryStrings Contains a list of query string names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStrings(java.util.List<java.lang.String> queryStrings) {
                this.queryStrings = queryStrings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryStringsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueryStringsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueryStringsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryStringsConfigProperty {
            private final java.lang.String queryStringBehavior;
            private final java.util.List<java.lang.String> queryStrings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queryStringBehavior = software.amazon.jsii.Kernel.get(this, "queryStringBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queryStrings = software.amazon.jsii.Kernel.get(this, "queryStrings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queryStringBehavior = java.util.Objects.requireNonNull(builder.queryStringBehavior, "queryStringBehavior is required");
                this.queryStrings = builder.queryStrings;
            }

            @Override
            public final java.lang.String getQueryStringBehavior() {
                return this.queryStringBehavior;
            }

            @Override
            public final java.util.List<java.lang.String> getQueryStrings() {
                return this.queryStrings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queryStringBehavior", om.valueToTree(this.getQueryStringBehavior()));
                if (this.getQueryStrings() != null) {
                    data.set("queryStrings", om.valueToTree(this.getQueryStrings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnOriginRequestPolicy.QueryStringsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryStringsConfigProperty.Jsii$Proxy that = (QueryStringsConfigProperty.Jsii$Proxy) o;

                if (!queryStringBehavior.equals(that.queryStringBehavior)) return false;
                return this.queryStrings != null ? this.queryStrings.equals(that.queryStrings) : that.queryStrings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.queryStringBehavior.hashCode();
                result = 31 * result + (this.queryStrings != null ? this.queryStrings.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicyProps.Builder();
        }

        /**
         * The origin request policy configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig</a>
         * @param originRequestPolicyConfig The origin request policy configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originRequestPolicyConfig(final software.amazon.awscdk.IResolvable originRequestPolicyConfig) {
            this.props.originRequestPolicyConfig(originRequestPolicyConfig);
            return this;
        }
        /**
         * The origin request policy configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig</a>
         * @param originRequestPolicyConfig The origin request policy configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originRequestPolicyConfig(final software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicy.OriginRequestPolicyConfigProperty originRequestPolicyConfig) {
            this.props.originRequestPolicyConfig(originRequestPolicyConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicy build() {
            return new software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
