package software.amazon.awscdk.services.cloudwatch;

/**
 * A reference to a MetricStream resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudwatch.*;
 * MetricStreamReference metricStreamReference = MetricStreamReference.builder()
 *         .metricStreamArn("metricStreamArn")
 *         .metricStreamName("metricStreamName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:00.499Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.MetricStreamReference")
@software.amazon.jsii.Jsii.Proxy(MetricStreamReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MetricStreamReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the MetricStream resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMetricStreamArn();

    /**
     * The Name of the MetricStream resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMetricStreamName();

    /**
     * @return a {@link Builder} of {@link MetricStreamReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MetricStreamReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MetricStreamReference> {
        java.lang.String metricStreamArn;
        java.lang.String metricStreamName;

        /**
         * Sets the value of {@link MetricStreamReference#getMetricStreamArn}
         * @param metricStreamArn The ARN of the MetricStream resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricStreamArn(java.lang.String metricStreamArn) {
            this.metricStreamArn = metricStreamArn;
            return this;
        }

        /**
         * Sets the value of {@link MetricStreamReference#getMetricStreamName}
         * @param metricStreamName The Name of the MetricStream resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricStreamName(java.lang.String metricStreamName) {
            this.metricStreamName = metricStreamName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MetricStreamReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MetricStreamReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MetricStreamReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricStreamReference {
        private final java.lang.String metricStreamArn;
        private final java.lang.String metricStreamName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.metricStreamArn = software.amazon.jsii.Kernel.get(this, "metricStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metricStreamName = software.amazon.jsii.Kernel.get(this, "metricStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.metricStreamArn = java.util.Objects.requireNonNull(builder.metricStreamArn, "metricStreamArn is required");
            this.metricStreamName = java.util.Objects.requireNonNull(builder.metricStreamName, "metricStreamName is required");
        }

        @Override
        public final java.lang.String getMetricStreamArn() {
            return this.metricStreamArn;
        }

        @Override
        public final java.lang.String getMetricStreamName() {
            return this.metricStreamName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("metricStreamArn", om.valueToTree(this.getMetricStreamArn()));
            data.set("metricStreamName", om.valueToTree(this.getMetricStreamName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.MetricStreamReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MetricStreamReference.Jsii$Proxy that = (MetricStreamReference.Jsii$Proxy) o;

            if (!metricStreamArn.equals(that.metricStreamArn)) return false;
            return this.metricStreamName.equals(that.metricStreamName);
        }

        @Override
        public final int hashCode() {
            int result = this.metricStreamArn.hashCode();
            result = 31 * result + (this.metricStreamName.hashCode());
            return result;
        }
    }
}
