package software.amazon.awscdk.services.cloudwatch;

/**
 * A CloudWatch search expression for dynamically finding and graphing multiple related metrics.
 * <p>
 * Search expressions allow you to search for and graph multiple related metrics from a single expression.
 * This is particularly useful in dynamic environments where the exact metric names or dimensions
 * may not be known at deployment time.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SearchExpression searchExpression = SearchExpression.Builder.create()
 *         .expression("SEARCH('{AWS/EC2,InstanceId} CPUUtilization', 'Average', 300)")
 *         .label("EC2 CPU Utilization")
 *         .period(Duration.minutes(5))
 *         .build();
 * </pre></blockquote>
 * <p>
 * This class does not represent a resource, so hence is not a construct. Instead,
 * SearchExpression is an abstraction that makes it easy to specify metrics for use in graphs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SearchExpression cpuUtilization = SearchExpression.Builder.create()
 *         .expression("SEARCH('{AWS/EC2,InstanceId} MetricName=\"CPUUtilization\"', 'Average', 900)")
 *         .label("EC2 CPU Utilization")
 *         .color("#ff7f0e")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:00.501Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.SearchExpression")
public class SearchExpression extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.IMetric {

    protected SearchExpression(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SearchExpression(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SearchExpression(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.SearchExpressionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Inspect the details of the metric object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.MetricConfig toMetricConfig() {
        return software.amazon.jsii.Kernel.call(this, "toMetricConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.MetricConfig.class));
    }

    /**
     * Returns a string representation of an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return a copy of SearchExpression with properties changed.
     * <p>
     * All properties except expression can be changed.
     * <p>
     * @param props The set of properties to change. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.SearchExpression with(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.SearchExpressionOptions props) {
        return software.amazon.jsii.Kernel.call(this, "with", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.SearchExpression.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The search expression defining the metrics to be retrieved.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getExpression() {
        return software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The aggregation period for the metrics produced by the Search Expression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getPeriod() {
        return software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }

    /**
     * Hex color code (e.g. '#00ff00'), to use when rendering the resulting metrics in a graph. If multiple time series are returned, color is assigned to the first metric, color for the other metrics is automatically assigned.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getColor() {
        return software.amazon.jsii.Kernel.get(this, "color", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The label is used as a prefix for the title of each metric returned by the search expression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
        return software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Account to evaluate search expressions within.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSearchAccount() {
        return software.amazon.jsii.Kernel.get(this, "searchAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Region to evaluate search expressions within.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSearchRegion() {
        return software.amazon.jsii.Kernel.get(this, "searchRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) Warnings generated by this search expression.
     * <p>
     * @deprecated <ul>
     * <li>use warningsV2</li>
     * </ul>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getWarnings() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "warnings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Warnings generated by this search expression.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getWarningsV2() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "warningsV2", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.SearchExpression}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.SearchExpression> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.cloudwatch.SearchExpressionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.cloudwatch.SearchExpressionProps.Builder();
        }

        /**
         * Color for the metric produced by the search expression.
         * <p>
         * If the search expression produces more than one time series, the color is assigned to the first one.
         * Other metrics are assigned colors automatically.
         * <p>
         * Default: - Automatically assigned.
         * <p>
         * @return {@code this}
         * @param color Color for the metric produced by the search expression. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder color(final java.lang.String color) {
            this.props.color(color);
            return this;
        }

        /**
         * Label for this search expression when added to a Graph in a Dashboard.
         * <p>
         * If this expression evaluates to more than one time series,
         * each time series will appear in the graph using a combination of the
         * expression label and the individual metric label. Specify the empty
         * string (<code>''</code>) to suppress the expression label and only keep the
         * metric label.
         * <p>
         * You can use <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">dynamic labels</a>
         * to show summary information about the displayed time series
         * in the legend. For example, if you use:
         * <p>
         * <blockquote><pre>
         * [max: ${MAX}] MyMetric
         * </pre></blockquote>
         * <p>
         * As the metric label, the maximum value in the visible range will
         * be shown next to the time series name in the graph's legend. If the
         * search expression produces more than one time series, the maximum
         * will be shown for each individual time series produce by this
         * search expression.
         * <p>
         * Default: - No label.
         * <p>
         * @return {@code this}
         * @param label Label for this search expression when added to a Graph in a Dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder label(final java.lang.String label) {
            this.props.label(label);
            return this;
        }

        /**
         * The period over which the search expression's statistics are applied.
         * <p>
         * This period overrides the period defined within the search expression.
         * <p>
         * Default: Duration.minutes(5)
         * <p>
         * @return {@code this}
         * @param period The period over which the search expression's statistics are applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(final software.amazon.awscdk.Duration period) {
            this.props.period(period);
            return this;
        }

        /**
         * Account to evaluate search expressions within.
         * <p>
         * Default: - Deployment account.
         * <p>
         * @return {@code this}
         * @param searchAccount Account to evaluate search expressions within. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder searchAccount(final java.lang.String searchAccount) {
            this.props.searchAccount(searchAccount);
            return this;
        }

        /**
         * Region to evaluate search expressions within.
         * <p>
         * Default: - Deployment region.
         * <p>
         * @return {@code this}
         * @param searchRegion Region to evaluate search expressions within. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder searchRegion(final java.lang.String searchRegion) {
            this.props.searchRegion(searchRegion);
            return this;
        }

        /**
         * The search expression defining the metrics to be retrieved.
         * <p>
         * A search expression cannot be used within an Alarm.
         * <p>
         * A search expression allows you to retrieve and graph multiple related metrics in a single statement.
         * It can return up to 500 time series.
         * <p>
         * Examples:
         * <p>
         * <ul>
         * <li><code>SEARCH('{AWS/EC2,InstanceId} CPUUtilization', 'Average', 300)</code></li>
         * <li><code>SEARCH('{AWS/ApplicationELB,LoadBalancer} RequestCount', 'Sum', 60)</code></li>
         * <li><code>SEARCH('{MyNamespace,ServiceName} Errors', 'Sum')</code></li>
         * </ul>
         * <p>
         * For more information about search expression syntax, see:
         * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/search-expression-syntax.html
         * <p>
         * @return {@code this}
         * @param expression The search expression defining the metrics to be retrieved. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expression(final java.lang.String expression) {
            this.props.expression(expression);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.SearchExpression}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudwatch.SearchExpression build() {
            return new software.amazon.awscdk.services.cloudwatch.SearchExpression(
                this.props.build()
            );
        }
    }
}
