package software.amazon.awscdk.services.codebuild;

/**
 * The types of webhook event actions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ISource gitHubSource = Source.gitHub(GitHubSourceProps.builder()
 *         .owner("awslabs")
 *         .repo("aws-cdk") // optional, default: undefined if unspecified will create organization webhook
 *         .webhook(true) // optional, default: true if `webhookFilters` were provided, false otherwise
 *         .webhookTriggersBatchBuild(true) // optional, default is false
 *         .webhookFilters(List.of(FilterGroup.inEventOf(EventAction.PUSH).andBranchIs("main").andCommitMessageIs("the commit message"), FilterGroup.inEventOf(EventAction.RELEASED).andBranchIs("main")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:00.630Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.EventAction")
public enum EventAction {
    /**
     * A push (of a branch, or a tag) to the repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUSH,
    /**
     * Creating a Pull Request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PULL_REQUEST_CREATED,
    /**
     * Updating a Pull Request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PULL_REQUEST_UPDATED,
    /**
     * Closing a Pull Request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PULL_REQUEST_CLOSED,
    /**
     * Merging a Pull Request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PULL_REQUEST_MERGED,
    /**
     * Re-opening a previously closed Pull Request.
     * <p>
     * Note that this event is only supported for GitHub and GitHubEnterprise sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PULL_REQUEST_REOPENED,
    /**
     * A release is created in the repository.
     * <p>
     * Works with GitHub only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RELEASED,
    /**
     * A prerelease is created in the repository.
     * <p>
     * Works with GitHub only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PRERELEASED,
    /**
     * A workflow job is queued in the repository.
     * <p>
     * Works with GitHub only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WORKFLOW_JOB_QUEUED,
}
