package software.amazon.awscdk.services.codebuild;

/**
 * Fleet for a reserved capacity CodeBuild project.
 * <p>
 * Fleets allow for process builds or tests to run immediately and reduces build durations,
 * by reserving compute resources for your projects.
 * <p>
 * You will be charged for the resources in the fleet, even if they are idle.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Fleet fleet = Fleet.Builder.create(this, "Fleet")
 *         .computeType(FleetComputeType.MEDIUM)
 *         .environmentType(EnvironmentType.LINUX_CONTAINER)
 *         .baseCapacity(1)
 *         .build();
 * Project.Builder.create(this, "Project")
 *         .environment(BuildEnvironment.builder()
 *                 .fleet(fleet)
 *                 .buildImage(LinuxBuildImage.STANDARD_7_0)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/fleets.html">https://docs.aws.amazon.com/codebuild/latest/userguide/fleets.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:00.632Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.Fleet")
public class Fleet extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.codebuild.IFleet {

    protected Fleet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Fleet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.Fleet.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Fleet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a Fleet construct that represents an external fleet.
     * <p>
     * @param scope The scope creating construct (usually <code>this</code>). This parameter is required.
     * @param id The construct's id. This parameter is required.
     * @param fleetArn The ARN of the fleet. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IFleet fromFleetArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String fleetArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Fleet.class, "fromFleetArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IFleet.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(fleetArn, "fleetArn is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The compute type of the fleet.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_codebuild.ComputeType.html">https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_codebuild.ComputeType.html</a>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FleetComputeType getComputeType() {
        return software.amazon.jsii.Kernel.get(this, "computeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FleetComputeType.class));
    }

    /**
     * The network connections associated with this Fleet's security group(s) in the configured VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * The build environment (operating system/architecture/accelerator) type made available to projects using this fleet.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.EnvironmentType getEnvironmentType() {
        return software.amazon.jsii.Kernel.get(this, "environmentType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.EnvironmentType.class));
    }

    /**
     * The ARN of the fleet.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFleetArn() {
        return software.amazon.jsii.Kernel.get(this, "fleetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the fleet.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFleetName() {
        return software.amazon.jsii.Kernel.get(this, "fleetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The grant principal for this Fleet's service role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codebuild.Fleet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codebuild.Fleet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codebuild.FleetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codebuild.FleetProps.Builder();
        }

        /**
         * The number of machines allocated to the compute ﬂeet. Deﬁnes the number of builds that can run in parallel.
         * <p>
         * Minimum value of 1.
         * <p>
         * @return {@code this}
         * @param baseCapacity The number of machines allocated to the compute ﬂeet. Deﬁnes the number of builds that can run in parallel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseCapacity(final java.lang.Number baseCapacity) {
            this.props.baseCapacity(baseCapacity);
            return this;
        }

        /**
         * The instance type of the compute fleet.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_codebuild.ComputeType.html">https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_codebuild.ComputeType.html</a>
         * @param computeType The instance type of the compute fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeType(final software.amazon.awscdk.services.codebuild.FleetComputeType computeType) {
            this.props.computeType(computeType);
            return this;
        }

        /**
         * The build environment (operating system/architecture/accelerator) type made available to projects using this fleet.
         * <p>
         * @return {@code this}
         * @param environmentType The build environment (operating system/architecture/accelerator) type made available to projects using this fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentType(final software.amazon.awscdk.services.codebuild.EnvironmentType environmentType) {
            this.props.environmentType(environmentType);
            return this;
        }

        /**
         * The compute configuration of the compute fleet.
         * <p>
         * This is only permitted if <code>computeType</code> is set to ATTRIBUTE_BASED or
         * CUSTOM_INSTANCE_TYPE. In such cases, this is required.
         * <p>
         * Default: - do not specify compute configuration
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment-reserved-capacity.types">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment-reserved-capacity.types</a>
         * @param computeConfiguration The compute configuration of the compute fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeConfiguration(final software.amazon.awscdk.services.codebuild.ComputeConfiguration computeConfiguration) {
            this.props.computeConfiguration(computeConfiguration);
            return this;
        }

        /**
         * The name of the Fleet.
         * <p>
         * Default: - CloudFormation generated name
         * <p>
         * @return {@code this}
         * @param fleetName The name of the Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetName(final java.lang.String fleetName) {
            this.props.fleetName(fleetName);
            return this;
        }

        /**
         * The compute fleet overflow behavior.
         * <p>
         * For overflow behavior <code>QUEUE</code>, overflow builds need to wait on the existing fleet instances to become available.
         * <p>
         * For overflow behavior <code>ON_DEMAND</code>, overflow builds run on CodeBuild on-demand.
         * <p>
         * Default: undefined - AWS CodeBuild default behavior is QUEUE
         * <p>
         * @return {@code this}
         * @param overflowBehavior The compute fleet overflow behavior. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overflowBehavior(final software.amazon.awscdk.services.codebuild.FleetOverflowBehavior overflowBehavior) {
            this.props.overflowBehavior(overflowBehavior);
            return this;
        }

        /**
         * Service Role assumed by Fleet instances.
         * <p>
         * This Role is not used by Project builds running on Fleet instances; Project
         * builds assume the <code>role</code> on Project instead.
         * <p>
         * Default: - A role will be created if any permissions are granted
         * <p>
         * @return {@code this}
         * @param role Service Role assumed by Fleet instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * What security groups to associate with the fleet's network interfaces. If none are provided, one will be created automatically.
         * <p>
         * Only used if <code>vpc</code> is supplied.
         * <p>
         * Default: - A security group will be automatically created.
         * <p>
         * @return {@code this}
         * @param securityGroups What security groups to associate with the fleet's network interfaces. If none are provided, one will be created automatically. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * Where to place the network interfaces within the VPC.
         * <p>
         * To access AWS services, your fleet needs to be in one of the following types of subnets:
         * <p>
         * <ol>
         * <li>Subnets with access to the internet (of type PRIVATE_WITH_EGRESS).</li>
         * <li>Private subnets unconnected to the internet, but with <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/use-vpc-endpoints-with-codebuild.html">VPC endpoints</a> for the necessary services.</li>
         * </ol>
         * <p>
         * If you don't specify a subnet selection, the default behavior is to use PRIVATE_WITH_EGRESS subnets first if they exist,
         * then PRIVATE_WITHOUT_EGRESS, and finally PUBLIC subnets. If your VPC doesn't have PRIVATE_WITH_EGRESS subnets but you need
         * AWS service access, add VPC Endpoints to your private subnets.
         * <p>
         * Default: - private subnets if available else public subnets
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/vpc-support.html">https://docs.aws.amazon.com/codebuild/latest/userguide/vpc-support.html</a>
         * @param subnetSelection Where to place the network interfaces within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * VPC network to place fleet instance network interfaces.
         * <p>
         * Specify this if the fleet needs to access resources in a VPC.
         * <p>
         * Default: - No VPC is specified.
         * <p>
         * @return {@code this}
         * @param vpc VPC network to place fleet instance network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codebuild.Fleet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codebuild.Fleet build() {
            return new software.amazon.awscdk.services.codebuild.Fleet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
