package software.amazon.awscdk.services.codedeploy;

/**
 * The configuration for automatically rolling back deployments in a given Deployment Group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.autoscaling.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * ServerApplication application;
 * AutoScalingGroup asg;
 * Alarm alarm;
 * ServerDeploymentGroup deploymentGroup = ServerDeploymentGroup.Builder.create(this, "CodeDeployDeploymentGroup")
 *         .application(application)
 *         .deploymentGroupName("MyDeploymentGroup")
 *         .autoScalingGroups(List.of(asg))
 *         // adds User Data that installs the CodeDeploy agent on your auto-scaling groups hosts
 *         // default: true
 *         .installAgent(true)
 *         // adds EC2 instances matching tags
 *         .ec2InstanceTags(new InstanceTagSet(Map.of(
 *                 // any instance with tags satisfying
 *                 // key1=v1 or key1=v2 or key2 (any value) or value v3 (any key)
 *                 // will match this group
 *                 "key1", List.of("v1", "v2"),
 *                 "key2", List.of(),
 *                 "", List.of("v3"))))
 *         // adds on-premise instances matching tags
 *         .onPremiseInstanceTags(new InstanceTagSet(Map.of(
 *                 "key1", List.of("v1", "v2")), Map.of(
 *                 "key2", List.of("v3"))))
 *         // CloudWatch alarms
 *         .alarms(List.of(alarm))
 *         // whether to ignore failure to fetch the status of alarms from CloudWatch
 *         // default: false
 *         .ignorePollAlarmsFailure(false)
 *         // whether to skip the step of checking CloudWatch alarms during the deployment process
 *         // default: false
 *         .ignoreAlarmConfiguration(false)
 *         // auto-rollback configuration
 *         .autoRollback(AutoRollbackConfig.builder()
 *                 .failedDeployment(true) // default: true
 *                 .stoppedDeployment(true) // default: false
 *                 .deploymentInAlarm(true)
 *                 .build())
 *         // whether the deployment group was configured to have CodeDeploy install a termination hook into an Auto Scaling group
 *         // default: false
 *         .terminationHook(true)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:00.737Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.AutoRollbackConfig")
@software.amazon.jsii.Jsii.Proxy(AutoRollbackConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AutoRollbackConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to automatically roll back a deployment during which one of the configured CloudWatch alarms for this Deployment Group went off.
     * <p>
     * Default: true if you've provided any Alarms with the `alarms` property, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeploymentInAlarm() {
        return null;
    }

    /**
     * Whether to automatically roll back a deployment that fails.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFailedDeployment() {
        return null;
    }

    /**
     * Whether to automatically roll back a deployment that was manually stopped.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getStoppedDeployment() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AutoRollbackConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AutoRollbackConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AutoRollbackConfig> {
        java.lang.Boolean deploymentInAlarm;
        java.lang.Boolean failedDeployment;
        java.lang.Boolean stoppedDeployment;

        /**
         * Sets the value of {@link AutoRollbackConfig#getDeploymentInAlarm}
         * @param deploymentInAlarm Whether to automatically roll back a deployment during which one of the configured CloudWatch alarms for this Deployment Group went off.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentInAlarm(java.lang.Boolean deploymentInAlarm) {
            this.deploymentInAlarm = deploymentInAlarm;
            return this;
        }

        /**
         * Sets the value of {@link AutoRollbackConfig#getFailedDeployment}
         * @param failedDeployment Whether to automatically roll back a deployment that fails.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failedDeployment(java.lang.Boolean failedDeployment) {
            this.failedDeployment = failedDeployment;
            return this;
        }

        /**
         * Sets the value of {@link AutoRollbackConfig#getStoppedDeployment}
         * @param stoppedDeployment Whether to automatically roll back a deployment that was manually stopped.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppedDeployment(java.lang.Boolean stoppedDeployment) {
            this.stoppedDeployment = stoppedDeployment;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AutoRollbackConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AutoRollbackConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AutoRollbackConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoRollbackConfig {
        private final java.lang.Boolean deploymentInAlarm;
        private final java.lang.Boolean failedDeployment;
        private final java.lang.Boolean stoppedDeployment;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deploymentInAlarm = software.amazon.jsii.Kernel.get(this, "deploymentInAlarm", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.failedDeployment = software.amazon.jsii.Kernel.get(this, "failedDeployment", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.stoppedDeployment = software.amazon.jsii.Kernel.get(this, "stoppedDeployment", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deploymentInAlarm = builder.deploymentInAlarm;
            this.failedDeployment = builder.failedDeployment;
            this.stoppedDeployment = builder.stoppedDeployment;
        }

        @Override
        public final java.lang.Boolean getDeploymentInAlarm() {
            return this.deploymentInAlarm;
        }

        @Override
        public final java.lang.Boolean getFailedDeployment() {
            return this.failedDeployment;
        }

        @Override
        public final java.lang.Boolean getStoppedDeployment() {
            return this.stoppedDeployment;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDeploymentInAlarm() != null) {
                data.set("deploymentInAlarm", om.valueToTree(this.getDeploymentInAlarm()));
            }
            if (this.getFailedDeployment() != null) {
                data.set("failedDeployment", om.valueToTree(this.getFailedDeployment()));
            }
            if (this.getStoppedDeployment() != null) {
                data.set("stoppedDeployment", om.valueToTree(this.getStoppedDeployment()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codedeploy.AutoRollbackConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AutoRollbackConfig.Jsii$Proxy that = (AutoRollbackConfig.Jsii$Proxy) o;

            if (this.deploymentInAlarm != null ? !this.deploymentInAlarm.equals(that.deploymentInAlarm) : that.deploymentInAlarm != null) return false;
            if (this.failedDeployment != null ? !this.failedDeployment.equals(that.failedDeployment) : that.failedDeployment != null) return false;
            return this.stoppedDeployment != null ? this.stoppedDeployment.equals(that.stoppedDeployment) : that.stoppedDeployment == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deploymentInAlarm != null ? this.deploymentInAlarm.hashCode() : 0;
            result = 31 * result + (this.failedDeployment != null ? this.failedDeployment.hashCode() : 0);
            result = 31 * result + (this.stoppedDeployment != null ? this.stoppedDeployment.hashCode() : 0);
            return result;
        }
    }
}
