package software.amazon.awscdk.services.codedeploy;

/**
 * A reference to a DeploymentGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codedeploy.*;
 * DeploymentGroupReference deploymentGroupReference = DeploymentGroupReference.builder()
 *         .deploymentGroupId("deploymentGroupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:00.784Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.DeploymentGroupReference")
@software.amazon.jsii.Jsii.Proxy(DeploymentGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeploymentGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the DeploymentGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeploymentGroupId();

    /**
     * @return a {@link Builder} of {@link DeploymentGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeploymentGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeploymentGroupReference> {
        java.lang.String deploymentGroupId;

        /**
         * Sets the value of {@link DeploymentGroupReference#getDeploymentGroupId}
         * @param deploymentGroupId The Id of the DeploymentGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentGroupId(java.lang.String deploymentGroupId) {
            this.deploymentGroupId = deploymentGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeploymentGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeploymentGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeploymentGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentGroupReference {
        private final java.lang.String deploymentGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deploymentGroupId = software.amazon.jsii.Kernel.get(this, "deploymentGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deploymentGroupId = java.util.Objects.requireNonNull(builder.deploymentGroupId, "deploymentGroupId is required");
        }

        @Override
        public final java.lang.String getDeploymentGroupId() {
            return this.deploymentGroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deploymentGroupId", om.valueToTree(this.getDeploymentGroupId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codedeploy.DeploymentGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeploymentGroupReference.Jsii$Proxy that = (DeploymentGroupReference.Jsii$Proxy) o;

            return this.deploymentGroupId.equals(that.deploymentGroupId);
        }

        @Override
        public final int hashCode() {
            int result = this.deploymentGroupId.hashCode();
            return result;
        }
    }
}
