package software.amazon.awscdk.services.codepipeline;

/**
 * Provider type for trigger.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodeStarConnectionsSourceAction sourceAction;
 * CodeBuildAction buildAction;
 * Pipeline.Builder.create(this, "Pipeline")
 *         .pipelineType(PipelineType.V2)
 *         .stages(List.of(StageProps.builder()
 *                 .stageName("Source")
 *                 .actions(List.of(sourceAction))
 *                 .build(), StageProps.builder()
 *                 .stageName("Build")
 *                 .actions(List.of(buildAction))
 *                 .build()))
 *         .triggers(List.of(TriggerProps.builder()
 *                 .providerType(ProviderType.CODE_STAR_SOURCE_CONNECTION)
 *                 .gitConfiguration(GitConfiguration.builder()
 *                         .sourceAction(sourceAction)
 *                         .pushFilter(List.of(GitPushFilter.builder()
 *                                 .tagsExcludes(List.of("exclude1", "exclude2"))
 *                                 .tagsIncludes(List.of("include*"))
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:00.934Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.ProviderType")
public enum ProviderType {
    /**
     * CodeStarSourceConnection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CODE_STAR_SOURCE_CONNECTION,
}
