package software.amazon.awscdk.services.codepipeline;

/**
 * Properties of trigger.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Pipeline pipeline;
 * CodeStarConnectionsSourceAction sourceAction;
 * pipeline.addTrigger(TriggerProps.builder()
 *         .providerType(ProviderType.CODE_STAR_SOURCE_CONNECTION)
 *         .gitConfiguration(GitConfiguration.builder()
 *                 .sourceAction(sourceAction)
 *                 .pushFilter(List.of(GitPushFilter.builder()
 *                         .tagsExcludes(List.of("exclude1", "exclude2"))
 *                         .tagsIncludes(List.of("include*"))
 *                         .build()))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:00.941Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.TriggerProps")
@software.amazon.jsii.Jsii.Proxy(TriggerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TriggerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The source provider for the event, such as connections configured for a repository with Git tags, for the specified trigger configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ProviderType getProviderType();

    /**
     * Provides the filter criteria and the source stage for the repository event that starts the pipeline, such as Git tags.
     * <p>
     * Default: - no configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.GitConfiguration getGitConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TriggerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TriggerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TriggerProps> {
        software.amazon.awscdk.services.codepipeline.ProviderType providerType;
        software.amazon.awscdk.services.codepipeline.GitConfiguration gitConfiguration;

        /**
         * Sets the value of {@link TriggerProps#getProviderType}
         * @param providerType The source provider for the event, such as connections configured for a repository with Git tags, for the specified trigger configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerType(software.amazon.awscdk.services.codepipeline.ProviderType providerType) {
            this.providerType = providerType;
            return this;
        }

        /**
         * Sets the value of {@link TriggerProps#getGitConfiguration}
         * @param gitConfiguration Provides the filter criteria and the source stage for the repository event that starts the pipeline, such as Git tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gitConfiguration(software.amazon.awscdk.services.codepipeline.GitConfiguration gitConfiguration) {
            this.gitConfiguration = gitConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TriggerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TriggerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TriggerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TriggerProps {
        private final software.amazon.awscdk.services.codepipeline.ProviderType providerType;
        private final software.amazon.awscdk.services.codepipeline.GitConfiguration gitConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.providerType = software.amazon.jsii.Kernel.get(this, "providerType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ProviderType.class));
            this.gitConfiguration = software.amazon.jsii.Kernel.get(this, "gitConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.GitConfiguration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.providerType = java.util.Objects.requireNonNull(builder.providerType, "providerType is required");
            this.gitConfiguration = builder.gitConfiguration;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.ProviderType getProviderType() {
            return this.providerType;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.GitConfiguration getGitConfiguration() {
            return this.gitConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("providerType", om.valueToTree(this.getProviderType()));
            if (this.getGitConfiguration() != null) {
                data.set("gitConfiguration", om.valueToTree(this.getGitConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.TriggerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TriggerProps.Jsii$Proxy that = (TriggerProps.Jsii$Proxy) o;

            if (!providerType.equals(that.providerType)) return false;
            return this.gitConfiguration != null ? this.gitConfiguration.equals(that.gitConfiguration) : that.gitConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.providerType.hashCode();
            result = 31 * result + (this.gitConfiguration != null ? this.gitConfiguration.hashCode() : 0);
            return result;
        }
    }
}
