package software.amazon.awscdk.services.codepipeline;

/**
 * Pipeline-Level variable.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * S3SourceAction sourceAction;
 * Artifact sourceOutput;
 * Bucket deployBucket;
 * // Pipeline-level variable
 * Variable variable = Variable.Builder.create()
 *         .variableName("bucket-var")
 *         .description("description")
 *         .defaultValue("sample")
 *         .build();
 * Pipeline.Builder.create(this, "Pipeline")
 *         .pipelineType(PipelineType.V2)
 *         .variables(List.of(variable))
 *         .stages(List.of(StageProps.builder()
 *                 .stageName("Source")
 *                 .actions(List.of(sourceAction))
 *                 .build(), StageProps.builder()
 *                 .stageName("Deploy")
 *                 .actions(List.of(
 *                     S3DeployAction.Builder.create()
 *                             .actionName("DeployAction")
 *                             // can reference the variables
 *                             .objectKey(String.format("%s.txt", variable.reference()))
 *                             .input(sourceOutput)
 *                             .bucket(deployBucket)
 *                             .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:00.941Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.Variable")
public class Variable extends software.amazon.jsii.JsiiObject {

    protected Variable(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Variable(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Variable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.VariableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Reference the variable name at Pipeline actions.
     * <p>
     * @return The variable name in a format that can be referenced at Pipeline actions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String reference() {
        return software.amazon.jsii.Kernel.call(this, "reference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of a pipeline-level variable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVariableName() {
        return software.amazon.jsii.Kernel.get(this, "variableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.Variable}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.Variable> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.VariableProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.VariableProps.Builder();
        }

        /**
         * The name of a pipeline-level variable.
         * <p>
         * @return {@code this}
         * @param variableName The name of a pipeline-level variable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variableName(final java.lang.String variableName) {
            this.props.variableName(variableName);
            return this;
        }

        /**
         * The default value of a pipeline-level variable.
         * <p>
         * Default: - No default value.
         * <p>
         * @return {@code this}
         * @param defaultValue The default value of a pipeline-level variable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultValue(final java.lang.String defaultValue) {
            this.props.defaultValue(defaultValue);
            return this;
        }

        /**
         * The description of a pipeline-level variable.
         * <p>
         * It's used to add additional context
         * about the variable, and not being used at time when pipeline executes.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description The description of a pipeline-level variable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.Variable}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.Variable build() {
            return new software.amazon.awscdk.services.codepipeline.Variable(
                this.props.build()
            );
        }
    }
}
