package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Properties for the CloudFormationDeployStackSetAction.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Pipeline pipeline;
 * Artifact sourceOutput;
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("DeployStackSets")
 *         .actions(List.of(
 *             // First, update the StackSet itself with the newest template
 *             CloudFormationDeployStackSetAction.Builder.create()
 *                     .actionName("UpdateStackSet")
 *                     .runOrder(1)
 *                     .stackSetName("MyStackSet")
 *                     .template(StackSetTemplate.fromArtifactPath(sourceOutput.atPath("template.yaml")))
 *                     // Change this to 'StackSetDeploymentModel.organizations()' if you want to deploy to OUs
 *                     .deploymentModel(StackSetDeploymentModel.selfManaged())
 *                     // This deploys to a set of accounts
 *                     .stackInstances(StackInstances.inAccounts(List.of("111111111111"), List.of("us-east-1", "eu-west-1")))
 *                     .build(),
 *             // Afterwards, update/create additional instances in other accounts
 *             CloudFormationDeployStackInstancesAction.Builder.create()
 *                     .actionName("AddMoreInstances")
 *                     .runOrder(2)
 *                     .stackSetName("MyStackSet")
 *                     .stackInstances(StackInstances.inAccounts(List.of("222222222222", "333333333333"), List.of("us-east-1", "eu-west-1")))
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:00.992Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CloudFormationDeployStackSetActionProps")
@software.amazon.jsii.Jsii.Proxy(CloudFormationDeployStackSetActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CloudFormationDeployStackSetActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.CommonAwsActionProps, software.amazon.awscdk.services.codepipeline.actions.CommonCloudFormationStackSetOptions {

    /**
     * The name to associate with the stack set.
     * <p>
     * This name must be unique in the Region where it is created.
     * <p>
     * The name may only contain alphanumeric and hyphen characters. It must begin with an alphabetic character and be 128 characters or fewer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStackSetName();

    /**
     * The location of the template that defines the resources in the stack set.
     * <p>
     * This must point to a template with a maximum size of 460,800 bytes.
     * <p>
     * Enter the path to the source artifact name and template file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.StackSetTemplate getTemplate();

    /**
     * Indicates that the template can create and update resources, depending on the types of resources in the template.
     * <p>
     * You must use this property if you have IAM resources in your stack template or you create a stack directly from a template containing macros.
     * <p>
     * Default: - the StackSet will have no IAM capabilities
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnCapabilities> getCfnCapabilities() {
        return null;
    }

    /**
     * Determines how IAM roles are created and managed.
     * <p>
     * The choices are:
     * <p>
     * <ul>
     * <li>Self Managed: you create IAM roles with the required permissions
     * in the administration account and all target accounts.</li>
     * <li>Service Managed: only available if the account and target accounts
     * are part of an AWS Organization. The necessary roles will be created
     * for you.</li>
     * </ul>
     * <p>
     * If you want to deploy to all accounts that are a member of AWS
     * Organizations Organizational Units (OUs), you must select Service Managed
     * permissions.
     * <p>
     * Note: This parameter can only be changed when no stack instances exist in
     * the stack set.
     * <p>
     * Default: StackSetDeploymentModel.selfManaged()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.actions.StackSetDeploymentModel getDeploymentModel() {
        return null;
    }

    /**
     * A description of the stack set.
     * <p>
     * You can use this to describe the stack set’s purpose or other relevant information.
     * <p>
     * Default: - no description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The template parameters for your stack set.
     * <p>
     * These parameters are shared between all instances of the stack set.
     * <p>
     * Default: - no parameters will be used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.actions.StackSetParameters getParameters() {
        return null;
    }

    /**
     * Specify where to create or update Stack Instances.
     * <p>
     * You can specify either AWS Accounts Ids or AWS Organizations Organizational Units.
     * <p>
     * Default: - don't create or update any Stack Instances
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.actions.StackInstances getStackInstances() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CloudFormationDeployStackSetActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudFormationDeployStackSetActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CloudFormationDeployStackSetActionProps> {
        java.lang.String stackSetName;
        software.amazon.awscdk.services.codepipeline.actions.StackSetTemplate template;
        java.util.List<software.amazon.awscdk.CfnCapabilities> cfnCapabilities;
        software.amazon.awscdk.services.codepipeline.actions.StackSetDeploymentModel deploymentModel;
        java.lang.String description;
        software.amazon.awscdk.services.codepipeline.actions.StackSetParameters parameters;
        software.amazon.awscdk.services.codepipeline.actions.StackInstances stackInstances;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.String actionName;
        java.lang.Number runOrder;
        java.lang.String variablesNamespace;
        java.lang.Number failureTolerancePercentage;
        java.lang.Number maxAccountConcurrencyPercentage;
        java.lang.String stackSetRegion;

        /**
         * Sets the value of {@link CloudFormationDeployStackSetActionProps#getStackSetName}
         * @param stackSetName The name to associate with the stack set. This parameter is required.
         *                     This name must be unique in the Region where it is created.
         *                     <p>
         *                     The name may only contain alphanumeric and hyphen characters. It must begin with an alphabetic character and be 128 characters or fewer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackSetName(java.lang.String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackSetActionProps#getTemplate}
         * @param template The location of the template that defines the resources in the stack set. This parameter is required.
         *                 This must point to a template with a maximum size of 460,800 bytes.
         *                 <p>
         *                 Enter the path to the source artifact name and template file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder template(software.amazon.awscdk.services.codepipeline.actions.StackSetTemplate template) {
            this.template = template;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackSetActionProps#getCfnCapabilities}
         * @param cfnCapabilities Indicates that the template can create and update resources, depending on the types of resources in the template.
         *                        You must use this property if you have IAM resources in your stack template or you create a stack directly from a template containing macros.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder cfnCapabilities(java.util.List<? extends software.amazon.awscdk.CfnCapabilities> cfnCapabilities) {
            this.cfnCapabilities = (java.util.List<software.amazon.awscdk.CfnCapabilities>)cfnCapabilities;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackSetActionProps#getDeploymentModel}
         * @param deploymentModel Determines how IAM roles are created and managed.
         *                        The choices are:
         *                        <p>
         *                        <ul>
         *                        <li>Self Managed: you create IAM roles with the required permissions
         *                        in the administration account and all target accounts.</li>
         *                        <li>Service Managed: only available if the account and target accounts
         *                        are part of an AWS Organization. The necessary roles will be created
         *                        for you.</li>
         *                        </ul>
         *                        <p>
         *                        If you want to deploy to all accounts that are a member of AWS
         *                        Organizations Organizational Units (OUs), you must select Service Managed
         *                        permissions.
         *                        <p>
         *                        Note: This parameter can only be changed when no stack instances exist in
         *                        the stack set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentModel(software.amazon.awscdk.services.codepipeline.actions.StackSetDeploymentModel deploymentModel) {
            this.deploymentModel = deploymentModel;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackSetActionProps#getDescription}
         * @param description A description of the stack set.
         *                    You can use this to describe the stack set’s purpose or other relevant information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackSetActionProps#getParameters}
         * @param parameters The template parameters for your stack set.
         *                   These parameters are shared between all instances of the stack set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(software.amazon.awscdk.services.codepipeline.actions.StackSetParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackSetActionProps#getStackInstances}
         * @param stackInstances Specify where to create or update Stack Instances.
         *                       You can specify either AWS Accounts Ids or AWS Organizations Organizational Units.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackInstances(software.amazon.awscdk.services.codepipeline.actions.StackInstances stackInstances) {
            this.stackInstances = stackInstances;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackSetActionProps#getRole}
         * @param role The Role in which context's this Action will be executing in.
         *             The Pipeline's Role will assume this Role
         *             (the required permissions for that will be granted automatically)
         *             right before executing this Action.
         *             This Action will be passed into your <code>IAction.bind</code>
         *             method in the <code>ActionBindOptions.role</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackSetActionProps#getActionName}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         *                   Note that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackSetActionProps#getRunOrder}
         * @param runOrder The runOrder property for this Action.
         *                 RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackSetActionProps#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackSetActionProps#getFailureTolerancePercentage}
         * @param failureTolerancePercentage The percentage of accounts per Region for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
         *                                   If
         *                                   the operation is stopped in a Region, AWS CloudFormation doesn't attempt the operation in subsequent Regions. When calculating the number
         *                                   of accounts based on the specified percentage, AWS CloudFormation rounds down to the next whole number.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failureTolerancePercentage(java.lang.Number failureTolerancePercentage) {
            this.failureTolerancePercentage = failureTolerancePercentage;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackSetActionProps#getMaxAccountConcurrencyPercentage}
         * @param maxAccountConcurrencyPercentage The maximum percentage of accounts in which to perform this operation at one time.
         *                                        When calculating the number of accounts based on the specified
         *                                        percentage, AWS CloudFormation rounds down to the next whole number. If rounding down would result in zero, AWS CloudFormation sets the number as
         *                                        one instead. Although you use this setting to specify the maximum, for large deployments the actual number of accounts acted upon concurrently
         *                                        may be lower due to service throttling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAccountConcurrencyPercentage(java.lang.Number maxAccountConcurrencyPercentage) {
            this.maxAccountConcurrencyPercentage = maxAccountConcurrencyPercentage;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackSetActionProps#getStackSetRegion}
         * @param stackSetRegion The AWS Region the StackSet is in.
         *                       Note that a cross-region Pipeline requires replication buckets to function correctly.
         *                       You can provide their names with the <code>PipelineProps.crossRegionReplicationBuckets</code> property.
         *                       If you don't, the CodePipeline Construct will create new Stacks in your CDK app containing those buckets,
         *                       that you will need to <code>cdk deploy</code> before deploying the main, Pipeline-containing Stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackSetRegion(java.lang.String stackSetRegion) {
            this.stackSetRegion = stackSetRegion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudFormationDeployStackSetActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CloudFormationDeployStackSetActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CloudFormationDeployStackSetActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudFormationDeployStackSetActionProps {
        private final java.lang.String stackSetName;
        private final software.amazon.awscdk.services.codepipeline.actions.StackSetTemplate template;
        private final java.util.List<software.amazon.awscdk.CfnCapabilities> cfnCapabilities;
        private final software.amazon.awscdk.services.codepipeline.actions.StackSetDeploymentModel deploymentModel;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.codepipeline.actions.StackSetParameters parameters;
        private final software.amazon.awscdk.services.codepipeline.actions.StackInstances stackInstances;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String actionName;
        private final java.lang.Number runOrder;
        private final java.lang.String variablesNamespace;
        private final java.lang.Number failureTolerancePercentage;
        private final java.lang.Number maxAccountConcurrencyPercentage;
        private final java.lang.String stackSetRegion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stackSetName = software.amazon.jsii.Kernel.get(this, "stackSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.template = software.amazon.jsii.Kernel.get(this, "template", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.StackSetTemplate.class));
            this.cfnCapabilities = software.amazon.jsii.Kernel.get(this, "cfnCapabilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnCapabilities.class)));
            this.deploymentModel = software.amazon.jsii.Kernel.get(this, "deploymentModel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.StackSetDeploymentModel.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.StackSetParameters.class));
            this.stackInstances = software.amazon.jsii.Kernel.get(this, "stackInstances", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.StackInstances.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.variablesNamespace = software.amazon.jsii.Kernel.get(this, "variablesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.failureTolerancePercentage = software.amazon.jsii.Kernel.get(this, "failureTolerancePercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxAccountConcurrencyPercentage = software.amazon.jsii.Kernel.get(this, "maxAccountConcurrencyPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.stackSetRegion = software.amazon.jsii.Kernel.get(this, "stackSetRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stackSetName = java.util.Objects.requireNonNull(builder.stackSetName, "stackSetName is required");
            this.template = java.util.Objects.requireNonNull(builder.template, "template is required");
            this.cfnCapabilities = (java.util.List<software.amazon.awscdk.CfnCapabilities>)builder.cfnCapabilities;
            this.deploymentModel = builder.deploymentModel;
            this.description = builder.description;
            this.parameters = builder.parameters;
            this.stackInstances = builder.stackInstances;
            this.role = builder.role;
            this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
            this.runOrder = builder.runOrder;
            this.variablesNamespace = builder.variablesNamespace;
            this.failureTolerancePercentage = builder.failureTolerancePercentage;
            this.maxAccountConcurrencyPercentage = builder.maxAccountConcurrencyPercentage;
            this.stackSetRegion = builder.stackSetRegion;
        }

        @Override
        public final java.lang.String getStackSetName() {
            return this.stackSetName;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.StackSetTemplate getTemplate() {
            return this.template;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnCapabilities> getCfnCapabilities() {
            return this.cfnCapabilities;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.StackSetDeploymentModel getDeploymentModel() {
            return this.deploymentModel;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.StackSetParameters getParameters() {
            return this.parameters;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.StackInstances getStackInstances() {
            return this.stackInstances;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        public final java.lang.Number getFailureTolerancePercentage() {
            return this.failureTolerancePercentage;
        }

        @Override
        public final java.lang.Number getMaxAccountConcurrencyPercentage() {
            return this.maxAccountConcurrencyPercentage;
        }

        @Override
        public final java.lang.String getStackSetRegion() {
            return this.stackSetRegion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stackSetName", om.valueToTree(this.getStackSetName()));
            data.set("template", om.valueToTree(this.getTemplate()));
            if (this.getCfnCapabilities() != null) {
                data.set("cfnCapabilities", om.valueToTree(this.getCfnCapabilities()));
            }
            if (this.getDeploymentModel() != null) {
                data.set("deploymentModel", om.valueToTree(this.getDeploymentModel()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getStackInstances() != null) {
                data.set("stackInstances", om.valueToTree(this.getStackInstances()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            data.set("actionName", om.valueToTree(this.getActionName()));
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }
            if (this.getFailureTolerancePercentage() != null) {
                data.set("failureTolerancePercentage", om.valueToTree(this.getFailureTolerancePercentage()));
            }
            if (this.getMaxAccountConcurrencyPercentage() != null) {
                data.set("maxAccountConcurrencyPercentage", om.valueToTree(this.getMaxAccountConcurrencyPercentage()));
            }
            if (this.getStackSetRegion() != null) {
                data.set("stackSetRegion", om.valueToTree(this.getStackSetRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.CloudFormationDeployStackSetActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudFormationDeployStackSetActionProps.Jsii$Proxy that = (CloudFormationDeployStackSetActionProps.Jsii$Proxy) o;

            if (!stackSetName.equals(that.stackSetName)) return false;
            if (!template.equals(that.template)) return false;
            if (this.cfnCapabilities != null ? !this.cfnCapabilities.equals(that.cfnCapabilities) : that.cfnCapabilities != null) return false;
            if (this.deploymentModel != null ? !this.deploymentModel.equals(that.deploymentModel) : that.deploymentModel != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.stackInstances != null ? !this.stackInstances.equals(that.stackInstances) : that.stackInstances != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (!actionName.equals(that.actionName)) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            if (this.variablesNamespace != null ? !this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace != null) return false;
            if (this.failureTolerancePercentage != null ? !this.failureTolerancePercentage.equals(that.failureTolerancePercentage) : that.failureTolerancePercentage != null) return false;
            if (this.maxAccountConcurrencyPercentage != null ? !this.maxAccountConcurrencyPercentage.equals(that.maxAccountConcurrencyPercentage) : that.maxAccountConcurrencyPercentage != null) return false;
            return this.stackSetRegion != null ? this.stackSetRegion.equals(that.stackSetRegion) : that.stackSetRegion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stackSetName.hashCode();
            result = 31 * result + (this.template.hashCode());
            result = 31 * result + (this.cfnCapabilities != null ? this.cfnCapabilities.hashCode() : 0);
            result = 31 * result + (this.deploymentModel != null ? this.deploymentModel.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.stackInstances != null ? this.stackInstances.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.actionName.hashCode());
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            result = 31 * result + (this.failureTolerancePercentage != null ? this.failureTolerancePercentage.hashCode() : 0);
            result = 31 * result + (this.maxAccountConcurrencyPercentage != null ? this.maxAccountConcurrencyPercentage.hashCode() : 0);
            result = 31 * result + (this.stackSetRegion != null ? this.stackSetRegion.hashCode() : 0);
            return result;
        }
    }
}
