package software.amazon.awscdk.services.codepipeline.actions;

/**
 * How should the CodeCommit Action detect changes.
 * <p>
 * This is the type of the <code>CodeCommitSourceAction.trigger</code> property.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Source stage: read from repository
 * Repository repo = Repository.Builder.create(stack, "TemplateRepo")
 *         .repositoryName("template-repo")
 *         .build();
 * Artifact sourceOutput = new Artifact("SourceArtifact");
 * CodeCommitSourceAction source = CodeCommitSourceAction.Builder.create()
 *         .actionName("Source")
 *         .repository(repo)
 *         .output(sourceOutput)
 *         .trigger(CodeCommitTrigger.POLL)
 *         .build();
 * Map&lt;String, Object&gt; sourceStage = Map.of(
 *         "stageName", "Source",
 *         "actions", List.of(source));
 * // Deployment stage: create and deploy changeset with manual approval
 * String stackName = "OurStack";
 * String changeSetName = "StagedChangeSet";
 * Map&lt;String, Object&gt; prodStage = Map.of(
 *         "stageName", "Deploy",
 *         "actions", List.of(
 *             CloudFormationCreateReplaceChangeSetAction.Builder.create()
 *                     .actionName("PrepareChanges")
 *                     .stackName(stackName)
 *                     .changeSetName(changeSetName)
 *                     .adminPermissions(true)
 *                     .templatePath(sourceOutput.atPath("template.yaml"))
 *                     .runOrder(1)
 *                     .build(),
 *             ManualApprovalAction.Builder.create()
 *                     .actionName("ApproveChanges")
 *                     .runOrder(2)
 *                     .build(),
 *             CloudFormationExecuteChangeSetAction.Builder.create()
 *                     .actionName("ExecuteChanges")
 *                     .stackName(stackName)
 *                     .changeSetName(changeSetName)
 *                     .runOrder(3)
 *                     .build()));
 * Pipeline.Builder.create(stack, "Pipeline")
 *         .crossAccountKeys(true)
 *         .stages(List.of(sourceStage, prodStage))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:01.001Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CodeCommitTrigger")
public enum CodeCommitTrigger {
    /**
     * The Action will never detect changes - the Pipeline it's part of will only begin a run when explicitly started.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
    /**
     * CodePipeline will poll the repository to detect changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    POLL,
    /**
     * CodePipeline will use CloudWatch Events to be notified of changes.
     * <p>
     * This is the default method of detecting changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EVENTS,
}
