package software.amazon.awscdk.services.codepipeline.actions;

/**
 * CodePipeline Action to deploy EC2 instances.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Artifact sourceOutput = new Artifact();
 * Pipeline pipeline = Pipeline.Builder.create(this, "MyPipeline")
 *         .pipelineType(PipelineType.V2)
 *         .build();
 * Ec2DeployAction deployAction = Ec2DeployAction.Builder.create()
 *         .actionName("Ec2Deploy")
 *         .input(sourceOutput)
 *         .instanceType(Ec2InstanceType.EC2)
 *         .instanceTagKey("Name")
 *         .instanceTagValue("MyInstance")
 *         .deploySpecifications(Ec2DeploySpecifications.inline(Ec2DeploySpecificationsInlineProps.builder()
 *                 .targetDirectory("/home/ec2-user/deploy")
 *                 .preScript("scripts/pre-deploy.sh")
 *                 .postScript("scripts/post-deploy.sh")
 *                 .build()))
 *         .build();
 * IStage deployStage = pipeline.addStage(StageOptions.builder()
 *         .stageName("Deploy")
 *         .actions(List.of(deployAction))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:01.026Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.Ec2DeployAction")
public class Ec2DeployAction extends software.amazon.awscdk.services.codepipeline.actions.Action {

    protected Ec2DeployAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Ec2DeployAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Ec2DeployAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.Ec2DeployActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * This is a renamed version of the <code>IAction.bind</code> method.
     * <p>
     * @param scope This parameter is required.
     * @param stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bound(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bound", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(stage, "stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.actions.Ec2DeployAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.actions.Ec2DeployAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.actions.Ec2DeployActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.actions.Ec2DeployActionProps.Builder();
        }

        /**
         * The physical, human-readable name of the Action.
         * <p>
         * Note that Action names must be unique within a single Stage.
         * <p>
         * @return {@code this}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * The runOrder property for this Action.
         * <p>
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html</a>
         * @param runOrder The runOrder property for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(final java.lang.Number runOrder) {
            this.props.runOrder(runOrder);
            return this;
        }

        /**
         * The name of the namespace to use for variables emitted by this action.
         * <p>
         * Default: - a name will be generated, based on the stage and action names,
         * if any of the action's variables were referenced - otherwise,
         * no namespace will be set
         * <p>
         * @return {@code this}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(final java.lang.String variablesNamespace) {
            this.props.variablesNamespace(variablesNamespace);
            return this;
        }

        /**
         * The Role in which context's this Action will be executing in.
         * <p>
         * The Pipeline's Role will assume this Role
         * (the required permissions for that will be granted automatically)
         * right before executing this Action.
         * This Action will be passed into your <code>IAction.bind</code>
         * method in the <code>ActionBindOptions.role</code> property.
         * <p>
         * Default: a new Role will be generated
         * <p>
         * @return {@code this}
         * @param role The Role in which context's this Action will be executing in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The deploy specifications.
         * <p>
         * @return {@code this}
         * @param deploySpecifications The deploy specifications. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploySpecifications(final software.amazon.awscdk.services.codepipeline.actions.Ec2DeploySpecifications deploySpecifications) {
            this.props.deploySpecifications(deploySpecifications);
            return this;
        }

        /**
         * The input artifact to deploy to EC2 instances.
         * <p>
         * @return {@code this}
         * @param input The input artifact to deploy to EC2 instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(final software.amazon.awscdk.services.codepipeline.Artifact input) {
            this.props.input(input);
            return this;
        }

        /**
         * The tag key of the instances that you created in Amazon EC2.
         * <p>
         * @return {@code this}
         * @param instanceTagKey The tag key of the instances that you created in Amazon EC2. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTagKey(final java.lang.String instanceTagKey) {
            this.props.instanceTagKey(instanceTagKey);
            return this;
        }

        /**
         * The type of instances or SSM nodes created in Amazon EC2.
         * <p>
         * You must have already created, tagged, and installed the SSM agent on all instances.
         * <p>
         * @return {@code this}
         * @param instanceType The type of instances or SSM nodes created in Amazon EC2. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final software.amazon.awscdk.services.codepipeline.actions.Ec2InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * The tag value of the instances that you created in Amazon EC2.
         * <p>
         * Default: - all instances with `instanceTagKey` will be matched
         * <p>
         * @return {@code this}
         * @param instanceTagValue The tag value of the instances that you created in Amazon EC2. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTagValue(final java.lang.String instanceTagValue) {
            this.props.instanceTagValue(instanceTagValue);
            return this;
        }

        /**
         * The number or percentage of instances that can deploy in parallel.
         * <p>
         * Default: - No configuration
         * <p>
         * @return {@code this}
         * @param maxBatch The number or percentage of instances that can deploy in parallel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatch(final software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances maxBatch) {
            this.props.maxBatch(maxBatch);
            return this;
        }

        /**
         * Stop the task after the task fails on the specified number or percentage of instances.
         * <p>
         * Default: - No configuration
         * <p>
         * @return {@code this}
         * @param maxError Stop the task after the task fails on the specified number or percentage of instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxError(final software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances maxError) {
            this.props.maxError(maxError);
            return this;
        }

        /**
         * The list of target groups for deployment. You must have already created the target groups.
         * <p>
         * Target groups provide a set of instances to process specific requests.
         * If the target group is specified, instances will be removed from the target group before deployment and added back to the target group after deployment.
         * <p>
         * Default: - No target groups
         * <p>
         * @return {@code this}
         * @param targetGroups The list of target groups for deployment. You must have already created the target groups. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroups(final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup> targetGroups) {
            this.props.targetGroups(targetGroups);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.actions.Ec2DeployAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.actions.Ec2DeployAction build() {
            return new software.amazon.awscdk.services.codepipeline.actions.Ec2DeployAction(
                this.props.build()
            );
        }
    }
}
