package software.amazon.awscdk.services.codestarconnections;

/**
 * Properties for defining a <code>CfnSyncConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codestarconnections.*;
 * CfnSyncConfigurationProps cfnSyncConfigurationProps = CfnSyncConfigurationProps.builder()
 *         .branch("branch")
 *         .configFile("configFile")
 *         .repositoryLinkId("repositoryLinkId")
 *         .resourceName("resourceName")
 *         .roleArn("roleArn")
 *         .syncType("syncType")
 *         // the properties below are optional
 *         .publishDeploymentStatus("publishDeploymentStatus")
 *         .triggerResourceUpdateOn("triggerResourceUpdateOn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:01.089Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codestarconnections.CfnSyncConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnSyncConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSyncConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The branch associated with a specific sync configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html#cfn-codestarconnections-syncconfiguration-branch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html#cfn-codestarconnections-syncconfiguration-branch</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBranch();

    /**
     * The file path to the configuration file associated with a specific sync configuration.
     * <p>
     * The path should point to an actual file in the sync configurations linked repository.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html#cfn-codestarconnections-syncconfiguration-configfile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html#cfn-codestarconnections-syncconfiguration-configfile</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConfigFile();

    /**
     * The ID of the repository link associated with a specific sync configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html#cfn-codestarconnections-syncconfiguration-repositorylinkid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html#cfn-codestarconnections-syncconfiguration-repositorylinkid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRepositoryLinkId();

    /**
     * The name of the connection resource associated with a specific sync configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html#cfn-codestarconnections-syncconfiguration-resourcename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html#cfn-codestarconnections-syncconfiguration-resourcename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceName();

    /**
     * The Amazon Resource Name (ARN) of the IAM role associated with a specific sync configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html#cfn-codestarconnections-syncconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html#cfn-codestarconnections-syncconfiguration-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The type of sync for a specific sync configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html#cfn-codestarconnections-syncconfiguration-synctype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html#cfn-codestarconnections-syncconfiguration-synctype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSyncType();

    /**
     * Whether to enable or disable publishing of deployment status to source providers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html#cfn-codestarconnections-syncconfiguration-publishdeploymentstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html#cfn-codestarconnections-syncconfiguration-publishdeploymentstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPublishDeploymentStatus() {
        return null;
    }

    /**
     * When to trigger Git sync to begin the stack update.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html#cfn-codestarconnections-syncconfiguration-triggerresourceupdateon">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarconnections-syncconfiguration.html#cfn-codestarconnections-syncconfiguration-triggerresourceupdateon</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTriggerResourceUpdateOn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSyncConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSyncConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSyncConfigurationProps> {
        java.lang.String branch;
        java.lang.String configFile;
        java.lang.String repositoryLinkId;
        java.lang.String resourceName;
        java.lang.String roleArn;
        java.lang.String syncType;
        java.lang.String publishDeploymentStatus;
        java.lang.String triggerResourceUpdateOn;

        /**
         * Sets the value of {@link CfnSyncConfigurationProps#getBranch}
         * @param branch The branch associated with a specific sync configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branch(java.lang.String branch) {
            this.branch = branch;
            return this;
        }

        /**
         * Sets the value of {@link CfnSyncConfigurationProps#getConfigFile}
         * @param configFile The file path to the configuration file associated with a specific sync configuration. This parameter is required.
         *                   The path should point to an actual file in the sync configurations linked repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configFile(java.lang.String configFile) {
            this.configFile = configFile;
            return this;
        }

        /**
         * Sets the value of {@link CfnSyncConfigurationProps#getRepositoryLinkId}
         * @param repositoryLinkId The ID of the repository link associated with a specific sync configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryLinkId(java.lang.String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSyncConfigurationProps#getResourceName}
         * @param resourceName The name of the connection resource associated with a specific sync configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceName(java.lang.String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSyncConfigurationProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role associated with a specific sync configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnSyncConfigurationProps#getSyncType}
         * @param syncType The type of sync for a specific sync configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncType(java.lang.String syncType) {
            this.syncType = syncType;
            return this;
        }

        /**
         * Sets the value of {@link CfnSyncConfigurationProps#getPublishDeploymentStatus}
         * @param publishDeploymentStatus Whether to enable or disable publishing of deployment status to source providers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishDeploymentStatus(java.lang.String publishDeploymentStatus) {
            this.publishDeploymentStatus = publishDeploymentStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnSyncConfigurationProps#getTriggerResourceUpdateOn}
         * @param triggerResourceUpdateOn When to trigger Git sync to begin the stack update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerResourceUpdateOn(java.lang.String triggerResourceUpdateOn) {
            this.triggerResourceUpdateOn = triggerResourceUpdateOn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSyncConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSyncConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSyncConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSyncConfigurationProps {
        private final java.lang.String branch;
        private final java.lang.String configFile;
        private final java.lang.String repositoryLinkId;
        private final java.lang.String resourceName;
        private final java.lang.String roleArn;
        private final java.lang.String syncType;
        private final java.lang.String publishDeploymentStatus;
        private final java.lang.String triggerResourceUpdateOn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.branch = software.amazon.jsii.Kernel.get(this, "branch", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configFile = software.amazon.jsii.Kernel.get(this, "configFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repositoryLinkId = software.amazon.jsii.Kernel.get(this, "repositoryLinkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceName = software.amazon.jsii.Kernel.get(this, "resourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.syncType = software.amazon.jsii.Kernel.get(this, "syncType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publishDeploymentStatus = software.amazon.jsii.Kernel.get(this, "publishDeploymentStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.triggerResourceUpdateOn = software.amazon.jsii.Kernel.get(this, "triggerResourceUpdateOn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.branch = java.util.Objects.requireNonNull(builder.branch, "branch is required");
            this.configFile = java.util.Objects.requireNonNull(builder.configFile, "configFile is required");
            this.repositoryLinkId = java.util.Objects.requireNonNull(builder.repositoryLinkId, "repositoryLinkId is required");
            this.resourceName = java.util.Objects.requireNonNull(builder.resourceName, "resourceName is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.syncType = java.util.Objects.requireNonNull(builder.syncType, "syncType is required");
            this.publishDeploymentStatus = builder.publishDeploymentStatus;
            this.triggerResourceUpdateOn = builder.triggerResourceUpdateOn;
        }

        @Override
        public final java.lang.String getBranch() {
            return this.branch;
        }

        @Override
        public final java.lang.String getConfigFile() {
            return this.configFile;
        }

        @Override
        public final java.lang.String getRepositoryLinkId() {
            return this.repositoryLinkId;
        }

        @Override
        public final java.lang.String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getSyncType() {
            return this.syncType;
        }

        @Override
        public final java.lang.String getPublishDeploymentStatus() {
            return this.publishDeploymentStatus;
        }

        @Override
        public final java.lang.String getTriggerResourceUpdateOn() {
            return this.triggerResourceUpdateOn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("branch", om.valueToTree(this.getBranch()));
            data.set("configFile", om.valueToTree(this.getConfigFile()));
            data.set("repositoryLinkId", om.valueToTree(this.getRepositoryLinkId()));
            data.set("resourceName", om.valueToTree(this.getResourceName()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            data.set("syncType", om.valueToTree(this.getSyncType()));
            if (this.getPublishDeploymentStatus() != null) {
                data.set("publishDeploymentStatus", om.valueToTree(this.getPublishDeploymentStatus()));
            }
            if (this.getTriggerResourceUpdateOn() != null) {
                data.set("triggerResourceUpdateOn", om.valueToTree(this.getTriggerResourceUpdateOn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codestarconnections.CfnSyncConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSyncConfigurationProps.Jsii$Proxy that = (CfnSyncConfigurationProps.Jsii$Proxy) o;

            if (!branch.equals(that.branch)) return false;
            if (!configFile.equals(that.configFile)) return false;
            if (!repositoryLinkId.equals(that.repositoryLinkId)) return false;
            if (!resourceName.equals(that.resourceName)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (!syncType.equals(that.syncType)) return false;
            if (this.publishDeploymentStatus != null ? !this.publishDeploymentStatus.equals(that.publishDeploymentStatus) : that.publishDeploymentStatus != null) return false;
            return this.triggerResourceUpdateOn != null ? this.triggerResourceUpdateOn.equals(that.triggerResourceUpdateOn) : that.triggerResourceUpdateOn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.branch.hashCode();
            result = 31 * result + (this.configFile.hashCode());
            result = 31 * result + (this.repositoryLinkId.hashCode());
            result = 31 * result + (this.resourceName.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.syncType.hashCode());
            result = 31 * result + (this.publishDeploymentStatus != null ? this.publishDeploymentStatus.hashCode() : 0);
            result = 31 * result + (this.triggerResourceUpdateOn != null ? this.triggerResourceUpdateOn.hashCode() : 0);
            return result;
        }
    }
}
