package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a <code>CfnIdentityPoolPrincipalTag</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * Object principalTags;
 * CfnIdentityPoolPrincipalTagProps cfnIdentityPoolPrincipalTagProps = CfnIdentityPoolPrincipalTagProps.builder()
 *         .identityPoolId("identityPoolId")
 *         .identityProviderName("identityProviderName")
 *         // the properties below are optional
 *         .principalTags(principalTags)
 *         .useDefaults(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolprincipaltag.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolprincipaltag.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:01.135Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnIdentityPoolPrincipalTagProps")
@software.amazon.jsii.Jsii.Proxy(CfnIdentityPoolPrincipalTagProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIdentityPoolPrincipalTagProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identity pool that you want to associate with this principal tag map.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolprincipaltag.html#cfn-cognito-identitypoolprincipaltag-identitypoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolprincipaltag.html#cfn-cognito-identitypoolprincipaltag-identitypoolid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentityPoolId();

    /**
     * The identity pool identity provider (IdP) that you want to associate with this principal tag map.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolprincipaltag.html#cfn-cognito-identitypoolprincipaltag-identityprovidername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolprincipaltag.html#cfn-cognito-identitypoolprincipaltag-identityprovidername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentityProviderName();

    /**
     * A JSON-formatted list of user claims and the principal tags that you want to associate with them.
     * <p>
     * When Amazon Cognito requests credentials, it sets the value of the principal tag to the value of the user's claim.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolprincipaltag.html#cfn-cognito-identitypoolprincipaltag-principaltags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolprincipaltag.html#cfn-cognito-identitypoolprincipaltag-principaltags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPrincipalTags() {
        return null;
    }

    /**
     * Use a default set of mappings between claims and tags for this provider, instead of a custom map.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolprincipaltag.html#cfn-cognito-identitypoolprincipaltag-usedefaults">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolprincipaltag.html#cfn-cognito-identitypoolprincipaltag-usedefaults</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUseDefaults() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIdentityPoolPrincipalTagProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIdentityPoolPrincipalTagProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIdentityPoolPrincipalTagProps> {
        java.lang.String identityPoolId;
        java.lang.String identityProviderName;
        java.lang.Object principalTags;
        java.lang.Object useDefaults;

        /**
         * Sets the value of {@link CfnIdentityPoolPrincipalTagProps#getIdentityPoolId}
         * @param identityPoolId The identity pool that you want to associate with this principal tag map. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityPoolId(java.lang.String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolPrincipalTagProps#getIdentityProviderName}
         * @param identityProviderName The identity pool identity provider (IdP) that you want to associate with this principal tag map. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderName(java.lang.String identityProviderName) {
            this.identityProviderName = identityProviderName;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolPrincipalTagProps#getPrincipalTags}
         * @param principalTags A JSON-formatted list of user claims and the principal tags that you want to associate with them.
         *                      When Amazon Cognito requests credentials, it sets the value of the principal tag to the value of the user's claim.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principalTags(java.lang.Object principalTags) {
            this.principalTags = principalTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolPrincipalTagProps#getUseDefaults}
         * @param useDefaults Use a default set of mappings between claims and tags for this provider, instead of a custom map.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useDefaults(java.lang.Boolean useDefaults) {
            this.useDefaults = useDefaults;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolPrincipalTagProps#getUseDefaults}
         * @param useDefaults Use a default set of mappings between claims and tags for this provider, instead of a custom map.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useDefaults(software.amazon.awscdk.IResolvable useDefaults) {
            this.useDefaults = useDefaults;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIdentityPoolPrincipalTagProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIdentityPoolPrincipalTagProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIdentityPoolPrincipalTagProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIdentityPoolPrincipalTagProps {
        private final java.lang.String identityPoolId;
        private final java.lang.String identityProviderName;
        private final java.lang.Object principalTags;
        private final java.lang.Object useDefaults;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.identityPoolId = software.amazon.jsii.Kernel.get(this, "identityPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identityProviderName = software.amazon.jsii.Kernel.get(this, "identityProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.principalTags = software.amazon.jsii.Kernel.get(this, "principalTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.useDefaults = software.amazon.jsii.Kernel.get(this, "useDefaults", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.identityPoolId = java.util.Objects.requireNonNull(builder.identityPoolId, "identityPoolId is required");
            this.identityProviderName = java.util.Objects.requireNonNull(builder.identityProviderName, "identityProviderName is required");
            this.principalTags = builder.principalTags;
            this.useDefaults = builder.useDefaults;
        }

        @Override
        public final java.lang.String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final java.lang.String getIdentityProviderName() {
            return this.identityProviderName;
        }

        @Override
        public final java.lang.Object getPrincipalTags() {
            return this.principalTags;
        }

        @Override
        public final java.lang.Object getUseDefaults() {
            return this.useDefaults;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("identityPoolId", om.valueToTree(this.getIdentityPoolId()));
            data.set("identityProviderName", om.valueToTree(this.getIdentityProviderName()));
            if (this.getPrincipalTags() != null) {
                data.set("principalTags", om.valueToTree(this.getPrincipalTags()));
            }
            if (this.getUseDefaults() != null) {
                data.set("useDefaults", om.valueToTree(this.getUseDefaults()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnIdentityPoolPrincipalTagProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIdentityPoolPrincipalTagProps.Jsii$Proxy that = (CfnIdentityPoolPrincipalTagProps.Jsii$Proxy) o;

            if (!identityPoolId.equals(that.identityPoolId)) return false;
            if (!identityProviderName.equals(that.identityProviderName)) return false;
            if (this.principalTags != null ? !this.principalTags.equals(that.principalTags) : that.principalTags != null) return false;
            return this.useDefaults != null ? this.useDefaults.equals(that.useDefaults) : that.useDefaults == null;
        }

        @Override
        public final int hashCode() {
            int result = this.identityPoolId.hashCode();
            result = 31 * result + (this.identityProviderName.hashCode());
            result = 31 * result + (this.principalTags != null ? this.principalTags.hashCode() : 0);
            result = 31 * result + (this.useDefaults != null ? this.useDefaults.hashCode() : 0);
            return result;
        }
    }
}
